/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.customizer;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluator;
import org.netbeans.api.project.Project;
import org.netbeans.modules.maven.TemplateAttrProvider;
import org.netbeans.modules.maven.api.FileUtilities;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.api.PluginPropertyUtils;
import org.netbeans.modules.maven.api.customizer.ModelHandle2;
import org.netbeans.modules.maven.customizer.Bundle;
import org.netbeans.modules.maven.model.ModelOperation;
import org.netbeans.modules.maven.model.pom.POMModel;
import org.netbeans.spi.project.AuxiliaryProperties;
import org.netbeans.spi.project.support.ant.ui.CustomizerUtilities;
import org.netbeans.spi.project.ui.support.ProjectCustomizer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;

public class LicenseHeaderPanelProvider
implements ProjectCustomizer.CompositeCategoryProvider {
    public ProjectCustomizer.Category createCategory(Lookup context) {
        return ProjectCustomizer.Category.create((String)"LICENSE_HEADERS", (String)Bundle.TIT_Headers(), null, (ProjectCustomizer.Category[])new ProjectCustomizer.Category[0]);
    }

    public JComponent createComponent(ProjectCustomizer.Category category, Lookup context) {
        ModelHandle2 handle = (ModelHandle2)context.lookup(ModelHandle2.class);
        Project prj = (Project)context.lookup(Project.class);
        return CustomizerUtilities.createLicenseHeaderCustomizerPanel((ProjectCustomizer.Category)category, (CustomizerUtilities.LicensePanelContentHandler)new Impl(handle, prj, (AuxiliaryProperties)prj.getLookup().lookup(AuxiliaryProperties.class)));
    }

    private final class Impl
    implements CustomizerUtilities.LicensePanelContentHandler {
        final ModelHandle2 handle;
        final AuxiliaryProperties props;
        private final Project project;
        private final ModelOperation<POMModel> operation;
        private String licenseContent;
        private String licensePath;

        public Impl(final ModelHandle2 handle, Project prj, AuxiliaryProperties props) {
            this.handle = handle;
            this.props = props;
            this.project = prj;
            this.operation = new ModelOperation<POMModel>(){
                final /* synthetic */ Impl this$1;
                {
                    this.this$1 = this$1;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void performOperation(POMModel model) {
                    block8: {
                        if (this.this$1.licenseContent == null) {
                            return;
                        }
                        try {
                            ExpressionEvaluator createEvaluator = PluginPropertyUtils.createEvaluator(this.this$1.project);
                            Object evaluate = createEvaluator.evaluate(this.this$1.licensePath);
                            if (evaluate != null) {
                                String eval = evaluate.toString();
                                File file = FileUtilities.resolveFilePath(handle.getProject().getBasedir(), eval);
                                FileObject fo = !file.exists() ? FileUtil.createData((File)file) : FileUtil.toFileObject((File)file);
                                if (!fo.isData()) break block8;
                                try (OutputStream out = fo.getOutputStream();){
                                    FileUtil.copy((InputStream)new ByteArrayInputStream(this.this$1.licenseContent.getBytes()), (OutputStream)out);
                                    break block8;
                                }
                            }
                            Logger.getLogger(LicenseHeaderPanelProvider.class.getName()).log(Level.WARNING, "Encountered problems evaluating license path: {0}", this.this$1.licensePath);
                        }
                        catch (IOException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                        catch (ExpressionEvaluationException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                    }
                }
            };
            this.licensePath = this.getProjectLicenseLocation();
        }

        public String getProjectLicenseLocation() {
            return this.props.get("netbeans.hint.licensePath", true);
        }

        public String getGlobalLicenseName() {
            String s = this.props.get("netbeans.hint.license", true);
            if (s == null) {
                s = TemplateAttrProvider.findLicenseByMavenProjectContent(((NbMavenProject)this.project.getLookup().lookup(NbMavenProject.class)).getMavenProject());
            }
            return s;
        }

        public FileObject resolveProjectLocation(String path) {
            if ("".equals(path)) {
                return null;
            }
            try {
                String eval = PluginPropertyUtils.createEvaluator(this.project).evaluate(path).toString();
                FileObject toRet = FileUtil.toFileObject((File)FileUtilities.resolveFilePath(this.handle.getProject().getBasedir(), eval));
                if (toRet != null && toRet.isFolder()) {
                    toRet = null;
                }
                return toRet;
            }
            catch (ExpressionEvaluationException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                return null;
            }
        }

        public void setProjectLicenseLocation(String newLocation) {
            this.licensePath = newLocation;
            this.handle.setRawAuxiliaryProperty("netbeans.hint.licensePath", newLocation, true);
            if (newLocation != null) {
                this.handle.setRawAuxiliaryProperty("netbeans.hint.license", null, true);
            }
        }

        public void setGlobalLicenseName(String newName) {
            this.handle.setRawAuxiliaryProperty("netbeans.hint.license", newName, true);
        }

        public String getDefaultProjectLicenseLocation() {
            return "${project.basedir}/licenseheader.txt";
        }

        public void setProjectLicenseContent(String text) {
            if (text == null) {
                this.handle.removePOMModification(this.operation);
                this.licenseContent = null;
            } else {
                this.handle.addPOMModification(this.operation);
                this.licenseContent = text;
            }
        }
    }
}

