/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.v2;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import org.netbeans.lib.profiler.common.event.ProfilingStateAdapter;
import org.netbeans.lib.profiler.common.event.ProfilingStateEvent;
import org.netbeans.lib.profiler.common.event.ProfilingStateListener;
import org.netbeans.modules.profiler.api.ProfilerDialogs;
import org.netbeans.modules.profiler.v2.Bundle;
import org.netbeans.modules.profiler.v2.ProfilerPlugin;
import org.netbeans.modules.profiler.v2.ProfilerSession;
import org.netbeans.modules.profiler.v2.SessionStorage;
import org.openide.util.Lookup;

final class ProfilerPlugins {
    private final List<ProfilerPlugin> plugins;

    ProfilerPlugins(ProfilerSession session) {
        Collection providers = Lookup.getDefault().lookupAll(ProfilerPlugin.Provider.class);
        if (providers.isEmpty()) {
            this.plugins = null;
        } else {
            ArrayList<ProfilerPlugin> _plugins = new ArrayList<ProfilerPlugin>();
            Lookup.Provider project = session.getProject();
            SessionStorage storage = session.getStorage();
            for (ProfilerPlugin.Provider provider : providers) {
                ProfilerPlugin plugin = null;
                try {
                    plugin = provider.createPlugin(project, storage);
                }
                catch (Throwable t) {
                    this.handleThrowable(plugin, t);
                }
                if (plugin == null) continue;
                _plugins.add(plugin);
            }
            if (_plugins.isEmpty()) {
                this.plugins = null;
            } else {
                session.addListener((ProfilingStateListener)new ProfilingStateAdapter(){

                    public void profilingStateChanged(ProfilingStateEvent e) {
                        int state = e.getNewState();
                        if (state == 2) {
                            ProfilerPlugins.this.notifyStarted();
                        } else if (state == 1) {
                            ProfilerPlugins.this.notifyStopped();
                        }
                    }
                });
                this.plugins = _plugins;
            }
        }
    }

    boolean hasPlugins() {
        return this.plugins != null;
    }

    List<JMenuItem> menuItems() {
        ArrayList<JMenuItem> menus = new ArrayList<JMenuItem>();
        if (this.plugins != null) {
            for (ProfilerPlugin plugin : this.plugins) {
                try {
                    JMenu menu = new JMenu(plugin.getName());
                    plugin.createMenu(menu);
                    if (menu.getItemCount() <= 0) continue;
                    menus.add(menu);
                }
                catch (Throwable t) {
                    this.handleThrowable(plugin, t);
                }
            }
        }
        return menus;
    }

    void notifyStarting() {
        if (this.plugins != null) {
            for (ProfilerPlugin plugin : this.plugins) {
                try {
                    plugin.sessionStarting();
                }
                catch (Throwable t) {
                    this.handleThrowable(plugin, t);
                }
            }
        }
    }

    void notifyStarted() {
        if (this.plugins != null) {
            for (ProfilerPlugin plugin : this.plugins) {
                try {
                    plugin.sessionStarted();
                }
                catch (Throwable t) {
                    this.handleThrowable(plugin, t);
                }
            }
        }
    }

    void notifyStopping() {
        if (this.plugins != null) {
            for (ProfilerPlugin plugin : this.plugins) {
                try {
                    plugin.sessionStopping();
                }
                catch (Throwable t) {
                    this.handleThrowable(plugin, t);
                }
            }
        }
    }

    void notifyStopped() {
        if (this.plugins != null) {
            for (ProfilerPlugin plugin : this.plugins) {
                try {
                    plugin.sessionStopped();
                }
                catch (Throwable t) {
                    this.handleThrowable(plugin, t);
                }
            }
        }
    }

    private void handleThrowable(final ProfilerPlugin p, final Throwable t) {
        t.printStackTrace(System.err);
        SwingUtilities.invokeLater(new Runnable(){
            final /* synthetic */ ProfilerPlugins this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                String log = t.getLocalizedMessage();
                String msg = p == null ? Bundle.ProfilerPlugins_PluginNotInitialized(log) : Bundle.ProfilerPlugins_PluginFailed(p.getName(), log);
                ProfilerDialogs.displayError((String)msg);
            }
        });
    }
}

