/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.parsing;

import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.annotations.common.NullUnknown;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.modules.java.source.parsing.AbstractSourceFileObject;
import org.netbeans.modules.java.source.parsing.FileObjects;
import org.netbeans.modules.java.source.parsing.InferableJavaFileObject;
import org.netbeans.modules.java.source.parsing.ModuleLocation;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.Pair;

final class ModuleSourceFileManager
implements JavaFileManager {
    private final boolean ignoreExcludes;
    private final ClassPath srcPath;
    private final ClassPath moduleSrcPath;
    private final Map<URL, String> patches;
    private Set<ModuleLocation.WithExcludes> sourceModuleLocations;

    public ModuleSourceFileManager(@NonNull ClassPath srcPath, @NonNull ClassPath moduleSrcPath, boolean ignoreExcludes) {
        assert (srcPath != null);
        assert (moduleSrcPath != null);
        this.srcPath = srcPath;
        this.moduleSrcPath = moduleSrcPath;
        this.ignoreExcludes = ignoreExcludes;
        this.patches = new HashMap<URL, String>();
    }

    @Override
    public Iterable<JavaFileObject> list(@NonNull JavaFileManager.Location l, @NonNull String packageName, @NonNull Set<JavaFileObject.Kind> kinds, boolean recursive) {
        ArrayList<JavaFileObject> result = new ArrayList<JavaFileObject>();
        Object folderName = FileObjects.convertPackage2Folder(packageName);
        if (((String)folderName).length() > 0) {
            folderName = (String)folderName + "/";
        }
        ModuleLocation.WithExcludes ml = ModuleSourceFileManager.asSourceModuleLocation(l);
        for (ClassPath.Entry entry : ml.getModuleEntries()) {
            FileObject tmpFile;
            FileObject root;
            if (!this.ignoreExcludes && !entry.includes((String)folderName) || (root = entry.getRoot()) == null || (tmpFile = root.getFileObject((String)folderName)) == null || !tmpFile.isFolder()) continue;
            Enumeration files = tmpFile.getChildren(recursive);
            while (files.hasMoreElements()) {
                JavaFileObject.Kind kind;
                FileObject file = (FileObject)files.nextElement();
                if (!this.ignoreExcludes && !entry.includes(file) || !kinds.contains((Object)(kind = FileObjects.getKind(file.getExt())))) continue;
                result.add(FileObjects.sourceFileObject(file, root));
            }
        }
        return result;
    }

    @Override
    public javax.tools.FileObject getFileForInput(@NonNull JavaFileManager.Location l, @NonNull String pkgName, @NonNull String relativeName) {
        String rp = FileObjects.resolveRelativePath(pkgName, relativeName);
        FileObject[] fileRootPair = this.findFile(ModuleSourceFileManager.asSourceModuleLocation(l), rp);
        return fileRootPair == null ? null : FileObjects.sourceFileObject(fileRootPair[0], fileRootPair[1]);
    }

    @Override
    public JavaFileObject getJavaFileForInput(@NonNull JavaFileManager.Location l, @NonNull String className, @NonNull JavaFileObject.Kind kind) {
        String[] namePair = FileObjects.getParentRelativePathAndName(className);
        String ext = kind == JavaFileObject.Kind.CLASS ? "sig" : kind.extension.substring(1);
        ModuleLocation.WithExcludes ml = ModuleSourceFileManager.asSourceModuleLocation(l);
        for (ClassPath.Entry entry : ml.getModuleEntries()) {
            FileObject[] children;
            FileObject parent;
            FileObject root = entry.getRoot();
            if (root == null || (parent = root.getFileObject(namePair[0])) == null) continue;
            for (FileObject child : children = parent.getChildren()) {
                if (!namePair[1].equals(child.getName()) || !ext.equalsIgnoreCase(child.getExt()) || !this.ignoreExcludes && !entry.includes(child)) continue;
                return FileObjects.sourceFileObject(child, root);
            }
        }
        return null;
    }

    @Override
    public javax.tools.FileObject getFileForOutput(@NonNull JavaFileManager.Location l, @NonNull String pkgName, @NonNull String relativeName, @NullAllowed javax.tools.FileObject sibling) throws IOException {
        throw new UnsupportedOperationException("Output is unsupported.");
    }

    @Override
    public JavaFileObject getJavaFileForOutput(JavaFileManager.Location l, String className, JavaFileObject.Kind kind, javax.tools.FileObject sibling) throws IOException, UnsupportedOperationException, IllegalArgumentException {
        throw new UnsupportedOperationException("Output is unsupported.");
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public int isSupportedOption(String string) {
        return -1;
    }

    @Override
    public boolean handleOption(String head, Iterator<String> tail) {
        Pair<String, List<URL>> modulePatches;
        if ("--patch-module".equals(head) && (modulePatches = FileObjects.parseModulePatches(tail)) != null) {
            String moduleName = (String)modulePatches.first();
            List patchURLs = (List)modulePatches.second();
            for (URL patchURL : patchURLs) {
                this.patches.put(patchURL, moduleName);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean hasLocation(JavaFileManager.Location location) {
        return location == StandardLocation.MODULE_SOURCE_PATH;
    }

    @Override
    public ClassLoader getClassLoader(JavaFileManager.Location l) {
        return null;
    }

    @Override
    public String inferBinaryName(JavaFileManager.Location l, JavaFileObject javaFileObject) {
        if (javaFileObject instanceof InferableJavaFileObject) {
            return ((InferableJavaFileObject)javaFileObject).inferBinaryName();
        }
        return null;
    }

    @Override
    public boolean isSameFile(javax.tools.FileObject a, javax.tools.FileObject b) {
        return a instanceof AbstractSourceFileObject && b instanceof AbstractSourceFileObject && ((AbstractSourceFileObject)a).getHandle().file != null && ((AbstractSourceFileObject)a).getHandle().file.equals(((AbstractSourceFileObject)b).getHandle().file);
    }

    @Override
    @NonNull
    public Iterable<Set<JavaFileManager.Location>> listLocationsForModules(@NonNull JavaFileManager.Location location) throws IOException {
        if (location != StandardLocation.MODULE_SOURCE_PATH) {
            throw new IllegalStateException(String.format("Unsupported location: %s", location));
        }
        return this.sourceModuleLocationsRemovedPatches().stream().map(loc -> Collections.singleton(loc)).collect(Collectors.toSet());
    }

    @Override
    @NullUnknown
    public String inferModuleName(@NonNull JavaFileManager.Location location) throws IOException {
        ModuleLocation.WithExcludes ml = ModuleSourceFileManager.asSourceModuleLocation(location);
        return ml.getModuleName();
    }

    @Override
    @CheckForNull
    public JavaFileManager.Location getLocationForModule(JavaFileManager.Location location, JavaFileObject jfo) throws IOException {
        if (location != StandardLocation.MODULE_SOURCE_PATH) {
            throw new IllegalStateException(String.format("Unsupported location: %s", location));
        }
        FileObject fo = URLMapper.findFileObject((URL)jfo.toUri().toURL());
        if (fo != null) {
            for (ModuleLocation.WithExcludes moduleLocation : this.sourceModuleLocationsRemovedPatches()) {
                for (ClassPath.Entry entry : moduleLocation.getModuleEntries()) {
                    FileObject root = entry.getRoot();
                    if (root == null || !FileUtil.isParentOf((FileObject)root, (FileObject)fo)) continue;
                    return moduleLocation;
                }
            }
        }
        return null;
    }

    @Override
    @CheckForNull
    public JavaFileManager.Location getLocationForModule(JavaFileManager.Location location, String moduleName) throws IOException {
        if (location != StandardLocation.MODULE_SOURCE_PATH) {
            throw new IllegalStateException(String.format("Unsupported location: %s", location));
        }
        for (ModuleLocation.WithExcludes moduleLocation : this.sourceModuleLocationsRemovedPatches()) {
            if (!Objects.equals(moduleName, moduleLocation.getModuleName())) continue;
            return moduleLocation;
        }
        return null;
    }

    private FileObject[] findFile(ModuleLocation.WithExcludes location, String relativePath) {
        for (ClassPath.Entry entry : location.getModuleEntries()) {
            FileObject file;
            FileObject root;
            if (!this.ignoreExcludes && !entry.includes(relativePath) || (root = entry.getRoot()) == null || (file = root.getFileObject(relativePath)) == null) continue;
            return new FileObject[]{file, root};
        }
        return null;
    }

    @NonNull
    private Set<ModuleLocation.WithExcludes> sourceModuleLocationsRemovedPatches() {
        Set<ModuleLocation.WithExcludes> all = this.sourceModuleLocations();
        if (this.patches.isEmpty()) {
            return all;
        }
        return all.stream().map(l -> {
            Collection<? extends ClassPath.Entry> origEntries = l.getModuleEntries();
            List entries = origEntries.stream().filter(e -> !this.patches.containsKey(e.getURL())).collect(Collectors.toList());
            if (entries.isEmpty()) {
                return null;
            }
            if (origEntries.size() == entries.size()) {
                return l;
            }
            return ModuleLocation.WithExcludes.createExcludes(l.getBaseLocation(), entries, l.getModuleName());
        }).filter(l -> l != null).collect(Collectors.toSet());
    }

    Set<ModuleLocation.WithExcludes> sourceModuleLocations() {
        if (this.sourceModuleLocations == null) {
            HashMap moduleRoots = new HashMap();
            HashSet seen = new HashSet();
            this.srcPath.entries().forEach(srcEntry -> {
                URL srcURL = srcEntry.getURL();
                if (!seen.contains(srcURL)) {
                    String src = srcURL.toExternalForm();
                    this.moduleSrcPath.entries().forEach(moduleEntry -> {
                        URL moduleURL = moduleEntry.getURL();
                        if (src.startsWith(moduleURL.toExternalForm())) {
                            try {
                                ArrayList<ClassPath.Entry> roots;
                                String relative = FileObjects.getRelativePath(moduleURL, srcURL);
                                int idx = relative.indexOf(47);
                                if (idx >= 0) {
                                    relative = relative.substring(0, idx);
                                }
                                if ((roots = (ArrayList<ClassPath.Entry>)moduleRoots.get(relative)) == null) {
                                    roots = new ArrayList<ClassPath.Entry>();
                                    moduleRoots.put(relative, roots);
                                }
                                roots.add((ClassPath.Entry)srcEntry);
                                seen.add(srcURL);
                            }
                            catch (URISyntaxException uRISyntaxException) {
                                // empty catch block
                            }
                        }
                    });
                }
            });
            this.sourceModuleLocations = moduleRoots.entrySet().stream().map(moduleRoot -> ModuleLocation.WithExcludes.createExcludes(StandardLocation.MODULE_SOURCE_PATH, (Collection)moduleRoot.getValue(), (String)moduleRoot.getKey())).collect(Collectors.toSet());
        }
        return this.sourceModuleLocations;
    }

    @NonNull
    private static ModuleLocation.WithExcludes asSourceModuleLocation(@NonNull JavaFileManager.Location l) {
        if (l.getClass() != ModuleLocation.WithExcludes.class) {
            throw new IllegalArgumentException(String.valueOf(l));
        }
        return (ModuleLocation.WithExcludes)l;
    }
}

