# This file has been autogenerated by the pywayland scanner

# Copyright 2019 Sebastian Wick
# Copyright 2019 Erwin Burema
# Copyright 2020 AMD
# Copyright 2020-2024 Collabora, Ltd.
# Copyright 2024 Xaver Hugl
# Copyright 2022-2025 Red Hat, Inc.
#
# Permission is hereby granted, free of charge, to any person obtaining a
# copy of this software and associated documentation files (the "Software"),
# to deal in the Software without restriction, including without limitation
# the rights to use, copy, modify, merge, publish, distribute, sublicense,
# and/or sell copies of the Software, and to permit persons to whom the
# Software is furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice (including the next
# paragraph) shall be included in all copies or substantial portions of the
# Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
# THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
# FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
# DEALINGS IN THE SOFTWARE.

from __future__ import annotations

import enum

from pywayland.protocol_core import (
    Argument,
    ArgumentType,
    Global,
    Interface,
    Proxy,
    Resource,
)

from ..wayland import WlOutput
from ..wayland import WlSurface
from .wp_color_management_output_v1 import WpColorManagementOutputV1
from .wp_color_management_surface_feedback_v1 import WpColorManagementSurfaceFeedbackV1
from .wp_color_management_surface_v1 import WpColorManagementSurfaceV1
from .wp_image_description_creator_icc_v1 import WpImageDescriptionCreatorIccV1
from .wp_image_description_creator_params_v1 import WpImageDescriptionCreatorParamsV1
from .wp_image_description_v1 import WpImageDescriptionV1


class WpColorManagerV1(Interface):
    """Color manager singleton

    A singleton global interface used for getting color management extensions
    for :class:`~pywayland.protocol.wayland.WlSurface` and
    :class:`~pywayland.protocol.wayland.WlOutput` objects, and for creating
    client defined image description objects. The extension interfaces allow
    getting the image description of outputs and setting the image description
    of surfaces.

    Compositors should never remove this global.
    """

    name = "wp_color_manager_v1"
    version = 1

    class error(enum.IntEnum):
        unsupported_feature = 0
        surface_exists = 1

    class render_intent(enum.IntEnum):
        perceptual = 0
        relative = 1
        saturation = 2
        absolute = 3
        relative_bpc = 4

    class feature(enum.IntEnum):
        icc_v2_v4 = 0
        parametric = 1
        set_primaries = 2
        set_tf_power = 3
        set_luminances = 4
        set_mastering_display_primaries = 5
        extended_target_volume = 6
        windows_scrgb = 7

    class primaries(enum.IntEnum):
        srgb = 1
        pal_m = 2
        pal = 3
        ntsc = 4
        generic_film = 5
        bt2020 = 6
        cie1931_xyz = 7
        dci_p3 = 8
        display_p3 = 9
        adobe_rgb = 10

    class transfer_function(enum.IntEnum):
        bt1886 = 1
        gamma22 = 2
        gamma28 = 3
        st240 = 4
        ext_linear = 5
        log_100 = 6
        log_316 = 7
        xvycc = 8
        srgb = 9
        ext_srgb = 10
        st2084_pq = 11
        st428 = 12
        hlg = 13


class WpColorManagerV1Proxy(Proxy[WpColorManagerV1]):
    interface = WpColorManagerV1

    @WpColorManagerV1.request()
    def destroy(self) -> None:
        """Destroy the color manager

        Destroy the :class:`WpColorManagerV1` object. This does not affect any
        other objects in any way.
        """
        self._marshal(0)
        self._destroy()

    @WpColorManagerV1.request(
        Argument(ArgumentType.NewId, interface=WpColorManagementOutputV1),
        Argument(ArgumentType.Object, interface=WlOutput),
    )
    def get_output(self, output: WlOutput) -> Proxy[WpColorManagementOutputV1]:
        """Create a color management interface for a :class:`~pywayland.protocol.wayland.WlOutput`

        This creates a new
        :class:`~pywayland.protocol.color_management_v1.WpColorManagementOutputV1`
        object for the given :class:`~pywayland.protocol.wayland.WlOutput`.

        See the
        :class:`~pywayland.protocol.color_management_v1.WpColorManagementOutputV1`
        interface for more details.

        :param output:
        :type output:
            :class:`~pywayland.protocol.wayland.WlOutput`
        :returns:
            :class:`~pywayland.protocol.color_management_v1.WpColorManagementOutputV1`
        """
        id = self._marshal_constructor(1, WpColorManagementOutputV1, output)
        return id

    @WpColorManagerV1.request(
        Argument(ArgumentType.NewId, interface=WpColorManagementSurfaceV1),
        Argument(ArgumentType.Object, interface=WlSurface),
    )
    def get_surface(self, surface: WlSurface) -> Proxy[WpColorManagementSurfaceV1]:
        """Create a color management interface for a :class:`~pywayland.protocol.wayland.WlSurface`

        If a
        :class:`~pywayland.protocol.color_management_v1.WpColorManagementSurfaceV1`
        object already exists for the given
        :class:`~pywayland.protocol.wayland.WlSurface`, the protocol error
        surface_exists is raised.

        This creates a new color
        :class:`~pywayland.protocol.color_management_v1.WpColorManagementSurfaceV1`
        object for the given :class:`~pywayland.protocol.wayland.WlSurface`.

        See the
        :class:`~pywayland.protocol.color_management_v1.WpColorManagementSurfaceV1`
        interface for more details.

        :param surface:
        :type surface:
            :class:`~pywayland.protocol.wayland.WlSurface`
        :returns:
            :class:`~pywayland.protocol.color_management_v1.WpColorManagementSurfaceV1`
        """
        id = self._marshal_constructor(2, WpColorManagementSurfaceV1, surface)
        return id

    @WpColorManagerV1.request(
        Argument(ArgumentType.NewId, interface=WpColorManagementSurfaceFeedbackV1),
        Argument(ArgumentType.Object, interface=WlSurface),
    )
    def get_surface_feedback(self, surface: WlSurface) -> Proxy[WpColorManagementSurfaceFeedbackV1]:
        """Create a color management feedback interface

        This creates a new color
        :class:`~pywayland.protocol.color_management_v1.WpColorManagementSurfaceFeedbackV1`
        object for the given :class:`~pywayland.protocol.wayland.WlSurface`.

        See the
        :class:`~pywayland.protocol.color_management_v1.WpColorManagementSurfaceFeedbackV1`
        interface for more details.

        :param surface:
        :type surface:
            :class:`~pywayland.protocol.wayland.WlSurface`
        :returns:
            :class:`~pywayland.protocol.color_management_v1.WpColorManagementSurfaceFeedbackV1`
        """
        id = self._marshal_constructor(3, WpColorManagementSurfaceFeedbackV1, surface)
        return id

    @WpColorManagerV1.request(
        Argument(ArgumentType.NewId, interface=WpImageDescriptionCreatorIccV1),
    )
    def create_icc_creator(self) -> Proxy[WpImageDescriptionCreatorIccV1]:
        """Make a new icc-based image description creator object

        Makes a new ICC-based image description creator object with all
        properties initially unset. The client can then use the object's
        interface to define all the required properties for an image
        description and finally create a
        :class:`~pywayland.protocol.color_management_v1.WpImageDescriptionV1`
        object.

        This request can be used when the compositor advertises
        :func:`WpColorManagerV1.feature()`.icc_v2_v4. Otherwise this request
        raises the protocol error unsupported_feature.

        :returns:
            :class:`~pywayland.protocol.color_management_v1.WpImageDescriptionCreatorIccV1`
            -- the new creator object
        """
        obj = self._marshal_constructor(4, WpImageDescriptionCreatorIccV1)
        return obj

    @WpColorManagerV1.request(
        Argument(ArgumentType.NewId, interface=WpImageDescriptionCreatorParamsV1),
    )
    def create_parametric_creator(self) -> Proxy[WpImageDescriptionCreatorParamsV1]:
        """Make a new parametric image description creator object

        Makes a new parametric image description creator object with all
        properties initially unset. The client can then use the object's
        interface to define all the required properties for an image
        description and finally create a
        :class:`~pywayland.protocol.color_management_v1.WpImageDescriptionV1`
        object.

        This request can be used when the compositor advertises
        :func:`WpColorManagerV1.feature()`.parametric. Otherwise this request
        raises the protocol error unsupported_feature.

        :returns:
            :class:`~pywayland.protocol.color_management_v1.WpImageDescriptionCreatorParamsV1`
            -- the new creator object
        """
        obj = self._marshal_constructor(5, WpImageDescriptionCreatorParamsV1)
        return obj

    @WpColorManagerV1.request(
        Argument(ArgumentType.NewId, interface=WpImageDescriptionV1),
    )
    def create_windows_scrgb(self) -> Proxy[WpImageDescriptionV1]:
        """Create windows-scrgb image description object

        This creates a pre-defined image description for the so-called Windows-
        scRGB stimulus encoding. This comes from the Windows 10 handling of its
        own definition of an scRGB color space for an HDR screen driven in
        BT.2100/PQ signalling mode.

        Windows-scRGB uses sRGB (BT.709) color primaries and white point. The
        transfer characteristic is extended linear.

        The nominal color channel value range is extended, meaning it includes
        negative and greater than 1.0 values. Negative values are used to
        escape the sRGB color gamut boundaries. To make use of the extended
        range, the client needs to use a pixel format that can represent those
        values, e.g. floating-point 16 bits per channel.

        Nominal color value R=G=B=0.0 corresponds to BT.2100/PQ system 0 cd/m²,
        and R=G=B=1.0 corresponds to BT.2100/PQ system 80 cd/m². The maximum is
        R=G=B=125.0 corresponding to 10k cd/m².

        Windows-scRGB is displayed by Windows 10 by converting it to
        BT.2100/PQ, maintaining the CIE 1931 chromaticity and mapping the
        luminance as above. No adjustment is made to the signal to account for
        the viewing conditions.

        The reference white level of Windows-scRGB is unknown. If a reference
        white level must be assumed for compositor processing, it should be
        R=G=B=2.5375 corresponding to 203 cd/m² of Report ITU-R BT.2408-7.

        The target color volume of Windows-scRGB is unknown. The color gamut
        may be anything between sRGB and BT.2100.

        Note: EGL_EXT_gl_colorspace_scrgb_linear definition differs from
        Windows-scRGB by using R=G=B=1.0 as the reference white level, while
        Windows-scRGB reference white level is unknown or varies. However, it
        seems probable that Windows implements both
        EGL_EXT_gl_colorspace_scrgb_linear and Vulkan
        VK_COLOR_SPACE_EXTENDED_SRGB_LINEAR_EXT as Windows-scRGB.

        This request can be used when the compositor advertises
        :func:`WpColorManagerV1.feature()`.windows_scrgb. Otherwise this
        request raises the protocol error unsupported_feature.

        The resulting image description object does not allow get_information
        request. The :func:`WpImageDescriptionV1.ready()
        <pywayland.protocol.color_management_v1.WpImageDescriptionV1.ready>`
        event shall be sent.

        :returns:
            :class:`~pywayland.protocol.color_management_v1.WpImageDescriptionV1`
        """
        image_description = self._marshal_constructor(6, WpImageDescriptionV1)
        return image_description


class WpColorManagerV1Resource(Resource):
    interface = WpColorManagerV1

    @WpColorManagerV1.event(
        Argument(ArgumentType.Uint),
    )
    def supported_intent(self, render_intent: int) -> None:
        """Supported rendering intent

        When this object is created, it shall immediately send this event once
        for each rendering intent the compositor supports.

        :param render_intent:
            rendering intent
        :type render_intent:
            `ArgumentType.Uint`
        """
        self._post_event(0, render_intent)

    @WpColorManagerV1.event(
        Argument(ArgumentType.Uint),
    )
    def supported_feature(self, feature: int) -> None:
        """Supported features

        When this object is created, it shall immediately send this event once
        for each compositor supported feature listed in the enumeration.

        :param feature:
            supported feature
        :type feature:
            `ArgumentType.Uint`
        """
        self._post_event(1, feature)

    @WpColorManagerV1.event(
        Argument(ArgumentType.Uint),
    )
    def supported_tf_named(self, tf: int) -> None:
        """Supported named transfer characteristic

        When this object is created, it shall immediately send this event once
        for each named transfer function the compositor supports with the
        parametric image description creator.

        :param tf:
            Named transfer function
        :type tf:
            `ArgumentType.Uint`
        """
        self._post_event(2, tf)

    @WpColorManagerV1.event(
        Argument(ArgumentType.Uint),
    )
    def supported_primaries_named(self, primaries: int) -> None:
        """Supported named primaries

        When this object is created, it shall immediately send this event once
        for each named set of primaries the compositor supports with the
        parametric image description creator.

        :param primaries:
            Named color primaries
        :type primaries:
            `ArgumentType.Uint`
        """
        self._post_event(3, primaries)

    @WpColorManagerV1.event()
    def done(self) -> None:
        """All features have been sent

        This event is sent when all supported rendering intents, features,
        transfer functions and named primaries have been sent.
        """
        self._post_event(4)


class WpColorManagerV1Global(Global):
    interface = WpColorManagerV1


WpColorManagerV1._gen_c()
WpColorManagerV1.proxy_class = WpColorManagerV1Proxy
WpColorManagerV1.resource_class = WpColorManagerV1Resource
WpColorManagerV1.global_class = WpColorManagerV1Global
