/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.profiling.snapshot;

import java.awt.Image;
import java.io.File;
import java.io.IOException;
import javax.swing.JComponent;
import org.graalvm.visualvm.core.datasource.DataSource;
import org.graalvm.visualvm.lib.profiler.LoadedSnapshot;
import org.graalvm.visualvm.lib.profiler.snaptracer.impl.IdeSnapshot;
import org.graalvm.visualvm.lib.profiler.snaptracer.impl.TracerController;
import org.graalvm.visualvm.lib.profiler.snaptracer.impl.TracerModel;
import org.graalvm.visualvm.lib.profiler.snaptracer.impl.TracerView;
import org.graalvm.visualvm.profiling.snapshot.ProfilerSnapshot;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;

class ProfilerSnapshotNPSS
extends ProfilerSnapshot {
    private IdeSnapshot loadedSnapshot;

    ProfilerSnapshotNPSS(File file, DataSource master) {
        super(file, master);
        try {
            FileObject primary = FileUtil.toFileObject((File)file);
            FileObject uigestureFO = primary.getParent().getFileObject(primary.getName(), "log");
            this.loadedSnapshot = new IdeSnapshot(primary, uigestureFO);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    @Override
    public LoadedSnapshot getLoadedSnapshot() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    Image resolveIcon() {
        return ImageUtilities.mergeImages((Image)CPU_ICON, (Image)NODE_BADGE, (int)0, (int)0);
    }

    @Override
    protected void remove() {
        super.remove();
        this.loadedSnapshot = null;
    }

    @Override
    JComponent getUIComponent() {
        TracerModel model = new TracerModel(this.loadedSnapshot);
        TracerController controller = new TracerController(model);
        TracerView view = new TracerView(model, controller);
        return view.createComponent();
    }

    @Override
    void closeComponent() {
    }
}

