﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/connect/Connect_EXPORTS.h>
#include <aws/connect/model/TemplateAttributes.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace Connect {
namespace Model {

/**
 * <p>Information about template message configuration.</p><p><h3>See Also:</h3>
 * <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/TemplatedMessageConfig">AWS
 * API Reference</a></p>
 */
class TemplatedMessageConfig {
 public:
  AWS_CONNECT_API TemplatedMessageConfig() = default;
  AWS_CONNECT_API TemplatedMessageConfig(Aws::Utils::Json::JsonView jsonValue);
  AWS_CONNECT_API TemplatedMessageConfig& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_CONNECT_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The identifier of the knowledge base. Can be either the ID or the ARN. URLs
   * cannot contain the ARN.</p>
   */
  inline const Aws::String& GetKnowledgeBaseId() const { return m_knowledgeBaseId; }
  inline bool KnowledgeBaseIdHasBeenSet() const { return m_knowledgeBaseIdHasBeenSet; }
  template <typename KnowledgeBaseIdT = Aws::String>
  void SetKnowledgeBaseId(KnowledgeBaseIdT&& value) {
    m_knowledgeBaseIdHasBeenSet = true;
    m_knowledgeBaseId = std::forward<KnowledgeBaseIdT>(value);
  }
  template <typename KnowledgeBaseIdT = Aws::String>
  TemplatedMessageConfig& WithKnowledgeBaseId(KnowledgeBaseIdT&& value) {
    SetKnowledgeBaseId(std::forward<KnowledgeBaseIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The identifier of the message template Id.</p>
   */
  inline const Aws::String& GetMessageTemplateId() const { return m_messageTemplateId; }
  inline bool MessageTemplateIdHasBeenSet() const { return m_messageTemplateIdHasBeenSet; }
  template <typename MessageTemplateIdT = Aws::String>
  void SetMessageTemplateId(MessageTemplateIdT&& value) {
    m_messageTemplateIdHasBeenSet = true;
    m_messageTemplateId = std::forward<MessageTemplateIdT>(value);
  }
  template <typename MessageTemplateIdT = Aws::String>
  TemplatedMessageConfig& WithMessageTemplateId(MessageTemplateIdT&& value) {
    SetMessageTemplateId(std::forward<MessageTemplateIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Information about template attributes, that is, CustomAttributes or
   * CustomerProfileAttributes.</p>
   */
  inline const TemplateAttributes& GetTemplateAttributes() const { return m_templateAttributes; }
  inline bool TemplateAttributesHasBeenSet() const { return m_templateAttributesHasBeenSet; }
  template <typename TemplateAttributesT = TemplateAttributes>
  void SetTemplateAttributes(TemplateAttributesT&& value) {
    m_templateAttributesHasBeenSet = true;
    m_templateAttributes = std::forward<TemplateAttributesT>(value);
  }
  template <typename TemplateAttributesT = TemplateAttributes>
  TemplatedMessageConfig& WithTemplateAttributes(TemplateAttributesT&& value) {
    SetTemplateAttributes(std::forward<TemplateAttributesT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_knowledgeBaseId;

  Aws::String m_messageTemplateId;

  TemplateAttributes m_templateAttributes;
  bool m_knowledgeBaseIdHasBeenSet = false;
  bool m_messageTemplateIdHasBeenSet = false;
  bool m_templateAttributesHasBeenSet = false;
};

}  // namespace Model
}  // namespace Connect
}  // namespace Aws
