/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.texteditor.stickyscroll;

import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.ui.texteditor.stickyscroll.IStickyLine;

public class StickyLine
implements IStickyLine {
    protected int lineNumber;
    protected String text;
    protected ISourceViewer sourceViewer;

    public StickyLine(int lineNumber, ISourceViewer sourceViewer) {
        this.lineNumber = lineNumber;
        this.sourceViewer = sourceViewer;
    }

    @Override
    public int getLineNumber() {
        return this.lineNumber;
    }

    @Override
    public String getText() {
        if (this.text == null) {
            StyledText textWidget = this.sourceViewer.getTextWidget();
            int widgetLineNumber = this.getWidgetLineNumber();
            if (widgetLineNumber < 0 || widgetLineNumber >= textWidget.getLineCount()) {
                return "";
            }
            this.text = textWidget.getLine(widgetLineNumber);
        }
        return this.text;
    }

    @Override
    public StyleRange[] getStyleRanges() {
        StyledText textWidget = this.sourceViewer.getTextWidget();
        int widgetLineNumber = this.getWidgetLineNumber();
        if (widgetLineNumber < 0 || widgetLineNumber >= textWidget.getLineCount()) {
            return null;
        }
        try {
            StyleRange[] styleRanges;
            int offsetAtLine = textWidget.getOffsetAtLine(widgetLineNumber);
            StyleRange[] styleRangeArray = styleRanges = textWidget.getStyleRanges(offsetAtLine, this.getText().length());
            int n = styleRanges.length;
            int n2 = 0;
            while (n2 < n) {
                StyleRange styleRange = styleRangeArray[n2];
                styleRange.start -= offsetAtLine;
                ++n2;
            }
            return styleRanges;
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    private int getWidgetLineNumber() {
        ISourceViewer iSourceViewer = this.sourceViewer;
        if (iSourceViewer instanceof ITextViewerExtension5) {
            ITextViewerExtension5 extension = (ITextViewerExtension5)iSourceViewer;
            return extension.modelLine2WidgetLine(this.lineNumber);
        }
        return this.lineNumber;
    }
}

