/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.ai.tools.content;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.freeplane.features.link.ConnectorModel;
import org.freeplane.features.link.MapLinks;
import org.freeplane.features.link.NodeLinkModel;
import org.freeplane.features.link.NodeLinks;
import org.freeplane.features.map.Clones;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.NodeModel;
import org.freeplane.plugin.ai.tools.content.CloneMetadata;
import org.freeplane.plugin.ai.tools.content.ConnectorItem;

public class NodeLinkMetadataReader {
    private NodeLinkMetadataReader() {
    }

    public static String readHyperlink(NodeModel nodeModel) {
        if (nodeModel == null) {
            return null;
        }
        return NodeLinks.getLinkAsString((NodeModel)nodeModel);
    }

    public static List<ConnectorItem> readOutgoingConnectors(NodeModel nodeModel) {
        if (nodeModel == null) {
            return null;
        }
        Collection links = NodeLinks.getLinks((NodeModel)nodeModel);
        return NodeLinkMetadataReader.toConnectorItems(links);
    }

    public static List<ConnectorItem> readIncomingConnectors(NodeModel nodeModel) {
        if (nodeModel == null || !nodeModel.hasID()) {
            return null;
        }
        MapLinks mapLinks = MapLinks.getLinks((MapModel)nodeModel.getMap());
        if (mapLinks == null) {
            return null;
        }
        Set links = mapLinks.get(nodeModel.getID());
        return NodeLinkMetadataReader.toConnectorItems(links);
    }

    public static CloneMetadata readCloneMetadata(NodeModel nodeModel) {
        if (nodeModel == null) {
            return null;
        }
        List<String> cloneIdentifiers = NodeLinkMetadataReader.readCloneIdentifiers(nodeModel);
        return new CloneMetadata(cloneIdentifiers, nodeModel.isCloneTreeRoot(), nodeModel.isCloneTreeNode());
    }

    private static List<String> readCloneIdentifiers(NodeModel nodeModel) {
        Clones clones = nodeModel.allClones();
        if (clones == null) {
            return null;
        }
        Collection cloneNodes = clones.toCollection();
        if (cloneNodes == null || cloneNodes.isEmpty()) {
            return new ArrayList<String>();
        }
        String currentId = nodeModel.createID();
        ArrayList<String> identifiers = new ArrayList<String>();
        for (NodeModel clone : cloneNodes) {
            String cloneId;
            if (clone == null || (cloneId = clone.createID()) == null || cloneId.equals(currentId)) continue;
            identifiers.add(cloneId);
        }
        return identifiers;
    }

    private static List<ConnectorItem> toConnectorItems(Collection<NodeLinkModel> links) {
        if (links == null || links.isEmpty()) {
            return null;
        }
        ArrayList<ConnectorItem> results = new ArrayList<ConnectorItem>();
        for (NodeLinkModel link : links) {
            ConnectorItem item;
            if (!(link instanceof ConnectorModel) || (item = ConnectorItem.fromConnector((ConnectorModel)link)) == null) continue;
            results.add(item);
        }
        if (results.isEmpty()) {
            return null;
        }
        return results;
    }
}

