/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.css.engine.value;

import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.parser.ParseHelper;
import io.sf.carte.echosvg.css.engine.value.AbstractColorManager;
import io.sf.carte.echosvg.css.engine.value.AbstractStringValue;
import io.sf.carte.echosvg.css.engine.value.ColorValue;
import io.sf.carte.echosvg.css.engine.value.ImmutableIdentValue;
import org.w3c.api.DOMTypeException;
import org.w3c.css.om.typed.CSSKeywordValue;
import org.w3c.dom.DOMException;

public class IdentValue
extends AbstractStringValue
implements CSSKeywordValue {
    private static final long serialVersionUID = 1L;

    public IdentValue(String s) {
        super(s);
    }

    public static IdentValue createConstant(String s) {
        return new ImmutableIdentValue(s.intern());
    }

    public CSSValue.Type getPrimitiveType() {
        return CSSValue.Type.IDENT;
    }

    public String getCssText() {
        return ParseHelper.escape((String)this.value);
    }

    @Override
    public String getIdentifierValue() {
        return this.value;
    }

    @Override
    public String getStringValue() {
        return this.value;
    }

    @Override
    public void setValue(String value) throws DOMTypeException {
        if (value == null || (value = value.trim()).isEmpty()) {
            throw new DOMTypeException("Value is null or empty.");
        }
        this.value = value.intern();
        if (this.handler != null) {
            this.handler.valueChanged(this);
        }
    }

    @Override
    public boolean isIdentifier(String internedIdent) {
        return this.value == internedIdent;
    }

    @Override
    public ColorValue getColorValue() throws DOMException {
        ColorValue cssval = AbstractColorManager.computedValues.get(this.value);
        return cssval != null ? cssval.clone() : super.getColorValue();
    }

    @Override
    public IdentValue clone() {
        return (IdentValue)super.clone();
    }
}

