/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.jpeg.drew;

public class Rational {
    private final long _numerator;
    private final long _denominator;

    public Rational(long l, long l2) {
        this._numerator = l;
        this._denominator = l2;
    }

    public double doubleValue() {
        if (this._denominator == 0L) {
            return 0.0;
        }
        return (double)this._numerator / (double)this._denominator;
    }

    public final int intValue() {
        return (int)this.longValue();
    }

    public final long longValue() {
        if (this._denominator == 0L) {
            return 0L;
        }
        return this._numerator / this._denominator;
    }

    public final long getDenominator() {
        return this._denominator;
    }

    public final long getNumerator() {
        return this._numerator;
    }

    public double convertToPositiveValue() {
        if (this._denominator == 0L) {
            return 0.0;
        }
        double d = this._numerator;
        double d2 = this._denominator;
        if (this._numerator >= 0L) {
            return d / d2;
        }
        double d3 = Math.pow(2.0, 32.0);
        d += d3;
        if (this._denominator < 0L) {
            d2 += d3;
        }
        return d / d2;
    }

    public String toString() {
        return this._numerator + "/" + this._denominator;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Rational)) {
            return false;
        }
        Rational rational = (Rational)object;
        return this.doubleValue() == rational.doubleValue();
    }
}

