/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.4.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

An inverse deconvolution filter regularized in the Tikhonov sense.


The Tikhonov deconvolution filter is the inverse deconvolution filter
with a regularization term added to the denominator. The filter
minimizes the equation \\[ ||\\hat{f} \\otimes h - g||_{L_2}^2 + \\mu||\\hat{f}||^2
\\] where $\\hat{f}$ is the estimate of the unblurred image, $h$ is the blurring kernel, $g$ is the blurred image, and $\\mu$ is a non-negative real regularization function.

The filter applies a kernel described in the Fourier domain as $H^*(\\omega) / (|H(\\omega)|^2 + \\mu)$ where $H(\\omega)$ is the Fourier transform of $h$ . The term $\\mu$ is called RegularizationConstant in this filter. If $\\mu$ is set to zero, this filter is equivalent to the InverseDeconvolutionImageFilter .


Gaetan Lehmann, Biologie du Developpement et de la Reproduction, INRA
de Jouy-en-Josas, France

Cory Quammen, The University of North Carolina at Chapel Hill

See:
 itk::simple::TikhonovDeconvolution for the procedural interface

 itk::TikhonovDeconvolutionImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkTikhonovDeconvolutionImageFilter.h
*/
public class TikhonovDeconvolutionImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected TikhonovDeconvolutionImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.TikhonovDeconvolutionImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(TikhonovDeconvolutionImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(TikhonovDeconvolutionImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::TikhonovDeconvolutionImageFilter::~TikhonovDeconvolutionImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_TikhonovDeconvolutionImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::TikhonovDeconvolutionImageFilter::TikhonovDeconvolutionImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  TikhonovDeconvolutionImageFilter() {
    this(SimpleITKJNI.new_TikhonovDeconvolutionImageFilter(), true);
  }

  /**
Self&amp; itk::simple::TikhonovDeconvolutionImageFilter::SetRegularizationConstant(double RegularizationConstant)

The regularization factor. Larger values reduce the dominance of noise
in the solution, but results in higher approximation error in the
deblurred image. Default value is 0.0, yielding the same results as
the InverseDeconvolutionImageFilter .

*/
public  void setRegularizationConstant(double RegularizationConstant) {
    SimpleITKJNI.TikhonovDeconvolutionImageFilter_setRegularizationConstant(swigCPtr, this, RegularizationConstant);
  }

  /**
double itk::simple::TikhonovDeconvolutionImageFilter::GetRegularizationConstant() const

The regularization factor. Larger values reduce the dominance of noise
in the solution, but results in higher approximation error in the
deblurred image. Default value is 0.0, yielding the same results as
the InverseDeconvolutionImageFilter .

*/
public  double getRegularizationConstant() {
    return SimpleITKJNI.TikhonovDeconvolutionImageFilter_getRegularizationConstant(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::TikhonovDeconvolutionImageFilter::SetNormalize(bool Normalize)

Normalize the output image by the sum of the kernel components

*/
public  void setNormalize(boolean Normalize) {
    SimpleITKJNI.TikhonovDeconvolutionImageFilter_setNormalize(swigCPtr, this, Normalize);
  }

  /**
Self&amp; itk::simple::TikhonovDeconvolutionImageFilter::NormalizeOn()

Set the value of Normalize to true or false respectfully.

*/
public  void normalizeOn() {
    SimpleITKJNI.TikhonovDeconvolutionImageFilter_normalizeOn(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::TikhonovDeconvolutionImageFilter::NormalizeOff()
*/
public  void normalizeOff() {
    SimpleITKJNI.TikhonovDeconvolutionImageFilter_normalizeOff(swigCPtr, this);
  }

  /**
bool itk::simple::TikhonovDeconvolutionImageFilter::GetNormalize() const
*/
public  boolean getNormalize() {
    return SimpleITKJNI.TikhonovDeconvolutionImageFilter_getNormalize(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::TikhonovDeconvolutionImageFilter::SetBoundaryCondition(BoundaryConditionType BoundaryCondition)
*/
public  void setBoundaryCondition(TikhonovDeconvolutionImageFilter.BoundaryConditionType BoundaryCondition) {
    SimpleITKJNI.TikhonovDeconvolutionImageFilter_setBoundaryCondition(swigCPtr, this, BoundaryCondition.swigValue());
  }

  /**
BoundaryConditionType itk::simple::TikhonovDeconvolutionImageFilter::GetBoundaryCondition() const
*/
public  TikhonovDeconvolutionImageFilter.BoundaryConditionType getBoundaryCondition() {
    return TikhonovDeconvolutionImageFilter.BoundaryConditionType.swigToEnum(SimpleITKJNI.TikhonovDeconvolutionImageFilter_getBoundaryCondition(swigCPtr, this));
  }

  /**
Self&amp; itk::simple::TikhonovDeconvolutionImageFilter::SetOutputRegionMode(OutputRegionModeType OutputRegionMode)
*/
public  void setOutputRegionMode(TikhonovDeconvolutionImageFilter.OutputRegionModeType OutputRegionMode) {
    SimpleITKJNI.TikhonovDeconvolutionImageFilter_setOutputRegionMode(swigCPtr, this, OutputRegionMode.swigValue());
  }

  /**
OutputRegionModeType itk::simple::TikhonovDeconvolutionImageFilter::GetOutputRegionMode() const
*/
public  TikhonovDeconvolutionImageFilter.OutputRegionModeType getOutputRegionMode() {
    return TikhonovDeconvolutionImageFilter.OutputRegionModeType.swigToEnum(SimpleITKJNI.TikhonovDeconvolutionImageFilter_getOutputRegionMode(swigCPtr, this));
  }

  /**
std::string itk::simple::TikhonovDeconvolutionImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.TikhonovDeconvolutionImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::TikhonovDeconvolutionImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.TikhonovDeconvolutionImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::TikhonovDeconvolutionImageFilter::Execute(const Image &amp;image1, const Image &amp;image2)

Execute the filter on the input images

*/
public  Image execute(Image image1, Image image2) {
    return new Image(SimpleITKJNI.TikhonovDeconvolutionImageFilter_execute(swigCPtr, this, Image.getCPtr(image1), image1, Image.getCPtr(image2), image2), true);
  }

  public final static class BoundaryConditionType {
    public final static TikhonovDeconvolutionImageFilter.BoundaryConditionType ZERO_PAD = new TikhonovDeconvolutionImageFilter.BoundaryConditionType("ZERO_PAD");
    public final static TikhonovDeconvolutionImageFilter.BoundaryConditionType ZERO_FLUX_NEUMANN_PAD = new TikhonovDeconvolutionImageFilter.BoundaryConditionType("ZERO_FLUX_NEUMANN_PAD");
    public final static TikhonovDeconvolutionImageFilter.BoundaryConditionType PERIODIC_PAD = new TikhonovDeconvolutionImageFilter.BoundaryConditionType("PERIODIC_PAD");

    public final int swigValue() {
      return swigValue;
    }

    public String toString() {
      return swigName;
    }

    public static BoundaryConditionType swigToEnum(int swigValue) {
      if (swigValue < swigValues.length && swigValue >= 0 && swigValues[swigValue].swigValue == swigValue)
        return swigValues[swigValue];
      for (int i = 0; i < swigValues.length; i++)
        if (swigValues[i].swigValue == swigValue)
          return swigValues[i];
      throw new IllegalArgumentException("No enum " + BoundaryConditionType.class + " with value " + swigValue);
    }

    private BoundaryConditionType(String swigName) {
      this.swigName = swigName;
      this.swigValue = swigNext++;
    }

    private BoundaryConditionType(String swigName, int swigValue) {
      this.swigName = swigName;
      this.swigValue = swigValue;
      swigNext = swigValue+1;
    }

    private BoundaryConditionType(String swigName, BoundaryConditionType swigEnum) {
      this.swigName = swigName;
      this.swigValue = swigEnum.swigValue;
      swigNext = this.swigValue+1;
    }

    private static BoundaryConditionType[] swigValues = { ZERO_PAD, ZERO_FLUX_NEUMANN_PAD, PERIODIC_PAD };
    private static int swigNext = 0;
    private final int swigValue;
    private final String swigName;
  }

  public final static class OutputRegionModeType {
    public final static TikhonovDeconvolutionImageFilter.OutputRegionModeType SAME = new TikhonovDeconvolutionImageFilter.OutputRegionModeType("SAME");
    public final static TikhonovDeconvolutionImageFilter.OutputRegionModeType VALID = new TikhonovDeconvolutionImageFilter.OutputRegionModeType("VALID");

    public final int swigValue() {
      return swigValue;
    }

    public String toString() {
      return swigName;
    }

    public static OutputRegionModeType swigToEnum(int swigValue) {
      if (swigValue < swigValues.length && swigValue >= 0 && swigValues[swigValue].swigValue == swigValue)
        return swigValues[swigValue];
      for (int i = 0; i < swigValues.length; i++)
        if (swigValues[i].swigValue == swigValue)
          return swigValues[i];
      throw new IllegalArgumentException("No enum " + OutputRegionModeType.class + " with value " + swigValue);
    }

    private OutputRegionModeType(String swigName) {
      this.swigName = swigName;
      this.swigValue = swigNext++;
    }

    private OutputRegionModeType(String swigName, int swigValue) {
      this.swigName = swigName;
      this.swigValue = swigValue;
      swigNext = swigValue+1;
    }

    private OutputRegionModeType(String swigName, OutputRegionModeType swigEnum) {
      this.swigName = swigName;
      this.swigValue = swigEnum.swigValue;
      swigNext = this.swigValue+1;
    }

    private static OutputRegionModeType[] swigValues = { SAME, VALID };
    private static int swigNext = 0;
    private final int swigValue;
    private final String swigName;
  }

}
