/*
 * Decompiled with CFR 0.152.
 */
package jspecview.application;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.EventListener;
import javajs.util.Lst;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import jspecview.api.JSVPanel;
import jspecview.application.AboutDialog;
import jspecview.application.MainFrame;
import jspecview.common.JSVFileManager;
import jspecview.common.JSViewer;
import jspecview.common.PanelData;
import jspecview.common.PanelNode;
import jspecview.common.ScriptToken;
import jspecview.common.Spectrum;
import jspecview.source.JDXSource;

public class ApplicationMenu
extends JMenuBar {
    private static final long serialVersionUID = 1L;
    protected MainFrame mainFrame;
    protected JSViewer jsvViewer;
    private JMenu processingMenu;
    private JMenu displayMenu;
    private JMenu exportAsMenu;
    private JMenu openRecentMenu;
    private JMenu saveAsMenu;
    private JMenu saveAsJDXMenu;
    private JMenuItem closeMenuItem;
    private JMenuItem closeAllMenuItem;
    private JMenuItem errorLogMenuItem;
    private JMenuItem printMenuItem;
    private JMenuItem sourceMenuItem;
    private JMenuItem integrationMenuItem;
    private JMenuItem transmittanceMenuItem;
    private JMenuItem solutionColorMenuItem;
    private JCheckBoxMenuItem gridCheckBoxMenuItem = new JCheckBoxMenuItem();
    private JCheckBoxMenuItem coordsCheckBoxMenuItem = new JCheckBoxMenuItem();
    private JCheckBoxMenuItem pointsOnlyCheckBoxMenuItem = new JCheckBoxMenuItem();
    private JCheckBoxMenuItem revPlotCheckBoxMenuItem = new JCheckBoxMenuItem();
    private JCheckBoxMenuItem scaleXCheckBoxMenuItem = new JCheckBoxMenuItem();
    private JCheckBoxMenuItem scaleYCheckBoxMenuItem = new JCheckBoxMenuItem();
    private JCheckBoxMenuItem toolbarCheckBoxMenuItem = new JCheckBoxMenuItem();
    private JCheckBoxMenuItem sidePanelCheckBoxMenuItem = new JCheckBoxMenuItem();
    private JCheckBoxMenuItem statusCheckBoxMenuItem = new JCheckBoxMenuItem();

    public ApplicationMenu(MainFrame mainFrame) throws Exception {
        this.mainFrame = mainFrame;
        this.jsvViewer = mainFrame.jsvViewer;
        this.jbInit();
    }

    private void jbInit() throws Exception {
        JMenuItem jMenuItem = ApplicationMenu.setMenuItem(null, 'F', "Add File...", 70, 2, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (ApplicationMenu.this.jsvViewer.openFileFromDialog(true, false, null, null)) {
                    ApplicationMenu.this.jsvViewer.runScript("view all");
                }
            }
        });
        JMenuItem jMenuItem2 = ApplicationMenu.setMenuItem(null, 'H', "Add H1 Simulation...", 72, 2, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (ApplicationMenu.this.jsvViewer.openFileFromDialog(true, false, "H1", null)) {
                    ApplicationMenu.this.jsvViewer.runScript("view all");
                }
            }
        });
        JMenuItem jMenuItem3 = ApplicationMenu.setMenuItem(null, 'C', "Add C13 Simulation...", 67, 2, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (ApplicationMenu.this.jsvViewer.openFileFromDialog(true, false, "C13", null)) {
                    ApplicationMenu.this.jsvViewer.runScript("view all");
                }
            }
        });
        JMenuItem jMenuItem4 = ApplicationMenu.setMenuItem(null, 'U', "Add URL...", 85, 2, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ApplicationMenu.this.jsvViewer.openFileFromDialog(true, true, null, null);
            }
        });
        this.printMenuItem = ApplicationMenu.setMenuItem(null, 'P', "Print...", 80, 2, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ApplicationMenu.this.jsvViewer.runScript("print");
            }
        });
        this.closeMenuItem = ApplicationMenu.setMenuItem(null, 'C', "Close", 115, 2, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ApplicationMenu.this.jsvViewer.runScript("CLOSE");
            }
        });
        this.closeAllMenuItem = ApplicationMenu.setMenuItem(null, 'L', "Close All", 0, 2, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ApplicationMenu.this.jsvViewer.runScript("CLOSE ALL");
            }
        });
        JMenuItem jMenuItem5 = ApplicationMenu.setMenuItem(null, 'T', "Script...", 83, 8, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ApplicationMenu.this.jsvViewer.runScript("script INLINE");
            }
        });
        JMenuItem jMenuItem6 = ApplicationMenu.setMenuItem(null, 'X', "Exit", 115, 8, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ApplicationMenu.this.mainFrame.exitJSpecView(false, true);
            }
        });
        ApplicationMenu.setMenuItem(this.gridCheckBoxMenuItem, 'G', "Grid", 71, 2, new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                ApplicationMenu.this.setBoolean(ScriptToken.GRIDON, itemEvent);
            }
        });
        ApplicationMenu.setMenuItem(this.coordsCheckBoxMenuItem, 'C', "Coordinates", 67, 2, new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                ApplicationMenu.this.setBoolean(ScriptToken.COORDINATESON, itemEvent);
            }
        });
        ApplicationMenu.setMenuItem(this.pointsOnlyCheckBoxMenuItem, 'P', "Points Only", 80, 2, new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                ApplicationMenu.this.setBoolean(ScriptToken.POINTSONLY, itemEvent);
            }
        });
        ApplicationMenu.setMenuItem(this.revPlotCheckBoxMenuItem, 'R', "Reverse Plot", 82, 2, new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                ApplicationMenu.this.setBoolean(ScriptToken.REVERSEPLOT, itemEvent);
            }
        });
        ApplicationMenu.setMenuItem(this.scaleXCheckBoxMenuItem, 'X', "X Scale", 88, 2, new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                ApplicationMenu.this.setBoolean(ScriptToken.XSCALEON, itemEvent);
            }
        });
        ApplicationMenu.setMenuItem(this.scaleYCheckBoxMenuItem, 'Y', "Y Scale", 89, 2, new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                ApplicationMenu.this.setBoolean(ScriptToken.YSCALEON, itemEvent);
            }
        });
        JMenuItem jMenuItem7 = ApplicationMenu.setMenuItem(null, 'N', "Next View", 78, 3, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ApplicationMenu.this.jsvViewer.runScript("zoom next");
            }
        });
        JMenuItem jMenuItem8 = ApplicationMenu.setMenuItem(null, 'P', "Previous View", 80, 3, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ApplicationMenu.this.jsvViewer.runScript("zoom previous");
            }
        });
        JMenuItem jMenuItem9 = ApplicationMenu.setMenuItem(null, 'F', "Full View", 70, 3, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ApplicationMenu.this.jsvViewer.runScript("zoom out");
            }
        });
        JMenuItem jMenuItem10 = ApplicationMenu.setMenuItem(null, 'C', "Clear Views", 67, 3, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ApplicationMenu.this.jsvViewer.runScript("zoom clear");
            }
        });
        JMenuItem jMenuItem11 = ApplicationMenu.setMenuItem(null, 'Z', "Set Zoom...", 90, 3, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ApplicationMenu.this.jsvViewer.runScript("zoom ?");
            }
        });
        JMenuItem jMenuItem12 = ApplicationMenu.setMenuItem(null, 'A', "All Spectra", 65, 3, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ApplicationMenu.this.jsvViewer.runScript("view all");
            }
        });
        JMenuItem jMenuItem13 = ApplicationMenu.setMenuItem(null, 'S', "Selected Spectra...", 83, 3, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ApplicationMenu.this.jsvViewer.runScript("view");
            }
        });
        JMenuItem jMenuItem14 = ApplicationMenu.setMenuItem(null, 'y', "Overlay Offset...", 0, 0, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ApplicationMenu.this.jsvViewer.runScript("stackOffsetY ?");
            }
        });
        this.sourceMenuItem = ApplicationMenu.setMenuItem(null, 'S', "Source ...", 83, 2, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ApplicationMenu.this.jsvViewer.runScript("showSource");
            }
        });
        this.errorLogMenuItem = ApplicationMenu.setMenuItem(null, '\u0000', "Error Log ...", 0, 0, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ApplicationMenu.this.jsvViewer.runScript("showErrors");
            }
        });
        JMenuItem jMenuItem15 = ApplicationMenu.setMenuItem(null, 'P', "Properties", 72, 2, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ApplicationMenu.this.jsvViewer.runScript("showProperties");
            }
        });
        JMenuItem jMenuItem16 = ApplicationMenu.setMenuItem(null, 'P', "Preferences...", 0, 0, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ApplicationMenu.this.showPreferencesDialog();
            }
        });
        JMenuItem jMenuItem17 = ApplicationMenu.setMenuItem(null, '\u0000', "About", 0, 0, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                new AboutDialog(ApplicationMenu.this.mainFrame);
            }
        });
        ApplicationMenu.setMenuItem(this.toolbarCheckBoxMenuItem, 'T', "Toolbar", 84, 9, new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                ApplicationMenu.this.mainFrame.enableToolbar(itemEvent.getStateChange() == 1);
            }
        });
        ApplicationMenu.setMenuItem(this.sidePanelCheckBoxMenuItem, 'S', "Side Panel", 83, 9, new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                ApplicationMenu.this.mainFrame.setSplitPane(itemEvent.getStateChange() == 1);
            }
        });
        ApplicationMenu.setMenuItem(this.statusCheckBoxMenuItem, 'B', "Status Bar", 66, 9, new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                ApplicationMenu.this.mainFrame.enableStatus(itemEvent.getStateChange() == 1);
            }
        });
        JMenu jMenu = new JMenu();
        jMenu.setMnemonic('F');
        jMenu.setText("File");
        JMenu jMenu2 = new JMenu();
        jMenu2.setMnemonic('H');
        jMenu2.setText("Help");
        JMenu jMenu3 = new JMenu();
        jMenu3.setMnemonic('O');
        jMenu3.setText("Options");
        this.displayMenu = new JMenu();
        this.displayMenu.setMnemonic('D');
        this.displayMenu.setText("Display");
        this.displayMenu.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent menuEvent) {
                ApplicationMenu.this.doMenuSelected();
            }

            @Override
            public void menuDeselected(MenuEvent menuEvent) {
            }

            @Override
            public void menuCanceled(MenuEvent menuEvent) {
            }
        });
        JMenu jMenu4 = new JMenu();
        jMenu4.setMnemonic('Z');
        jMenu4.setText("Zoom");
        this.openRecentMenu = new JMenu();
        this.openRecentMenu.setActionCommand("OpenRecent");
        this.openRecentMenu.setMnemonic('R');
        this.openRecentMenu.setText("Add Recent");
        this.saveAsMenu = new JMenu();
        this.saveAsMenu.setMnemonic('A');
        this.saveAsJDXMenu = new JMenu();
        this.saveAsJDXMenu.setMnemonic('J');
        this.exportAsMenu = new JMenu();
        this.exportAsMenu.setMnemonic('E');
        this.processingMenu = new JMenu();
        this.processingMenu.setMnemonic('P');
        this.processingMenu.setText("Processing");
        this.processingMenu.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent menuEvent) {
            }

            @Override
            public void menuDeselected(MenuEvent menuEvent) {
            }

            @Override
            public void menuCanceled(MenuEvent menuEvent) {
            }
        });
        this.setProcessingMenu(this.processingMenu);
        jMenu.add(jMenuItem);
        jMenu.add(jMenuItem2);
        jMenu.add(jMenuItem3);
        jMenu.add(jMenuItem4);
        jMenu.add(this.openRecentMenu);
        jMenu.addSeparator();
        jMenu.add(this.closeMenuItem).setEnabled(false);
        jMenu.add(this.closeAllMenuItem).setEnabled(false);
        jMenu.addSeparator();
        jMenu.add(jMenuItem5);
        jMenu.addSeparator();
        jMenu.add(this.saveAsMenu).setEnabled(false);
        jMenu.add(this.exportAsMenu).setEnabled(false);
        jMenu.addSeparator();
        jMenu.add(this.printMenuItem).setEnabled(false);
        jMenu.addSeparator();
        jMenu.add(jMenuItem6);
        this.displayMenu.add(jMenuItem12);
        this.displayMenu.add(jMenuItem13);
        this.displayMenu.add(jMenuItem14);
        this.displayMenu.addSeparator();
        this.displayMenu.add(this.gridCheckBoxMenuItem);
        this.displayMenu.add(this.coordsCheckBoxMenuItem);
        this.displayMenu.add(this.scaleXCheckBoxMenuItem);
        this.displayMenu.add(this.scaleYCheckBoxMenuItem);
        this.displayMenu.add(this.revPlotCheckBoxMenuItem);
        this.displayMenu.add(this.pointsOnlyCheckBoxMenuItem);
        this.displayMenu.addSeparator();
        this.displayMenu.add(jMenu4);
        this.displayMenu.addSeparator();
        this.displayMenu.add(this.sourceMenuItem).setEnabled(false);
        this.displayMenu.add(this.errorLogMenuItem).setEnabled(false);
        this.displayMenu.add(jMenuItem15);
        jMenu4.add(jMenuItem7);
        jMenu4.add(jMenuItem8);
        jMenu4.add(jMenuItem9);
        jMenu4.add(jMenuItem10);
        jMenu4.add(jMenuItem11);
        jMenu3.add(jMenuItem16);
        jMenu3.addSeparator();
        jMenu3.add(this.toolbarCheckBoxMenuItem);
        jMenu3.add(this.sidePanelCheckBoxMenuItem);
        jMenu3.add(this.statusCheckBoxMenuItem);
        jMenu2.add(jMenuItem17);
        this.add(jMenu);
        this.add(this.displayMenu).setEnabled(false);
        this.add(jMenu3);
        this.add(this.processingMenu).setEnabled(false);
        this.add(jMenu2);
        ApplicationMenu.setMenus(this.saveAsMenu, this.saveAsJDXMenu, this.exportAsMenu, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ApplicationMenu.this.mainFrame.exportSpectrumViaMenu(actionEvent.getActionCommand());
            }
        });
        this.toolbarCheckBoxMenuItem.setSelected(true);
        this.sidePanelCheckBoxMenuItem.setSelected(true);
        this.statusCheckBoxMenuItem.setSelected(true);
    }

    protected void doMenuSelected() {
        PanelData panelData = this.mainFrame.jsvViewer.pd();
        this.gridCheckBoxMenuItem.setSelected(panelData != null && panelData.getBoolean(ScriptToken.GRIDON));
        this.coordsCheckBoxMenuItem.setSelected(panelData != null && panelData.getBoolean(ScriptToken.COORDINATESON));
        this.pointsOnlyCheckBoxMenuItem.setSelected(panelData != null && panelData.getBoolean(ScriptToken.POINTSONLY));
        this.revPlotCheckBoxMenuItem.setSelected(panelData != null && panelData.getBoolean(ScriptToken.REVERSEPLOT));
    }

    public void setProcessingMenu(JComponent jComponent) {
        this.integrationMenuItem = ApplicationMenu.setMenuItem(null, 'I', "Integration", 0, 0, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ApplicationMenu.this.jsvViewer.runScript("showIntegration");
            }
        });
        jComponent.add(this.integrationMenuItem);
        jComponent.add(ApplicationMenu.setMenuItem(null, 'M', "Measurements", 0, 0, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ApplicationMenu.this.jsvViewer.runScript("showMeasurements");
            }
        }));
        jComponent.add(ApplicationMenu.setMenuItem(null, 'P', "Peaks", 0, 0, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ApplicationMenu.this.jsvViewer.runScript("showPeakList");
            }
        }));
        this.transmittanceMenuItem = ApplicationMenu.setMenuItem(null, '\u0000', "Transmittance/Absorbance", 0, 0, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ApplicationMenu.this.jsvViewer.runScript("IRMODE IMPLIED");
            }
        });
        jComponent.add(this.transmittanceMenuItem);
        this.solutionColorMenuItem = ApplicationMenu.setMenuItem(null, 'C', "Predicted Solution Colour", 0, 0, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ApplicationMenu.this.jsvViewer.runScript("GETSOLUTIONCOLOR");
            }
        });
        jComponent.add(this.solutionColorMenuItem);
    }

    protected void setBoolean(ScriptToken scriptToken, ItemEvent itemEvent) {
        boolean bl = itemEvent.getStateChange() == 1;
        this.jsvViewer.runScript((Object)((Object)scriptToken) + " " + bl);
    }

    public void setSourceEnabled(boolean bl) {
        this.closeAllMenuItem.setEnabled(bl);
        this.displayMenu.setEnabled(bl);
        this.processingMenu.setEnabled(bl);
        this.exportAsMenu.setEnabled(bl);
        this.saveAsMenu.setEnabled(bl);
        this.printMenuItem.setEnabled(bl);
        this.sourceMenuItem.setEnabled(bl);
        this.errorLogMenuItem.setEnabled(bl);
    }

    void setCloseMenuItem(String string) {
        this.closeMenuItem.setEnabled(string != null);
        this.closeMenuItem.setText(string == null ? "Close" : "Close " + string);
    }

    void setError(boolean bl, boolean bl2) {
        this.errorLogMenuItem.setEnabled(bl);
    }

    public void setMenuEnables(PanelNode panelNode) {
        if (panelNode == null) {
            this.setCloseMenuItem(null);
            this.setSourceEnabled(false);
        } else {
            this.setSourceEnabled(true);
            PanelData panelData = panelNode.pd();
            Spectrum spectrum = panelData.getSpectrum();
            this.setCheckBoxes(panelData);
            this.setCloseMenuItem(JSVFileManager.getTagName(panelNode.source.getFilePath()));
            this.exportAsMenu.setEnabled(true);
            this.saveAsMenu.setEnabled(true);
            this.saveAsJDXMenu.setEnabled(spectrum.canSaveAsJDX());
            this.integrationMenuItem.setEnabled(spectrum.canIntegrate());
            this.transmittanceMenuItem.setEnabled(spectrum.isAbsorbance() || spectrum.isTransmittance());
            this.solutionColorMenuItem.setEnabled(spectrum.canShowSolutionColor());
        }
    }

    void showPreferencesDialog() {
        this.mainFrame.showPreferences();
    }

    public void setSelections(boolean bl, boolean bl2, boolean bl3, JSVPanel jSVPanel) {
        this.sidePanelCheckBoxMenuItem.setSelected(bl);
        this.toolbarCheckBoxMenuItem.setSelected(bl2);
        this.statusCheckBoxMenuItem.setSelected(bl3);
        if (jSVPanel != null) {
            this.setCheckBoxes(jSVPanel.getPanelData());
        }
    }

    private void setCheckBoxes(PanelData panelData) {
        this.gridCheckBoxMenuItem.setSelected(panelData.getBoolean(ScriptToken.GRIDON));
        this.coordsCheckBoxMenuItem.setSelected(panelData.getBoolean(ScriptToken.COORDINATESON));
        this.revPlotCheckBoxMenuItem.setSelected(panelData.getBoolean(ScriptToken.REVERSEPLOT));
        this.scaleXCheckBoxMenuItem.setSelected(panelData.getBoolean(ScriptToken.XSCALEON));
        this.scaleYCheckBoxMenuItem.setSelected(panelData.getBoolean(ScriptToken.YSCALEON));
    }

    public void setRecentMenu(Lst<String> lst) {
        this.openRecentMenu.removeAll();
        int n = 0;
        while (n < lst.size()) {
            String string = (String)lst.get(n);
            JMenuItem jMenuItem = new JMenuItem(string);
            this.openRecentMenu.add(jMenuItem);
            jMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ApplicationMenu.this.jsvViewer.openFile(((JMenuItem)actionEvent.getSource()).getText(), false);
                }
            });
            ++n;
        }
    }

    public void updateRecentMenus(Lst<String> lst) {
        this.openRecentMenu.removeAll();
        int n = 0;
        while (n < lst.size()) {
            String string = (String)lst.get(n);
            JMenuItem jMenuItem = new JMenuItem(string);
            this.openRecentMenu.add(jMenuItem);
            jMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ApplicationMenu.this.jsvViewer.openFile(((JMenuItem)actionEvent.getSource()).getText(), true);
                }
            });
            ++n;
        }
    }

    public void clearSourceMenu(JDXSource jDXSource) {
        if (jDXSource == null) {
            this.setMenuEnables(null);
        } else {
            this.saveAsJDXMenu.setEnabled(true);
            this.saveAsMenu.setEnabled(true);
        }
    }

    public static void addMenuItem(JMenu jMenu, String string, char c, ActionListener actionListener) {
        JMenuItem jMenuItem = new JMenuItem();
        jMenuItem.setMnemonic(c == '\u0000' ? string.charAt(0) : c);
        jMenuItem.setText(string);
        jMenuItem.addActionListener(actionListener);
        jMenu.add(jMenuItem);
    }

    public static void setMenus(JMenu jMenu, JMenu jMenu2, JMenu jMenu3, ActionListener actionListener) {
        jMenu.setText("Save As");
        ApplicationMenu.addMenuItem(jMenu, "Original...", '\u0000', actionListener);
        jMenu2.setText("JDX");
        ApplicationMenu.addMenuItem(jMenu2, "XY", '\u0000', actionListener);
        ApplicationMenu.addMenuItem(jMenu2, "DIF", '\u0000', actionListener);
        ApplicationMenu.addMenuItem(jMenu2, "DIFDUP", 'U', actionListener);
        ApplicationMenu.addMenuItem(jMenu2, "FIX", '\u0000', actionListener);
        ApplicationMenu.addMenuItem(jMenu2, "PAC", '\u0000', actionListener);
        ApplicationMenu.addMenuItem(jMenu2, "SQZ", '\u0000', actionListener);
        jMenu.add(jMenu2);
        ApplicationMenu.addMenuItem(jMenu, "CML", '\u0000', actionListener);
        ApplicationMenu.addMenuItem(jMenu, "XML (AnIML)", '\u0000', actionListener);
        if (jMenu3 != null) {
            jMenu3.setText("Export As");
            ApplicationMenu.addMenuItem(jMenu3, "JPG", '\u0000', actionListener);
            ApplicationMenu.addMenuItem(jMenu3, "PNG", 'N', actionListener);
            ApplicationMenu.addMenuItem(jMenu3, "SVG", '\u0000', actionListener);
            ApplicationMenu.addMenuItem(jMenu3, "PDF", '\u0000', actionListener);
        }
    }

    public static JMenuItem setMenuItem(JMenuItem jMenuItem, char c, String string, int n, int n2, EventListener eventListener) {
        if (jMenuItem == null) {
            jMenuItem = new JMenuItem();
        }
        if (c != '\u0000') {
            jMenuItem.setMnemonic(c);
        }
        jMenuItem.setText(string);
        if (n > 0) {
            jMenuItem.setAccelerator(KeyStroke.getKeyStroke(n, n2, false));
        }
        if (eventListener instanceof ActionListener) {
            jMenuItem.addActionListener((ActionListener)eventListener);
        } else if (eventListener instanceof ItemListener) {
            jMenuItem.addItemListener((ItemListener)eventListener);
        }
        return jMenuItem;
    }
}

