/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.keys;

import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import java.util.List;
import java.util.Optional;
import org.jboss.logging.Logger;
import org.keycloak.common.util.CertificateUtils;
import org.keycloak.common.util.PemUtils;
import org.keycloak.component.ComponentModel;
import org.keycloak.crypto.KeyUse;
import org.keycloak.crypto.KeyWrapper;
import org.keycloak.keys.AbstractEcKeyProvider;
import org.keycloak.keys.GeneratedEcdsaKeyProviderFactory;
import org.keycloak.models.RealmModel;

public class GeneratedEcdsaKeyProvider
extends AbstractEcKeyProvider {
    private static final Logger logger = Logger.getLogger(GeneratedEcdsaKeyProvider.class);

    public GeneratedEcdsaKeyProvider(RealmModel realm, ComponentModel model) {
        super(realm, model);
    }

    @Override
    protected KeyWrapper loadKey(RealmModel realm, ComponentModel model) {
        String privateEcdsaKeyBase64Encoded = (String)model.getConfig().getFirst((Object)"ecdsaPrivateKey");
        String publicEcdsaKeyBase64Encoded = (String)model.getConfig().getFirst((Object)"ecdsaPublicKey");
        String ecInNistRep = (String)model.getConfig().getFirst((Object)"ecdsaEllipticCurveKey");
        boolean generateCertificate = Optional.ofNullable((String)model.getConfig().getFirst((Object)"ecGenerateCertificate")).map(Boolean::parseBoolean).orElse(false);
        try {
            PKCS8EncodedKeySpec privateKeySpec = new PKCS8EncodedKeySpec(Base64.getMimeDecoder().decode(privateEcdsaKeyBase64Encoded));
            KeyFactory kf = KeyFactory.getInstance("EC");
            PrivateKey decodedPrivateKey = kf.generatePrivate(privateKeySpec);
            X509EncodedKeySpec publicKeySpec = new X509EncodedKeySpec(Base64.getMimeDecoder().decode(publicEcdsaKeyBase64Encoded));
            PublicKey decodedPublicKey = kf.generatePublic(publicKeySpec);
            KeyPair keyPair = new KeyPair(decodedPublicKey, decodedPrivateKey);
            X509Certificate selfSignedCertificate = Optional.ofNullable((String)model.getConfig().getFirst((Object)"certificate")).map(PemUtils::decodeCertificate).orElse(null);
            if (generateCertificate && selfSignedCertificate == null) {
                selfSignedCertificate = CertificateUtils.generateV1SelfSignedCertificate((KeyPair)keyPair, (String)realm.getName());
                model.getConfig().put((Object)"certificate", List.of(Base64.getEncoder().encodeToString(selfSignedCertificate.getEncoded())));
            }
            return this.createKeyWrapper(keyPair, GeneratedEcdsaKeyProviderFactory.convertECDomainParmNistRepToJWSAlgorithm(ecInNistRep), KeyUse.SIG, selfSignedCertificate);
        }
        catch (Exception e) {
            logger.debug((Object)e.getMessage(), (Throwable)e);
            logger.warnf("Exception at decodeEcdsaPublicKey. %s", (Object)e.toString());
            return null;
        }
    }
}

