/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.query.lucenelib;

import org.apache.lucene.search.Query;
import org.apache.lucene.search.join.BitSetProducer;
import org.opensearch.knn.index.query.common.QueryUtils;
import org.opensearch.knn.index.query.lucenelib.ExpandNestedDocsQuery;
import org.opensearch.knn.index.query.lucenelib.InternalNestedKnnByteVectorQuery;
import org.opensearch.knn.index.query.lucenelib.InternalNestedKnnFloatVectorQuery;
import org.opensearch.knn.index.query.lucenelib.OSDiversifyingChildrenByteKnnVectorQuery;
import org.opensearch.knn.index.query.lucenelib.OSDiversifyingChildrenFloatKnnVectorQuery;

public class NestedKnnVectorQueryFactory {
    public static Query createNestedKnnVectorQuery(String fieldName, byte[] vector, int luceneK, Query filterQuery, BitSetProducer parentFilter, boolean expandNestedDocs, int k) {
        if (expandNestedDocs) {
            return new ExpandNestedDocsQuery.ExpandNestedDocsQueryBuilder().internalNestedKnnVectorQuery(new InternalNestedKnnByteVectorQuery(fieldName, vector, filterQuery, luceneK, parentFilter, k)).queryUtils(QueryUtils.getInstance()).build();
        }
        return new OSDiversifyingChildrenByteKnnVectorQuery(fieldName, vector, filterQuery, luceneK, parentFilter, k);
    }

    public static Query createNestedKnnVectorQuery(String fieldName, float[] vector, int luceneK, Query filterQuery, BitSetProducer parentFilter, boolean expandNestedDocs, int k) {
        if (expandNestedDocs) {
            return new ExpandNestedDocsQuery.ExpandNestedDocsQueryBuilder().internalNestedKnnVectorQuery(new InternalNestedKnnFloatVectorQuery(fieldName, vector, filterQuery, luceneK, parentFilter, k)).queryUtils(QueryUtils.getInstance()).build();
        }
        return new OSDiversifyingChildrenFloatKnnVectorQuery(fieldName, vector, filterQuery, luceneK, parentFilter, k);
    }
}

