/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.client;

import jakarta.ws.rs.core.Configuration;
import org.glassfish.jersey.client.ClientRuntime;
import org.glassfish.jersey.innate.io.SafelyClosable;
import org.glassfish.jersey.internal.BootstrapBag;
import org.glassfish.jersey.internal.BootstrapConfigurator;
import org.glassfish.jersey.internal.inject.Binding;
import org.glassfish.jersey.internal.inject.Bindings;
import org.glassfish.jersey.internal.inject.InjectionManager;
import org.glassfish.jersey.internal.inject.InstanceBinding;
import org.glassfish.jersey.internal.util.collection.LazyValue;
import org.glassfish.jersey.internal.util.collection.Value;
import org.glassfish.jersey.internal.util.collection.Values;
import org.glassfish.jersey.message.MessageBodyWorkers;
import org.glassfish.jersey.message.internal.MessageBodyFactory;

class ClientMessageBodyFactory
extends MessageBodyFactory
implements SafelyClosable {
    private LazyValue<ClientRuntime> clientRuntime;

    private ClientMessageBodyFactory(Configuration configuration, Value<ClientRuntime> clientRuntimeValue) {
        super(configuration);
        this.clientRuntime = Values.lazy(clientRuntimeValue);
    }

    public void close() {
        this.clientRuntime = null;
    }

    ClientRuntime getClientRuntime() {
        return (ClientRuntime)this.clientRuntime.get();
    }

    static class MessageBodyWorkersConfigurator
    implements BootstrapConfigurator {
        private ClientMessageBodyFactory messageBodyFactory;
        private ClientRuntime clientRuntime;

        MessageBodyWorkersConfigurator() {
        }

        public void init(InjectionManager injectionManager, BootstrapBag bootstrapBag) {
            this.messageBodyFactory = new ClientMessageBodyFactory(bootstrapBag.getConfiguration(), (Value<ClientRuntime>)((Value)() -> this.clientRuntime));
            InstanceBinding binding = (InstanceBinding)Bindings.service((Object)((Object)this.messageBodyFactory)).to(MessageBodyWorkers.class);
            injectionManager.register((Binding)binding);
        }

        public void postInit(InjectionManager injectionManager, BootstrapBag bootstrapBag) {
            this.messageBodyFactory.initialize(injectionManager);
            bootstrapBag.setMessageBodyWorkers((MessageBodyWorkers)this.messageBodyFactory);
        }

        void setClientRuntime(ClientRuntime clientRuntime) {
            this.clientRuntime = clientRuntime;
        }
    }
}

