/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin;

import java.lang.invoke.MethodHandles;
import java.util.HashMap;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.solr.cloud.SyncStrategy;
import org.apache.solr.cloud.ZkController;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.core.SolrCore;
import org.apache.solr.handler.admin.CoreAdminHandler;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.util.RefCounted;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RequestSyncShardOp
implements CoreAdminHandler.CoreAdminOp {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    RequestSyncShardOp() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(CoreAdminHandler.CallInfo it) throws Exception {
        block21: {
            SolrParams params = it.req.getParams();
            log.info("I have been requested to sync up my shard");
            String cname = params.required().get("core");
            ZkController zkController = it.handler.coreContainer.getZkController();
            if (zkController == null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Only valid for SolrCloud");
            }
            try (SyncStrategy syncStrategy = null;
                 SolrCore core = it.handler.coreContainer.getCore(cname);){
                if (core != null) {
                    syncStrategy = new SyncStrategy(core.getCoreContainer());
                    HashMap<String, String> props = new HashMap<String, String>();
                    props.put("core", cname);
                    props.put("node_name", zkController.getNodeName());
                    props.put("base_url", zkController.getZkStateReader().getBaseUrlForNodeName(zkController.getNodeName()));
                    boolean success = syncStrategy.sync(zkController, core, new ZkNodeProps(props), true).isSuccess();
                    if (log.isDebugEnabled()) {
                        try {
                            RefCounted<SolrIndexSearcher> searchHolder = core.getNewestSearcher(false);
                            SolrIndexSearcher searcher = searchHolder.get();
                            try {
                                if (log.isDebugEnabled()) {
                                    log.debug("{} synched {}", (Object)core.getCoreContainer().getZkController().getNodeName(), (Object)searcher.count((Query)new MatchAllDocsQuery()));
                                }
                            }
                            finally {
                                searchHolder.decref();
                            }
                        }
                        catch (Exception e) {
                            log.debug("Error in solrcloud_debug block", (Throwable)e);
                        }
                    }
                    if (!success) {
                        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Sync Failed");
                    }
                    break block21;
                }
                log.error("Could not find core to call sync: {}", (Object)cname);
            }
        }
    }
}

