/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.scan;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.jar.Manifest;
import org.apache.tomcat.Jar;
import org.apache.tomcat.util.scan.JarFactory;

public class ReferenceCountedJar
implements Jar {
    private final URL url;
    private Jar wrappedJar;
    private int referenceCount = 0;

    public ReferenceCountedJar(URL uRL) throws IOException {
        this.url = uRL;
        this.open();
    }

    private synchronized ReferenceCountedJar open() throws IOException {
        if (this.wrappedJar == null) {
            this.wrappedJar = JarFactory.newInstance(this.url);
        }
        ++this.referenceCount;
        return this;
    }

    public synchronized void close() {
        --this.referenceCount;
        if (this.referenceCount == 0) {
            this.wrappedJar.close();
            this.wrappedJar = null;
        }
    }

    public URL getJarFileURL() {
        return this.url;
    }

    public InputStream getInputStream(String string) throws IOException {
        try (ReferenceCountedJar referenceCountedJar = this.open();){
            InputStream inputStream = referenceCountedJar.wrappedJar.getInputStream(string);
            return inputStream;
        }
    }

    public long getLastModified(String string) throws IOException {
        try (ReferenceCountedJar referenceCountedJar = this.open();){
            long l = referenceCountedJar.wrappedJar.getLastModified(string);
            return l;
        }
    }

    public boolean exists(String string) throws IOException {
        try (ReferenceCountedJar referenceCountedJar = this.open();){
            boolean bl = referenceCountedJar.wrappedJar.exists(string);
            return bl;
        }
    }

    public void nextEntry() {
        try (ReferenceCountedJar referenceCountedJar = this.open();){
            referenceCountedJar.wrappedJar.nextEntry();
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException);
        }
    }

    public String getEntryName() {
        ReferenceCountedJar referenceCountedJar = this.open();
        try {
            String string = referenceCountedJar.wrappedJar.getEntryName();
            if (referenceCountedJar != null) {
                referenceCountedJar.close();
            }
            return string;
        }
        catch (Throwable throwable) {
            try {
                if (referenceCountedJar != null) {
                    try {
                        referenceCountedJar.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (IOException iOException) {
                throw new IllegalStateException(iOException);
            }
        }
    }

    public InputStream getEntryInputStream() throws IOException {
        try (ReferenceCountedJar referenceCountedJar = this.open();){
            InputStream inputStream = referenceCountedJar.wrappedJar.getEntryInputStream();
            return inputStream;
        }
    }

    public String getURL(String string) {
        ReferenceCountedJar referenceCountedJar = this.open();
        try {
            String string2 = referenceCountedJar.wrappedJar.getURL(string);
            if (referenceCountedJar != null) {
                referenceCountedJar.close();
            }
            return string2;
        }
        catch (Throwable throwable) {
            try {
                if (referenceCountedJar != null) {
                    try {
                        referenceCountedJar.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (IOException iOException) {
                throw new IllegalStateException(iOException);
            }
        }
    }

    public Manifest getManifest() throws IOException {
        try (ReferenceCountedJar referenceCountedJar = this.open();){
            Manifest manifest = referenceCountedJar.wrappedJar.getManifest();
            return manifest;
        }
    }

    public void reset() throws IOException {
        try (ReferenceCountedJar referenceCountedJar = this.open();){
            referenceCountedJar.wrappedJar.reset();
        }
    }
}

