/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.grid.internal.utils.configuration.json;

import java.util.List;
import org.openqa.grid.common.exception.GridConfigurationException;
import org.openqa.grid.internal.utils.configuration.json.GridJsonConfiguration;
import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.json.JsonInput;

public class NodeJsonConfiguration
extends GridJsonConfiguration {
    private String hubHost;
    private Integer hubPort;
    private String id;
    private List<MutableCapabilities> capabilities;
    public Integer maxSession;
    private Integer downPollingLimit;
    private String hub;
    private Integer nodePolling;
    private Integer nodeStatusCheckTimeout;
    private String proxy;
    private Boolean register = true;
    private Integer registerCycle;
    private Integer unregisterIfStillDownAfter;
    private boolean enablePlatformVerification = true;
    private Object configuration;

    private NodeJsonConfiguration() {
    }

    public static NodeJsonConfiguration loadFromJson(JsonInput source) {
        NodeJsonConfiguration config = NodeJsonConfiguration.fromJson(source, NodeJsonConfiguration.class);
        if (config.configuration != null) {
            throw new GridConfigurationException("Deprecated -nodeConfig file encountered. Please update the file to work with Selenium 3. See https://github.com/SeleniumHQ/selenium/wiki/Grid2#configuring-the-nodes-by-json for more details.");
        }
        if (config.getRole() != null && !config.getRole().equals("node")) {
            throw new RuntimeException("Unable to load node configuration from " + source + " because it contains configuration for '" + config.getRole() + "' role");
        }
        return config;
    }

    public static NodeJsonConfiguration loadFromResourceOrFile(String source) {
        NodeJsonConfiguration config = NodeJsonConfiguration.fromResourceOrFile(source, NodeJsonConfiguration.class);
        if (config.configuration != null) {
            throw new GridConfigurationException("Deprecated -nodeConfig file encountered. Please update the file to work with Selenium 3. See https://github.com/SeleniumHQ/selenium/wiki/Grid2#configuring-the-nodes-by-json for more details.");
        }
        if (config.getRole() != null && !config.getRole().equals("node")) {
            throw new RuntimeException("Unable to load node configuration from " + source + " because it contains configuration for '" + config.getRole() + "' role");
        }
        return config;
    }

    public String getHubHost() {
        return this.hubHost;
    }

    public Integer getHubPort() {
        return this.hubPort;
    }

    public String getId() {
        return this.id;
    }

    public List<MutableCapabilities> getCapabilities() {
        return this.capabilities;
    }

    public Integer getMaxSession() {
        return this.maxSession;
    }

    public Integer getDownPollingLimit() {
        return this.downPollingLimit;
    }

    public String getHub() {
        return this.hub;
    }

    public Integer getNodePolling() {
        return this.nodePolling;
    }

    public Integer getNodeStatusCheckTimeout() {
        return this.nodeStatusCheckTimeout;
    }

    public String getProxy() {
        return this.proxy;
    }

    public Boolean getRegister() {
        return this.register;
    }

    public Integer getRegisterCycle() {
        return this.registerCycle;
    }

    public Integer getUnregisterIfStillDownAfter() {
        return this.unregisterIfStillDownAfter;
    }

    public boolean isEnablePlatformVerification() {
        return this.enablePlatformVerification;
    }
}

