/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.osgish;

import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.jolokia.osgish.OsgishServiceMBean;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.service.log.LogService;
import org.osgi.util.tracker.ServiceTracker;

public class OsgishService
implements OsgishServiceMBean,
MBeanRegistration,
ServiceListener,
BundleListener {
    BundleContext bundleContext;
    private long bundlesLastChanged;
    private long servicesLastChanged;
    private long packagesLastChanged;
    private ServiceTracker logTracker;
    private static final String OSGISH_SERVICE_NAME = "osgish:type=Service";

    public OsgishService(BundleContext pBundleContext) {
        long time;
        this.logTracker = new ServiceTracker(pBundleContext, LogService.class.getName(), null);
        this.bundlesLastChanged = time = this.getCurrentTime();
        this.servicesLastChanged = time;
        this.packagesLastChanged = time;
        this.bundleContext = pBundleContext;
    }

    public boolean hasStateChanged(String pWhat, long pTimestamp) {
        if ("bundles".equals(pWhat)) {
            return this.isYoungerThan(this.bundlesLastChanged, pTimestamp);
        }
        if ("services".equals(pWhat)) {
            return this.isYoungerThan(this.servicesLastChanged, pTimestamp);
        }
        if ("packages".equals(pWhat)) {
            return this.isYoungerThan(this.packagesLastChanged, pTimestamp);
        }
        return false;
    }

    private boolean isYoungerThan(long pLastChanged, long pTimestamp) {
        return pLastChanged >= pTimestamp;
    }

    void log(int level, String message) {
        LogService logService = (LogService)this.logTracker.getService();
        if (logService != null) {
            logService.log(level, message);
        }
    }

    public void serviceChanged(ServiceEvent event) {
        this.servicesLastChanged = this.getCurrentTime();
    }

    public void bundleChanged(BundleEvent event) {
        long time;
        this.bundlesLastChanged = time = this.getCurrentTime();
        this.packagesLastChanged = time;
    }

    private long getCurrentTime() {
        return System.currentTimeMillis() / 1000L;
    }

    public ObjectName preRegister(MBeanServer pMBeanServer, ObjectName pObjectName) throws MalformedObjectNameException {
        return new ObjectName(OSGISH_SERVICE_NAME);
    }

    public void postRegister(Boolean pBoolean) {
        this.bundleContext.addBundleListener((BundleListener)this);
        this.bundleContext.addServiceListener((ServiceListener)this);
        this.logTracker.open();
        this.log(4, "Registered osgish:type=Service");
    }

    public void preDeregister() {
        this.bundleContext.removeBundleListener((BundleListener)this);
        this.bundleContext.removeServiceListener((ServiceListener)this);
        this.log(4, "Unregistered osgish:type=Service");
        this.logTracker.close();
    }

    public void postDeregister() {
    }
}

