# Generated by default/object.tt
package Paws::Quicksight::FolderSearchFilter;
  use Moose;
  has Name => (is => 'ro', isa => 'Str');
  has Operator => (is => 'ro', isa => 'Str');
  has Value => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::Quicksight::FolderSearchFilter

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Quicksight::FolderSearchFilter object:

  $service_obj->Method(Att1 => { Name => $value, ..., Value => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Quicksight::FolderSearchFilter object:

  $result = $service_obj->Method(...);
  $result->Att1->Name

=head1 DESCRIPTION

Searches a folder by a filter.

=head1 ATTRIBUTES


=head2 Name => Str

The name of the value that you want to use as a filter. For example,
C<"Name": "PARENT_FOLDER_ARN">.


=head2 Operator => Str

The comparison operator that you want to use as a filter. For example,
C<"Operator": "StringEquals">.


=head2 Value => Str

The value of the named item (in this example, C<PARENT_FOLDER_ARN>),
that you want to use as a filter. For example, C<"Value":
"arn:aws:quicksight:us-east-1:1:folder/folderId">.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Quicksight>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

