# NOTE: Assertions have been autogenerated by utils/update_mca_test_checks.py
# RUN: llvm-mca -mtriple=riscv64 -mcpu=spacemit-x60 -iterations=1 -instruction-tables=full < %s | FileCheck %s

# Integer Register-Immediate Instructions
addi a0, a0, 1
addiw a0, a0, 1
slti a0, a0, 1
sltiu a0, a0, 1

andi a0, a0, 1
ori a0, a0, 1
xori a0, a0, 1

slli a0, a0, 1
srli a0, a0, 1
srai a0, a0, 1
slliw a0, a0, 1
srliw a0, a0, 1
sraiw a0, a0, 1

lui a0, 1
auipc a1, 1

# Integer Register-Register Operations
add a0, a0, a1
addw a0, a0, a0
slt a0, a0, a0
sltu a0, a0, a0

and a0, a0, a0
or a0, a0, a0
xor a0, a0, a0

sll a0, a0, a0
srl a0, a0, a0
sra a0, a0, a0
sllw a0, a0, a0
srlw a0, a0, a0
sraw a0, a0, a0

sub a0, a0, a0
subw a0, a0, a0

# Control Transfer Instructions

## Unconditional Jumps
jal a0, 1f
1:
jalr a0
beq a0, a0, 1f
1:
bne a0, a0, 1f
1:
blt a0, a0, 1f
1:
bltu a0, a0, 1f
1:
bge a0, a0, 1f
1:
bgeu a0, a0, 1f
1:
add a0, a0, a0

# Load and Store Instructions
lb t0, 0(a0)
lbu t0, 0(a0)
lh t0, 0(a0)
lhu t0, 0(a0)
lw t0, 0(a0)
lwu t0, 0(a0)
ld t0, 0(a0)

sb t0, 0(a0)
sh t0, 0(a0)
sw t0, 0(a0)
sd t0, 0(a0)

# Multiply/Division
mul a0, a0, a0
mulh a0, a0, a0
mulhu a0, a0, a0
mulhsu a0, a0, a0
mulw a0, a0, a0
div a0, a1, a2
divu a0, a1, a2
rem a0, a1, a2
remu a0, a1, a2
divw a0, a1, a2
divuw a0, a1, a2
remw a0, a1, a2
remuw a0, a1, a2

# Zicsr
csrrw t0, 0xfff, t1
csrrs s3, 0x001, s5
csrrc sp, 0x000, ra
csrrwi a5, 0x000, 0
csrrsi t2, 0xfff, 31
csrrci t1, 0x140, 5

# Zicond
czero.eqz a0, a1, a2
czero.nez a0, a1, a2

# Zicond
czero.eqz a0, a1, a2
czero.nez a0, a1, a2

# Zba
add.uw a0, a0, a0
slli.uw a0, a0, 1
sh1add.uw a0, a0, a0
sh2add.uw a0, a0, a0
sh3add.uw a0, a0, a0
sh1add a0, a0, a0
sh2add a0, a0, a0
sh3add a0, a0, a0

# Zbb
andn a0, a0, a0
orn a0, a0, a0
xnor a0, a0, a0

clz a0, a0
clzw a0, a0
ctz a0, a0
ctzw a0, a0

cpop a0, a0
cpopw a0, a0

min a0, a0, a0
minu a0, a0, a0
max a0, a0, a0
maxu a0, a0, a0

sext.b a0, a0
sext.h a0, a0
zext.h a0, a0

rol a0, a0, a0
rolw a0, a0, a0
ror a0, a0, a0
rorw a0, a0, a0
rori a0, a0, 1
roriw a0, a0, 1

orc.b a0, a0

rev8 a0, a0

# Zbc
clmul a0, a0, a0
clmulr a0, a0, a0
clmulh a0, a0, a0

# Zbs
bclr a0, a1, a2
bclri a0, a1, 1
bext a0, a1, a2
bexti a0, a1, 1
binv a0, a1, a2
binvi a0, a1, 1
bset a0, a1, a2
bseti a0, a1, 1

# CHECK:      Resources:
# CHECK-NEXT: [0]   - SMX60_FP:1
# CHECK-NEXT: [1]   - SMX60_IEU:2 SMX60_IEUA, SMX60_IEUB
# CHECK-NEXT: [2]   - SMX60_IEUA:1
# CHECK-NEXT: [3]   - SMX60_IEUB:1
# CHECK-NEXT: [4]   - SMX60_LS:2

# CHECK:      Instruction Info:
# CHECK-NEXT: [1]: #uOps
# CHECK-NEXT: [2]: Latency
# CHECK-NEXT: [3]: RThroughput
# CHECK-NEXT: [4]: MayLoad
# CHECK-NEXT: [5]: MayStore
# CHECK-NEXT: [6]: HasSideEffects (U)
# CHECK-NEXT: [7]: Bypass Latency
# CHECK-NEXT: [8]: Resources (<Name> | <Name>[<ReleaseAtCycle>] | <Name>[<AcquireAtCycle>,<ReleaseAtCycle])
# CHECK-NEXT: [9]: LLVM Opcode Name

# CHECK:      [1]    [2]    [3]    [4]    [5]    [6]    [7]    [8]                                        [9]                        Instructions:
# CHECK-NEXT:  1      1     0.50                         1     SMX60_IEU                                  C_ADDI                     addi	a0, a0, 1
# CHECK-NEXT:  1      1     0.50                         1     SMX60_IEU                                  C_ADDIW                    addiw	a0, a0, 1
# CHECK-NEXT:  1      1     0.50                         1     SMX60_IEU                                  SLTI                       slti	a0, a0, 1
# CHECK-NEXT:  1      1     0.50                         1     SMX60_IEU                                  SLTIU                      seqz	a0, a0
# CHECK-NEXT:  1      1     0.50                         1     SMX60_IEU                                  C_ANDI                     andi	a0, a0, 1
# CHECK-NEXT:  1      1     0.50                         1     SMX60_IEU                                  ORI                        ori	a0, a0, 1
# CHECK-NEXT:  1      1     0.50                         1     SMX60_IEU                                  XORI                       xori	a0, a0, 1
# CHECK-NEXT:  1      1     0.50                         1     SMX60_IEU                                  C_SLLI                     slli	a0, a0, 1
# CHECK-NEXT:  1      1     0.50                         1     SMX60_IEU                                  C_SRLI                     srli	a0, a0, 1
# CHECK-NEXT:  1      1     0.50                         1     SMX60_IEU                                  C_SRAI                     srai	a0, a0, 1
# CHECK-NEXT:  1      1     0.50                         1     SMX60_IEU                                  SLLIW                      slliw	a0, a0, 1
# CHECK-NEXT:  1      1     0.50                         1     SMX60_IEU                                  SRLIW                      srliw	a0, a0, 1
# CHECK-NEXT:  1      1     0.50                         1     SMX60_IEU                                  SRAIW                      sraiw	a0, a0, 1
# CHECK-NEXT:  1      1     0.50                         1     SMX60_IEU                                  C_LUI                      lui	a0, 1
# CHECK-NEXT:  1      1     0.50                         1     SMX60_IEU                                  AUIPC                      auipc	a1, 1
# CHECK-NEXT:  1      1     0.50                         1     SMX60_IEU                                  C_ADD                      add	a0, a0, a1
# CHECK-NEXT:  1      1     0.50                         1     SMX60_IEU                                  C_ADDW                     addw	a0, a0, a0
# CHECK-NEXT:  1      1     0.50                         1     SMX60_IEU                                  SLT                        slt	a0, a0, a0
# CHECK-NEXT:  1      1     0.50                         1     SMX60_IEU                                  SLTU                       sltu	a0, a0, a0
# CHECK-NEXT:  1      1     0.50                         1     SMX60_IEU                                  C_AND                      and	a0, a0, a0
# CHECK-NEXT:  1      1     0.50                         1     SMX60_IEU                                  C_OR                       or	a0, a0, a0
# CHECK-NEXT:  1      1     0.50                         1     SMX60_IEU                                  C_XOR                      xor	a0, a0, a0
# CHECK-NEXT:  1      1     0.50                         1     SMX60_IEU                                  SLL                        sll	a0, a0, a0
# CHECK-NEXT:  1      1     0.50                         1     SMX60_IEU                                  SRL                        srl	a0, a0, a0
# CHECK-NEXT:  1      1     0.50                         1     SMX60_IEU                                  SRA                        sra	a0, a0, a0
# CHECK-NEXT:  1      1     0.50                         1     SMX60_IEU                                  SLLW                       sllw	a0, a0, a0
# CHECK-NEXT:  1      1     0.50                         1     SMX60_IEU                                  SRLW                       srlw	a0, a0, a0
# CHECK-NEXT:  1      1     0.50                         1     SMX60_IEU                                  SRAW                       sraw	a0, a0, a0
# CHECK-NEXT:  1      1     0.50                         1     SMX60_IEU                                  C_SUB                      sub	a0, a0, a0
# CHECK-NEXT:  1      1     0.50                         1     SMX60_IEU                                  C_SUBW                     subw	a0, a0, a0
# CHECK-NEXT:  1      1     1.00                         1     SMX60_IEU,SMX60_IEUA                       JAL                        jal	a0, .Ltmp0
# CHECK-NEXT:  1      1     1.00                         1     SMX60_IEU,SMX60_IEUA                       C_JALR                     jalr	a0
# CHECK-NEXT:  1      1     1.00                         1     SMX60_IEU,SMX60_IEUA                       BEQ                        beq	a0, a0, .Ltmp1
# CHECK-NEXT:  1      1     1.00                         1     SMX60_IEU,SMX60_IEUA                       BNE                        bne	a0, a0, .Ltmp2
# CHECK-NEXT:  1      1     1.00                         1     SMX60_IEU,SMX60_IEUA                       BLT                        blt	a0, a0, .Ltmp3
# CHECK-NEXT:  1      1     1.00                         1     SMX60_IEU,SMX60_IEUA                       BLTU                       bltu	a0, a0, .Ltmp4
# CHECK-NEXT:  1      1     1.00                         1     SMX60_IEU,SMX60_IEUA                       BGE                        bge	a0, a0, .Ltmp5
# CHECK-NEXT:  1      1     1.00                         1     SMX60_IEU,SMX60_IEUA                       BGEU                       bgeu	a0, a0, .Ltmp6
# CHECK-NEXT:  1      1     0.50                         1     SMX60_IEU                                  C_ADD                      add	a0, a0, a0
# CHECK-NEXT:  1      4     0.50    *                    4     SMX60_LS                                   LB                         lb	t0, 0(a0)
# CHECK-NEXT:  1      4     0.50    *                    4     SMX60_LS                                   LBU                        lbu	t0, 0(a0)
# CHECK-NEXT:  1      4     0.50    *                    4     SMX60_LS                                   LH                         lh	t0, 0(a0)
# CHECK-NEXT:  1      4     0.50    *                    4     SMX60_LS                                   LHU                        lhu	t0, 0(a0)
# CHECK-NEXT:  1      4     0.50    *                    4     SMX60_LS                                   LW                         lw	t0, 0(a0)
# CHECK-NEXT:  1      4     0.50    *                    4     SMX60_LS                                   LWU                        lwu	t0, 0(a0)
# CHECK-NEXT:  1      4     0.50    *                    4     SMX60_LS                                   LD                         ld	t0, 0(a0)
# CHECK-NEXT:  1      4     0.50           *             4     SMX60_LS                                   SB                         sb	t0, 0(a0)
# CHECK-NEXT:  1      4     0.50           *             4     SMX60_LS                                   SH                         sh	t0, 0(a0)
# CHECK-NEXT:  1      4     0.50           *             4     SMX60_LS                                   SW                         sw	t0, 0(a0)
# CHECK-NEXT:  1      4     0.50           *             4     SMX60_LS                                   SD                         sd	t0, 0(a0)
# CHECK-NEXT:  1      6     0.50                         6     SMX60_IEU                                  MUL                        mul	a0, a0, a0
# CHECK-NEXT:  1      6     0.50                         6     SMX60_IEU                                  MULH                       mulh	a0, a0, a0
# CHECK-NEXT:  1      6     0.50                         6     SMX60_IEU                                  MULHU                      mulhu	a0, a0, a0
# CHECK-NEXT:  1      6     0.50                         6     SMX60_IEU                                  MULHSU                     mulhsu	a0, a0, a0
# CHECK-NEXT:  1      3     0.50                         3     SMX60_IEU                                  MULW                       mulw	a0, a0, a0
# CHECK-NEXT:  1      20    20.00                        20    SMX60_IEU[20],SMX60_IEUA[20]               DIV                        div	a0, a1, a2
# CHECK-NEXT:  1      20    20.00                        20    SMX60_IEU[20],SMX60_IEUA[20]               DIVU                       divu	a0, a1, a2
# CHECK-NEXT:  1      20    20.00                        20    SMX60_IEU[20],SMX60_IEUA[20]               REM                        rem	a0, a1, a2
# CHECK-NEXT:  1      20    20.00                        20    SMX60_IEU[20],SMX60_IEUA[20]               REMU                       remu	a0, a1, a2
# CHECK-NEXT:  1      12    12.00                        12    SMX60_IEU[12],SMX60_IEUA[12]               DIVW                       divw	a0, a1, a2
# CHECK-NEXT:  1      12    12.00                        12    SMX60_IEU[12],SMX60_IEUA[12]               DIVUW                      divuw	a0, a1, a2
# CHECK-NEXT:  1      12    12.00                        12    SMX60_IEU[12],SMX60_IEUA[12]               REMW                       remw	a0, a1, a2
# CHECK-NEXT:  1      12    12.00                        12    SMX60_IEU[12],SMX60_IEUA[12]               REMUW                      remuw	a0, a1, a2
# CHECK-NEXT:  1      1     0.50                  U      1     SMX60_IEU                                  CSRRW                      csrrw	t0, 4095, t1
# CHECK-NEXT:  1      1     0.50                  U      1     SMX60_IEU                                  CSRRS                      csrrs	s3, fflags, s5
# CHECK-NEXT:  1      1     0.50                  U      1     SMX60_IEU                                  CSRRC                      csrrc	sp, 0, ra
# CHECK-NEXT:  1      1     0.50                  U      1     SMX60_IEU                                  CSRRWI                     csrrwi	a5, 0, 0
# CHECK-NEXT:  1      1     0.50                  U      1     SMX60_IEU                                  CSRRSI                     csrrsi	t2, 4095, 31
# CHECK-NEXT:  1      1     0.50                  U      1     SMX60_IEU                                  CSRRCI                     csrrci	t1, sscratch, 5
# CHECK-NEXT:  1      1     0.50                         1     SMX60_IEU                                  CZERO_EQZ                  czero.eqz	a0, a1, a2
# CHECK-NEXT:  1      1     0.50                         1     SMX60_IEU                                  CZERO_NEZ                  czero.nez	a0, a1, a2
# CHECK-NEXT:  1      1     0.50                         1     SMX60_IEU                                  CZERO_EQZ                  czero.eqz	a0, a1, a2
# CHECK-NEXT:  1      1     0.50                         1     SMX60_IEU                                  CZERO_NEZ                  czero.nez	a0, a1, a2
# CHECK-NEXT:  1      1     0.50                         1     SMX60_IEU                                  ADD_UW                     add.uw	a0, a0, a0
# CHECK-NEXT:  1      1     0.50                         1     SMX60_IEU                                  SLLI_UW                    slli.uw	a0, a0, 1
# CHECK-NEXT:  1      2     0.50                         2     SMX60_IEU                                  SH1ADD_UW                  sh1add.uw	a0, a0, a0
# CHECK-NEXT:  1      2     0.50                         2     SMX60_IEU                                  SH2ADD_UW                  sh2add.uw	a0, a0, a0
# CHECK-NEXT:  1      2     0.50                         2     SMX60_IEU                                  SH3ADD_UW                  sh3add.uw	a0, a0, a0
# CHECK-NEXT:  1      2     0.50                         2     SMX60_IEU                                  SH1ADD                     sh1add	a0, a0, a0
# CHECK-NEXT:  1      2     0.50                         2     SMX60_IEU                                  SH2ADD                     sh2add	a0, a0, a0
# CHECK-NEXT:  1      2     0.50                         2     SMX60_IEU                                  SH3ADD                     sh3add	a0, a0, a0
# CHECK-NEXT:  1      1     0.50                         1     SMX60_IEU                                  ANDN                       andn	a0, a0, a0
# CHECK-NEXT:  1      1     0.50                         1     SMX60_IEU                                  ORN                        orn	a0, a0, a0
# CHECK-NEXT:  1      1     0.50                         1     SMX60_IEU                                  XNOR                       xnor	a0, a0, a0
# CHECK-NEXT:  1      1     0.50                         1     SMX60_IEU                                  CLZ                        clz	a0, a0
# CHECK-NEXT:  1      1     0.50                         1     SMX60_IEU                                  CLZW                       clzw	a0, a0
# CHECK-NEXT:  1      1     0.50                         1     SMX60_IEU                                  CTZ                        ctz	a0, a0
# CHECK-NEXT:  1      1     0.50                         1     SMX60_IEU                                  CTZW                       ctzw	a0, a0
# CHECK-NEXT:  1      2     0.50                         2     SMX60_IEU                                  CPOP                       cpop	a0, a0
# CHECK-NEXT:  1      2     0.50                         2     SMX60_IEU                                  CPOPW                      cpopw	a0, a0
# CHECK-NEXT:  1      1     0.50                         1     SMX60_IEU                                  MIN                        min	a0, a0, a0
# CHECK-NEXT:  1      1     0.50                         1     SMX60_IEU                                  MINU                       minu	a0, a0, a0
# CHECK-NEXT:  1      1     0.50                         1     SMX60_IEU                                  MAX                        max	a0, a0, a0
# CHECK-NEXT:  1      1     0.50                         1     SMX60_IEU                                  MAXU                       maxu	a0, a0, a0
# CHECK-NEXT:  1      1     0.50                         1     SMX60_IEU                                  SEXT_B                     sext.b	a0, a0
# CHECK-NEXT:  1      1     0.50                         1     SMX60_IEU                                  SEXT_H                     sext.h	a0, a0
# CHECK-NEXT:  1      1     0.50                         1     SMX60_IEU                                  ZEXT_H_RV64                zext.h	a0, a0
# CHECK-NEXT:  1      1     0.50                         1     SMX60_IEU                                  ROL                        rol	a0, a0, a0
# CHECK-NEXT:  1      1     0.50                         1     SMX60_IEU                                  ROLW                       rolw	a0, a0, a0
# CHECK-NEXT:  1      1     0.50                         1     SMX60_IEU                                  ROR                        ror	a0, a0, a0
# CHECK-NEXT:  1      1     0.50                         1     SMX60_IEU                                  RORW                       rorw	a0, a0, a0
# CHECK-NEXT:  1      1     0.50                         1     SMX60_IEU                                  RORI                       rori	a0, a0, 1
# CHECK-NEXT:  1      1     0.50                         1     SMX60_IEU                                  RORIW                      roriw	a0, a0, 1
# CHECK-NEXT:  1      1     0.50                         1     SMX60_IEU                                  ORC_B                      orc.b	a0, a0
# CHECK-NEXT:  1      1     0.50                         1     SMX60_IEU                                  REV8_RV64                  rev8	a0, a0
# CHECK-NEXT:  1      2     0.50                         2     SMX60_IEU                                  CLMUL                      clmul	a0, a0, a0
# CHECK-NEXT:  1      2     0.50                         2     SMX60_IEU                                  CLMULR                     clmulr	a0, a0, a0
# CHECK-NEXT:  1      2     0.50                         2     SMX60_IEU                                  CLMULH                     clmulh	a0, a0, a0
# CHECK-NEXT:  1      1     0.50                         1     SMX60_IEU                                  BCLR                       bclr	a0, a1, a2
# CHECK-NEXT:  1      1     0.50                         1     SMX60_IEU                                  BCLRI                      bclri	a0, a1, 1
# CHECK-NEXT:  1      1     0.50                         1     SMX60_IEU                                  BEXT                       bext	a0, a1, a2
# CHECK-NEXT:  1      1     0.50                         1     SMX60_IEU                                  BEXTI                      bexti	a0, a1, 1
# CHECK-NEXT:  1      1     0.50                         1     SMX60_IEU                                  BINV                       binv	a0, a1, a2
# CHECK-NEXT:  1      1     0.50                         1     SMX60_IEU                                  BINVI                      binvi	a0, a1, 1
# CHECK-NEXT:  1      1     0.50                         1     SMX60_IEU                                  BSET                       bset	a0, a1, a2
# CHECK-NEXT:  1      1     0.50                         1     SMX60_IEU                                  BSETI                      bseti	a0, a1, 1

# CHECK:      Resources:
# CHECK-NEXT: [0]   - SMX60_FP
# CHECK-NEXT: [1]   - SMX60_IEUA
# CHECK-NEXT: [2]   - SMX60_IEUB
# CHECK-NEXT: [3.0] - SMX60_LS
# CHECK-NEXT: [3.1] - SMX60_LS

# CHECK:      Resource pressure per iteration:
# CHECK-NEXT: [0]    [1]    [2]    [3.0]  [3.1]
# CHECK-NEXT:  -     180.50 44.50  5.50   5.50

# CHECK:      Resource pressure by instruction:
# CHECK-NEXT: [0]    [1]    [2]    [3.0]  [3.1]  Instructions:
# CHECK-NEXT:  -     0.50   0.50    -      -     addi	a0, a0, 1
# CHECK-NEXT:  -     0.50   0.50    -      -     addiw	a0, a0, 1
# CHECK-NEXT:  -     0.50   0.50    -      -     slti	a0, a0, 1
# CHECK-NEXT:  -     0.50   0.50    -      -     seqz	a0, a0
# CHECK-NEXT:  -     0.50   0.50    -      -     andi	a0, a0, 1
# CHECK-NEXT:  -     0.50   0.50    -      -     ori	a0, a0, 1
# CHECK-NEXT:  -     0.50   0.50    -      -     xori	a0, a0, 1
# CHECK-NEXT:  -     0.50   0.50    -      -     slli	a0, a0, 1
# CHECK-NEXT:  -     0.50   0.50    -      -     srli	a0, a0, 1
# CHECK-NEXT:  -     0.50   0.50    -      -     srai	a0, a0, 1
# CHECK-NEXT:  -     0.50   0.50    -      -     slliw	a0, a0, 1
# CHECK-NEXT:  -     0.50   0.50    -      -     srliw	a0, a0, 1
# CHECK-NEXT:  -     0.50   0.50    -      -     sraiw	a0, a0, 1
# CHECK-NEXT:  -     0.50   0.50    -      -     lui	a0, 1
# CHECK-NEXT:  -     0.50   0.50    -      -     auipc	a1, 1
# CHECK-NEXT:  -     0.50   0.50    -      -     add	a0, a0, a1
# CHECK-NEXT:  -     0.50   0.50    -      -     addw	a0, a0, a0
# CHECK-NEXT:  -     0.50   0.50    -      -     slt	a0, a0, a0
# CHECK-NEXT:  -     0.50   0.50    -      -     sltu	a0, a0, a0
# CHECK-NEXT:  -     0.50   0.50    -      -     and	a0, a0, a0
# CHECK-NEXT:  -     0.50   0.50    -      -     or	a0, a0, a0
# CHECK-NEXT:  -     0.50   0.50    -      -     xor	a0, a0, a0
# CHECK-NEXT:  -     0.50   0.50    -      -     sll	a0, a0, a0
# CHECK-NEXT:  -     0.50   0.50    -      -     srl	a0, a0, a0
# CHECK-NEXT:  -     0.50   0.50    -      -     sra	a0, a0, a0
# CHECK-NEXT:  -     0.50   0.50    -      -     sllw	a0, a0, a0
# CHECK-NEXT:  -     0.50   0.50    -      -     srlw	a0, a0, a0
# CHECK-NEXT:  -     0.50   0.50    -      -     sraw	a0, a0, a0
# CHECK-NEXT:  -     0.50   0.50    -      -     sub	a0, a0, a0
# CHECK-NEXT:  -     0.50   0.50    -      -     subw	a0, a0, a0
# CHECK-NEXT:  -     1.00    -      -      -     jal	a0, .Ltmp0
# CHECK-NEXT:  -     1.00    -      -      -     jalr	a0
# CHECK-NEXT:  -     1.00    -      -      -     beq	a0, a0, .Ltmp1
# CHECK-NEXT:  -     1.00    -      -      -     bne	a0, a0, .Ltmp2
# CHECK-NEXT:  -     1.00    -      -      -     blt	a0, a0, .Ltmp3
# CHECK-NEXT:  -     1.00    -      -      -     bltu	a0, a0, .Ltmp4
# CHECK-NEXT:  -     1.00    -      -      -     bge	a0, a0, .Ltmp5
# CHECK-NEXT:  -     1.00    -      -      -     bgeu	a0, a0, .Ltmp6
# CHECK-NEXT:  -     0.50   0.50    -      -     add	a0, a0, a0
# CHECK-NEXT:  -      -      -     0.50   0.50   lb	t0, 0(a0)
# CHECK-NEXT:  -      -      -     0.50   0.50   lbu	t0, 0(a0)
# CHECK-NEXT:  -      -      -     0.50   0.50   lh	t0, 0(a0)
# CHECK-NEXT:  -      -      -     0.50   0.50   lhu	t0, 0(a0)
# CHECK-NEXT:  -      -      -     0.50   0.50   lw	t0, 0(a0)
# CHECK-NEXT:  -      -      -     0.50   0.50   lwu	t0, 0(a0)
# CHECK-NEXT:  -      -      -     0.50   0.50   ld	t0, 0(a0)
# CHECK-NEXT:  -      -      -     0.50   0.50   sb	t0, 0(a0)
# CHECK-NEXT:  -      -      -     0.50   0.50   sh	t0, 0(a0)
# CHECK-NEXT:  -      -      -     0.50   0.50   sw	t0, 0(a0)
# CHECK-NEXT:  -      -      -     0.50   0.50   sd	t0, 0(a0)
# CHECK-NEXT:  -     0.50   0.50    -      -     mul	a0, a0, a0
# CHECK-NEXT:  -     0.50   0.50    -      -     mulh	a0, a0, a0
# CHECK-NEXT:  -     0.50   0.50    -      -     mulhu	a0, a0, a0
# CHECK-NEXT:  -     0.50   0.50    -      -     mulhsu	a0, a0, a0
# CHECK-NEXT:  -     0.50   0.50    -      -     mulw	a0, a0, a0
# CHECK-NEXT:  -     20.00   -      -      -     div	a0, a1, a2
# CHECK-NEXT:  -     20.00   -      -      -     divu	a0, a1, a2
# CHECK-NEXT:  -     20.00   -      -      -     rem	a0, a1, a2
# CHECK-NEXT:  -     20.00   -      -      -     remu	a0, a1, a2
# CHECK-NEXT:  -     12.00   -      -      -     divw	a0, a1, a2
# CHECK-NEXT:  -     12.00   -      -      -     divuw	a0, a1, a2
# CHECK-NEXT:  -     12.00   -      -      -     remw	a0, a1, a2
# CHECK-NEXT:  -     12.00   -      -      -     remuw	a0, a1, a2
# CHECK-NEXT:  -     0.50   0.50    -      -     csrrw	t0, 4095, t1
# CHECK-NEXT:  -     0.50   0.50    -      -     csrrs	s3, fflags, s5
# CHECK-NEXT:  -     0.50   0.50    -      -     csrrc	sp, 0, ra
# CHECK-NEXT:  -     0.50   0.50    -      -     csrrwi	a5, 0, 0
# CHECK-NEXT:  -     0.50   0.50    -      -     csrrsi	t2, 4095, 31
# CHECK-NEXT:  -     0.50   0.50    -      -     csrrci	t1, sscratch, 5
# CHECK-NEXT:  -     0.50   0.50    -      -     czero.eqz	a0, a1, a2
# CHECK-NEXT:  -     0.50   0.50    -      -     czero.nez	a0, a1, a2
# CHECK-NEXT:  -     0.50   0.50    -      -     czero.eqz	a0, a1, a2
# CHECK-NEXT:  -     0.50   0.50    -      -     czero.nez	a0, a1, a2
# CHECK-NEXT:  -     0.50   0.50    -      -     add.uw	a0, a0, a0
# CHECK-NEXT:  -     0.50   0.50    -      -     slli.uw	a0, a0, 1
# CHECK-NEXT:  -     0.50   0.50    -      -     sh1add.uw	a0, a0, a0
# CHECK-NEXT:  -     0.50   0.50    -      -     sh2add.uw	a0, a0, a0
# CHECK-NEXT:  -     0.50   0.50    -      -     sh3add.uw	a0, a0, a0
# CHECK-NEXT:  -     0.50   0.50    -      -     sh1add	a0, a0, a0
# CHECK-NEXT:  -     0.50   0.50    -      -     sh2add	a0, a0, a0
# CHECK-NEXT:  -     0.50   0.50    -      -     sh3add	a0, a0, a0
# CHECK-NEXT:  -     0.50   0.50    -      -     andn	a0, a0, a0
# CHECK-NEXT:  -     0.50   0.50    -      -     orn	a0, a0, a0
# CHECK-NEXT:  -     0.50   0.50    -      -     xnor	a0, a0, a0
# CHECK-NEXT:  -     0.50   0.50    -      -     clz	a0, a0
# CHECK-NEXT:  -     0.50   0.50    -      -     clzw	a0, a0
# CHECK-NEXT:  -     0.50   0.50    -      -     ctz	a0, a0
# CHECK-NEXT:  -     0.50   0.50    -      -     ctzw	a0, a0
# CHECK-NEXT:  -     0.50   0.50    -      -     cpop	a0, a0
# CHECK-NEXT:  -     0.50   0.50    -      -     cpopw	a0, a0
# CHECK-NEXT:  -     0.50   0.50    -      -     min	a0, a0, a0
# CHECK-NEXT:  -     0.50   0.50    -      -     minu	a0, a0, a0
# CHECK-NEXT:  -     0.50   0.50    -      -     max	a0, a0, a0
# CHECK-NEXT:  -     0.50   0.50    -      -     maxu	a0, a0, a0
# CHECK-NEXT:  -     0.50   0.50    -      -     sext.b	a0, a0
# CHECK-NEXT:  -     0.50   0.50    -      -     sext.h	a0, a0
# CHECK-NEXT:  -     0.50   0.50    -      -     zext.h	a0, a0
# CHECK-NEXT:  -     0.50   0.50    -      -     rol	a0, a0, a0
# CHECK-NEXT:  -     0.50   0.50    -      -     rolw	a0, a0, a0
# CHECK-NEXT:  -     0.50   0.50    -      -     ror	a0, a0, a0
# CHECK-NEXT:  -     0.50   0.50    -      -     rorw	a0, a0, a0
# CHECK-NEXT:  -     0.50   0.50    -      -     rori	a0, a0, 1
# CHECK-NEXT:  -     0.50   0.50    -      -     roriw	a0, a0, 1
# CHECK-NEXT:  -     0.50   0.50    -      -     orc.b	a0, a0
# CHECK-NEXT:  -     0.50   0.50    -      -     rev8	a0, a0
# CHECK-NEXT:  -     0.50   0.50    -      -     clmul	a0, a0, a0
# CHECK-NEXT:  -     0.50   0.50    -      -     clmulr	a0, a0, a0
# CHECK-NEXT:  -     0.50   0.50    -      -     clmulh	a0, a0, a0
# CHECK-NEXT:  -     0.50   0.50    -      -     bclr	a0, a1, a2
# CHECK-NEXT:  -     0.50   0.50    -      -     bclri	a0, a1, 1
# CHECK-NEXT:  -     0.50   0.50    -      -     bext	a0, a1, a2
# CHECK-NEXT:  -     0.50   0.50    -      -     bexti	a0, a1, 1
# CHECK-NEXT:  -     0.50   0.50    -      -     binv	a0, a1, a2
# CHECK-NEXT:  -     0.50   0.50    -      -     binvi	a0, a1, 1
# CHECK-NEXT:  -     0.50   0.50    -      -     bset	a0, a1, a2
# CHECK-NEXT:  -     0.50   0.50    -      -     bseti	a0, a1, 1
