use strict;
use warnings FATAL => 'all';

use Apache::Test;
use Apache::TestUtil;
use Apache::TestRequest;

my $vars = Apache::Test::vars();

plan tests => 2, need $vars->{ssl_module_name}, need_lwp,
    qw(LWP::Protocol::https);

my $r;

Apache::TestRequest::user_agent(ssl_opts => {SSL_version => 'TLSv13'});
Apache::TestRequest::scheme('https');
Apache::TestRequest::module('ssl_optional_cc');

$r = GET "/require/none/";
my $tls13_works = $r->is_success;

# Forget the above user agent settings, start fresh
Apache::TestRequest::user_agent(reset => 1);

# If TLS 1.3 worked, run the tests using it and expect 403.
# Older TLS versions seem to show the TLS alert client side as a 500.
my $expected_status;
if ($tls13_works) {
  Apache::TestRequest::user_agent(ssl_opts => {SSL_version => 'TLSv13'});
  $expected_status = 403;
  t_debug "Using TLSv13, expecting status 403";
} else {
  t_debug "Using TLS before TLSv13, expecting status 500";
  $expected_status = 500;
}

Apache::TestRequest::user_agent_keepalive(1);
Apache::TestRequest::scheme('https');
Apache::TestRequest::module('ssl_optional_cc');

$r = GET "/require/any/";

ok t_cmp($r->code, $expected_status, "first access denied without client cert");

$r = GET "/require/any/";

ok t_cmp($r->code, $expected_status, "second access denied without client cert");
