/* -*- C++ -*-
 * File: internal/libraw_cameraids.h
 * Copyright 2008-2024 LibRaw LLC (info@libraw.org)
 * Created: Sat Aug  17, 2020

LibRaw is free software; you can redistribute it and/or modify
it under the terms of the one of two licenses as you choose:

1. GNU LESSER GENERAL PUBLIC LICENSE version 2.1
   (See file LICENSE.LGPL provided in LibRaw distribution archive for details).

2. COMMON DEVELOPMENT AND DISTRIBUTION LICENSE (CDDL) Version 1.0
   (See file LICENSE.CDDL provided in LibRaw distribution archive for details).

 */

#ifndef LIBRAW_CONST_H
#define LIBRAW_CONST_H

#define CanonID_EOS_M50            0x00000412ULL
#define CanonID_EOS_M6_Mark_II     0x00000811ULL
#define CanonID_EOS_M200           0x00000812ULL
#define CanonID_EOS_D30            0x01140000ULL
#define CanonID_EOS_D60            0x01668000ULL
#define CanonID_EOS_M3             0x03740000ULL
#define CanonID_EOS_M10            0x03840000ULL
#define CanonID_EOS_M5             0x03940000ULL
#define CanonID_EOS_M100           0x03980000ULL
#define CanonID_EOS_M6             0x04070000ULL
#define CanonID_EOS_1D            (0x80000000ULL + 0x001ULL)
#define CanonID_EOS_1Ds           (0x80000000ULL + 0x167ULL)
#define CanonID_EOS_10D           (0x80000000ULL + 0x168ULL)
#define CanonID_EOS_1D_Mark_III   (0x80000000ULL + 0x169ULL)
#define CanonID_EOS_300D          (0x80000000ULL + 0x170ULL)
#define CanonID_EOS_1D_Mark_II    (0x80000000ULL + 0x174ULL)
#define CanonID_EOS_20D           (0x80000000ULL + 0x175ULL)
#define CanonID_EOS_450D          (0x80000000ULL + 0x176ULL)
#define CanonID_EOS_1Ds_Mark_II   (0x80000000ULL + 0x188ULL)
#define CanonID_EOS_350D          (0x80000000ULL + 0x189ULL)
#define CanonID_EOS_40D           (0x80000000ULL + 0x190ULL)
#define CanonID_EOS_5D            (0x80000000ULL + 0x213ULL)
#define CanonID_EOS_1Ds_Mark_III  (0x80000000ULL + 0x215ULL)
#define CanonID_EOS_5D_Mark_II    (0x80000000ULL + 0x218ULL)
#define CanonID_EOS_1D_Mark_II_N  (0x80000000ULL + 0x232ULL)
#define CanonID_EOS_30D           (0x80000000ULL + 0x234ULL)
#define CanonID_EOS_400D          (0x80000000ULL + 0x236ULL)
#define CanonID_EOS_7D            (0x80000000ULL + 0x250ULL)
#define CanonID_EOS_500D          (0x80000000ULL + 0x252ULL)
#define CanonID_EOS_1000D         (0x80000000ULL + 0x254ULL)
#define CanonID_EOS_50D           (0x80000000ULL + 0x261ULL)
#define CanonID_EOS_1D_X          (0x80000000ULL + 0x269ULL)
#define CanonID_EOS_550D          (0x80000000ULL + 0x270ULL)
#define CanonID_EOS_1D_Mark_IV    (0x80000000ULL + 0x281ULL)
#define CanonID_EOS_5D_Mark_III   (0x80000000ULL + 0x285ULL)
#define CanonID_EOS_600D          (0x80000000ULL + 0x286ULL)
#define CanonID_EOS_60D           (0x80000000ULL + 0x287ULL)
#define CanonID_EOS_1100D         (0x80000000ULL + 0x288ULL)
#define CanonID_EOS_7D_Mark_II    (0x80000000ULL + 0x289ULL)
#define CanonID_EOS_650D          (0x80000000ULL + 0x301ULL)
#define CanonID_EOS_6D            (0x80000000ULL + 0x302ULL)
#define CanonID_EOS_1D_C          (0x80000000ULL + 0x324ULL)
#define CanonID_EOS_70D           (0x80000000ULL + 0x325ULL)
#define CanonID_EOS_700D          (0x80000000ULL + 0x326ULL)
#define CanonID_EOS_1200D         (0x80000000ULL + 0x327ULL)
#define CanonID_EOS_1D_X_Mark_II  (0x80000000ULL + 0x328ULL)
#define CanonID_EOS_M             (0x80000000ULL + 0x331ULL)
#define CanonID_EOS_100D          (0x80000000ULL + 0x346ULL)
#define CanonID_EOS_760D          (0x80000000ULL + 0x347ULL)
#define CanonID_EOS_5D_Mark_IV    (0x80000000ULL + 0x349ULL)
#define CanonID_EOS_80D           (0x80000000ULL + 0x350ULL)
#define CanonID_EOS_M2            (0x80000000ULL + 0x355ULL)
#define CanonID_EOS_5DS           (0x80000000ULL + 0x382ULL)
#define CanonID_EOS_750D          (0x80000000ULL + 0x393ULL)
#define CanonID_EOS_5DS_R         (0x80000000ULL + 0x401ULL)
#define CanonID_EOS_1300D         (0x80000000ULL + 0x404ULL)
#define CanonID_EOS_800D          (0x80000000ULL + 0x405ULL)
#define CanonID_EOS_6D_Mark_II    (0x80000000ULL + 0x406ULL)
#define CanonID_EOS_77D           (0x80000000ULL + 0x408ULL)
#define CanonID_EOS_200D          (0x80000000ULL + 0x417ULL)
#define CanonID_EOS_R5            (0x80000000ULL + 0x421ULL)
#define CanonID_EOS_3000D         (0x80000000ULL + 0x422ULL)
#define CanonID_EOS_R             (0x80000000ULL + 0x424ULL)
#define CanonID_EOS_1D_X_Mark_III (0x80000000ULL + 0x428ULL)
#define CanonID_EOS_1500D         (0x80000000ULL + 0x432ULL)
#define CanonID_EOS_RP            (0x80000000ULL + 0x433ULL)
#define CanonID_EOS_850D          (0x80000000ULL + 0x435ULL)
#define CanonID_EOS_250D          (0x80000000ULL + 0x436ULL)
#define CanonID_EOS_90D           (0x80000000ULL + 0x437ULL)
#define CanonID_EOS_R3            (0x80000000ULL + 0x450ULL)
#define CanonID_EOS_R6            (0x80000000ULL + 0x453ULL)
#define CanonID_EOS_R7            (0x80000000ULL + 0x464ULL)
#define CanonID_EOS_R10           (0x80000000ULL + 0x465ULL)
#define CanonID_EOS_M50_Mark_II   (0x80000000ULL + 0x468ULL)
#define CanonID_EOS_R50           (0x80000000ULL + 0x480ULL)
#define CanonID_EOS_R6m2          (0x80000000ULL + 0x481ULL)
#define CanonID_EOS_R8            (0x80000000ULL + 0x487ULL)
#define CanonID_EOS_R100          (0x80000000ULL + 0x498ULL)

// CanonID_EOS_D2000C after Canon's TIFF2CR2 convertor:
#define CanonID_EOS_D2000C        (0x80000000ULL + 0x520ULL)
// CanonID_EOS_D6000C id after Canon's TIFF2CR2 convertor:
#define CanonID_EOS_D6000C        (0x80000000ULL + 0x560ULL)

#define OlyID_str2hex(str) ((unsigned long long)str[0]<<32 | str[1]<<24 | str[2]<<16 | str[3]<<8 | str[4])
#define OlyID_E_20            OlyID_str2hex("D4029")
#define OlyID_E_1             OlyID_str2hex("D4040")
#define OlyID_E_300           OlyID_str2hex("D4041")
#define OlyID_SP_550UZ        OlyID_str2hex("D4321")
#define OlyID_SP_510UZ        OlyID_str2hex("D4322")
#define OlyID_SP_560UZ        OlyID_str2hex("D4355")
#define OlyID_SP_570UZ        OlyID_str2hex("D4364")
#define OlyID_SP_565UZ        OlyID_str2hex("D4374")
#define OlyID_XZ_1            OlyID_str2hex("D4401")
#define OlyID_XZ_2            OlyID_str2hex("D4531")
#define OlyID_XZ_10           OlyID_str2hex("D4546")
#define OlyID_STYLUS_1        OlyID_str2hex("D4572")
#define OlyID_SH_2            OlyID_str2hex("D4585")
#define OlyID_TG_4            OlyID_str2hex("D4586")
#define OlyID_TG_5            OlyID_str2hex("D4593")
#define OlyID_TG_6            OlyID_str2hex("D4603")
#define OlyID_E_10            OlyID_str2hex("D4842")
#define OlyID_AIR_A01         OlyID_str2hex("K0055")
#define OlyID_NORMA           OlyID_str2hex("NORMA")
#define OlyID_E_330           OlyID_str2hex("S0003")
#define OlyID_E_500           OlyID_str2hex("S0004")
#define OlyID_E_400           OlyID_str2hex("S0009")
#define OlyID_E_510           OlyID_str2hex("S0010")
#define OlyID_E_3             OlyID_str2hex("S0011")
#define OlyID_E_410           OlyID_str2hex("S0013")
#define OlyID_E_420           OlyID_str2hex("S0016")
#define OlyID_E_30            OlyID_str2hex("S0017")
#define OlyID_E_520           OlyID_str2hex("S0018")
#define OlyID_E_P1            OlyID_str2hex("S0019")
#define OlyID_E_620           OlyID_str2hex("S0023")
#define OlyID_E_P2            OlyID_str2hex("S0026")
#define OlyID_E_PL1           OlyID_str2hex("S0027")
#define OlyID_E_450           OlyID_str2hex("S0029")
#define OlyID_E_600           OlyID_str2hex("S0030")
#define OlyID_E_P3            OlyID_str2hex("S0032")
#define OlyID_E_5             OlyID_str2hex("S0033")
#define OlyID_E_PL2           OlyID_str2hex("S0034")
#define OlyID_E_M5            OlyID_str2hex("S0036")
#define OlyID_E_PL3           OlyID_str2hex("S0038")
#define OlyID_E_PM1           OlyID_str2hex("S0039")
#define OlyID_E_PL1s          OlyID_str2hex("S0040")
#define OlyID_E_PL5           OlyID_str2hex("S0042")
#define OlyID_E_PM2           OlyID_str2hex("S0043")
#define OlyID_E_P5            OlyID_str2hex("S0044")
#define OlyID_E_PL6           OlyID_str2hex("S0045")
#define OlyID_E_PL7           OlyID_str2hex("S0046")
#define OlyID_E_M1            OlyID_str2hex("S0047")
#define OlyID_E_M10           OlyID_str2hex("S0051")
#define OlyID_E_M5_Mark_II    OlyID_str2hex("S0052")
#define OlyID_E_M10_Mark_II   OlyID_str2hex("S0059")
#define OlyID_PEN_F           OlyID_str2hex("S0061")
#define OlyID_E_PL8           OlyID_str2hex("S0065")
#define OlyID_E_M1_Mark_II    OlyID_str2hex("S0067")
#define OlyID_E_M10_Mark_III  OlyID_str2hex("S0068")
#define OlyID_E_PL9           OlyID_str2hex("S0076")
#define OlyID_E_M1X           OlyID_str2hex("S0080")
#define OlyID_E_PL10          OlyID_str2hex("S0085")
#define OlyID_E_M10_Mark_IV   OlyID_str2hex("S0088")
#define OlyID_E_M5_Mark_III   OlyID_str2hex("S0089")
#define OlyID_E_M1_Mark_III   OlyID_str2hex("S0092")
#define OlyID_E_P7            OlyID_str2hex("S0093")
#define OlyID_OM_1            OlyID_str2hex("S0095")
#define OlyID_OM_5            OlyID_str2hex("S0101")
#define OlyID_C_3030Z         OlyID_str2hex("SX351")
#define OlyID_C_5050Z         OlyID_str2hex("SX558")
#define OlyID_C_350Z          OlyID_str2hex("SX751")
#define OlyID_C_740UZ         OlyID_str2hex("SX754")
#define OlyID_C_5060WZ        OlyID_str2hex("SX756")
#define OlyID_C_8080WZ        OlyID_str2hex("SX757")
#define OlyID_C_770UZ         OlyID_str2hex("SX772")
#define OlyID_C_7070WZ        OlyID_str2hex("SX851")
#define OlyID_C_7000Z         OlyID_str2hex("SX852")
#define OlyID_SP_500UZ        OlyID_str2hex("SX853")
#define OlyID_SP_310          OlyID_str2hex("SX854")
#define OlyID_SP_350          OlyID_str2hex("SX855")
#define OlyID_SP_320          OlyID_str2hex("SX873")

#define PentaxID_Optio_S      0x1296cULL
#define PentaxID_Optio_S_V101 0x12971ULL
#define PentaxID_staristD     0x12994ULL
#define PentaxID_Optio_33WR   0x129c6ULL
#define PentaxID_Optio_S4     0x129d5ULL
#define PentaxID_Optio_750Z   0x12a66ULL
#define PentaxID_staristDS    0x12aa2ULL
#define PentaxID_staristDL    0x12b1aULL
#define PentaxID_staristDS2   0x12b60ULL
#define PentaxID_GX_1S        0x12b62ULL
#define PentaxID_staristDL2   0x12b7eULL
#define PentaxID_GX_1L        0x12b80ULL
#define PentaxID_K100D        0x12b9cULL
#define PentaxID_K110D        0x12b9dULL
#define PentaxID_K100D_Super  0x12ba2ULL
#define PentaxID_K10D         0x12c1eULL
#define PentaxID_GX10         0x12c20ULL
#define PentaxID_K20D         0x12cd2ULL
#define PentaxID_GX20         0x12cd4ULL
#define PentaxID_K200D        0x12cfaULL
#define PentaxID_K2000        0x12d72ULL
#define PentaxID_K_m          0x12d73ULL
#define PentaxID_K_7          0x12db8ULL
#define PentaxID_K_x          0x12dfeULL
#define PentaxID_645D         0x12e08ULL
#define PentaxID_K_r          0x12e6cULL
#define PentaxID_K_5          0x12e76ULL
#define PentaxID_Q            0x12ee4ULL
#define PentaxID_K_01         0x12ef8ULL
#define PentaxID_K_30         0x12f52ULL
#define PentaxID_Q10          0x12f66ULL
#define PentaxID_K_5_II       0x12f70ULL
#define PentaxID_K_5_II_s     0x12f71ULL
#define PentaxID_Q7           0x12f7aULL
#define PentaxID_MX_1         0x12f84ULL
#define PentaxID_K_50         0x12fb6ULL
#define PentaxID_K_3          0x12fc0ULL
#define PentaxID_K_500        0x12fcaULL
#define PentaxID_645Z         0x13010ULL
#define PentaxID_K_S1         0x1301aULL
#define PentaxID_K_S2         0x13024ULL
#define PentaxID_Q_S1         0x1302eULL
#define PentaxID_K_1          0x13092ULL
#define PentaxID_K_3_II       0x1309cULL
#define PentaxID_GR_III       0x1320eULL
#define PentaxID_K_70         0x13222ULL
#define PentaxID_KP           0x1322cULL
#define PentaxID_K_1_Mark_II  0x13240ULL
#define PentaxID_K_3_III      0x13254ULL
#define PentaxID_GR_IIIx      0x1329aULL

#define SonyID_DSC_R1           0x002ULL
#define SonyID_DSLR_A100        0x100ULL
#define SonyID_DSLR_A900        0x101ULL
#define SonyID_DSLR_A700        0x102ULL
#define SonyID_DSLR_A200        0x103ULL
#define SonyID_DSLR_A350        0x104ULL
#define SonyID_DSLR_A300        0x105ULL
#define SonyID_DSLR_A900_APSC   0x106ULL
#define SonyID_DSLR_A380        0x107ULL
#define SonyID_DSLR_A330        0x108ULL
#define SonyID_DSLR_A230        0x109ULL
#define SonyID_DSLR_A290        0x10aULL
#define SonyID_DSLR_A850        0x10dULL
#define SonyID_DSLR_A850_APSC   0x10eULL
#define SonyID_DSLR_A550        0x111ULL
#define SonyID_DSLR_A500        0x112ULL
#define SonyID_DSLR_A450        0x113ULL
#define SonyID_NEX_5            0x116ULL
#define SonyID_NEX_3            0x117ULL
#define SonyID_SLT_A33          0x118ULL
#define SonyID_SLT_A55          0x119ULL
#define SonyID_DSLR_A560        0x11aULL
#define SonyID_DSLR_A580        0x11bULL
#define SonyID_NEX_C3           0x11cULL
#define SonyID_SLT_A35          0x11dULL
#define SonyID_SLT_A65          0x11eULL
#define SonyID_SLT_A77          0x11fULL
#define SonyID_NEX_5N           0x120ULL
#define SonyID_NEX_7            0x121ULL
#define SonyID_NEX_VG20         0x122ULL
#define SonyID_SLT_A37          0x123ULL
#define SonyID_SLT_A57          0x124ULL
#define SonyID_NEX_F3           0x125ULL
#define SonyID_SLT_A99          0x126ULL
#define SonyID_NEX_6            0x127ULL
#define SonyID_NEX_5R           0x128ULL
#define SonyID_DSC_RX100        0x129ULL
#define SonyID_DSC_RX1          0x12aULL
#define SonyID_NEX_VG900        0x12bULL
#define SonyID_NEX_VG30         0x12cULL
#define SonyID_ILCE_3000        0x12eULL
#define SonyID_SLT_A58          0x12fULL
#define SonyID_NEX_3N           0x131ULL
#define SonyID_ILCE_7           0x132ULL
#define SonyID_NEX_5T           0x133ULL
#define SonyID_DSC_RX100M2      0x134ULL
#define SonyID_DSC_RX10         0x135ULL
#define SonyID_DSC_RX1R         0x136ULL
#define SonyID_ILCE_7R          0x137ULL
#define SonyID_ILCE_6000        0x138ULL
#define SonyID_ILCE_5000        0x139ULL
#define SonyID_DSC_RX100M3      0x13dULL
#define SonyID_ILCE_7S          0x13eULL
#define SonyID_ILCA_77M2        0x13fULL
#define SonyID_ILCE_5100        0x153ULL
#define SonyID_ILCE_7M2         0x154ULL
#define SonyID_DSC_RX100M4      0x155ULL
#define SonyID_DSC_RX10M2       0x156ULL
#define SonyID_DSC_RX1RM2       0x158ULL
#define SonyID_ILCE_QX1         0x15aULL
#define SonyID_ILCE_7RM2        0x15bULL
#define SonyID_ILCE_7SM2        0x15eULL
#define SonyID_ILCA_68          0x161ULL
#define SonyID_ILCA_99M2        0x162ULL
#define SonyID_DSC_RX10M3       0x163ULL
#define SonyID_DSC_RX100M5      0x164ULL
#define SonyID_ILCE_6300        0x165ULL
#define SonyID_ILCE_9           0x166ULL
#define SonyID_ILCE_6500        0x168ULL
#define SonyID_ILCE_7RM3        0x16aULL
#define SonyID_ILCE_7M3         0x16bULL
#define SonyID_DSC_RX0          0x16cULL
#define SonyID_DSC_RX10M4       0x16dULL
#define SonyID_DSC_RX100M6      0x16eULL
#define SonyID_DSC_HX99         0x16fULL
#define SonyID_DSC_RX100M5A     0x171ULL
#define SonyID_ILCE_6400        0x173ULL
#define SonyID_DSC_RX0M2        0x174ULL
#define SonyID_DSC_HX95         0x175ULL
#define SonyID_DSC_RX100M7      0x176ULL
#define SonyID_ILCE_7RM4        0x177ULL
#define SonyID_ILCE_9M2         0x178ULL
#define SonyID_ILCE_6600        0x17aULL
#define SonyID_ILCE_6100        0x17bULL
#define SonyID_ZV_1             0x17cULL
#define SonyID_ILCE_7C          0x17dULL
#define SonyID_ZV_E10           0x17eULL
#define SonyID_ILCE_7SM3        0x17fULL
#define SonyID_ILCE_1           0x180ULL
#define SonyID_ILME_FX3         0x181ULL
#define SonyID_ILCE_7RM3A       0x182ULL
#define SonyID_ILCE_7RM4A       0x183ULL
#define SonyID_ILCE_7M4         0x184ULL
// #define SonyID_ZV_1F            0x185ULL // Sony ZV-1F doesn't save raw
#define SonyID_ILCE_7RM5        0x186ULL
#define SonyID_ILME_FX30        0x187ULL
#define SonyID_ZV_E1            0x189ULL
#define SonyID_ILCE_6700        0x18aULL
#define SonyID_ZV_1M2           0x18bULL
#define SonyID_ILCE_7CR         0x18cULL
#define SonyID_ILCE_7CM2        0x18dULL
#endif
