/*********************************************************************
 *   Copyright 1993, UCAR/Unidata
 *   See netcdf/COPYRIGHT file for copying and redistribution conditions.
 *********************************************************************/

#include "hdf.h"

#ifdef H4_HAVE_NETCDF
#include "netcdf.h"
#else
#include "hdf4_netcdf.h"
#endif

#include "emalloc.h"
#include "testcdf.h"
#include "tests.h"

/* #define MDEBUG 1 */

/*
 * Test driver for netCDF implementation.  This program performs
 * tests against the netCDF specification for all user-level
 * functions in an implementation of the netCDF library.  Must be
 * invoked from a directory in which the invoker has write
 * permission.
 */

#include <stdio.h>

#include <stdlib.h>
#include <string.h> /* to remove warnings, HDFFR-1434 */

/* In-memory netcdf structure, kept in sync with disk netcdf */
struct netcdf *test_g = NULL;

int
main(void)
{
    static char testfile[]            = "test.nc";
    static char unlim_testfile_name[] = "test_unlim.nc";

    ncopts &= ~NC_FATAL;   /* make errors nonfatal */
    ncopts &= ~NC_VERBOSE; /* turn off error messages */
    ncopts |= NC_VERBOSE;  /* turn  error messages on--AKC */
    ncopts &= ~NC_VERBOSE; /* turn off error messages */

    test_g = (struct netcdf *)emalloc(sizeof(struct netcdf));
    memset(test_g, 0, sizeof(struct netcdf));

    test_nccreate(testfile);

    test_ncopen(testfile);

    test_ncredef(testfile);

    test_ncendef(testfile);

    test_ncclose(testfile);

    test_ncinquire(testfile);
#if (!defined _MSC_VER) || (_MSC_VER < 1400)
    test_ncsync(testfile);
#endif
    test_ncabort(testfile);

    test_ncdimdef(testfile);

    test_ncdimid(testfile);

    test_ncdiminq(testfile);

    test_ncdimrename(testfile);

    test_ncvardef(testfile);

    test_ncvarid(testfile);

    test_ncvarinq(testfile);

    test_ncvarput1(testfile);

    test_ncvarget1(testfile);

    test_ncvarput(testfile);

    test_ncvarget(testfile);

    test_ncvarget_unlim(unlim_testfile_name);

    test_ncvarputg(testfile);

    test_ncvargetg(testfile);

    test_ncrecinq(testfile);

    test_ncrecput(testfile);

    test_ncrecget(testfile);

    test_ncvarrename(testfile);

    test_ncattput(testfile);

    test_ncattinq(testfile);

    test_ncattget(testfile);

    test_ncattcopy(testfile, "test2.nc");

    test_ncattname(testfile);

    test_ncattrename(testfile);

    test_ncattdel(testfile);

    test_nctypelen();

    for (int i = 0; i < test_g->ndims; i++) {
        free(test_g->dims[i].name);
    }
    for (int i = 0; i < test_g->nvars; i++) {
        free(test_g->vars[i].name);
        free(test_g->vars[i].dims);
    }
    for (int i = 0; i < test_g->natts; i++) {
        free(test_g->atts[i].name);
    }
    free(test_g);

    return EXIT_SUCCESS;
}
