# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Dict, List, Optional, Union

import msrest.serialization

from ._compute_management_client_enums import *


class ApiError(msrest.serialization.Model):
    """Api error.

    :param details: The Api error details.
    :type details: list[~azure.mgmt.compute.v2020_09_30.models.ApiErrorBase]
    :param innererror: The Api inner error.
    :type innererror: ~azure.mgmt.compute.v2020_09_30.models.InnerError
    :param code: The error code.
    :type code: str
    :param target: The target of the particular error.
    :type target: str
    :param message: The error message.
    :type message: str
    """

    _attribute_map = {
        'details': {'key': 'details', 'type': '[ApiErrorBase]'},
        'innererror': {'key': 'innererror', 'type': 'InnerError'},
        'code': {'key': 'code', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        details: Optional[List["ApiErrorBase"]] = None,
        innererror: Optional["InnerError"] = None,
        code: Optional[str] = None,
        target: Optional[str] = None,
        message: Optional[str] = None,
        **kwargs
    ):
        super(ApiError, self).__init__(**kwargs)
        self.details = details
        self.innererror = innererror
        self.code = code
        self.target = target
        self.message = message


class ApiErrorBase(msrest.serialization.Model):
    """Api error base.

    :param code: The error code.
    :type code: str
    :param target: The target of the particular error.
    :type target: str
    :param message: The error message.
    :type message: str
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        code: Optional[str] = None,
        target: Optional[str] = None,
        message: Optional[str] = None,
        **kwargs
    ):
        super(ApiErrorBase, self).__init__(**kwargs)
        self.code = code
        self.target = target
        self.message = message


class DiskImageEncryption(msrest.serialization.Model):
    """This is the disk image encryption base class.

    :param disk_encryption_set_id: A relative URI containing the resource ID of the disk encryption
     set.
    :type disk_encryption_set_id: str
    """

    _attribute_map = {
        'disk_encryption_set_id': {'key': 'diskEncryptionSetId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        disk_encryption_set_id: Optional[str] = None,
        **kwargs
    ):
        super(DiskImageEncryption, self).__init__(**kwargs)
        self.disk_encryption_set_id = disk_encryption_set_id


class DataDiskImageEncryption(DiskImageEncryption):
    """Contains encryption settings for a data disk image.

    All required parameters must be populated in order to send to Azure.

    :param disk_encryption_set_id: A relative URI containing the resource ID of the disk encryption
     set.
    :type disk_encryption_set_id: str
    :param lun: Required. This property specifies the logical unit number of the data disk. This
     value is used to identify data disks within the Virtual Machine and therefore must be unique
     for each data disk attached to the Virtual Machine.
    :type lun: int
    """

    _validation = {
        'lun': {'required': True},
    }

    _attribute_map = {
        'disk_encryption_set_id': {'key': 'diskEncryptionSetId', 'type': 'str'},
        'lun': {'key': 'lun', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        lun: int,
        disk_encryption_set_id: Optional[str] = None,
        **kwargs
    ):
        super(DataDiskImageEncryption, self).__init__(disk_encryption_set_id=disk_encryption_set_id, **kwargs)
        self.lun = lun


class Disallowed(msrest.serialization.Model):
    """Describes the disallowed disk types.

    :param disk_types: A list of disk types.
    :type disk_types: list[str]
    """

    _attribute_map = {
        'disk_types': {'key': 'diskTypes', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        disk_types: Optional[List[str]] = None,
        **kwargs
    ):
        super(Disallowed, self).__init__(**kwargs)
        self.disk_types = disk_types


class EncryptionImages(msrest.serialization.Model):
    """Optional. Allows users to provide customer managed keys for encrypting the OS and data disks in the gallery artifact.

    :param os_disk_image: This is the disk image encryption base class.
    :type os_disk_image: ~azure.mgmt.compute.v2020_09_30.models.DiskImageEncryption
    :param data_disk_images: A list of encryption specifications for data disk images.
    :type data_disk_images: list[~azure.mgmt.compute.v2020_09_30.models.DataDiskImageEncryption]
    """

    _attribute_map = {
        'os_disk_image': {'key': 'osDiskImage', 'type': 'DiskImageEncryption'},
        'data_disk_images': {'key': 'dataDiskImages', 'type': '[DataDiskImageEncryption]'},
    }

    def __init__(
        self,
        *,
        os_disk_image: Optional["DiskImageEncryption"] = None,
        data_disk_images: Optional[List["DataDiskImageEncryption"]] = None,
        **kwargs
    ):
        super(EncryptionImages, self).__init__(**kwargs)
        self.os_disk_image = os_disk_image
        self.data_disk_images = data_disk_images


class Resource(msrest.serialization.Model):
    """The Resource model definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Required. Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.location = location
        self.tags = tags


class Gallery(Resource):
    """Specifies information about the Shared Image Gallery that you want to create or update.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Required. Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param description: The description of this Shared Image Gallery resource. This property is
     updatable.
    :type description: str
    :param identifier: Describes the gallery unique name.
    :type identifier: ~azure.mgmt.compute.v2020_09_30.models.GalleryIdentifier
    :ivar provisioning_state: The provisioning state, which only appears in the response. Possible
     values include: "Creating", "Updating", "Failed", "Succeeded", "Deleting", "Migrating".
    :vartype provisioning_state: str or
     ~azure.mgmt.compute.v2020_09_30.models.GalleryPropertiesProvisioningState
    :param sharing_profile: Profile for gallery sharing to subscription or tenant.
    :type sharing_profile: ~azure.mgmt.compute.v2020_09_30.models.SharingProfile
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'identifier': {'key': 'properties.identifier', 'type': 'GalleryIdentifier'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'sharing_profile': {'key': 'properties.sharingProfile', 'type': 'SharingProfile'},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        description: Optional[str] = None,
        identifier: Optional["GalleryIdentifier"] = None,
        sharing_profile: Optional["SharingProfile"] = None,
        **kwargs
    ):
        super(Gallery, self).__init__(location=location, tags=tags, **kwargs)
        self.description = description
        self.identifier = identifier
        self.provisioning_state = None
        self.sharing_profile = sharing_profile


class GalleryApplication(Resource):
    """Specifies information about the gallery Application Definition that you want to create or update.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Required. Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param description: The description of this gallery Application Definition resource. This
     property is updatable.
    :type description: str
    :param eula: The Eula agreement for the gallery Application Definition.
    :type eula: str
    :param privacy_statement_uri: The privacy statement uri.
    :type privacy_statement_uri: str
    :param release_note_uri: The release note uri.
    :type release_note_uri: str
    :param end_of_life_date: The end of life date of the gallery Application Definition. This
     property can be used for decommissioning purposes. This property is updatable.
    :type end_of_life_date: ~datetime.datetime
    :param supported_os_type: This property allows you to specify the supported type of the OS that
     application is built for. :code:`<br>`:code:`<br>` Possible values are:
     :code:`<br>`:code:`<br>` **Windows** :code:`<br>`:code:`<br>` **Linux**. Possible values
     include: "Windows", "Linux".
    :type supported_os_type: str or ~azure.mgmt.compute.v2020_09_30.models.OperatingSystemTypes
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'eula': {'key': 'properties.eula', 'type': 'str'},
        'privacy_statement_uri': {'key': 'properties.privacyStatementUri', 'type': 'str'},
        'release_note_uri': {'key': 'properties.releaseNoteUri', 'type': 'str'},
        'end_of_life_date': {'key': 'properties.endOfLifeDate', 'type': 'iso-8601'},
        'supported_os_type': {'key': 'properties.supportedOSType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        description: Optional[str] = None,
        eula: Optional[str] = None,
        privacy_statement_uri: Optional[str] = None,
        release_note_uri: Optional[str] = None,
        end_of_life_date: Optional[datetime.datetime] = None,
        supported_os_type: Optional[Union[str, "OperatingSystemTypes"]] = None,
        **kwargs
    ):
        super(GalleryApplication, self).__init__(location=location, tags=tags, **kwargs)
        self.description = description
        self.eula = eula
        self.privacy_statement_uri = privacy_statement_uri
        self.release_note_uri = release_note_uri
        self.end_of_life_date = end_of_life_date
        self.supported_os_type = supported_os_type


class GalleryApplicationList(msrest.serialization.Model):
    """The List Gallery Applications operation response.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. A list of Gallery Applications.
    :type value: list[~azure.mgmt.compute.v2020_09_30.models.GalleryApplication]
    :param next_link: The uri to fetch the next page of Application Definitions in the Application
     Gallery. Call ListNext() with this to fetch the next page of gallery Application Definitions.
    :type next_link: str
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[GalleryApplication]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["GalleryApplication"],
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(GalleryApplicationList, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class UpdateResourceDefinition(msrest.serialization.Model):
    """The Update Resource model definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        super(UpdateResourceDefinition, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.tags = tags


class GalleryApplicationUpdate(UpdateResourceDefinition):
    """Specifies information about the gallery Application Definition that you want to update.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param description: The description of this gallery Application Definition resource. This
     property is updatable.
    :type description: str
    :param eula: The Eula agreement for the gallery Application Definition.
    :type eula: str
    :param privacy_statement_uri: The privacy statement uri.
    :type privacy_statement_uri: str
    :param release_note_uri: The release note uri.
    :type release_note_uri: str
    :param end_of_life_date: The end of life date of the gallery Application Definition. This
     property can be used for decommissioning purposes. This property is updatable.
    :type end_of_life_date: ~datetime.datetime
    :param supported_os_type: This property allows you to specify the supported type of the OS that
     application is built for. :code:`<br>`:code:`<br>` Possible values are:
     :code:`<br>`:code:`<br>` **Windows** :code:`<br>`:code:`<br>` **Linux**. Possible values
     include: "Windows", "Linux".
    :type supported_os_type: str or ~azure.mgmt.compute.v2020_09_30.models.OperatingSystemTypes
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'eula': {'key': 'properties.eula', 'type': 'str'},
        'privacy_statement_uri': {'key': 'properties.privacyStatementUri', 'type': 'str'},
        'release_note_uri': {'key': 'properties.releaseNoteUri', 'type': 'str'},
        'end_of_life_date': {'key': 'properties.endOfLifeDate', 'type': 'iso-8601'},
        'supported_os_type': {'key': 'properties.supportedOSType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        description: Optional[str] = None,
        eula: Optional[str] = None,
        privacy_statement_uri: Optional[str] = None,
        release_note_uri: Optional[str] = None,
        end_of_life_date: Optional[datetime.datetime] = None,
        supported_os_type: Optional[Union[str, "OperatingSystemTypes"]] = None,
        **kwargs
    ):
        super(GalleryApplicationUpdate, self).__init__(tags=tags, **kwargs)
        self.description = description
        self.eula = eula
        self.privacy_statement_uri = privacy_statement_uri
        self.release_note_uri = release_note_uri
        self.end_of_life_date = end_of_life_date
        self.supported_os_type = supported_os_type


class GalleryApplicationVersion(Resource):
    """Specifies information about the gallery Application Version that you want to create or update.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Required. Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param publishing_profile: The publishing profile of a gallery image version.
    :type publishing_profile:
     ~azure.mgmt.compute.v2020_09_30.models.GalleryApplicationVersionPublishingProfile
    :ivar provisioning_state: The provisioning state, which only appears in the response. Possible
     values include: "Creating", "Updating", "Failed", "Succeeded", "Deleting", "Migrating".
    :vartype provisioning_state: str or
     ~azure.mgmt.compute.v2020_09_30.models.GalleryApplicationVersionPropertiesProvisioningState
    :ivar replication_status: This is the replication status of the gallery image version.
    :vartype replication_status: ~azure.mgmt.compute.v2020_09_30.models.ReplicationStatus
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'provisioning_state': {'readonly': True},
        'replication_status': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'publishing_profile': {'key': 'properties.publishingProfile', 'type': 'GalleryApplicationVersionPublishingProfile'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'replication_status': {'key': 'properties.replicationStatus', 'type': 'ReplicationStatus'},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        publishing_profile: Optional["GalleryApplicationVersionPublishingProfile"] = None,
        **kwargs
    ):
        super(GalleryApplicationVersion, self).__init__(location=location, tags=tags, **kwargs)
        self.publishing_profile = publishing_profile
        self.provisioning_state = None
        self.replication_status = None


class GalleryApplicationVersionList(msrest.serialization.Model):
    """The List Gallery Application version operation response.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. A list of gallery Application Versions.
    :type value: list[~azure.mgmt.compute.v2020_09_30.models.GalleryApplicationVersion]
    :param next_link: The uri to fetch the next page of gallery Application Versions. Call
     ListNext() with this to fetch the next page of gallery Application Versions.
    :type next_link: str
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[GalleryApplicationVersion]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["GalleryApplicationVersion"],
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(GalleryApplicationVersionList, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class GalleryArtifactPublishingProfileBase(msrest.serialization.Model):
    """Describes the basic gallery artifact publishing profile.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param target_regions: The target regions where the Image Version is going to be replicated to.
     This property is updatable.
    :type target_regions: list[~azure.mgmt.compute.v2020_09_30.models.TargetRegion]
    :param replica_count: The number of replicas of the Image Version to be created per region.
     This property would take effect for a region when regionalReplicaCount is not specified. This
     property is updatable.
    :type replica_count: int
    :param exclude_from_latest: If set to true, Virtual Machines deployed from the latest version
     of the Image Definition won't use this Image Version.
    :type exclude_from_latest: bool
    :ivar published_date: The timestamp for when the gallery image version is published.
    :vartype published_date: ~datetime.datetime
    :param end_of_life_date: The end of life date of the gallery image version. This property can
     be used for decommissioning purposes. This property is updatable.
    :type end_of_life_date: ~datetime.datetime
    :param storage_account_type: Specifies the storage account type to be used to store the image.
     This property is not updatable. Possible values include: "Standard_LRS", "Standard_ZRS",
     "Premium_LRS".
    :type storage_account_type: str or ~azure.mgmt.compute.v2020_09_30.models.StorageAccountType
    """

    _validation = {
        'published_date': {'readonly': True},
    }

    _attribute_map = {
        'target_regions': {'key': 'targetRegions', 'type': '[TargetRegion]'},
        'replica_count': {'key': 'replicaCount', 'type': 'int'},
        'exclude_from_latest': {'key': 'excludeFromLatest', 'type': 'bool'},
        'published_date': {'key': 'publishedDate', 'type': 'iso-8601'},
        'end_of_life_date': {'key': 'endOfLifeDate', 'type': 'iso-8601'},
        'storage_account_type': {'key': 'storageAccountType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        target_regions: Optional[List["TargetRegion"]] = None,
        replica_count: Optional[int] = None,
        exclude_from_latest: Optional[bool] = None,
        end_of_life_date: Optional[datetime.datetime] = None,
        storage_account_type: Optional[Union[str, "StorageAccountType"]] = None,
        **kwargs
    ):
        super(GalleryArtifactPublishingProfileBase, self).__init__(**kwargs)
        self.target_regions = target_regions
        self.replica_count = replica_count
        self.exclude_from_latest = exclude_from_latest
        self.published_date = None
        self.end_of_life_date = end_of_life_date
        self.storage_account_type = storage_account_type


class GalleryApplicationVersionPublishingProfile(GalleryArtifactPublishingProfileBase):
    """The publishing profile of a gallery image version.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param target_regions: The target regions where the Image Version is going to be replicated to.
     This property is updatable.
    :type target_regions: list[~azure.mgmt.compute.v2020_09_30.models.TargetRegion]
    :param replica_count: The number of replicas of the Image Version to be created per region.
     This property would take effect for a region when regionalReplicaCount is not specified. This
     property is updatable.
    :type replica_count: int
    :param exclude_from_latest: If set to true, Virtual Machines deployed from the latest version
     of the Image Definition won't use this Image Version.
    :type exclude_from_latest: bool
    :ivar published_date: The timestamp for when the gallery image version is published.
    :vartype published_date: ~datetime.datetime
    :param end_of_life_date: The end of life date of the gallery image version. This property can
     be used for decommissioning purposes. This property is updatable.
    :type end_of_life_date: ~datetime.datetime
    :param storage_account_type: Specifies the storage account type to be used to store the image.
     This property is not updatable. Possible values include: "Standard_LRS", "Standard_ZRS",
     "Premium_LRS".
    :type storage_account_type: str or ~azure.mgmt.compute.v2020_09_30.models.StorageAccountType
    :param source: Required. The source image from which the Image Version is going to be created.
    :type source: ~azure.mgmt.compute.v2020_09_30.models.UserArtifactSource
    :param manage_actions:
    :type manage_actions: ~azure.mgmt.compute.v2020_09_30.models.UserArtifactManage
    :param enable_health_check: Optional. Whether or not this application reports health.
    :type enable_health_check: bool
    """

    _validation = {
        'published_date': {'readonly': True},
        'source': {'required': True},
    }

    _attribute_map = {
        'target_regions': {'key': 'targetRegions', 'type': '[TargetRegion]'},
        'replica_count': {'key': 'replicaCount', 'type': 'int'},
        'exclude_from_latest': {'key': 'excludeFromLatest', 'type': 'bool'},
        'published_date': {'key': 'publishedDate', 'type': 'iso-8601'},
        'end_of_life_date': {'key': 'endOfLifeDate', 'type': 'iso-8601'},
        'storage_account_type': {'key': 'storageAccountType', 'type': 'str'},
        'source': {'key': 'source', 'type': 'UserArtifactSource'},
        'manage_actions': {'key': 'manageActions', 'type': 'UserArtifactManage'},
        'enable_health_check': {'key': 'enableHealthCheck', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        source: "UserArtifactSource",
        target_regions: Optional[List["TargetRegion"]] = None,
        replica_count: Optional[int] = None,
        exclude_from_latest: Optional[bool] = None,
        end_of_life_date: Optional[datetime.datetime] = None,
        storage_account_type: Optional[Union[str, "StorageAccountType"]] = None,
        manage_actions: Optional["UserArtifactManage"] = None,
        enable_health_check: Optional[bool] = None,
        **kwargs
    ):
        super(GalleryApplicationVersionPublishingProfile, self).__init__(target_regions=target_regions, replica_count=replica_count, exclude_from_latest=exclude_from_latest, end_of_life_date=end_of_life_date, storage_account_type=storage_account_type, **kwargs)
        self.source = source
        self.manage_actions = manage_actions
        self.enable_health_check = enable_health_check


class GalleryApplicationVersionUpdate(UpdateResourceDefinition):
    """Specifies information about the gallery Application Version that you want to update.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param publishing_profile: The publishing profile of a gallery image version.
    :type publishing_profile:
     ~azure.mgmt.compute.v2020_09_30.models.GalleryApplicationVersionPublishingProfile
    :ivar provisioning_state: The provisioning state, which only appears in the response. Possible
     values include: "Creating", "Updating", "Failed", "Succeeded", "Deleting", "Migrating".
    :vartype provisioning_state: str or
     ~azure.mgmt.compute.v2020_09_30.models.GalleryApplicationVersionPropertiesProvisioningState
    :ivar replication_status: This is the replication status of the gallery image version.
    :vartype replication_status: ~azure.mgmt.compute.v2020_09_30.models.ReplicationStatus
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'replication_status': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'publishing_profile': {'key': 'properties.publishingProfile', 'type': 'GalleryApplicationVersionPublishingProfile'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'replication_status': {'key': 'properties.replicationStatus', 'type': 'ReplicationStatus'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        publishing_profile: Optional["GalleryApplicationVersionPublishingProfile"] = None,
        **kwargs
    ):
        super(GalleryApplicationVersionUpdate, self).__init__(tags=tags, **kwargs)
        self.publishing_profile = publishing_profile
        self.provisioning_state = None
        self.replication_status = None


class GalleryArtifactSource(msrest.serialization.Model):
    """The source image from which the Image Version is going to be created.

    All required parameters must be populated in order to send to Azure.

    :param managed_image: Required. The managed artifact.
    :type managed_image: ~azure.mgmt.compute.v2020_09_30.models.ManagedArtifact
    """

    _validation = {
        'managed_image': {'required': True},
    }

    _attribute_map = {
        'managed_image': {'key': 'managedImage', 'type': 'ManagedArtifact'},
    }

    def __init__(
        self,
        *,
        managed_image: "ManagedArtifact",
        **kwargs
    ):
        super(GalleryArtifactSource, self).__init__(**kwargs)
        self.managed_image = managed_image


class GalleryArtifactVersionSource(msrest.serialization.Model):
    """The gallery artifact version source.

    :param id: The id of the gallery artifact version source. Can specify a disk uri, snapshot uri,
     user image or storage account resource.
    :type id: str
    :param uri: The uri of the gallery artifact version source. Currently used to specify vhd/blob
     source.
    :type uri: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'uri': {'key': 'uri', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        uri: Optional[str] = None,
        **kwargs
    ):
        super(GalleryArtifactVersionSource, self).__init__(**kwargs)
        self.id = id
        self.uri = uri


class GalleryDiskImage(msrest.serialization.Model):
    """This is the disk image base class.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar size_in_gb: This property indicates the size of the VHD to be created.
    :vartype size_in_gb: int
    :param host_caching: The host caching of the disk. Valid values are 'None', 'ReadOnly', and
     'ReadWrite'. Possible values include: "None", "ReadOnly", "ReadWrite".
    :type host_caching: str or ~azure.mgmt.compute.v2020_09_30.models.HostCaching
    :param source: The gallery artifact version source.
    :type source: ~azure.mgmt.compute.v2020_09_30.models.GalleryArtifactVersionSource
    """

    _validation = {
        'size_in_gb': {'readonly': True},
    }

    _attribute_map = {
        'size_in_gb': {'key': 'sizeInGB', 'type': 'int'},
        'host_caching': {'key': 'hostCaching', 'type': 'str'},
        'source': {'key': 'source', 'type': 'GalleryArtifactVersionSource'},
    }

    def __init__(
        self,
        *,
        host_caching: Optional[Union[str, "HostCaching"]] = None,
        source: Optional["GalleryArtifactVersionSource"] = None,
        **kwargs
    ):
        super(GalleryDiskImage, self).__init__(**kwargs)
        self.size_in_gb = None
        self.host_caching = host_caching
        self.source = source


class GalleryDataDiskImage(GalleryDiskImage):
    """This is the data disk image.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar size_in_gb: This property indicates the size of the VHD to be created.
    :vartype size_in_gb: int
    :param host_caching: The host caching of the disk. Valid values are 'None', 'ReadOnly', and
     'ReadWrite'. Possible values include: "None", "ReadOnly", "ReadWrite".
    :type host_caching: str or ~azure.mgmt.compute.v2020_09_30.models.HostCaching
    :param source: The gallery artifact version source.
    :type source: ~azure.mgmt.compute.v2020_09_30.models.GalleryArtifactVersionSource
    :param lun: Required. This property specifies the logical unit number of the data disk. This
     value is used to identify data disks within the Virtual Machine and therefore must be unique
     for each data disk attached to the Virtual Machine.
    :type lun: int
    """

    _validation = {
        'size_in_gb': {'readonly': True},
        'lun': {'required': True},
    }

    _attribute_map = {
        'size_in_gb': {'key': 'sizeInGB', 'type': 'int'},
        'host_caching': {'key': 'hostCaching', 'type': 'str'},
        'source': {'key': 'source', 'type': 'GalleryArtifactVersionSource'},
        'lun': {'key': 'lun', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        lun: int,
        host_caching: Optional[Union[str, "HostCaching"]] = None,
        source: Optional["GalleryArtifactVersionSource"] = None,
        **kwargs
    ):
        super(GalleryDataDiskImage, self).__init__(host_caching=host_caching, source=source, **kwargs)
        self.lun = lun


class GalleryIdentifier(msrest.serialization.Model):
    """Describes the gallery unique name.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar unique_name: The unique name of the Shared Image Gallery. This name is generated
     automatically by Azure.
    :vartype unique_name: str
    """

    _validation = {
        'unique_name': {'readonly': True},
    }

    _attribute_map = {
        'unique_name': {'key': 'uniqueName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(GalleryIdentifier, self).__init__(**kwargs)
        self.unique_name = None


class GalleryImage(Resource):
    """Specifies information about the gallery image definition that you want to create or update.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Required. Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param description: The description of this gallery image definition resource. This property is
     updatable.
    :type description: str
    :param eula: The Eula agreement for the gallery image definition.
    :type eula: str
    :param privacy_statement_uri: The privacy statement uri.
    :type privacy_statement_uri: str
    :param release_note_uri: The release note uri.
    :type release_note_uri: str
    :param os_type: This property allows you to specify the type of the OS that is included in the
     disk when creating a VM from a managed image. :code:`<br>`:code:`<br>` Possible values are:
     :code:`<br>`:code:`<br>` **Windows** :code:`<br>`:code:`<br>` **Linux**. Possible values
     include: "Windows", "Linux".
    :type os_type: str or ~azure.mgmt.compute.v2020_09_30.models.OperatingSystemTypes
    :param os_state: This property allows the user to specify whether the virtual machines created
     under this image are 'Generalized' or 'Specialized'. Possible values include: "Generalized",
     "Specialized".
    :type os_state: str or ~azure.mgmt.compute.v2020_09_30.models.OperatingSystemStateTypes
    :param hyper_v_generation: The hypervisor generation of the Virtual Machine. Applicable to OS
     disks only. Possible values include: "V1", "V2".
    :type hyper_v_generation: str or ~azure.mgmt.compute.v2020_09_30.models.HyperVGeneration
    :param features: A list of gallery image features.
    :type features: list[~azure.mgmt.compute.v2020_09_30.models.GalleryImageFeature]
    :param end_of_life_date: The end of life date of the gallery image definition. This property
     can be used for decommissioning purposes. This property is updatable.
    :type end_of_life_date: ~datetime.datetime
    :param identifier: This is the gallery image definition identifier.
    :type identifier: ~azure.mgmt.compute.v2020_09_30.models.GalleryImageIdentifier
    :param recommended: The properties describe the recommended machine configuration for this
     Image Definition. These properties are updatable.
    :type recommended: ~azure.mgmt.compute.v2020_09_30.models.RecommendedMachineConfiguration
    :param disallowed: Describes the disallowed disk types.
    :type disallowed: ~azure.mgmt.compute.v2020_09_30.models.Disallowed
    :param purchase_plan: Describes the gallery image definition purchase plan. This is used by
     marketplace images.
    :type purchase_plan: ~azure.mgmt.compute.v2020_09_30.models.ImagePurchasePlan
    :ivar provisioning_state: The provisioning state, which only appears in the response. Possible
     values include: "Creating", "Updating", "Failed", "Succeeded", "Deleting", "Migrating".
    :vartype provisioning_state: str or
     ~azure.mgmt.compute.v2020_09_30.models.GalleryImagePropertiesProvisioningState
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'eula': {'key': 'properties.eula', 'type': 'str'},
        'privacy_statement_uri': {'key': 'properties.privacyStatementUri', 'type': 'str'},
        'release_note_uri': {'key': 'properties.releaseNoteUri', 'type': 'str'},
        'os_type': {'key': 'properties.osType', 'type': 'str'},
        'os_state': {'key': 'properties.osState', 'type': 'str'},
        'hyper_v_generation': {'key': 'properties.hyperVGeneration', 'type': 'str'},
        'features': {'key': 'properties.features', 'type': '[GalleryImageFeature]'},
        'end_of_life_date': {'key': 'properties.endOfLifeDate', 'type': 'iso-8601'},
        'identifier': {'key': 'properties.identifier', 'type': 'GalleryImageIdentifier'},
        'recommended': {'key': 'properties.recommended', 'type': 'RecommendedMachineConfiguration'},
        'disallowed': {'key': 'properties.disallowed', 'type': 'Disallowed'},
        'purchase_plan': {'key': 'properties.purchasePlan', 'type': 'ImagePurchasePlan'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        description: Optional[str] = None,
        eula: Optional[str] = None,
        privacy_statement_uri: Optional[str] = None,
        release_note_uri: Optional[str] = None,
        os_type: Optional[Union[str, "OperatingSystemTypes"]] = None,
        os_state: Optional[Union[str, "OperatingSystemStateTypes"]] = None,
        hyper_v_generation: Optional[Union[str, "HyperVGeneration"]] = None,
        features: Optional[List["GalleryImageFeature"]] = None,
        end_of_life_date: Optional[datetime.datetime] = None,
        identifier: Optional["GalleryImageIdentifier"] = None,
        recommended: Optional["RecommendedMachineConfiguration"] = None,
        disallowed: Optional["Disallowed"] = None,
        purchase_plan: Optional["ImagePurchasePlan"] = None,
        **kwargs
    ):
        super(GalleryImage, self).__init__(location=location, tags=tags, **kwargs)
        self.description = description
        self.eula = eula
        self.privacy_statement_uri = privacy_statement_uri
        self.release_note_uri = release_note_uri
        self.os_type = os_type
        self.os_state = os_state
        self.hyper_v_generation = hyper_v_generation
        self.features = features
        self.end_of_life_date = end_of_life_date
        self.identifier = identifier
        self.recommended = recommended
        self.disallowed = disallowed
        self.purchase_plan = purchase_plan
        self.provisioning_state = None


class GalleryImageFeature(msrest.serialization.Model):
    """A feature for gallery image.

    :param name: The name of the gallery image feature.
    :type name: str
    :param value: The value of the gallery image feature.
    :type value: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        value: Optional[str] = None,
        **kwargs
    ):
        super(GalleryImageFeature, self).__init__(**kwargs)
        self.name = name
        self.value = value


class GalleryImageIdentifier(msrest.serialization.Model):
    """This is the gallery image definition identifier.

    All required parameters must be populated in order to send to Azure.

    :param publisher: Required. The name of the gallery image definition publisher.
    :type publisher: str
    :param offer: Required. The name of the gallery image definition offer.
    :type offer: str
    :param sku: Required. The name of the gallery image definition SKU.
    :type sku: str
    """

    _validation = {
        'publisher': {'required': True},
        'offer': {'required': True},
        'sku': {'required': True},
    }

    _attribute_map = {
        'publisher': {'key': 'publisher', 'type': 'str'},
        'offer': {'key': 'offer', 'type': 'str'},
        'sku': {'key': 'sku', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        publisher: str,
        offer: str,
        sku: str,
        **kwargs
    ):
        super(GalleryImageIdentifier, self).__init__(**kwargs)
        self.publisher = publisher
        self.offer = offer
        self.sku = sku


class GalleryImageList(msrest.serialization.Model):
    """The List Gallery Images operation response.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. A list of Shared Image Gallery images.
    :type value: list[~azure.mgmt.compute.v2020_09_30.models.GalleryImage]
    :param next_link: The uri to fetch the next page of Image Definitions in the Shared Image
     Gallery. Call ListNext() with this to fetch the next page of gallery image definitions.
    :type next_link: str
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[GalleryImage]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["GalleryImage"],
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(GalleryImageList, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class GalleryImageUpdate(UpdateResourceDefinition):
    """Specifies information about the gallery image definition that you want to update.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param description: The description of this gallery image definition resource. This property is
     updatable.
    :type description: str
    :param eula: The Eula agreement for the gallery image definition.
    :type eula: str
    :param privacy_statement_uri: The privacy statement uri.
    :type privacy_statement_uri: str
    :param release_note_uri: The release note uri.
    :type release_note_uri: str
    :param os_type: This property allows you to specify the type of the OS that is included in the
     disk when creating a VM from a managed image. :code:`<br>`:code:`<br>` Possible values are:
     :code:`<br>`:code:`<br>` **Windows** :code:`<br>`:code:`<br>` **Linux**. Possible values
     include: "Windows", "Linux".
    :type os_type: str or ~azure.mgmt.compute.v2020_09_30.models.OperatingSystemTypes
    :param os_state: This property allows the user to specify whether the virtual machines created
     under this image are 'Generalized' or 'Specialized'. Possible values include: "Generalized",
     "Specialized".
    :type os_state: str or ~azure.mgmt.compute.v2020_09_30.models.OperatingSystemStateTypes
    :param hyper_v_generation: The hypervisor generation of the Virtual Machine. Applicable to OS
     disks only. Possible values include: "V1", "V2".
    :type hyper_v_generation: str or ~azure.mgmt.compute.v2020_09_30.models.HyperVGeneration
    :param features: A list of gallery image features.
    :type features: list[~azure.mgmt.compute.v2020_09_30.models.GalleryImageFeature]
    :param end_of_life_date: The end of life date of the gallery image definition. This property
     can be used for decommissioning purposes. This property is updatable.
    :type end_of_life_date: ~datetime.datetime
    :param identifier: This is the gallery image definition identifier.
    :type identifier: ~azure.mgmt.compute.v2020_09_30.models.GalleryImageIdentifier
    :param recommended: The properties describe the recommended machine configuration for this
     Image Definition. These properties are updatable.
    :type recommended: ~azure.mgmt.compute.v2020_09_30.models.RecommendedMachineConfiguration
    :param disallowed: Describes the disallowed disk types.
    :type disallowed: ~azure.mgmt.compute.v2020_09_30.models.Disallowed
    :param purchase_plan: Describes the gallery image definition purchase plan. This is used by
     marketplace images.
    :type purchase_plan: ~azure.mgmt.compute.v2020_09_30.models.ImagePurchasePlan
    :ivar provisioning_state: The provisioning state, which only appears in the response. Possible
     values include: "Creating", "Updating", "Failed", "Succeeded", "Deleting", "Migrating".
    :vartype provisioning_state: str or
     ~azure.mgmt.compute.v2020_09_30.models.GalleryImagePropertiesProvisioningState
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'eula': {'key': 'properties.eula', 'type': 'str'},
        'privacy_statement_uri': {'key': 'properties.privacyStatementUri', 'type': 'str'},
        'release_note_uri': {'key': 'properties.releaseNoteUri', 'type': 'str'},
        'os_type': {'key': 'properties.osType', 'type': 'str'},
        'os_state': {'key': 'properties.osState', 'type': 'str'},
        'hyper_v_generation': {'key': 'properties.hyperVGeneration', 'type': 'str'},
        'features': {'key': 'properties.features', 'type': '[GalleryImageFeature]'},
        'end_of_life_date': {'key': 'properties.endOfLifeDate', 'type': 'iso-8601'},
        'identifier': {'key': 'properties.identifier', 'type': 'GalleryImageIdentifier'},
        'recommended': {'key': 'properties.recommended', 'type': 'RecommendedMachineConfiguration'},
        'disallowed': {'key': 'properties.disallowed', 'type': 'Disallowed'},
        'purchase_plan': {'key': 'properties.purchasePlan', 'type': 'ImagePurchasePlan'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        description: Optional[str] = None,
        eula: Optional[str] = None,
        privacy_statement_uri: Optional[str] = None,
        release_note_uri: Optional[str] = None,
        os_type: Optional[Union[str, "OperatingSystemTypes"]] = None,
        os_state: Optional[Union[str, "OperatingSystemStateTypes"]] = None,
        hyper_v_generation: Optional[Union[str, "HyperVGeneration"]] = None,
        features: Optional[List["GalleryImageFeature"]] = None,
        end_of_life_date: Optional[datetime.datetime] = None,
        identifier: Optional["GalleryImageIdentifier"] = None,
        recommended: Optional["RecommendedMachineConfiguration"] = None,
        disallowed: Optional["Disallowed"] = None,
        purchase_plan: Optional["ImagePurchasePlan"] = None,
        **kwargs
    ):
        super(GalleryImageUpdate, self).__init__(tags=tags, **kwargs)
        self.description = description
        self.eula = eula
        self.privacy_statement_uri = privacy_statement_uri
        self.release_note_uri = release_note_uri
        self.os_type = os_type
        self.os_state = os_state
        self.hyper_v_generation = hyper_v_generation
        self.features = features
        self.end_of_life_date = end_of_life_date
        self.identifier = identifier
        self.recommended = recommended
        self.disallowed = disallowed
        self.purchase_plan = purchase_plan
        self.provisioning_state = None


class GalleryImageVersion(Resource):
    """Specifies information about the gallery image version that you want to create or update.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Required. Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param publishing_profile: Describes the basic gallery artifact publishing profile.
    :type publishing_profile:
     ~azure.mgmt.compute.v2020_09_30.models.GalleryArtifactPublishingProfileBase
    :ivar provisioning_state: The provisioning state, which only appears in the response. Possible
     values include: "Creating", "Updating", "Failed", "Succeeded", "Deleting", "Migrating".
    :vartype provisioning_state: str or
     ~azure.mgmt.compute.v2020_09_30.models.GalleryImageVersionPropertiesProvisioningState
    :param storage_profile: This is the storage profile of a Gallery Image Version.
    :type storage_profile: ~azure.mgmt.compute.v2020_09_30.models.GalleryImageVersionStorageProfile
    :ivar replication_status: This is the replication status of the gallery image version.
    :vartype replication_status: ~azure.mgmt.compute.v2020_09_30.models.ReplicationStatus
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'provisioning_state': {'readonly': True},
        'replication_status': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'publishing_profile': {'key': 'properties.publishingProfile', 'type': 'GalleryArtifactPublishingProfileBase'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'storage_profile': {'key': 'properties.storageProfile', 'type': 'GalleryImageVersionStorageProfile'},
        'replication_status': {'key': 'properties.replicationStatus', 'type': 'ReplicationStatus'},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        publishing_profile: Optional["GalleryArtifactPublishingProfileBase"] = None,
        storage_profile: Optional["GalleryImageVersionStorageProfile"] = None,
        **kwargs
    ):
        super(GalleryImageVersion, self).__init__(location=location, tags=tags, **kwargs)
        self.publishing_profile = publishing_profile
        self.provisioning_state = None
        self.storage_profile = storage_profile
        self.replication_status = None


class GalleryImageVersionList(msrest.serialization.Model):
    """The List Gallery Image version operation response.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. A list of gallery image versions.
    :type value: list[~azure.mgmt.compute.v2020_09_30.models.GalleryImageVersion]
    :param next_link: The uri to fetch the next page of gallery image versions. Call ListNext()
     with this to fetch the next page of gallery image versions.
    :type next_link: str
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[GalleryImageVersion]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["GalleryImageVersion"],
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(GalleryImageVersionList, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class GalleryImageVersionPublishingProfile(GalleryArtifactPublishingProfileBase):
    """The publishing profile of a gallery image Version.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param target_regions: The target regions where the Image Version is going to be replicated to.
     This property is updatable.
    :type target_regions: list[~azure.mgmt.compute.v2020_09_30.models.TargetRegion]
    :param replica_count: The number of replicas of the Image Version to be created per region.
     This property would take effect for a region when regionalReplicaCount is not specified. This
     property is updatable.
    :type replica_count: int
    :param exclude_from_latest: If set to true, Virtual Machines deployed from the latest version
     of the Image Definition won't use this Image Version.
    :type exclude_from_latest: bool
    :ivar published_date: The timestamp for when the gallery image version is published.
    :vartype published_date: ~datetime.datetime
    :param end_of_life_date: The end of life date of the gallery image version. This property can
     be used for decommissioning purposes. This property is updatable.
    :type end_of_life_date: ~datetime.datetime
    :param storage_account_type: Specifies the storage account type to be used to store the image.
     This property is not updatable. Possible values include: "Standard_LRS", "Standard_ZRS",
     "Premium_LRS".
    :type storage_account_type: str or ~azure.mgmt.compute.v2020_09_30.models.StorageAccountType
    """

    _validation = {
        'published_date': {'readonly': True},
    }

    _attribute_map = {
        'target_regions': {'key': 'targetRegions', 'type': '[TargetRegion]'},
        'replica_count': {'key': 'replicaCount', 'type': 'int'},
        'exclude_from_latest': {'key': 'excludeFromLatest', 'type': 'bool'},
        'published_date': {'key': 'publishedDate', 'type': 'iso-8601'},
        'end_of_life_date': {'key': 'endOfLifeDate', 'type': 'iso-8601'},
        'storage_account_type': {'key': 'storageAccountType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        target_regions: Optional[List["TargetRegion"]] = None,
        replica_count: Optional[int] = None,
        exclude_from_latest: Optional[bool] = None,
        end_of_life_date: Optional[datetime.datetime] = None,
        storage_account_type: Optional[Union[str, "StorageAccountType"]] = None,
        **kwargs
    ):
        super(GalleryImageVersionPublishingProfile, self).__init__(target_regions=target_regions, replica_count=replica_count, exclude_from_latest=exclude_from_latest, end_of_life_date=end_of_life_date, storage_account_type=storage_account_type, **kwargs)


class GalleryImageVersionStorageProfile(msrest.serialization.Model):
    """This is the storage profile of a Gallery Image Version.

    :param source: The gallery artifact version source.
    :type source: ~azure.mgmt.compute.v2020_09_30.models.GalleryArtifactVersionSource
    :param os_disk_image: This is the disk image base class.
    :type os_disk_image: ~azure.mgmt.compute.v2020_09_30.models.GalleryDiskImage
    :param data_disk_images: A list of data disk images.
    :type data_disk_images: list[~azure.mgmt.compute.v2020_09_30.models.GalleryDataDiskImage]
    """

    _attribute_map = {
        'source': {'key': 'source', 'type': 'GalleryArtifactVersionSource'},
        'os_disk_image': {'key': 'osDiskImage', 'type': 'GalleryDiskImage'},
        'data_disk_images': {'key': 'dataDiskImages', 'type': '[GalleryDataDiskImage]'},
    }

    def __init__(
        self,
        *,
        source: Optional["GalleryArtifactVersionSource"] = None,
        os_disk_image: Optional["GalleryDiskImage"] = None,
        data_disk_images: Optional[List["GalleryDataDiskImage"]] = None,
        **kwargs
    ):
        super(GalleryImageVersionStorageProfile, self).__init__(**kwargs)
        self.source = source
        self.os_disk_image = os_disk_image
        self.data_disk_images = data_disk_images


class GalleryImageVersionUpdate(UpdateResourceDefinition):
    """Specifies information about the gallery image version that you want to update.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param publishing_profile: Describes the basic gallery artifact publishing profile.
    :type publishing_profile:
     ~azure.mgmt.compute.v2020_09_30.models.GalleryArtifactPublishingProfileBase
    :ivar provisioning_state: The provisioning state, which only appears in the response. Possible
     values include: "Creating", "Updating", "Failed", "Succeeded", "Deleting", "Migrating".
    :vartype provisioning_state: str or
     ~azure.mgmt.compute.v2020_09_30.models.GalleryImageVersionPropertiesProvisioningState
    :param storage_profile: This is the storage profile of a Gallery Image Version.
    :type storage_profile: ~azure.mgmt.compute.v2020_09_30.models.GalleryImageVersionStorageProfile
    :ivar replication_status: This is the replication status of the gallery image version.
    :vartype replication_status: ~azure.mgmt.compute.v2020_09_30.models.ReplicationStatus
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'replication_status': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'publishing_profile': {'key': 'properties.publishingProfile', 'type': 'GalleryArtifactPublishingProfileBase'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'storage_profile': {'key': 'properties.storageProfile', 'type': 'GalleryImageVersionStorageProfile'},
        'replication_status': {'key': 'properties.replicationStatus', 'type': 'ReplicationStatus'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        publishing_profile: Optional["GalleryArtifactPublishingProfileBase"] = None,
        storage_profile: Optional["GalleryImageVersionStorageProfile"] = None,
        **kwargs
    ):
        super(GalleryImageVersionUpdate, self).__init__(tags=tags, **kwargs)
        self.publishing_profile = publishing_profile
        self.provisioning_state = None
        self.storage_profile = storage_profile
        self.replication_status = None


class GalleryList(msrest.serialization.Model):
    """The List Galleries operation response.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. A list of galleries.
    :type value: list[~azure.mgmt.compute.v2020_09_30.models.Gallery]
    :param next_link: The uri to fetch the next page of galleries. Call ListNext() with this to
     fetch the next page of galleries.
    :type next_link: str
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Gallery]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["Gallery"],
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(GalleryList, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class GalleryOSDiskImage(GalleryDiskImage):
    """This is the OS disk image.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar size_in_gb: This property indicates the size of the VHD to be created.
    :vartype size_in_gb: int
    :param host_caching: The host caching of the disk. Valid values are 'None', 'ReadOnly', and
     'ReadWrite'. Possible values include: "None", "ReadOnly", "ReadWrite".
    :type host_caching: str or ~azure.mgmt.compute.v2020_09_30.models.HostCaching
    :param source: The gallery artifact version source.
    :type source: ~azure.mgmt.compute.v2020_09_30.models.GalleryArtifactVersionSource
    """

    _validation = {
        'size_in_gb': {'readonly': True},
    }

    _attribute_map = {
        'size_in_gb': {'key': 'sizeInGB', 'type': 'int'},
        'host_caching': {'key': 'hostCaching', 'type': 'str'},
        'source': {'key': 'source', 'type': 'GalleryArtifactVersionSource'},
    }

    def __init__(
        self,
        *,
        host_caching: Optional[Union[str, "HostCaching"]] = None,
        source: Optional["GalleryArtifactVersionSource"] = None,
        **kwargs
    ):
        super(GalleryOSDiskImage, self).__init__(host_caching=host_caching, source=source, **kwargs)


class GalleryUpdate(UpdateResourceDefinition):
    """Specifies information about the Shared Image Gallery that you want to update.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param description: The description of this Shared Image Gallery resource. This property is
     updatable.
    :type description: str
    :param identifier: Describes the gallery unique name.
    :type identifier: ~azure.mgmt.compute.v2020_09_30.models.GalleryIdentifier
    :ivar provisioning_state: The provisioning state, which only appears in the response. Possible
     values include: "Creating", "Updating", "Failed", "Succeeded", "Deleting", "Migrating".
    :vartype provisioning_state: str or
     ~azure.mgmt.compute.v2020_09_30.models.GalleryPropertiesProvisioningState
    :param sharing_profile: Profile for gallery sharing to subscription or tenant.
    :type sharing_profile: ~azure.mgmt.compute.v2020_09_30.models.SharingProfile
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'identifier': {'key': 'properties.identifier', 'type': 'GalleryIdentifier'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'sharing_profile': {'key': 'properties.sharingProfile', 'type': 'SharingProfile'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        description: Optional[str] = None,
        identifier: Optional["GalleryIdentifier"] = None,
        sharing_profile: Optional["SharingProfile"] = None,
        **kwargs
    ):
        super(GalleryUpdate, self).__init__(tags=tags, **kwargs)
        self.description = description
        self.identifier = identifier
        self.provisioning_state = None
        self.sharing_profile = sharing_profile


class ImagePurchasePlan(msrest.serialization.Model):
    """Describes the gallery image definition purchase plan. This is used by marketplace images.

    :param name: The plan ID.
    :type name: str
    :param publisher: The publisher ID.
    :type publisher: str
    :param product: The product ID.
    :type product: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'publisher': {'key': 'publisher', 'type': 'str'},
        'product': {'key': 'product', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        publisher: Optional[str] = None,
        product: Optional[str] = None,
        **kwargs
    ):
        super(ImagePurchasePlan, self).__init__(**kwargs)
        self.name = name
        self.publisher = publisher
        self.product = product


class InnerError(msrest.serialization.Model):
    """Inner error details.

    :param exceptiontype: The exception type.
    :type exceptiontype: str
    :param errordetail: The internal error message or exception dump.
    :type errordetail: str
    """

    _attribute_map = {
        'exceptiontype': {'key': 'exceptiontype', 'type': 'str'},
        'errordetail': {'key': 'errordetail', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        exceptiontype: Optional[str] = None,
        errordetail: Optional[str] = None,
        **kwargs
    ):
        super(InnerError, self).__init__(**kwargs)
        self.exceptiontype = exceptiontype
        self.errordetail = errordetail


class ManagedArtifact(msrest.serialization.Model):
    """The managed artifact.

    All required parameters must be populated in order to send to Azure.

    :param id: Required. The managed artifact id.
    :type id: str
    """

    _validation = {
        'id': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: str,
        **kwargs
    ):
        super(ManagedArtifact, self).__init__(**kwargs)
        self.id = id


class OSDiskImageEncryption(DiskImageEncryption):
    """Contains encryption settings for an OS disk image.

    :param disk_encryption_set_id: A relative URI containing the resource ID of the disk encryption
     set.
    :type disk_encryption_set_id: str
    """

    _attribute_map = {
        'disk_encryption_set_id': {'key': 'diskEncryptionSetId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        disk_encryption_set_id: Optional[str] = None,
        **kwargs
    ):
        super(OSDiskImageEncryption, self).__init__(disk_encryption_set_id=disk_encryption_set_id, **kwargs)


class PirResource(msrest.serialization.Model):
    """The Resource model definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Resource name.
    :vartype name: str
    :ivar location: Resource location.
    :vartype location: str
    """

    _validation = {
        'name': {'readonly': True},
        'location': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PirResource, self).__init__(**kwargs)
        self.name = None
        self.location = None


class PirSharedGalleryResource(PirResource):
    """Base information about the shared gallery resource in pir.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Resource name.
    :vartype name: str
    :ivar location: Resource location.
    :vartype location: str
    :param unique_id: The unique id of this shared gallery.
    :type unique_id: str
    """

    _validation = {
        'name': {'readonly': True},
        'location': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'unique_id': {'key': 'identifier.uniqueId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        unique_id: Optional[str] = None,
        **kwargs
    ):
        super(PirSharedGalleryResource, self).__init__(**kwargs)
        self.unique_id = unique_id


class RecommendedMachineConfiguration(msrest.serialization.Model):
    """The properties describe the recommended machine configuration for this Image Definition. These properties are updatable.

    :param v_cp_us: Describes the resource range.
    :type v_cp_us: ~azure.mgmt.compute.v2020_09_30.models.ResourceRange
    :param memory: Describes the resource range.
    :type memory: ~azure.mgmt.compute.v2020_09_30.models.ResourceRange
    """

    _attribute_map = {
        'v_cp_us': {'key': 'vCPUs', 'type': 'ResourceRange'},
        'memory': {'key': 'memory', 'type': 'ResourceRange'},
    }

    def __init__(
        self,
        *,
        v_cp_us: Optional["ResourceRange"] = None,
        memory: Optional["ResourceRange"] = None,
        **kwargs
    ):
        super(RecommendedMachineConfiguration, self).__init__(**kwargs)
        self.v_cp_us = v_cp_us
        self.memory = memory


class RegionalReplicationStatus(msrest.serialization.Model):
    """This is the regional replication status.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar region: The region to which the gallery image version is being replicated to.
    :vartype region: str
    :ivar state: This is the regional replication state. Possible values include: "Unknown",
     "Replicating", "Completed", "Failed".
    :vartype state: str or ~azure.mgmt.compute.v2020_09_30.models.ReplicationState
    :ivar details: The details of the replication status.
    :vartype details: str
    :ivar progress: It indicates progress of the replication job.
    :vartype progress: int
    """

    _validation = {
        'region': {'readonly': True},
        'state': {'readonly': True},
        'details': {'readonly': True},
        'progress': {'readonly': True},
    }

    _attribute_map = {
        'region': {'key': 'region', 'type': 'str'},
        'state': {'key': 'state', 'type': 'str'},
        'details': {'key': 'details', 'type': 'str'},
        'progress': {'key': 'progress', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RegionalReplicationStatus, self).__init__(**kwargs)
        self.region = None
        self.state = None
        self.details = None
        self.progress = None


class ReplicationStatus(msrest.serialization.Model):
    """This is the replication status of the gallery image version.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar aggregated_state: This is the aggregated replication status based on all the regional
     replication status flags. Possible values include: "Unknown", "InProgress", "Completed",
     "Failed".
    :vartype aggregated_state: str or
     ~azure.mgmt.compute.v2020_09_30.models.AggregatedReplicationState
    :ivar summary: This is a summary of replication status for each region.
    :vartype summary: list[~azure.mgmt.compute.v2020_09_30.models.RegionalReplicationStatus]
    """

    _validation = {
        'aggregated_state': {'readonly': True},
        'summary': {'readonly': True},
    }

    _attribute_map = {
        'aggregated_state': {'key': 'aggregatedState', 'type': 'str'},
        'summary': {'key': 'summary', 'type': '[RegionalReplicationStatus]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ReplicationStatus, self).__init__(**kwargs)
        self.aggregated_state = None
        self.summary = None


class ResourceRange(msrest.serialization.Model):
    """Describes the resource range.

    :param min: The minimum number of the resource.
    :type min: int
    :param max: The maximum number of the resource.
    :type max: int
    """

    _attribute_map = {
        'min': {'key': 'min', 'type': 'int'},
        'max': {'key': 'max', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        min: Optional[int] = None,
        max: Optional[int] = None,
        **kwargs
    ):
        super(ResourceRange, self).__init__(**kwargs)
        self.min = min
        self.max = max


class SharedGallery(PirSharedGalleryResource):
    """Specifies information about the Shared Gallery that you want to create or update.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Resource name.
    :vartype name: str
    :ivar location: Resource location.
    :vartype location: str
    :param unique_id: The unique id of this shared gallery.
    :type unique_id: str
    """

    _validation = {
        'name': {'readonly': True},
        'location': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'unique_id': {'key': 'identifier.uniqueId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        unique_id: Optional[str] = None,
        **kwargs
    ):
        super(SharedGallery, self).__init__(unique_id=unique_id, **kwargs)


class SharedGalleryImage(PirSharedGalleryResource):
    """Specifies information about the gallery image definition that you want to create or update.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Resource name.
    :vartype name: str
    :ivar location: Resource location.
    :vartype location: str
    :param unique_id: The unique id of this shared gallery.
    :type unique_id: str
    :param os_type: This property allows you to specify the type of the OS that is included in the
     disk when creating a VM from a managed image. :code:`<br>`:code:`<br>` Possible values are:
     :code:`<br>`:code:`<br>` **Windows** :code:`<br>`:code:`<br>` **Linux**. Possible values
     include: "Windows", "Linux".
    :type os_type: str or ~azure.mgmt.compute.v2020_09_30.models.OperatingSystemTypes
    :param os_state: This property allows the user to specify whether the virtual machines created
     under this image are 'Generalized' or 'Specialized'. Possible values include: "Generalized",
     "Specialized".
    :type os_state: str or ~azure.mgmt.compute.v2020_09_30.models.OperatingSystemStateTypes
    :param end_of_life_date: The end of life date of the gallery image definition. This property
     can be used for decommissioning purposes. This property is updatable.
    :type end_of_life_date: ~datetime.datetime
    :param identifier: This is the gallery image definition identifier.
    :type identifier: ~azure.mgmt.compute.v2020_09_30.models.GalleryImageIdentifier
    :param recommended: The properties describe the recommended machine configuration for this
     Image Definition. These properties are updatable.
    :type recommended: ~azure.mgmt.compute.v2020_09_30.models.RecommendedMachineConfiguration
    :param disallowed: Describes the disallowed disk types.
    :type disallowed: ~azure.mgmt.compute.v2020_09_30.models.Disallowed
    :param hyper_v_generation: The hypervisor generation of the Virtual Machine. Applicable to OS
     disks only. Possible values include: "V1", "V2".
    :type hyper_v_generation: str or ~azure.mgmt.compute.v2020_09_30.models.HyperVGeneration
    :param features: A list of gallery image features.
    :type features: list[~azure.mgmt.compute.v2020_09_30.models.GalleryImageFeature]
    :param purchase_plan: Describes the gallery image definition purchase plan. This is used by
     marketplace images.
    :type purchase_plan: ~azure.mgmt.compute.v2020_09_30.models.ImagePurchasePlan
    """

    _validation = {
        'name': {'readonly': True},
        'location': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'unique_id': {'key': 'identifier.uniqueId', 'type': 'str'},
        'os_type': {'key': 'properties.osType', 'type': 'str'},
        'os_state': {'key': 'properties.osState', 'type': 'str'},
        'end_of_life_date': {'key': 'properties.endOfLifeDate', 'type': 'iso-8601'},
        'identifier': {'key': 'properties.identifier', 'type': 'GalleryImageIdentifier'},
        'recommended': {'key': 'properties.recommended', 'type': 'RecommendedMachineConfiguration'},
        'disallowed': {'key': 'properties.disallowed', 'type': 'Disallowed'},
        'hyper_v_generation': {'key': 'properties.hyperVGeneration', 'type': 'str'},
        'features': {'key': 'properties.features', 'type': '[GalleryImageFeature]'},
        'purchase_plan': {'key': 'properties.purchasePlan', 'type': 'ImagePurchasePlan'},
    }

    def __init__(
        self,
        *,
        unique_id: Optional[str] = None,
        os_type: Optional[Union[str, "OperatingSystemTypes"]] = None,
        os_state: Optional[Union[str, "OperatingSystemStateTypes"]] = None,
        end_of_life_date: Optional[datetime.datetime] = None,
        identifier: Optional["GalleryImageIdentifier"] = None,
        recommended: Optional["RecommendedMachineConfiguration"] = None,
        disallowed: Optional["Disallowed"] = None,
        hyper_v_generation: Optional[Union[str, "HyperVGeneration"]] = None,
        features: Optional[List["GalleryImageFeature"]] = None,
        purchase_plan: Optional["ImagePurchasePlan"] = None,
        **kwargs
    ):
        super(SharedGalleryImage, self).__init__(unique_id=unique_id, **kwargs)
        self.os_type = os_type
        self.os_state = os_state
        self.end_of_life_date = end_of_life_date
        self.identifier = identifier
        self.recommended = recommended
        self.disallowed = disallowed
        self.hyper_v_generation = hyper_v_generation
        self.features = features
        self.purchase_plan = purchase_plan


class SharedGalleryImageList(msrest.serialization.Model):
    """The List Shared Gallery Images operation response.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. A list of shared gallery images.
    :type value: list[~azure.mgmt.compute.v2020_09_30.models.SharedGalleryImage]
    :param next_link: The uri to fetch the next page of shared gallery images. Call ListNext() with
     this to fetch the next page of shared gallery images.
    :type next_link: str
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[SharedGalleryImage]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["SharedGalleryImage"],
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(SharedGalleryImageList, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class SharedGalleryImageVersion(PirSharedGalleryResource):
    """Specifies information about the gallery image version that you want to create or update.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Resource name.
    :vartype name: str
    :ivar location: Resource location.
    :vartype location: str
    :param unique_id: The unique id of this shared gallery.
    :type unique_id: str
    :param published_date: The published date of the gallery image version Definition. This
     property can be used for decommissioning purposes. This property is updatable.
    :type published_date: ~datetime.datetime
    :param end_of_life_date: The end of life date of the gallery image version Definition. This
     property can be used for decommissioning purposes. This property is updatable.
    :type end_of_life_date: ~datetime.datetime
    """

    _validation = {
        'name': {'readonly': True},
        'location': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'unique_id': {'key': 'identifier.uniqueId', 'type': 'str'},
        'published_date': {'key': 'properties.publishedDate', 'type': 'iso-8601'},
        'end_of_life_date': {'key': 'properties.endOfLifeDate', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        *,
        unique_id: Optional[str] = None,
        published_date: Optional[datetime.datetime] = None,
        end_of_life_date: Optional[datetime.datetime] = None,
        **kwargs
    ):
        super(SharedGalleryImageVersion, self).__init__(unique_id=unique_id, **kwargs)
        self.published_date = published_date
        self.end_of_life_date = end_of_life_date


class SharedGalleryImageVersionList(msrest.serialization.Model):
    """The List Shared Gallery Image versions operation response.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. A list of shared gallery images versions.
    :type value: list[~azure.mgmt.compute.v2020_09_30.models.SharedGalleryImageVersion]
    :param next_link: The uri to fetch the next page of shared gallery image versions. Call
     ListNext() with this to fetch the next page of shared gallery image versions.
    :type next_link: str
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[SharedGalleryImageVersion]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["SharedGalleryImageVersion"],
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(SharedGalleryImageVersionList, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class SharedGalleryList(msrest.serialization.Model):
    """The List Shared Galleries operation response.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. A list of shared galleries.
    :type value: list[~azure.mgmt.compute.v2020_09_30.models.PirSharedGalleryResource]
    :param next_link: The uri to fetch the next page of shared galleries. Call ListNext() with this
     to fetch the next page of shared galleries.
    :type next_link: str
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[PirSharedGalleryResource]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["PirSharedGalleryResource"],
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(SharedGalleryList, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class SharingProfile(msrest.serialization.Model):
    """Profile for gallery sharing to subscription or tenant.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param permissions: This property allows you to specify the permission of sharing gallery.
     :code:`<br>`:code:`<br>` Possible values are: :code:`<br>`:code:`<br>` **Private**
     :code:`<br>`:code:`<br>` **Groups**. Possible values include: "Private", "Groups".
    :type permissions: str or ~azure.mgmt.compute.v2020_09_30.models.GallerySharingPermissionTypes
    :ivar groups: A list of sharing profile groups.
    :vartype groups: list[~azure.mgmt.compute.v2020_09_30.models.SharingProfileGroup]
    """

    _validation = {
        'groups': {'readonly': True},
    }

    _attribute_map = {
        'permissions': {'key': 'permissions', 'type': 'str'},
        'groups': {'key': 'groups', 'type': '[SharingProfileGroup]'},
    }

    def __init__(
        self,
        *,
        permissions: Optional[Union[str, "GallerySharingPermissionTypes"]] = None,
        **kwargs
    ):
        super(SharingProfile, self).__init__(**kwargs)
        self.permissions = permissions
        self.groups = None


class SharingProfileGroup(msrest.serialization.Model):
    """Group of the gallery sharing profile.

    :param type: This property allows you to specify the type of sharing group.
     :code:`<br>`:code:`<br>` Possible values are: :code:`<br>`:code:`<br>` **Subscriptions**
     :code:`<br>`:code:`<br>` **AADTenants**. Possible values include: "Subscriptions",
     "AADTenants".
    :type type: str or ~azure.mgmt.compute.v2020_09_30.models.SharingProfileGroupTypes
    :param ids: A list of subscription/tenant ids the gallery is aimed to be shared to.
    :type ids: list[str]
    """

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'ids': {'key': 'ids', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        type: Optional[Union[str, "SharingProfileGroupTypes"]] = None,
        ids: Optional[List[str]] = None,
        **kwargs
    ):
        super(SharingProfileGroup, self).__init__(**kwargs)
        self.type = type
        self.ids = ids


class SharingUpdate(msrest.serialization.Model):
    """Specifies information about the gallery sharing profile update.

    All required parameters must be populated in order to send to Azure.

    :param operation_type: Required. This property allows you to specify the operation type of
     gallery sharing update. :code:`<br>`:code:`<br>` Possible values are: :code:`<br>`:code:`<br>`
     **Add** :code:`<br>`:code:`<br>` **Remove** :code:`<br>`:code:`<br>` **Reset**. Possible values
     include: "Add", "Remove", "Reset".
    :type operation_type: str or ~azure.mgmt.compute.v2020_09_30.models.SharingUpdateOperationTypes
    :param groups: A list of sharing profile groups.
    :type groups: list[~azure.mgmt.compute.v2020_09_30.models.SharingProfileGroup]
    """

    _validation = {
        'operation_type': {'required': True},
    }

    _attribute_map = {
        'operation_type': {'key': 'operationType', 'type': 'str'},
        'groups': {'key': 'groups', 'type': '[SharingProfileGroup]'},
    }

    def __init__(
        self,
        *,
        operation_type: Union[str, "SharingUpdateOperationTypes"],
        groups: Optional[List["SharingProfileGroup"]] = None,
        **kwargs
    ):
        super(SharingUpdate, self).__init__(**kwargs)
        self.operation_type = operation_type
        self.groups = groups


class TargetRegion(msrest.serialization.Model):
    """Describes the target region information.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The name of the region.
    :type name: str
    :param regional_replica_count: The number of replicas of the Image Version to be created per
     region. This property is updatable.
    :type regional_replica_count: int
    :param storage_account_type: Specifies the storage account type to be used to store the image.
     This property is not updatable. Possible values include: "Standard_LRS", "Standard_ZRS",
     "Premium_LRS".
    :type storage_account_type: str or ~azure.mgmt.compute.v2020_09_30.models.StorageAccountType
    :param encryption: Optional. Allows users to provide customer managed keys for encrypting the
     OS and data disks in the gallery artifact.
    :type encryption: ~azure.mgmt.compute.v2020_09_30.models.EncryptionImages
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'regional_replica_count': {'key': 'regionalReplicaCount', 'type': 'int'},
        'storage_account_type': {'key': 'storageAccountType', 'type': 'str'},
        'encryption': {'key': 'encryption', 'type': 'EncryptionImages'},
    }

    def __init__(
        self,
        *,
        name: str,
        regional_replica_count: Optional[int] = None,
        storage_account_type: Optional[Union[str, "StorageAccountType"]] = None,
        encryption: Optional["EncryptionImages"] = None,
        **kwargs
    ):
        super(TargetRegion, self).__init__(**kwargs)
        self.name = name
        self.regional_replica_count = regional_replica_count
        self.storage_account_type = storage_account_type
        self.encryption = encryption


class UserArtifactManage(msrest.serialization.Model):
    """UserArtifactManage.

    All required parameters must be populated in order to send to Azure.

    :param install: Required. Required. The path and arguments to install the gallery application.
     This is limited to 4096 characters.
    :type install: str
    :param remove: Required. Required. The path and arguments to remove the gallery application.
     This is limited to 4096 characters.
    :type remove: str
    :param update: Optional. The path and arguments to update the gallery application. If not
     present, then update operation will invoke remove command on the previous version and install
     command on the current version of the gallery application. This is limited to 4096 characters.
    :type update: str
    """

    _validation = {
        'install': {'required': True},
        'remove': {'required': True},
    }

    _attribute_map = {
        'install': {'key': 'install', 'type': 'str'},
        'remove': {'key': 'remove', 'type': 'str'},
        'update': {'key': 'update', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        install: str,
        remove: str,
        update: Optional[str] = None,
        **kwargs
    ):
        super(UserArtifactManage, self).__init__(**kwargs)
        self.install = install
        self.remove = remove
        self.update = update


class UserArtifactSource(msrest.serialization.Model):
    """The source image from which the Image Version is going to be created.

    All required parameters must be populated in order to send to Azure.

    :param media_link: Required. Required. The mediaLink of the artifact, must be a readable
     storage page blob.
    :type media_link: str
    :param default_configuration_link: Optional. The defaultConfigurationLink of the artifact, must
     be a readable storage page blob.
    :type default_configuration_link: str
    """

    _validation = {
        'media_link': {'required': True},
    }

    _attribute_map = {
        'media_link': {'key': 'mediaLink', 'type': 'str'},
        'default_configuration_link': {'key': 'defaultConfigurationLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        media_link: str,
        default_configuration_link: Optional[str] = None,
        **kwargs
    ):
        super(UserArtifactSource, self).__init__(**kwargs)
        self.media_link = media_link
        self.default_configuration_link = default_configuration_link
