# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class AnalyzeResultOperationStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Operation status.
    """

    NOT_STARTED = "notStarted"
    RUNNING = "running"
    FAILED = "failed"
    SUCCEEDED = "succeeded"

class ApiVersion(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """API version.
    """

    TWO_THOUSAND_TWENTY_TWO08_31 = "2022-08-31"

class ContentType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Content type for upload
    """

    #: Content Type 'application/octet-stream'.
    APPLICATION_OCTET_STREAM = "application/octet-stream"
    #: Content Type 'application/pdf'.
    APPLICATION_PDF = "application/pdf"
    #: Content Type 'image/bmp'.
    IMAGE_BMP = "image/bmp"
    #: Content Type 'image/heif'.
    IMAGE_HEIF = "image/heif"
    #: Content Type 'image/jpeg'.
    IMAGE_JPEG = "image/jpeg"
    #: Content Type 'image/png'.
    IMAGE_PNG = "image/png"
    #: Content Type 'image/tiff'.
    IMAGE_TIFF = "image/tiff"
    #: Content Type 'application/json'.
    APPLICATION_JSON = "application/json"

class DocumentBuildMode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Custom document model build mode.
    """

    TEMPLATE = "template"
    NEURAL = "neural"

class DocumentFieldType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Semantic data type of the field value.
    """

    STRING = "string"
    DATE = "date"
    TIME = "time"
    PHONE_NUMBER = "phoneNumber"
    NUMBER = "number"
    INTEGER = "integer"
    SELECTION_MARK = "selectionMark"
    COUNTRY_REGION = "countryRegion"
    SIGNATURE = "signature"
    ARRAY = "array"
    OBJECT = "object"
    CURRENCY = "currency"
    ADDRESS = "address"

class DocumentSignatureType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Presence of signature.
    """

    SIGNED = "signed"
    UNSIGNED = "unsigned"

class DocumentTableCellKind(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Table cell kind.
    """

    CONTENT = "content"
    ROW_HEADER = "rowHeader"
    COLUMN_HEADER = "columnHeader"
    STUB_HEAD = "stubHead"
    DESCRIPTION = "description"

class LengthUnit(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The unit used by the width, height, and polygon properties. For images, the unit is "pixel".
    For PDF, the unit is "inch".
    """

    PIXEL = "pixel"
    INCH = "inch"

class OperationKind(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of operation.
    """

    DOCUMENT_MODEL_BUILD = "documentModelBuild"
    DOCUMENT_MODEL_COMPOSE = "documentModelCompose"
    DOCUMENT_MODEL_COPY_TO = "documentModelCopyTo"

class OperationStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Operation status.
    """

    NOT_STARTED = "notStarted"
    RUNNING = "running"
    FAILED = "failed"
    SUCCEEDED = "succeeded"
    CANCELED = "canceled"

class ParagraphRole(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Semantic role of the paragraph.
    """

    PAGE_HEADER = "pageHeader"
    PAGE_FOOTER = "pageFooter"
    PAGE_NUMBER = "pageNumber"
    TITLE = "title"
    SECTION_HEADING = "sectionHeading"
    FOOTNOTE = "footnote"

class SelectionMarkState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """State of the selection mark.
    """

    SELECTED = "selected"
    UNSELECTED = "unselected"

class StringIndexType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Method used to compute string offset and length.
    """

    TEXT_ELEMENTS = "textElements"
    UNICODE_CODE_POINT = "unicodeCodePoint"
    UTF16_CODE_UNIT = "utf16CodeUnit"
