// Populate the sidebar
//
// This is a script, and not included directly in the page, to control the total size of the book.
// The TOC contains an entry for each page, so if each page includes a copy of the TOC,
// the total size of the page becomes O(n**2).
class MDBookSidebarScrollbox extends HTMLElement {
    constructor() {
        super();
    }
    connectedCallback() {
        this.innerHTML = '<ol class="chapter"><li class="chapter-item affix "><a href="index.html">Introduction</a></li><li class="chapter-item "><a href="hello.html"><strong aria-hidden="true">1.</strong> Hello World</a><a class="toggle"><div>❱</div></a></li><li><ol class="section"><li class="chapter-item "><a href="hello/comment.html"><strong aria-hidden="true">1.1.</strong> Comments</a></li><li class="chapter-item "><a href="hello/print.html"><strong aria-hidden="true">1.2.</strong> Formatted print</a><a class="toggle"><div>❱</div></a></li><li><ol class="section"><li class="chapter-item "><a href="hello/print/print_debug.html"><strong aria-hidden="true">1.2.1.</strong> Debug</a></li><li class="chapter-item "><a href="hello/print/print_display.html"><strong aria-hidden="true">1.2.2.</strong> Display</a><a class="toggle"><div>❱</div></a></li><li><ol class="section"><li class="chapter-item "><a href="hello/print/print_display/testcase_list.html"><strong aria-hidden="true">1.2.2.1.</strong> Testcase: List</a></li></ol></li><li class="chapter-item "><a href="hello/print/fmt.html"><strong aria-hidden="true">1.2.3.</strong> Formatting</a></li></ol></li></ol></li><li class="chapter-item "><a href="primitives.html"><strong aria-hidden="true">2.</strong> Primitives</a><a class="toggle"><div>❱</div></a></li><li><ol class="section"><li class="chapter-item "><a href="primitives/literals.html"><strong aria-hidden="true">2.1.</strong> Literals and operators</a></li><li class="chapter-item "><a href="primitives/tuples.html"><strong aria-hidden="true">2.2.</strong> Tuples</a></li><li class="chapter-item "><a href="primitives/array.html"><strong aria-hidden="true">2.3.</strong> Arrays and Slices</a></li></ol></li><li class="chapter-item "><a href="custom_types.html"><strong aria-hidden="true">3.</strong> Custom Types</a><a class="toggle"><div>❱</div></a></li><li><ol class="section"><li class="chapter-item "><a href="custom_types/structs.html"><strong aria-hidden="true">3.1.</strong> Structures</a></li><li class="chapter-item "><a href="custom_types/enum.html"><strong aria-hidden="true">3.2.</strong> Enums</a><a class="toggle"><div>❱</div></a></li><li><ol class="section"><li class="chapter-item "><a href="custom_types/enum/enum_use.html"><strong aria-hidden="true">3.2.1.</strong> use</a></li><li class="chapter-item "><a href="custom_types/enum/c_like.html"><strong aria-hidden="true">3.2.2.</strong> C-like</a></li><li class="chapter-item "><a href="custom_types/enum/testcase_linked_list.html"><strong aria-hidden="true">3.2.3.</strong> Testcase: linked-list</a></li></ol></li><li class="chapter-item "><a href="custom_types/constants.html"><strong aria-hidden="true">3.3.</strong> constants</a></li></ol></li><li class="chapter-item "><a href="variable_bindings.html"><strong aria-hidden="true">4.</strong> Variable Bindings</a><a class="toggle"><div>❱</div></a></li><li><ol class="section"><li class="chapter-item "><a href="variable_bindings/mut.html"><strong aria-hidden="true">4.1.</strong> Mutability</a></li><li class="chapter-item "><a href="variable_bindings/scope.html"><strong aria-hidden="true">4.2.</strong> Scope and Shadowing</a></li><li class="chapter-item "><a href="variable_bindings/declare.html"><strong aria-hidden="true">4.3.</strong> Declare first</a></li><li class="chapter-item "><a href="variable_bindings/freeze.html"><strong aria-hidden="true">4.4.</strong> Freezing</a></li></ol></li><li class="chapter-item "><a href="types.html"><strong aria-hidden="true">5.</strong> Types</a><a class="toggle"><div>❱</div></a></li><li><ol class="section"><li class="chapter-item "><a href="types/cast.html"><strong aria-hidden="true">5.1.</strong> Casting</a></li><li class="chapter-item "><a href="types/literals.html"><strong aria-hidden="true">5.2.</strong> Literals</a></li><li class="chapter-item "><a href="types/inference.html"><strong aria-hidden="true">5.3.</strong> Inference</a></li><li class="chapter-item "><a href="types/alias.html"><strong aria-hidden="true">5.4.</strong> Aliasing</a></li></ol></li><li class="chapter-item "><a href="conversion.html"><strong aria-hidden="true">6.</strong> Conversion</a><a class="toggle"><div>❱</div></a></li><li><ol class="section"><li class="chapter-item "><a href="conversion/from_into.html"><strong aria-hidden="true">6.1.</strong> From and Into</a></li><li class="chapter-item "><a href="conversion/try_from_try_into.html"><strong aria-hidden="true">6.2.</strong> TryFrom and TryInto</a></li><li class="chapter-item "><a href="conversion/string.html"><strong aria-hidden="true">6.3.</strong> To and from Strings</a></li></ol></li><li class="chapter-item "><a href="expression.html"><strong aria-hidden="true">7.</strong> Expressions</a></li><li class="chapter-item "><a href="flow_control.html"><strong aria-hidden="true">8.</strong> Flow of Control</a><a class="toggle"><div>❱</div></a></li><li><ol class="section"><li class="chapter-item "><a href="flow_control/if_else.html"><strong aria-hidden="true">8.1.</strong> if/else</a></li><li class="chapter-item "><a href="flow_control/loop.html"><strong aria-hidden="true">8.2.</strong> loop</a><a class="toggle"><div>❱</div></a></li><li><ol class="section"><li class="chapter-item "><a href="flow_control/loop/nested.html"><strong aria-hidden="true">8.2.1.</strong> Nesting and labels</a></li><li class="chapter-item "><a href="flow_control/loop/return.html"><strong aria-hidden="true">8.2.2.</strong> Returning from loops</a></li></ol></li><li class="chapter-item "><a href="flow_control/while.html"><strong aria-hidden="true">8.3.</strong> while</a></li><li class="chapter-item "><a href="flow_control/for.html"><strong aria-hidden="true">8.4.</strong> for and range</a></li><li class="chapter-item "><a href="flow_control/match.html"><strong aria-hidden="true">8.5.</strong> match</a><a class="toggle"><div>❱</div></a></li><li><ol class="section"><li class="chapter-item "><a href="flow_control/match/destructuring.html"><strong aria-hidden="true">8.5.1.</strong> Destructuring</a><a class="toggle"><div>❱</div></a></li><li><ol class="section"><li class="chapter-item "><a href="flow_control/match/destructuring/destructure_tuple.html"><strong aria-hidden="true">8.5.1.1.</strong> tuples</a></li><li class="chapter-item "><a href="flow_control/match/destructuring/destructure_slice.html"><strong aria-hidden="true">8.5.1.2.</strong> arrays/slices</a></li><li class="chapter-item "><a href="flow_control/match/destructuring/destructure_enum.html"><strong aria-hidden="true">8.5.1.3.</strong> enums</a></li><li class="chapter-item "><a href="flow_control/match/destructuring/destructure_pointers.html"><strong aria-hidden="true">8.5.1.4.</strong> pointers/ref</a></li><li class="chapter-item "><a href="flow_control/match/destructuring/destructure_structures.html"><strong aria-hidden="true">8.5.1.5.</strong> structs</a></li></ol></li><li class="chapter-item "><a href="flow_control/match/guard.html"><strong aria-hidden="true">8.5.2.</strong> Guards</a></li><li class="chapter-item "><a href="flow_control/match/binding.html"><strong aria-hidden="true">8.5.3.</strong> Binding</a></li></ol></li><li class="chapter-item "><a href="flow_control/if_let.html"><strong aria-hidden="true">8.6.</strong> if let</a></li><li class="chapter-item "><a href="flow_control/let_else.html"><strong aria-hidden="true">8.7.</strong> let-else</a></li><li class="chapter-item "><a href="flow_control/while_let.html"><strong aria-hidden="true">8.8.</strong> while let</a></li></ol></li><li class="chapter-item "><a href="fn.html"><strong aria-hidden="true">9.</strong> Functions</a><a class="toggle"><div>❱</div></a></li><li><ol class="section"><li class="chapter-item "><a href="fn/methods.html"><strong aria-hidden="true">9.1.</strong> Methods</a></li><li class="chapter-item "><a href="fn/closures.html"><strong aria-hidden="true">9.2.</strong> Closures</a><a class="toggle"><div>❱</div></a></li><li><ol class="section"><li class="chapter-item "><a href="fn/closures/capture.html"><strong aria-hidden="true">9.2.1.</strong> Capturing</a></li><li class="chapter-item "><a href="fn/closures/input_parameters.html"><strong aria-hidden="true">9.2.2.</strong> As input parameters</a></li><li class="chapter-item "><a href="fn/closures/anonymity.html"><strong aria-hidden="true">9.2.3.</strong> Type anonymity</a></li><li class="chapter-item "><a href="fn/closures/input_functions.html"><strong aria-hidden="true">9.2.4.</strong> Input functions</a></li><li class="chapter-item "><a href="fn/closures/output_parameters.html"><strong aria-hidden="true">9.2.5.</strong> As output parameters</a></li><li class="chapter-item "><a href="fn/closures/closure_examples.html"><strong aria-hidden="true">9.2.6.</strong> Examples in std</a><a class="toggle"><div>❱</div></a></li><li><ol class="section"><li class="chapter-item "><a href="fn/closures/closure_examples/iter_any.html"><strong aria-hidden="true">9.2.6.1.</strong> Iterator::any</a></li><li class="chapter-item "><a href="fn/closures/closure_examples/iter_find.html"><strong aria-hidden="true">9.2.6.2.</strong> Searching through iterators</a></li></ol></li></ol></li><li class="chapter-item "><a href="fn/hof.html"><strong aria-hidden="true">9.3.</strong> Higher Order Functions</a></li><li class="chapter-item "><a href="fn/diverging.html"><strong aria-hidden="true">9.4.</strong> Diverging functions</a></li></ol></li><li class="chapter-item "><a href="mod.html"><strong aria-hidden="true">10.</strong> Modules</a><a class="toggle"><div>❱</div></a></li><li><ol class="section"><li class="chapter-item "><a href="mod/visibility.html"><strong aria-hidden="true">10.1.</strong> Visibility</a></li><li class="chapter-item "><a href="mod/struct_visibility.html"><strong aria-hidden="true">10.2.</strong> Struct visibility</a></li><li class="chapter-item "><a href="mod/use.html"><strong aria-hidden="true">10.3.</strong> The use declaration</a></li><li class="chapter-item "><a href="mod/super.html"><strong aria-hidden="true">10.4.</strong> super and self</a></li><li class="chapter-item "><a href="mod/split.html"><strong aria-hidden="true">10.5.</strong> File hierarchy</a></li></ol></li><li class="chapter-item "><a href="crates.html"><strong aria-hidden="true">11.</strong> Crates</a><a class="toggle"><div>❱</div></a></li><li><ol class="section"><li class="chapter-item "><a href="crates/lib.html"><strong aria-hidden="true">11.1.</strong> Creating a Library</a></li><li class="chapter-item "><a href="crates/using_lib.html"><strong aria-hidden="true">11.2.</strong> Using a Library</a></li></ol></li><li class="chapter-item "><a href="cargo.html"><strong aria-hidden="true">12.</strong> Cargo</a><a class="toggle"><div>❱</div></a></li><li><ol class="section"><li class="chapter-item "><a href="cargo/deps.html"><strong aria-hidden="true">12.1.</strong> Dependencies</a></li><li class="chapter-item "><a href="cargo/conventions.html"><strong aria-hidden="true">12.2.</strong> Conventions</a></li><li class="chapter-item "><a href="cargo/test.html"><strong aria-hidden="true">12.3.</strong> Tests</a></li><li class="chapter-item "><a href="cargo/build_scripts.html"><strong aria-hidden="true">12.4.</strong> Build Scripts</a></li></ol></li><li class="chapter-item "><a href="attribute.html"><strong aria-hidden="true">13.</strong> Attributes</a><a class="toggle"><div>❱</div></a></li><li><ol class="section"><li class="chapter-item "><a href="attribute/unused.html"><strong aria-hidden="true">13.1.</strong> dead_code</a></li><li class="chapter-item "><a href="attribute/crate.html"><strong aria-hidden="true">13.2.</strong> Crates</a></li><li class="chapter-item "><a href="attribute/cfg.html"><strong aria-hidden="true">13.3.</strong> cfg</a><a class="toggle"><div>❱</div></a></li><li><ol class="section"><li class="chapter-item "><a href="attribute/cfg/custom.html"><strong aria-hidden="true">13.3.1.</strong> Custom</a></li></ol></li></ol></li><li class="chapter-item "><a href="generics.html"><strong aria-hidden="true">14.</strong> Generics</a><a class="toggle"><div>❱</div></a></li><li><ol class="section"><li class="chapter-item "><a href="generics/gen_fn.html"><strong aria-hidden="true">14.1.</strong> Functions</a></li><li class="chapter-item "><a href="generics/impl.html"><strong aria-hidden="true">14.2.</strong> Implementation</a></li><li class="chapter-item "><a href="generics/gen_trait.html"><strong aria-hidden="true">14.3.</strong> Traits</a></li><li class="chapter-item "><a href="generics/bounds.html"><strong aria-hidden="true">14.4.</strong> Bounds</a><a class="toggle"><div>❱</div></a></li><li><ol class="section"><li class="chapter-item "><a href="generics/bounds/testcase_empty.html"><strong aria-hidden="true">14.4.1.</strong> Testcase: empty bounds</a></li></ol></li><li class="chapter-item "><a href="generics/multi_bounds.html"><strong aria-hidden="true">14.5.</strong> Multiple bounds</a></li><li class="chapter-item "><a href="generics/where.html"><strong aria-hidden="true">14.6.</strong> Where clauses</a></li><li class="chapter-item "><a href="generics/new_types.html"><strong aria-hidden="true">14.7.</strong> New Type Idiom</a></li><li class="chapter-item "><a href="generics/assoc_items.html"><strong aria-hidden="true">14.8.</strong> Associated items</a><a class="toggle"><div>❱</div></a></li><li><ol class="section"><li class="chapter-item "><a href="generics/assoc_items/the_problem.html"><strong aria-hidden="true">14.8.1.</strong> The Problem</a></li><li class="chapter-item "><a href="generics/assoc_items/types.html"><strong aria-hidden="true">14.8.2.</strong> Associated types</a></li></ol></li><li class="chapter-item "><a href="generics/phantom.html"><strong aria-hidden="true">14.9.</strong> Phantom type parameters</a><a class="toggle"><div>❱</div></a></li><li><ol class="section"><li class="chapter-item "><a href="generics/phantom/testcase_units.html"><strong aria-hidden="true">14.9.1.</strong> Testcase: unit clarification</a></li></ol></li></ol></li><li class="chapter-item "><a href="scope.html"><strong aria-hidden="true">15.</strong> Scoping rules</a><a class="toggle"><div>❱</div></a></li><li><ol class="section"><li class="chapter-item "><a href="scope/raii.html"><strong aria-hidden="true">15.1.</strong> RAII</a></li><li class="chapter-item "><a href="scope/move.html"><strong aria-hidden="true">15.2.</strong> Ownership and moves</a><a class="toggle"><div>❱</div></a></li><li><ol class="section"><li class="chapter-item "><a href="scope/move/mut.html"><strong aria-hidden="true">15.2.1.</strong> Mutability</a></li><li class="chapter-item "><a href="scope/move/partial_move.html"><strong aria-hidden="true">15.2.2.</strong> Partial moves</a></li></ol></li><li class="chapter-item "><a href="scope/borrow.html"><strong aria-hidden="true">15.3.</strong> Borrowing</a><a class="toggle"><div>❱</div></a></li><li><ol class="section"><li class="chapter-item "><a href="scope/borrow/mut.html"><strong aria-hidden="true">15.3.1.</strong> Mutability</a></li><li class="chapter-item "><a href="scope/borrow/alias.html"><strong aria-hidden="true">15.3.2.</strong> Aliasing</a></li><li class="chapter-item "><a href="scope/borrow/ref.html"><strong aria-hidden="true">15.3.3.</strong> The ref pattern</a></li></ol></li><li class="chapter-item "><a href="scope/lifetime.html"><strong aria-hidden="true">15.4.</strong> Lifetimes</a><a class="toggle"><div>❱</div></a></li><li><ol class="section"><li class="chapter-item "><a href="scope/lifetime/explicit.html"><strong aria-hidden="true">15.4.1.</strong> Explicit annotation</a></li><li class="chapter-item "><a href="scope/lifetime/fn.html"><strong aria-hidden="true">15.4.2.</strong> Functions</a></li><li class="chapter-item "><a href="scope/lifetime/methods.html"><strong aria-hidden="true">15.4.3.</strong> Methods</a></li><li class="chapter-item "><a href="scope/lifetime/struct.html"><strong aria-hidden="true">15.4.4.</strong> Structs</a></li><li class="chapter-item "><a href="scope/lifetime/trait.html"><strong aria-hidden="true">15.4.5.</strong> Traits</a></li><li class="chapter-item "><a href="scope/lifetime/lifetime_bounds.html"><strong aria-hidden="true">15.4.6.</strong> Bounds</a></li><li class="chapter-item "><a href="scope/lifetime/lifetime_coercion.html"><strong aria-hidden="true">15.4.7.</strong> Coercion</a></li><li class="chapter-item "><a href="scope/lifetime/static_lifetime.html"><strong aria-hidden="true">15.4.8.</strong> Static</a></li><li class="chapter-item "><a href="scope/lifetime/elision.html"><strong aria-hidden="true">15.4.9.</strong> Elision</a></li></ol></li></ol></li><li class="chapter-item "><a href="trait.html"><strong aria-hidden="true">16.</strong> Traits</a><a class="toggle"><div>❱</div></a></li><li><ol class="section"><li class="chapter-item "><a href="trait/derive.html"><strong aria-hidden="true">16.1.</strong> Derive</a></li><li class="chapter-item "><a href="trait/dyn.html"><strong aria-hidden="true">16.2.</strong> Returning Traits with dyn</a></li><li class="chapter-item "><a href="trait/ops.html"><strong aria-hidden="true">16.3.</strong> Operator Overloading</a></li><li class="chapter-item "><a href="trait/drop.html"><strong aria-hidden="true">16.4.</strong> Drop</a></li><li class="chapter-item "><a href="trait/iter.html"><strong aria-hidden="true">16.5.</strong> Iterators</a></li><li class="chapter-item "><a href="trait/impl_trait.html"><strong aria-hidden="true">16.6.</strong> impl Trait</a></li><li class="chapter-item "><a href="trait/clone.html"><strong aria-hidden="true">16.7.</strong> Clone</a></li><li class="chapter-item "><a href="trait/supertraits.html"><strong aria-hidden="true">16.8.</strong> Supertraits</a></li><li class="chapter-item "><a href="trait/disambiguating.html"><strong aria-hidden="true">16.9.</strong> Disambiguating overlapping traits</a></li></ol></li><li class="chapter-item "><a href="macros.html"><strong aria-hidden="true">17.</strong> macro_rules!</a><a class="toggle"><div>❱</div></a></li><li><ol class="section"><li class="chapter-item "><a href="macros/syntax.html"><strong aria-hidden="true">17.1.</strong> Syntax</a><a class="toggle"><div>❱</div></a></li><li><ol class="section"><li class="chapter-item "><a href="macros/designators.html"><strong aria-hidden="true">17.1.1.</strong> Designators</a></li><li class="chapter-item "><a href="macros/overload.html"><strong aria-hidden="true">17.1.2.</strong> Overload</a></li><li class="chapter-item "><a href="macros/repeat.html"><strong aria-hidden="true">17.1.3.</strong> Repeat</a></li></ol></li><li class="chapter-item "><a href="macros/dry.html"><strong aria-hidden="true">17.2.</strong> DRY (Don&#39;t Repeat Yourself)</a></li><li class="chapter-item "><a href="macros/dsl.html"><strong aria-hidden="true">17.3.</strong> DSL (Domain Specific Languages)</a></li><li class="chapter-item "><a href="macros/variadics.html"><strong aria-hidden="true">17.4.</strong> Variadics</a></li></ol></li><li class="chapter-item "><a href="error.html"><strong aria-hidden="true">18.</strong> Error handling</a><a class="toggle"><div>❱</div></a></li><li><ol class="section"><li class="chapter-item "><a href="error/panic.html"><strong aria-hidden="true">18.1.</strong> panic</a></li><li class="chapter-item "><a href="error/abort_unwind.html"><strong aria-hidden="true">18.2.</strong> abort &amp; unwind</a></li><li class="chapter-item "><a href="error/option_unwrap.html"><strong aria-hidden="true">18.3.</strong> Option &amp; unwrap</a><a class="toggle"><div>❱</div></a></li><li><ol class="section"><li class="chapter-item "><a href="error/option_unwrap/question_mark.html"><strong aria-hidden="true">18.3.1.</strong> Unpacking options with ?</a></li><li class="chapter-item "><a href="error/option_unwrap/map.html"><strong aria-hidden="true">18.3.2.</strong> Combinators: map</a></li><li class="chapter-item "><a href="error/option_unwrap/and_then.html"><strong aria-hidden="true">18.3.3.</strong> Combinators: and_then</a></li><li class="chapter-item "><a href="error/option_unwrap/defaults.html"><strong aria-hidden="true">18.3.4.</strong> Defaults: or, or_else, get_or_insert, get_or_insert_with</a></li></ol></li><li class="chapter-item "><a href="error/result.html"><strong aria-hidden="true">18.4.</strong> Result</a><a class="toggle"><div>❱</div></a></li><li><ol class="section"><li class="chapter-item "><a href="error/result/result_map.html"><strong aria-hidden="true">18.4.1.</strong> map for Result</a></li><li class="chapter-item "><a href="error/result/result_alias.html"><strong aria-hidden="true">18.4.2.</strong> aliases for Result</a></li><li class="chapter-item "><a href="error/result/early_returns.html"><strong aria-hidden="true">18.4.3.</strong> Early returns</a></li><li class="chapter-item "><a href="error/result/enter_question_mark.html"><strong aria-hidden="true">18.4.4.</strong> Introducing ?</a></li></ol></li><li class="chapter-item "><a href="error/multiple_error_types.html"><strong aria-hidden="true">18.5.</strong> Multiple error types</a><a class="toggle"><div>❱</div></a></li><li><ol class="section"><li class="chapter-item "><a href="error/multiple_error_types/option_result.html"><strong aria-hidden="true">18.5.1.</strong> Pulling Results out of Options</a></li><li class="chapter-item "><a href="error/multiple_error_types/define_error_type.html"><strong aria-hidden="true">18.5.2.</strong> Defining an error type</a></li><li class="chapter-item "><a href="error/multiple_error_types/boxing_errors.html"><strong aria-hidden="true">18.5.3.</strong> Boxing errors</a></li><li class="chapter-item "><a href="error/multiple_error_types/reenter_question_mark.html"><strong aria-hidden="true">18.5.4.</strong> Other uses of ?</a></li><li class="chapter-item "><a href="error/multiple_error_types/wrap_error.html"><strong aria-hidden="true">18.5.5.</strong> Wrapping errors</a></li></ol></li><li class="chapter-item "><a href="error/iter_result.html"><strong aria-hidden="true">18.6.</strong> Iterating over Results</a></li></ol></li><li class="chapter-item "><a href="std.html"><strong aria-hidden="true">19.</strong> Std library types</a><a class="toggle"><div>❱</div></a></li><li><ol class="section"><li class="chapter-item "><a href="std/box.html"><strong aria-hidden="true">19.1.</strong> Box, stack and heap</a></li><li class="chapter-item "><a href="std/vec.html"><strong aria-hidden="true">19.2.</strong> Vectors</a></li><li class="chapter-item "><a href="std/str.html"><strong aria-hidden="true">19.3.</strong> Strings</a></li><li class="chapter-item "><a href="std/option.html"><strong aria-hidden="true">19.4.</strong> Option</a></li><li class="chapter-item "><a href="std/result.html"><strong aria-hidden="true">19.5.</strong> Result</a><a class="toggle"><div>❱</div></a></li><li><ol class="section"><li class="chapter-item "><a href="std/result/question_mark.html"><strong aria-hidden="true">19.5.1.</strong> ?</a></li></ol></li><li class="chapter-item "><a href="std/panic.html"><strong aria-hidden="true">19.6.</strong> panic!</a></li><li class="chapter-item "><a href="std/hash.html"><strong aria-hidden="true">19.7.</strong> HashMap</a><a class="toggle"><div>❱</div></a></li><li><ol class="section"><li class="chapter-item "><a href="std/hash/alt_key_types.html"><strong aria-hidden="true">19.7.1.</strong> Alternate/custom key types</a></li><li class="chapter-item "><a href="std/hash/hashset.html"><strong aria-hidden="true">19.7.2.</strong> HashSet</a></li></ol></li><li class="chapter-item "><a href="std/rc.html"><strong aria-hidden="true">19.8.</strong> Rc</a></li><li class="chapter-item "><a href="std/arc.html"><strong aria-hidden="true">19.9.</strong> Arc</a></li></ol></li><li class="chapter-item "><a href="std_misc.html"><strong aria-hidden="true">20.</strong> Std misc</a><a class="toggle"><div>❱</div></a></li><li><ol class="section"><li class="chapter-item "><a href="std_misc/threads.html"><strong aria-hidden="true">20.1.</strong> Threads</a><a class="toggle"><div>❱</div></a></li><li><ol class="section"><li class="chapter-item "><a href="std_misc/threads/testcase_mapreduce.html"><strong aria-hidden="true">20.1.1.</strong> Testcase: map-reduce</a></li></ol></li><li class="chapter-item "><a href="std_misc/channels.html"><strong aria-hidden="true">20.2.</strong> Channels</a></li><li class="chapter-item "><a href="std_misc/path.html"><strong aria-hidden="true">20.3.</strong> Path</a></li><li class="chapter-item "><a href="std_misc/file.html"><strong aria-hidden="true">20.4.</strong> File I/O</a><a class="toggle"><div>❱</div></a></li><li><ol class="section"><li class="chapter-item "><a href="std_misc/file/open.html"><strong aria-hidden="true">20.4.1.</strong> open</a></li><li class="chapter-item "><a href="std_misc/file/create.html"><strong aria-hidden="true">20.4.2.</strong> create</a></li><li class="chapter-item "><a href="std_misc/file/read_lines.html"><strong aria-hidden="true">20.4.3.</strong> read_lines</a></li></ol></li><li class="chapter-item "><a href="std_misc/process.html"><strong aria-hidden="true">20.5.</strong> Child processes</a><a class="toggle"><div>❱</div></a></li><li><ol class="section"><li class="chapter-item "><a href="std_misc/process/pipe.html"><strong aria-hidden="true">20.5.1.</strong> Pipes</a></li><li class="chapter-item "><a href="std_misc/process/wait.html"><strong aria-hidden="true">20.5.2.</strong> Wait</a></li></ol></li><li class="chapter-item "><a href="std_misc/fs.html"><strong aria-hidden="true">20.6.</strong> Filesystem Operations</a></li><li class="chapter-item "><a href="std_misc/arg.html"><strong aria-hidden="true">20.7.</strong> Program arguments</a><a class="toggle"><div>❱</div></a></li><li><ol class="section"><li class="chapter-item "><a href="std_misc/arg/matching.html"><strong aria-hidden="true">20.7.1.</strong> Argument parsing</a></li></ol></li><li class="chapter-item "><a href="std_misc/ffi.html"><strong aria-hidden="true">20.8.</strong> Foreign Function Interface</a></li></ol></li><li class="chapter-item "><a href="testing.html"><strong aria-hidden="true">21.</strong> Testing</a><a class="toggle"><div>❱</div></a></li><li><ol class="section"><li class="chapter-item "><a href="testing/unit_testing.html"><strong aria-hidden="true">21.1.</strong> Unit testing</a></li><li class="chapter-item "><a href="testing/doc_testing.html"><strong aria-hidden="true">21.2.</strong> Documentation testing</a></li><li class="chapter-item "><a href="testing/integration_testing.html"><strong aria-hidden="true">21.3.</strong> Integration testing</a></li><li class="chapter-item "><a href="testing/dev_dependencies.html"><strong aria-hidden="true">21.4.</strong> Dev-dependencies</a></li></ol></li><li class="chapter-item "><a href="unsafe.html"><strong aria-hidden="true">22.</strong> Unsafe Operations</a><a class="toggle"><div>❱</div></a></li><li><ol class="section"><li class="chapter-item "><a href="unsafe/asm.html"><strong aria-hidden="true">22.1.</strong> Inline assembly</a></li></ol></li><li class="chapter-item "><a href="compatibility.html"><strong aria-hidden="true">23.</strong> Compatibility</a><a class="toggle"><div>❱</div></a></li><li><ol class="section"><li class="chapter-item "><a href="compatibility/raw_identifiers.html"><strong aria-hidden="true">23.1.</strong> Raw identifiers</a></li></ol></li><li class="chapter-item "><a href="meta.html"><strong aria-hidden="true">24.</strong> Meta</a><a class="toggle"><div>❱</div></a></li><li><ol class="section"><li class="chapter-item "><a href="meta/doc.html"><strong aria-hidden="true">24.1.</strong> Documentation</a></li><li class="chapter-item "><a href="meta/playground.html"><strong aria-hidden="true">24.2.</strong> Playground</a></li></ol></li></ol>';
        // Set the current, active page, and reveal it if it's hidden
        let current_page = document.location.href.toString().split("#")[0];
        if (current_page.endsWith("/")) {
            current_page += "index.html";
        }
        var links = Array.prototype.slice.call(this.querySelectorAll("a"));
        var l = links.length;
        for (var i = 0; i < l; ++i) {
            var link = links[i];
            var href = link.getAttribute("href");
            if (href && !href.startsWith("#") && !/^(?:[a-z+]+:)?\/\//.test(href)) {
                link.href = path_to_root + href;
            }
            // The "index" page is supposed to alias the first chapter in the book.
            if (link.href === current_page || (i === 0 && path_to_root === "" && current_page.endsWith("/index.html"))) {
                link.classList.add("active");
                var parent = link.parentElement;
                if (parent && parent.classList.contains("chapter-item")) {
                    parent.classList.add("expanded");
                }
                while (parent) {
                    if (parent.tagName === "LI" && parent.previousElementSibling) {
                        if (parent.previousElementSibling.classList.contains("chapter-item")) {
                            parent.previousElementSibling.classList.add("expanded");
                        }
                    }
                    parent = parent.parentElement;
                }
            }
        }
        // Track and set sidebar scroll position
        this.addEventListener('click', function(e) {
            if (e.target.tagName === 'A') {
                sessionStorage.setItem('sidebar-scroll', this.scrollTop);
            }
        }, { passive: true });
        var sidebarScrollTop = sessionStorage.getItem('sidebar-scroll');
        sessionStorage.removeItem('sidebar-scroll');
        if (sidebarScrollTop) {
            // preserve sidebar scroll position when navigating via links within sidebar
            this.scrollTop = sidebarScrollTop;
        } else {
            // scroll sidebar to current active section when navigating via "next/previous chapter" buttons
            var activeSection = document.querySelector('#sidebar .active');
            if (activeSection) {
                activeSection.scrollIntoView({ block: 'center' });
            }
        }
        // Toggle buttons
        var sidebarAnchorToggles = document.querySelectorAll('#sidebar a.toggle');
        function toggleSection(ev) {
            ev.currentTarget.parentElement.classList.toggle('expanded');
        }
        Array.from(sidebarAnchorToggles).forEach(function (el) {
            el.addEventListener('click', toggleSection);
        });
    }
}
window.customElements.define("mdbook-sidebar-scrollbox", MDBookSidebarScrollbox);
