/*
 * Decompiled with CFR 0.152.
 */
package proguard.obfuscate;

import java.util.List;
import proguard.Configuration;
import proguard.classfile.Clazz;
import proguard.classfile.LibraryClass;
import proguard.classfile.LibraryField;
import proguard.classfile.LibraryMethod;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramField;
import proguard.classfile.ProgramMethod;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.MemberVisitor;
import proguard.obfuscate.MappingProcessor;
import proguard.obfuscate.PackageRenameRule;

public class PackageRenamer
implements ClassVisitor,
MemberVisitor {
    private final MappingProcessor keeper;
    private String className;
    private List renameRules;

    public PackageRenamer(MappingProcessor keeper, Configuration configuration) {
        this.keeper = keeper;
        this.renameRules = configuration.renamePackages;
    }

    @Override
    public void visitAnyClass(Clazz clazz) {
        throw new UnsupportedOperationException(this.getClass().getName() + " does not support " + clazz.getClass().getName());
    }

    @Override
    public void visitProgramClass(ProgramClass programClass) {
        String name = ClassUtil.externalClassName(programClass.getName());
        for (int i = 0; i < this.renameRules.size(); ++i) {
            PackageRenameRule rule = (PackageRenameRule)this.renameRules.get(i);
            if (!name.startsWith(rule.packagePrefix)) continue;
            String newClassName = rule.addPrefix + "." + name;
            this.className = programClass.getName();
            if (!this.keeper.processClassMapping(this.className, newClassName)) break;
            programClass.fieldsAccept(this);
            programClass.methodsAccept(this);
            break;
        }
    }

    @Override
    public void visitProgramField(ProgramClass programClass, ProgramField programField) {
        this.keeper.processFieldMapping(this.className, ClassUtil.externalType(programField.getDescriptor(programClass)), programField.getName(programClass), this.className, programField.getName(programClass));
    }

    @Override
    public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
        this.keeper.processMethodMapping(this.className, 0, 0, ClassUtil.externalMethodReturnType(programMethod.getDescriptor(programClass)), programMethod.getName(programClass), ClassUtil.externalMethodArguments(programMethod.getDescriptor(programClass)), this.className, 0, 0, programMethod.getName(programClass));
    }

    @Override
    public void visitLibraryClass(LibraryClass libraryClass) {
    }

    @Override
    public void visitLibraryField(LibraryClass libraryClass, LibraryField libraryField) {
    }

    @Override
    public void visitLibraryMethod(LibraryClass libraryClass, LibraryMethod libraryMethod) {
    }
}

