// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// MysqlCheckParams mysql check params
//
// swagger:model mysql_check_params
type MysqlCheckParams struct {
	// client version
	// Enum: ["pre-41","post-41"]
	// +kubebuilder:validation:Enum=pre-41;post-41;
	ClientVersion string `json:"client_version,omitempty"`

	// username
	Username string `json:"username,omitempty"`
}

// Validate validates this mysql check params
func (m *MysqlCheckParams) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateClientVersion(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var mysqlCheckParamsTypeClientVersionPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["pre-41","post-41"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		mysqlCheckParamsTypeClientVersionPropEnum = append(mysqlCheckParamsTypeClientVersionPropEnum, v)
	}
}

const (

	// MysqlCheckParamsClientVersionPreDash41 captures enum value "pre-41"
	MysqlCheckParamsClientVersionPreDash41 string = "pre-41"

	// MysqlCheckParamsClientVersionPostDash41 captures enum value "post-41"
	MysqlCheckParamsClientVersionPostDash41 string = "post-41"
)

// prop value enum
func (m *MysqlCheckParams) validateClientVersionEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, mysqlCheckParamsTypeClientVersionPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *MysqlCheckParams) validateClientVersion(formats strfmt.Registry) error {
	if swag.IsZero(m.ClientVersion) { // not required
		return nil
	}

	// value enum
	if err := m.validateClientVersionEnum("client_version", "body", m.ClientVersion); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this mysql check params based on context it is used
func (m *MysqlCheckParams) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *MysqlCheckParams) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *MysqlCheckParams) UnmarshalBinary(b []byte) error {
	var res MysqlCheckParams
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
