// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/bigquery/analyticshub/v1/analyticshub.proto

#include "google/cloud/bigquery/analyticshub/v1/analytics_hub_client.h"
#include <memory>

namespace google {
namespace cloud {
namespace bigquery_analyticshub_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

AnalyticsHubServiceClient::AnalyticsHubServiceClient(
    std::shared_ptr<AnalyticsHubServiceConnection> connection, Options opts)
    : connection_(std::move(connection)),
      options_(
          internal::MergeOptions(std::move(opts), connection_->options())) {}
AnalyticsHubServiceClient::~AnalyticsHubServiceClient() = default;

StreamRange<google::cloud::bigquery::analyticshub::v1::DataExchange>
AnalyticsHubServiceClient::ListDataExchanges(std::string const& parent,
                                             Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::bigquery::analyticshub::v1::ListDataExchangesRequest request;
  request.set_parent(parent);
  return connection_->ListDataExchanges(request);
}

StreamRange<google::cloud::bigquery::analyticshub::v1::DataExchange>
AnalyticsHubServiceClient::ListDataExchanges(
    google::cloud::bigquery::analyticshub::v1::ListDataExchangesRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListDataExchanges(std::move(request));
}

StreamRange<google::cloud::bigquery::analyticshub::v1::DataExchange>
AnalyticsHubServiceClient::ListOrgDataExchanges(std::string const& organization,
                                                Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::bigquery::analyticshub::v1::ListOrgDataExchangesRequest
      request;
  request.set_organization(organization);
  return connection_->ListOrgDataExchanges(request);
}

StreamRange<google::cloud::bigquery::analyticshub::v1::DataExchange>
AnalyticsHubServiceClient::ListOrgDataExchanges(
    google::cloud::bigquery::analyticshub::v1::ListOrgDataExchangesRequest
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListOrgDataExchanges(std::move(request));
}

StatusOr<google::cloud::bigquery::analyticshub::v1::DataExchange>
AnalyticsHubServiceClient::GetDataExchange(std::string const& name,
                                           Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::bigquery::analyticshub::v1::GetDataExchangeRequest request;
  request.set_name(name);
  return connection_->GetDataExchange(request);
}

StatusOr<google::cloud::bigquery::analyticshub::v1::DataExchange>
AnalyticsHubServiceClient::GetDataExchange(
    google::cloud::bigquery::analyticshub::v1::GetDataExchangeRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetDataExchange(request);
}

StatusOr<google::cloud::bigquery::analyticshub::v1::DataExchange>
AnalyticsHubServiceClient::CreateDataExchange(
    std::string const& parent,
    google::cloud::bigquery::analyticshub::v1::DataExchange const&
        data_exchange,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::bigquery::analyticshub::v1::CreateDataExchangeRequest request;
  request.set_parent(parent);
  *request.mutable_data_exchange() = data_exchange;
  return connection_->CreateDataExchange(request);
}

StatusOr<google::cloud::bigquery::analyticshub::v1::DataExchange>
AnalyticsHubServiceClient::CreateDataExchange(
    google::cloud::bigquery::analyticshub::v1::CreateDataExchangeRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateDataExchange(request);
}

StatusOr<google::cloud::bigquery::analyticshub::v1::DataExchange>
AnalyticsHubServiceClient::UpdateDataExchange(
    google::cloud::bigquery::analyticshub::v1::DataExchange const&
        data_exchange,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::bigquery::analyticshub::v1::UpdateDataExchangeRequest request;
  *request.mutable_data_exchange() = data_exchange;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateDataExchange(request);
}

StatusOr<google::cloud::bigquery::analyticshub::v1::DataExchange>
AnalyticsHubServiceClient::UpdateDataExchange(
    google::cloud::bigquery::analyticshub::v1::UpdateDataExchangeRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateDataExchange(request);
}

Status AnalyticsHubServiceClient::DeleteDataExchange(std::string const& name,
                                                     Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::bigquery::analyticshub::v1::DeleteDataExchangeRequest request;
  request.set_name(name);
  return connection_->DeleteDataExchange(request);
}

Status AnalyticsHubServiceClient::DeleteDataExchange(
    google::cloud::bigquery::analyticshub::v1::DeleteDataExchangeRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteDataExchange(request);
}

StreamRange<google::cloud::bigquery::analyticshub::v1::Listing>
AnalyticsHubServiceClient::ListListings(std::string const& parent,
                                        Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::bigquery::analyticshub::v1::ListListingsRequest request;
  request.set_parent(parent);
  return connection_->ListListings(request);
}

StreamRange<google::cloud::bigquery::analyticshub::v1::Listing>
AnalyticsHubServiceClient::ListListings(
    google::cloud::bigquery::analyticshub::v1::ListListingsRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListListings(std::move(request));
}

StatusOr<google::cloud::bigquery::analyticshub::v1::Listing>
AnalyticsHubServiceClient::GetListing(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::bigquery::analyticshub::v1::GetListingRequest request;
  request.set_name(name);
  return connection_->GetListing(request);
}

StatusOr<google::cloud::bigquery::analyticshub::v1::Listing>
AnalyticsHubServiceClient::GetListing(
    google::cloud::bigquery::analyticshub::v1::GetListingRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetListing(request);
}

StatusOr<google::cloud::bigquery::analyticshub::v1::Listing>
AnalyticsHubServiceClient::CreateListing(
    std::string const& parent,
    google::cloud::bigquery::analyticshub::v1::Listing const& listing,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::bigquery::analyticshub::v1::CreateListingRequest request;
  request.set_parent(parent);
  *request.mutable_listing() = listing;
  return connection_->CreateListing(request);
}

StatusOr<google::cloud::bigquery::analyticshub::v1::Listing>
AnalyticsHubServiceClient::CreateListing(
    google::cloud::bigquery::analyticshub::v1::CreateListingRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateListing(request);
}

StatusOr<google::cloud::bigquery::analyticshub::v1::Listing>
AnalyticsHubServiceClient::UpdateListing(
    google::cloud::bigquery::analyticshub::v1::Listing const& listing,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::bigquery::analyticshub::v1::UpdateListingRequest request;
  *request.mutable_listing() = listing;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateListing(request);
}

StatusOr<google::cloud::bigquery::analyticshub::v1::Listing>
AnalyticsHubServiceClient::UpdateListing(
    google::cloud::bigquery::analyticshub::v1::UpdateListingRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateListing(request);
}

Status AnalyticsHubServiceClient::DeleteListing(std::string const& name,
                                                Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::bigquery::analyticshub::v1::DeleteListingRequest request;
  request.set_name(name);
  return connection_->DeleteListing(request);
}

Status AnalyticsHubServiceClient::DeleteListing(
    google::cloud::bigquery::analyticshub::v1::DeleteListingRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteListing(request);
}

StatusOr<google::cloud::bigquery::analyticshub::v1::SubscribeListingResponse>
AnalyticsHubServiceClient::SubscribeListing(std::string const& name,
                                            Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::bigquery::analyticshub::v1::SubscribeListingRequest request;
  request.set_name(name);
  return connection_->SubscribeListing(request);
}

StatusOr<google::cloud::bigquery::analyticshub::v1::SubscribeListingResponse>
AnalyticsHubServiceClient::SubscribeListing(
    google::cloud::bigquery::analyticshub::v1::SubscribeListingRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->SubscribeListing(request);
}

future<StatusOr<
    google::cloud::bigquery::analyticshub::v1::SubscribeDataExchangeResponse>>
AnalyticsHubServiceClient::SubscribeDataExchange(std::string const& name,
                                                 Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::bigquery::analyticshub::v1::SubscribeDataExchangeRequest
      request;
  request.set_name(name);
  return connection_->SubscribeDataExchange(request);
}

future<StatusOr<
    google::cloud::bigquery::analyticshub::v1::SubscribeDataExchangeResponse>>
AnalyticsHubServiceClient::SubscribeDataExchange(
    google::cloud::bigquery::analyticshub::v1::
        SubscribeDataExchangeRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->SubscribeDataExchange(request);
}

future<StatusOr<
    google::cloud::bigquery::analyticshub::v1::RefreshSubscriptionResponse>>
AnalyticsHubServiceClient::RefreshSubscription(std::string const& name,
                                               Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::bigquery::analyticshub::v1::RefreshSubscriptionRequest request;
  request.set_name(name);
  return connection_->RefreshSubscription(request);
}

future<StatusOr<
    google::cloud::bigquery::analyticshub::v1::RefreshSubscriptionResponse>>
AnalyticsHubServiceClient::RefreshSubscription(
    google::cloud::bigquery::analyticshub::v1::RefreshSubscriptionRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->RefreshSubscription(request);
}

StatusOr<google::cloud::bigquery::analyticshub::v1::Subscription>
AnalyticsHubServiceClient::GetSubscription(std::string const& name,
                                           Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::bigquery::analyticshub::v1::GetSubscriptionRequest request;
  request.set_name(name);
  return connection_->GetSubscription(request);
}

StatusOr<google::cloud::bigquery::analyticshub::v1::Subscription>
AnalyticsHubServiceClient::GetSubscription(
    google::cloud::bigquery::analyticshub::v1::GetSubscriptionRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetSubscription(request);
}

StreamRange<google::cloud::bigquery::analyticshub::v1::Subscription>
AnalyticsHubServiceClient::ListSubscriptions(std::string const& parent,
                                             Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::bigquery::analyticshub::v1::ListSubscriptionsRequest request;
  request.set_parent(parent);
  return connection_->ListSubscriptions(request);
}

StreamRange<google::cloud::bigquery::analyticshub::v1::Subscription>
AnalyticsHubServiceClient::ListSubscriptions(
    google::cloud::bigquery::analyticshub::v1::ListSubscriptionsRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListSubscriptions(std::move(request));
}

StreamRange<google::cloud::bigquery::analyticshub::v1::Subscription>
AnalyticsHubServiceClient::ListSharedResourceSubscriptions(
    std::string const& resource, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::bigquery::analyticshub::v1::
      ListSharedResourceSubscriptionsRequest request;
  request.set_resource(resource);
  return connection_->ListSharedResourceSubscriptions(request);
}

StreamRange<google::cloud::bigquery::analyticshub::v1::Subscription>
AnalyticsHubServiceClient::ListSharedResourceSubscriptions(
    google::cloud::bigquery::analyticshub::v1::
        ListSharedResourceSubscriptionsRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListSharedResourceSubscriptions(std::move(request));
}

StatusOr<google::cloud::bigquery::analyticshub::v1::RevokeSubscriptionResponse>
AnalyticsHubServiceClient::RevokeSubscription(std::string const& name,
                                              Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::bigquery::analyticshub::v1::RevokeSubscriptionRequest request;
  request.set_name(name);
  return connection_->RevokeSubscription(request);
}

StatusOr<google::cloud::bigquery::analyticshub::v1::RevokeSubscriptionResponse>
AnalyticsHubServiceClient::RevokeSubscription(
    google::cloud::bigquery::analyticshub::v1::RevokeSubscriptionRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->RevokeSubscription(request);
}

future<StatusOr<google::cloud::bigquery::analyticshub::v1::OperationMetadata>>
AnalyticsHubServiceClient::DeleteSubscription(std::string const& name,
                                              Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::bigquery::analyticshub::v1::DeleteSubscriptionRequest request;
  request.set_name(name);
  return connection_->DeleteSubscription(request);
}

future<StatusOr<google::cloud::bigquery::analyticshub::v1::OperationMetadata>>
AnalyticsHubServiceClient::DeleteSubscription(
    google::cloud::bigquery::analyticshub::v1::DeleteSubscriptionRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteSubscription(request);
}

StatusOr<google::iam::v1::Policy> AnalyticsHubServiceClient::GetIamPolicy(
    google::iam::v1::GetIamPolicyRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetIamPolicy(request);
}

StatusOr<google::iam::v1::Policy> AnalyticsHubServiceClient::SetIamPolicy(
    google::iam::v1::SetIamPolicyRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->SetIamPolicy(request);
}

StatusOr<google::iam::v1::TestIamPermissionsResponse>
AnalyticsHubServiceClient::TestIamPermissions(
    google::iam::v1::TestIamPermissionsRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->TestIamPermissions(request);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace bigquery_analyticshub_v1
}  // namespace cloud
}  // namespace google
