// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/bigquery/migration/v2/migration_service.proto

#include "google/cloud/bigquery/migration/v2/internal/migration_option_defaults.h"
#include "google/cloud/bigquery/migration/v2/migration_connection.h"
#include "google/cloud/bigquery/migration/v2/migration_options.h"
#include "google/cloud/internal/populate_common_options.h"
#include "google/cloud/internal/populate_grpc_options.h"
#include <memory>

namespace google {
namespace cloud {
namespace bigquery_migration_v2_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

namespace {
auto constexpr kBackoffScaling = 2.0;
}  // namespace

Options MigrationServiceDefaultOptions(Options options) {
  options = google::cloud::internal::PopulateCommonOptions(
      std::move(options), "GOOGLE_CLOUD_CPP_MIGRATION_SERVICE_ENDPOINT", "",
      "GOOGLE_CLOUD_CPP_MIGRATION_SERVICE_AUTHORITY",
      "bigquerymigration.googleapis.com");
  options =
      google::cloud::internal::PopulateGrpcOptions(std::move(options), "");
  if (!options
           .has<bigquery_migration_v2::MigrationServiceRetryPolicyOption>()) {
    options.set<bigquery_migration_v2::MigrationServiceRetryPolicyOption>(
        bigquery_migration_v2::MigrationServiceLimitedTimeRetryPolicy(
            std::chrono::minutes(30))
            .clone());
  }
  if (!options
           .has<bigquery_migration_v2::MigrationServiceBackoffPolicyOption>()) {
    options.set<bigquery_migration_v2::MigrationServiceBackoffPolicyOption>(
        ExponentialBackoffPolicy(
            std::chrono::seconds(0), std::chrono::seconds(1),
            std::chrono::minutes(5), kBackoffScaling, kBackoffScaling)
            .clone());
  }
  if (!options.has<bigquery_migration_v2::
                       MigrationServiceConnectionIdempotencyPolicyOption>()) {
    options.set<bigquery_migration_v2::
                    MigrationServiceConnectionIdempotencyPolicyOption>(
        bigquery_migration_v2::
            MakeDefaultMigrationServiceConnectionIdempotencyPolicy());
  }

  return options;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace bigquery_migration_v2_internal
}  // namespace cloud
}  // namespace google
