// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/compute/license_codes/v1/license_codes.proto

#include "google/cloud/compute/license_codes/v1/internal/license_codes_tracing_connection.h"
#include "google/cloud/internal/opentelemetry.h"
#include <memory>

namespace google {
namespace cloud {
namespace compute_license_codes_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

LicenseCodesTracingConnection::LicenseCodesTracingConnection(
    std::shared_ptr<compute_license_codes_v1::LicenseCodesConnection> child)
    : child_(std::move(child)) {}

StatusOr<google::cloud::cpp::compute::v1::LicenseCode>
LicenseCodesTracingConnection::GetLicenseCode(
    google::cloud::cpp::compute::license_codes::v1::GetLicenseCodeRequest const&
        request) {
  auto span = internal::MakeSpan(
      "compute_license_codes_v1::LicenseCodesConnection::GetLicenseCode");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetLicenseCode(request));
}

StatusOr<google::cloud::cpp::compute::v1::TestPermissionsResponse>
LicenseCodesTracingConnection::TestIamPermissions(
    google::cloud::cpp::compute::license_codes::v1::
        TestIamPermissionsRequest const& request) {
  auto span = internal::MakeSpan(
      "compute_license_codes_v1::LicenseCodesConnection::TestIamPermissions");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->TestIamPermissions(request));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<compute_license_codes_v1::LicenseCodesConnection>
MakeLicenseCodesTracingConnection(
    std::shared_ptr<compute_license_codes_v1::LicenseCodesConnection> conn) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  if (internal::TracingEnabled(conn->options())) {
    conn = std::make_shared<LicenseCodesTracingConnection>(std::move(conn));
  }
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return conn;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace compute_license_codes_v1_internal
}  // namespace cloud
}  // namespace google
