// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source:
// google/cloud/compute/region_security_policies/v1/region_security_policies.proto

#include "google/cloud/compute/region_security_policies/v1/region_security_policies_client.h"
#include <memory>

namespace google {
namespace cloud {
namespace compute_region_security_policies_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

RegionSecurityPoliciesClient::RegionSecurityPoliciesClient(
    std::shared_ptr<RegionSecurityPoliciesConnection> connection, Options opts)
    : connection_(std::move(connection)),
      options_(
          internal::MergeOptions(std::move(opts), connection_->options())) {}
RegionSecurityPoliciesClient::~RegionSecurityPoliciesClient() = default;

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
RegionSecurityPoliciesClient::AddRule(
    std::string const& project, std::string const& region,
    std::string const& security_policy,
    google::cloud::cpp::compute::v1::SecurityPolicyRule const&
        security_policy_rule_resource,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::region_security_policies::v1::AddRuleRequest
      request;
  request.set_project(project);
  request.set_region(region);
  request.set_security_policy(security_policy);
  *request.mutable_security_policy_rule_resource() =
      security_policy_rule_resource;
  return connection_->AddRule(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
RegionSecurityPoliciesClient::AddRule(
    google::cloud::cpp::compute::region_security_policies::v1::
        AddRuleRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->AddRule(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
RegionSecurityPoliciesClient::DeleteSecurityPolicy(
    std::string const& project, std::string const& region,
    std::string const& security_policy, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::region_security_policies::v1::
      DeleteSecurityPolicyRequest request;
  request.set_project(project);
  request.set_region(region);
  request.set_security_policy(security_policy);
  return connection_->DeleteSecurityPolicy(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
RegionSecurityPoliciesClient::DeleteSecurityPolicy(
    google::cloud::cpp::compute::region_security_policies::v1::
        DeleteSecurityPolicyRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteSecurityPolicy(request);
}

StatusOr<google::cloud::cpp::compute::v1::SecurityPolicy>
RegionSecurityPoliciesClient::GetSecurityPolicy(
    std::string const& project, std::string const& region,
    std::string const& security_policy, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::region_security_policies::v1::
      GetSecurityPolicyRequest request;
  request.set_project(project);
  request.set_region(region);
  request.set_security_policy(security_policy);
  return connection_->GetSecurityPolicy(request);
}

StatusOr<google::cloud::cpp::compute::v1::SecurityPolicy>
RegionSecurityPoliciesClient::GetSecurityPolicy(
    google::cloud::cpp::compute::region_security_policies::v1::
        GetSecurityPolicyRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetSecurityPolicy(request);
}

StatusOr<google::cloud::cpp::compute::v1::SecurityPolicyRule>
RegionSecurityPoliciesClient::GetRule(std::string const& project,
                                      std::string const& region,
                                      std::string const& security_policy,
                                      Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::region_security_policies::v1::GetRuleRequest
      request;
  request.set_project(project);
  request.set_region(region);
  request.set_security_policy(security_policy);
  return connection_->GetRule(request);
}

StatusOr<google::cloud::cpp::compute::v1::SecurityPolicyRule>
RegionSecurityPoliciesClient::GetRule(
    google::cloud::cpp::compute::region_security_policies::v1::
        GetRuleRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetRule(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
RegionSecurityPoliciesClient::InsertSecurityPolicy(
    std::string const& project, std::string const& region,
    google::cloud::cpp::compute::v1::SecurityPolicy const&
        security_policy_resource,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::region_security_policies::v1::
      InsertSecurityPolicyRequest request;
  request.set_project(project);
  request.set_region(region);
  *request.mutable_security_policy_resource() = security_policy_resource;
  return connection_->InsertSecurityPolicy(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
RegionSecurityPoliciesClient::InsertSecurityPolicy(
    google::cloud::cpp::compute::region_security_policies::v1::
        InsertSecurityPolicyRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->InsertSecurityPolicy(request);
}

StreamRange<google::cloud::cpp::compute::v1::SecurityPolicy>
RegionSecurityPoliciesClient::ListRegionSecurityPolicies(
    std::string const& project, std::string const& region, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::region_security_policies::v1::
      ListRegionSecurityPoliciesRequest request;
  request.set_project(project);
  request.set_region(region);
  return connection_->ListRegionSecurityPolicies(request);
}

StreamRange<google::cloud::cpp::compute::v1::SecurityPolicy>
RegionSecurityPoliciesClient::ListRegionSecurityPolicies(
    google::cloud::cpp::compute::region_security_policies::v1::
        ListRegionSecurityPoliciesRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListRegionSecurityPolicies(std::move(request));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
RegionSecurityPoliciesClient::PatchSecurityPolicy(
    std::string const& project, std::string const& region,
    std::string const& security_policy, std::string const& update_mask,
    google::cloud::cpp::compute::v1::SecurityPolicy const&
        security_policy_resource,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::region_security_policies::v1::
      PatchSecurityPolicyRequest request;
  request.set_project(project);
  request.set_region(region);
  request.set_security_policy(security_policy);
  request.set_update_mask(update_mask);
  *request.mutable_security_policy_resource() = security_policy_resource;
  return connection_->PatchSecurityPolicy(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
RegionSecurityPoliciesClient::PatchSecurityPolicy(
    google::cloud::cpp::compute::region_security_policies::v1::
        PatchSecurityPolicyRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->PatchSecurityPolicy(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
RegionSecurityPoliciesClient::PatchRule(
    std::string const& project, std::string const& region,
    std::string const& security_policy,
    google::cloud::cpp::compute::v1::SecurityPolicyRule const&
        security_policy_rule_resource,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::region_security_policies::v1::PatchRuleRequest
      request;
  request.set_project(project);
  request.set_region(region);
  request.set_security_policy(security_policy);
  *request.mutable_security_policy_rule_resource() =
      security_policy_rule_resource;
  return connection_->PatchRule(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
RegionSecurityPoliciesClient::PatchRule(
    google::cloud::cpp::compute::region_security_policies::v1::
        PatchRuleRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->PatchRule(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
RegionSecurityPoliciesClient::RemoveRule(std::string const& project,
                                         std::string const& region,
                                         std::string const& security_policy,
                                         Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::region_security_policies::v1::RemoveRuleRequest
      request;
  request.set_project(project);
  request.set_region(region);
  request.set_security_policy(security_policy);
  return connection_->RemoveRule(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
RegionSecurityPoliciesClient::RemoveRule(
    google::cloud::cpp::compute::region_security_policies::v1::
        RemoveRuleRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->RemoveRule(request);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace compute_region_security_policies_v1
}  // namespace cloud
}  // namespace google
