// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/compute/subnetworks/v1/subnetworks.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_COMPUTE_SUBNETWORKS_V1_SUBNETWORKS_CONNECTION_IDEMPOTENCY_POLICY_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_COMPUTE_SUBNETWORKS_V1_SUBNETWORKS_CONNECTION_IDEMPOTENCY_POLICY_H

#include "google/cloud/idempotency.h"
#include "google/cloud/version.h"
#include <google/cloud/compute/subnetworks/v1/subnetworks.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace compute_subnetworks_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

class SubnetworksConnectionIdempotencyPolicy {
 public:
  virtual ~SubnetworksConnectionIdempotencyPolicy();

  /// Create a new copy of this object.
  virtual std::unique_ptr<SubnetworksConnectionIdempotencyPolicy> clone() const;

  virtual google::cloud::Idempotency AggregatedListSubnetworks(
      google::cloud::cpp::compute::subnetworks::v1::
          AggregatedListSubnetworksRequest request);

  virtual google::cloud::Idempotency DeleteSubnetwork(
      google::cloud::cpp::compute::subnetworks::v1::
          DeleteSubnetworkRequest const& request);

  virtual google::cloud::Idempotency ExpandIpCidrRange(
      google::cloud::cpp::compute::subnetworks::v1::
          ExpandIpCidrRangeRequest const& request);

  virtual google::cloud::Idempotency GetSubnetwork(
      google::cloud::cpp::compute::subnetworks::v1::GetSubnetworkRequest const&
          request);

  virtual google::cloud::Idempotency GetIamPolicy(
      google::cloud::cpp::compute::subnetworks::v1::GetIamPolicyRequest const&
          request);

  virtual google::cloud::Idempotency InsertSubnetwork(
      google::cloud::cpp::compute::subnetworks::v1::
          InsertSubnetworkRequest const& request);

  virtual google::cloud::Idempotency ListSubnetworks(
      google::cloud::cpp::compute::subnetworks::v1::ListSubnetworksRequest
          request);

  virtual google::cloud::Idempotency ListUsable(
      google::cloud::cpp::compute::subnetworks::v1::ListUsableRequest request);

  virtual google::cloud::Idempotency PatchSubnetwork(
      google::cloud::cpp::compute::subnetworks::v1::
          PatchSubnetworkRequest const& request);

  virtual google::cloud::Idempotency SetIamPolicy(
      google::cloud::cpp::compute::subnetworks::v1::SetIamPolicyRequest const&
          request);

  virtual google::cloud::Idempotency SetPrivateIpGoogleAccess(
      google::cloud::cpp::compute::subnetworks::v1::
          SetPrivateIpGoogleAccessRequest const& request);

  virtual google::cloud::Idempotency TestIamPermissions(
      google::cloud::cpp::compute::subnetworks::v1::
          TestIamPermissionsRequest const& request);
};

std::unique_ptr<SubnetworksConnectionIdempotencyPolicy>
MakeDefaultSubnetworksConnectionIdempotencyPolicy();

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace compute_subnetworks_v1
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_COMPUTE_SUBNETWORKS_V1_SUBNETWORKS_CONNECTION_IDEMPOTENCY_POLICY_H
