// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/compute/target_pools/v1/target_pools.proto

#include "google/cloud/compute/target_pools/v1/target_pools_client.h"
#include <memory>

namespace google {
namespace cloud {
namespace compute_target_pools_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

TargetPoolsClient::TargetPoolsClient(
    std::shared_ptr<TargetPoolsConnection> connection, Options opts)
    : connection_(std::move(connection)),
      options_(
          internal::MergeOptions(std::move(opts), connection_->options())) {}
TargetPoolsClient::~TargetPoolsClient() = default;

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
TargetPoolsClient::AddHealthCheck(
    std::string const& project, std::string const& region,
    std::string const& target_pool,
    google::cloud::cpp::compute::v1::TargetPoolsAddHealthCheckRequest const&
        target_pools_add_health_check_request_resource,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::target_pools::v1::AddHealthCheckRequest request;
  request.set_project(project);
  request.set_region(region);
  request.set_target_pool(target_pool);
  *request.mutable_target_pools_add_health_check_request_resource() =
      target_pools_add_health_check_request_resource;
  return connection_->AddHealthCheck(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
TargetPoolsClient::AddHealthCheck(
    google::cloud::cpp::compute::target_pools::v1::AddHealthCheckRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->AddHealthCheck(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
TargetPoolsClient::AddInstance(
    std::string const& project, std::string const& region,
    std::string const& target_pool,
    google::cloud::cpp::compute::v1::TargetPoolsAddInstanceRequest const&
        target_pools_add_instance_request_resource,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::target_pools::v1::AddInstanceRequest request;
  request.set_project(project);
  request.set_region(region);
  request.set_target_pool(target_pool);
  *request.mutable_target_pools_add_instance_request_resource() =
      target_pools_add_instance_request_resource;
  return connection_->AddInstance(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
TargetPoolsClient::AddInstance(
    google::cloud::cpp::compute::target_pools::v1::AddInstanceRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->AddInstance(request);
}

StreamRange<std::pair<std::string,
                      google::cloud::cpp::compute::v1::TargetPoolsScopedList>>
TargetPoolsClient::AggregatedListTargetPools(std::string const& project,
                                             Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::target_pools::v1::
      AggregatedListTargetPoolsRequest request;
  request.set_project(project);
  return connection_->AggregatedListTargetPools(request);
}

StreamRange<std::pair<std::string,
                      google::cloud::cpp::compute::v1::TargetPoolsScopedList>>
TargetPoolsClient::AggregatedListTargetPools(
    google::cloud::cpp::compute::target_pools::v1::
        AggregatedListTargetPoolsRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->AggregatedListTargetPools(std::move(request));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
TargetPoolsClient::DeleteTargetPool(std::string const& project,
                                    std::string const& region,
                                    std::string const& target_pool,
                                    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::target_pools::v1::DeleteTargetPoolRequest
      request;
  request.set_project(project);
  request.set_region(region);
  request.set_target_pool(target_pool);
  return connection_->DeleteTargetPool(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
TargetPoolsClient::DeleteTargetPool(
    google::cloud::cpp::compute::target_pools::v1::
        DeleteTargetPoolRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteTargetPool(request);
}

StatusOr<google::cloud::cpp::compute::v1::TargetPool>
TargetPoolsClient::GetTargetPool(std::string const& project,
                                 std::string const& region,
                                 std::string const& target_pool, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::target_pools::v1::GetTargetPoolRequest request;
  request.set_project(project);
  request.set_region(region);
  request.set_target_pool(target_pool);
  return connection_->GetTargetPool(request);
}

StatusOr<google::cloud::cpp::compute::v1::TargetPool>
TargetPoolsClient::GetTargetPool(
    google::cloud::cpp::compute::target_pools::v1::GetTargetPoolRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetTargetPool(request);
}

StatusOr<google::cloud::cpp::compute::v1::TargetPoolInstanceHealth>
TargetPoolsClient::GetHealth(
    std::string const& project, std::string const& region,
    std::string const& target_pool,
    google::cloud::cpp::compute::v1::InstanceReference const&
        instance_reference_resource,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::target_pools::v1::GetHealthRequest request;
  request.set_project(project);
  request.set_region(region);
  request.set_target_pool(target_pool);
  *request.mutable_instance_reference_resource() = instance_reference_resource;
  return connection_->GetHealth(request);
}

StatusOr<google::cloud::cpp::compute::v1::TargetPoolInstanceHealth>
TargetPoolsClient::GetHealth(
    google::cloud::cpp::compute::target_pools::v1::GetHealthRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetHealth(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
TargetPoolsClient::InsertTargetPool(
    std::string const& project, std::string const& region,
    google::cloud::cpp::compute::v1::TargetPool const& target_pool_resource,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::target_pools::v1::InsertTargetPoolRequest
      request;
  request.set_project(project);
  request.set_region(region);
  *request.mutable_target_pool_resource() = target_pool_resource;
  return connection_->InsertTargetPool(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
TargetPoolsClient::InsertTargetPool(
    google::cloud::cpp::compute::target_pools::v1::
        InsertTargetPoolRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->InsertTargetPool(request);
}

StreamRange<google::cloud::cpp::compute::v1::TargetPool>
TargetPoolsClient::ListTargetPools(std::string const& project,
                                   std::string const& region, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::target_pools::v1::ListTargetPoolsRequest request;
  request.set_project(project);
  request.set_region(region);
  return connection_->ListTargetPools(request);
}

StreamRange<google::cloud::cpp::compute::v1::TargetPool>
TargetPoolsClient::ListTargetPools(
    google::cloud::cpp::compute::target_pools::v1::ListTargetPoolsRequest
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListTargetPools(std::move(request));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
TargetPoolsClient::RemoveHealthCheck(
    std::string const& project, std::string const& region,
    std::string const& target_pool,
    google::cloud::cpp::compute::v1::TargetPoolsRemoveHealthCheckRequest const&
        target_pools_remove_health_check_request_resource,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::target_pools::v1::RemoveHealthCheckRequest
      request;
  request.set_project(project);
  request.set_region(region);
  request.set_target_pool(target_pool);
  *request.mutable_target_pools_remove_health_check_request_resource() =
      target_pools_remove_health_check_request_resource;
  return connection_->RemoveHealthCheck(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
TargetPoolsClient::RemoveHealthCheck(
    google::cloud::cpp::compute::target_pools::v1::
        RemoveHealthCheckRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->RemoveHealthCheck(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
TargetPoolsClient::RemoveInstance(
    std::string const& project, std::string const& region,
    std::string const& target_pool,
    google::cloud::cpp::compute::v1::TargetPoolsRemoveInstanceRequest const&
        target_pools_remove_instance_request_resource,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::target_pools::v1::RemoveInstanceRequest request;
  request.set_project(project);
  request.set_region(region);
  request.set_target_pool(target_pool);
  *request.mutable_target_pools_remove_instance_request_resource() =
      target_pools_remove_instance_request_resource;
  return connection_->RemoveInstance(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
TargetPoolsClient::RemoveInstance(
    google::cloud::cpp::compute::target_pools::v1::RemoveInstanceRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->RemoveInstance(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
TargetPoolsClient::SetBackup(
    std::string const& project, std::string const& region,
    std::string const& target_pool,
    google::cloud::cpp::compute::v1::TargetReference const&
        target_reference_resource,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::target_pools::v1::SetBackupRequest request;
  request.set_project(project);
  request.set_region(region);
  request.set_target_pool(target_pool);
  *request.mutable_target_reference_resource() = target_reference_resource;
  return connection_->SetBackup(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
TargetPoolsClient::SetBackup(
    google::cloud::cpp::compute::target_pools::v1::SetBackupRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->SetBackup(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
TargetPoolsClient::SetSecurityPolicy(
    std::string const& project, std::string const& region,
    std::string const& target_pool,
    google::cloud::cpp::compute::v1::SecurityPolicyReference const&
        security_policy_reference_resource,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::target_pools::v1::SetSecurityPolicyRequest
      request;
  request.set_project(project);
  request.set_region(region);
  request.set_target_pool(target_pool);
  *request.mutable_security_policy_reference_resource() =
      security_policy_reference_resource;
  return connection_->SetSecurityPolicy(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
TargetPoolsClient::SetSecurityPolicy(
    google::cloud::cpp::compute::target_pools::v1::
        SetSecurityPolicyRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->SetSecurityPolicy(request);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace compute_target_pools_v1
}  // namespace cloud
}  // namespace google
