// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/dialogflow/cx/v3/environment.proto

#include "google/cloud/dialogflow_cx/environments_connection_idempotency_policy.h"
#include <memory>

namespace google {
namespace cloud {
namespace dialogflow_cx {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using ::google::cloud::Idempotency;

EnvironmentsConnectionIdempotencyPolicy::
    ~EnvironmentsConnectionIdempotencyPolicy() = default;

std::unique_ptr<EnvironmentsConnectionIdempotencyPolicy>
EnvironmentsConnectionIdempotencyPolicy::clone() const {
  return std::make_unique<EnvironmentsConnectionIdempotencyPolicy>(*this);
}

Idempotency EnvironmentsConnectionIdempotencyPolicy::ListEnvironments(
    google::cloud::dialogflow::cx::v3::ListEnvironmentsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency EnvironmentsConnectionIdempotencyPolicy::GetEnvironment(
    google::cloud::dialogflow::cx::v3::GetEnvironmentRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency EnvironmentsConnectionIdempotencyPolicy::CreateEnvironment(
    google::cloud::dialogflow::cx::v3::CreateEnvironmentRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency EnvironmentsConnectionIdempotencyPolicy::UpdateEnvironment(
    google::cloud::dialogflow::cx::v3::UpdateEnvironmentRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency EnvironmentsConnectionIdempotencyPolicy::DeleteEnvironment(
    google::cloud::dialogflow::cx::v3::DeleteEnvironmentRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency EnvironmentsConnectionIdempotencyPolicy::LookupEnvironmentHistory(
    google::cloud::dialogflow::cx::v3::
        LookupEnvironmentHistoryRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency EnvironmentsConnectionIdempotencyPolicy::RunContinuousTest(
    google::cloud::dialogflow::cx::v3::RunContinuousTestRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency EnvironmentsConnectionIdempotencyPolicy::ListContinuousTestResults(
    google::cloud::dialogflow::cx::v3::
        ListContinuousTestResultsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency EnvironmentsConnectionIdempotencyPolicy::DeployFlow(
    google::cloud::dialogflow::cx::v3::DeployFlowRequest const&) {
  return Idempotency::kNonIdempotent;
}

std::unique_ptr<EnvironmentsConnectionIdempotencyPolicy>
MakeDefaultEnvironmentsConnectionIdempotencyPolicy() {
  return std::make_unique<EnvironmentsConnectionIdempotencyPolicy>();
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace dialogflow_cx
}  // namespace cloud
}  // namespace google
