// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/domains/v1/domains.proto

#include "google/cloud/domains/v1/domains_connection_idempotency_policy.h"
#include <memory>

namespace google {
namespace cloud {
namespace domains_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using ::google::cloud::Idempotency;

DomainsConnectionIdempotencyPolicy::~DomainsConnectionIdempotencyPolicy() =
    default;

std::unique_ptr<DomainsConnectionIdempotencyPolicy>
DomainsConnectionIdempotencyPolicy::clone() const {
  return std::make_unique<DomainsConnectionIdempotencyPolicy>(*this);
}

Idempotency DomainsConnectionIdempotencyPolicy::SearchDomains(
    google::cloud::domains::v1::SearchDomainsRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency DomainsConnectionIdempotencyPolicy::RetrieveRegisterParameters(
    google::cloud::domains::v1::RetrieveRegisterParametersRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency DomainsConnectionIdempotencyPolicy::RegisterDomain(
    google::cloud::domains::v1::RegisterDomainRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency DomainsConnectionIdempotencyPolicy::RetrieveTransferParameters(
    google::cloud::domains::v1::RetrieveTransferParametersRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency DomainsConnectionIdempotencyPolicy::TransferDomain(
    google::cloud::domains::v1::TransferDomainRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency DomainsConnectionIdempotencyPolicy::ListRegistrations(
    google::cloud::domains::v1::ListRegistrationsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency DomainsConnectionIdempotencyPolicy::GetRegistration(
    google::cloud::domains::v1::GetRegistrationRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency DomainsConnectionIdempotencyPolicy::UpdateRegistration(
    google::cloud::domains::v1::UpdateRegistrationRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency DomainsConnectionIdempotencyPolicy::ConfigureManagementSettings(
    google::cloud::domains::v1::ConfigureManagementSettingsRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency DomainsConnectionIdempotencyPolicy::ConfigureDnsSettings(
    google::cloud::domains::v1::ConfigureDnsSettingsRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency DomainsConnectionIdempotencyPolicy::ConfigureContactSettings(
    google::cloud::domains::v1::ConfigureContactSettingsRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency DomainsConnectionIdempotencyPolicy::ExportRegistration(
    google::cloud::domains::v1::ExportRegistrationRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency DomainsConnectionIdempotencyPolicy::DeleteRegistration(
    google::cloud::domains::v1::DeleteRegistrationRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency DomainsConnectionIdempotencyPolicy::RetrieveAuthorizationCode(
    google::cloud::domains::v1::RetrieveAuthorizationCodeRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency DomainsConnectionIdempotencyPolicy::ResetAuthorizationCode(
    google::cloud::domains::v1::ResetAuthorizationCodeRequest const&) {
  return Idempotency::kNonIdempotent;
}

std::unique_ptr<DomainsConnectionIdempotencyPolicy>
MakeDefaultDomainsConnectionIdempotencyPolicy() {
  return std::make_unique<DomainsConnectionIdempotencyPolicy>();
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace domains_v1
}  // namespace cloud
}  // namespace google
