// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/devtools/cloudprofiler/v2/profiler.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_PROFILER_V2_MOCKS_MOCK_PROFILER_CONNECTION_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_PROFILER_V2_MOCKS_MOCK_PROFILER_CONNECTION_H

#include "google/cloud/profiler/v2/profiler_connection.h"
#include <gmock/gmock.h>

namespace google {
namespace cloud {
namespace profiler_v2_mocks {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

/**
 * A class to mock `ProfilerServiceConnection`.
 *
 * Application developers may want to test their code with simulated responses,
 * including errors, from an object of type `ProfilerServiceClient`. To do so,
 * construct an object of type `ProfilerServiceClient` with an instance of this
 * class. Then use the Google Test framework functions to program the behavior
 * of this mock.
 *
 * @see [This example][bq-mock] for how to test your application with GoogleTest.
 * While the example showcases types from the BigQuery library, the underlying
 * principles apply for any pair of `*Client` and `*Connection`.
 *
 * [bq-mock]: @cloud_cpp_docs_link{bigquery,bigquery-read-mock}
 */
class MockProfilerServiceConnection
    : public profiler_v2::ProfilerServiceConnection {
 public:
  MOCK_METHOD(Options, options, (), (override));

  MOCK_METHOD(StatusOr<google::devtools::cloudprofiler::v2::Profile>,
              CreateProfile,
              (google::devtools::cloudprofiler::v2::CreateProfileRequest const&
                   request),
              (override));

  MOCK_METHOD(
      StatusOr<google::devtools::cloudprofiler::v2::Profile>,
      CreateOfflineProfile,
      (google::devtools::cloudprofiler::v2::CreateOfflineProfileRequest const&
           request),
      (override));

  MOCK_METHOD(StatusOr<google::devtools::cloudprofiler::v2::Profile>,
              UpdateProfile,
              (google::devtools::cloudprofiler::v2::UpdateProfileRequest const&
                   request),
              (override));
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace profiler_v2_mocks
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_PROFILER_V2_MOCKS_MOCK_PROFILER_CONNECTION_H
