"use strict";const utils=require("@typescript-eslint/utils"),node_path=require("node:path"),o$3=require("typescript"),node_module=require("node:module");var _documentCurrentScript=typeof document<"u"?document.currentScript:null;function _interopDefaultCompat(d){return d&&typeof d=="object"&&"default"in d?d.default:d}const o__default=_interopDefaultCompat(o$3),version="1.1.38";function createEslintRule(d){return utils.ESLintUtils.RuleCreator(Y=>`https://github.com/vitest-dev/eslint-plugin-vitest/blob/main/docs/rules/${Y}.md`)(d)}const joinNames=(d,Y)=>d&&Y?`${d}.${Y}`:null,isFunction=d=>d.type===utils.AST_NODE_TYPES.FunctionExpression||d.type===utils.AST_NODE_TYPES.ArrowFunctionExpression;function getNodeName(d){if(isSupportedAccessor(d))return getAccessorValue(d);switch(d.type){case utils.AST_NODE_TYPES.TaggedTemplateExpression:return getNodeName(d.tag);case utils.AST_NODE_TYPES.MemberExpression:return joinNames(getNodeName(d.object),getNodeName(d.property));case utils.AST_NODE_TYPES.NewExpression:case utils.AST_NODE_TYPES.CallExpression:return getNodeName(d.callee)}return null}const isSupportedAccessor=(d,Y)=>isIdentifier(d,Y)||isStringNode(d,Y),isIdentifier=(d,Y)=>d.type===utils.AST_NODE_TYPES.Identifier&&(Y===void 0||d.name===Y),p$2=(d,Y)=>d.type===utils.AST_NODE_TYPES.TemplateLiteral&&d.quasis.length===1&&(Y===void 0||d.quasis[0].value.raw===Y),g$2=(d,Y)=>d.type===utils.AST_NODE_TYPES.Literal&&typeof d.value=="string"&&(Y===void 0||d.value===Y),isStringNode=(d,Y)=>g$2(d,Y)||p$2(d,Y),getAccessorValue=d=>d.type===utils.AST_NODE_TYPES.Identifier?d.name:getStringValue(d),getStringValue=d=>d?.type===utils.AST_NODE_TYPES.TemplateLiteral?d.quasis[0].value.raw:d?.value,replaceAccessorFixer=(d,Y,q)=>d.replaceText(Y,Y.type===utils.AST_NODE_TYPES.Identifier?q:`'${q}'`),removeExtraArgumentsFixer=(d,Y,q,B)=>{const H=q.arguments[B],V=q.arguments[q.arguments.length-1],{sourceCode:K}=Y;let X=K.getTokenAfter(V);return X.value===","&&(X=K.getTokenAfter(X)),d.removeRange([H.range[0],X.range[0]])},isParsedInstanceOfMatcherCall=(d,Y)=>getAccessorValue(d.matcher)==="toBeInstanceOf"&&d.args.length===1&&isSupportedAccessor(d.args[0],Y);var DescribeAlias=(d=>(d.describe="describe",d.fdescribe="fdescribe",d.xdescribe="xdescribe",d))(DescribeAlias||{}),TestCaseName=(d=>(d.fit="fit",d.it="it",d.test="test",d.xit="xit",d.xtest="xtest",d.bench="bench",d))(TestCaseName||{}),HookName=(d=>(d.beforeAll="beforeAll",d.beforeEach="beforeEach",d.afterAll="afterAll",d.afterEach="afterEach",d))(HookName||{}),ModifierName=(d=>(d.to="to",d.have="have",d.not="not",d.rejects="rejects",d.resolves="resolves",d.returns="returns",d.branded="branded",d.asserts="asserts",d.constructorParameters="constructorParameters",d.parameters="parameters",d.thisParameter="thisParameter",d.guards="guards",d.instance="instance",d.items="items",d))(ModifierName||{}),EqualityMatcher=(d=>(d.toBe="toBe",d.toEqual="toEqual",d.toStrictEqual="toStrictEqual",d))(EqualityMatcher||{});const ValidVitestFnCallChains=new Set(["beforeEach","beforeAll","afterEach","afterAll","it","it.skip","it.only","it.concurrent","it.sequential","it.todo","it.fails","it.extend","it.skipIf","it.runIf","it.each","it.skip.only","it.skip.concurrent","it.skip.sequential","it.skip.todo","it.skip.fails","it.only.skip","it.only.concurrent","it.only.sequential","it.only.todo","it.only.fails","it.concurrent.skip","it.concurrent.only","it.concurrent.sequential","it.concurrent.todo","it.concurrent.fails","it.sequential.skip","it.sequential.only","it.sequential.concurrent","it.sequential.todo","it.sequential.fails","it.todo.skip","it.todo.only","it.todo.concurrent","it.todo.sequential","it.todo.fails","it.fails.skip","it.fails.only","it.fails.concurrent","it.fails.sequential","it.fails.todo","it.extend.skip","it.extend.only","it.extend.concurrent","it.extend.sequential","it.extend.todo","it.extend.fails","it.skipIf.skip","it.skipIf.only","it.skipIf.concurrent","it.skipIf.sequential","it.skipIf.todo","it.skipIf.fails","it.runIf.skip","it.runIf.only","it.runIf.concurrent","it.runIf.sequential","it.runIf.todo","it.runIf.fails","it.skip.each","it.only.each","it.concurrent.each","it.sequential.each","it.todo.each","it.fails.each","it.extend.skipIf","it.extend.runIf","it.extend.each","it.skipIf.each","it.runIf.each","it.skip.only.concurrent","it.skip.only.sequential","it.skip.only.todo","it.skip.only.fails","it.skip.concurrent.only","it.skip.concurrent.sequential","it.skip.concurrent.todo","it.skip.concurrent.fails","it.skip.sequential.only","it.skip.sequential.concurrent","it.skip.sequential.todo","it.skip.sequential.fails","it.skip.todo.only","it.skip.todo.concurrent","it.skip.todo.sequential","it.skip.todo.fails","it.skip.fails.only","it.skip.fails.concurrent","it.skip.fails.sequential","it.skip.fails.todo","it.only.skip.concurrent","it.only.skip.sequential","it.only.skip.todo","it.only.skip.fails","it.only.concurrent.skip","it.only.concurrent.sequential","it.only.concurrent.todo","it.only.concurrent.fails","it.only.sequential.skip","it.only.sequential.concurrent","it.only.sequential.todo","it.only.sequential.fails","it.only.todo.skip","it.only.todo.concurrent","it.only.todo.sequential","it.only.todo.fails","it.only.fails.skip","it.only.fails.concurrent","it.only.fails.sequential","it.only.fails.todo","it.concurrent.skip.only","it.concurrent.skip.sequential","it.concurrent.skip.todo","it.concurrent.skip.fails","it.concurrent.only.skip","it.concurrent.only.sequential","it.concurrent.only.todo","it.concurrent.only.fails","it.concurrent.sequential.skip","it.concurrent.sequential.only","it.concurrent.sequential.todo","it.concurrent.sequential.fails","it.concurrent.todo.skip","it.concurrent.todo.only","it.concurrent.todo.sequential","it.concurrent.todo.fails","it.concurrent.fails.skip","it.concurrent.fails.only","it.concurrent.fails.sequential","it.concurrent.fails.todo","it.sequential.skip.only","it.sequential.skip.concurrent","it.sequential.skip.todo","it.sequential.skip.fails","it.sequential.only.skip","it.sequential.only.concurrent","it.sequential.only.todo","it.sequential.only.fails","it.sequential.concurrent.skip","it.sequential.concurrent.only","it.sequential.concurrent.todo","it.sequential.concurrent.fails","it.sequential.todo.skip","it.sequential.todo.only","it.sequential.todo.concurrent","it.sequential.todo.fails","it.sequential.fails.skip","it.sequential.fails.only","it.sequential.fails.concurrent","it.sequential.fails.todo","it.todo.skip.only","it.todo.skip.concurrent","it.todo.skip.sequential","it.todo.skip.fails","it.todo.only.skip","it.todo.only.concurrent","it.todo.only.sequential","it.todo.only.fails","it.todo.concurrent.skip","it.todo.concurrent.only","it.todo.concurrent.sequential","it.todo.concurrent.fails","it.todo.sequential.skip","it.todo.sequential.only","it.todo.sequential.concurrent","it.todo.sequential.fails","it.todo.fails.skip","it.todo.fails.only","it.todo.fails.concurrent","it.todo.fails.sequential","it.fails.skip.only","it.fails.skip.concurrent","it.fails.skip.sequential","it.fails.skip.todo","it.fails.only.skip","it.fails.only.concurrent","it.fails.only.sequential","it.fails.only.todo","it.fails.concurrent.skip","it.fails.concurrent.only","it.fails.concurrent.sequential","it.fails.concurrent.todo","it.fails.sequential.skip","it.fails.sequential.only","it.fails.sequential.concurrent","it.fails.sequential.todo","it.fails.todo.skip","it.fails.todo.only","it.fails.todo.concurrent","it.fails.todo.sequential","it.extend.skip.only","it.extend.skip.concurrent","it.extend.skip.sequential","it.extend.skip.todo","it.extend.skip.fails","it.extend.only.skip","it.extend.only.concurrent","it.extend.only.sequential","it.extend.only.todo","it.extend.only.fails","it.extend.concurrent.skip","it.extend.concurrent.only","it.extend.concurrent.sequential","it.extend.concurrent.todo","it.extend.concurrent.fails","it.extend.sequential.skip","it.extend.sequential.only","it.extend.sequential.concurrent","it.extend.sequential.todo","it.extend.sequential.fails","it.extend.todo.skip","it.extend.todo.only","it.extend.todo.concurrent","it.extend.todo.sequential","it.extend.todo.fails","it.extend.fails.skip","it.extend.fails.only","it.extend.fails.concurrent","it.extend.fails.sequential","it.extend.fails.todo","it.skipIf.skip.only","it.skipIf.skip.concurrent","it.skipIf.skip.sequential","it.skipIf.skip.todo","it.skipIf.skip.fails","it.skipIf.only.skip","it.skipIf.only.concurrent","it.skipIf.only.sequential","it.skipIf.only.todo","it.skipIf.only.fails","it.skipIf.concurrent.skip","it.skipIf.concurrent.only","it.skipIf.concurrent.sequential","it.skipIf.concurrent.todo","it.skipIf.concurrent.fails","it.skipIf.sequential.skip","it.skipIf.sequential.only","it.skipIf.sequential.concurrent","it.skipIf.sequential.todo","it.skipIf.sequential.fails","it.skipIf.todo.skip","it.skipIf.todo.only","it.skipIf.todo.concurrent","it.skipIf.todo.sequential","it.skipIf.todo.fails","it.skipIf.fails.skip","it.skipIf.fails.only","it.skipIf.fails.concurrent","it.skipIf.fails.sequential","it.skipIf.fails.todo","it.runIf.skip.only","it.runIf.skip.concurrent","it.runIf.skip.sequential","it.runIf.skip.todo","it.runIf.skip.fails","it.runIf.only.skip","it.runIf.only.concurrent","it.runIf.only.sequential","it.runIf.only.todo","it.runIf.only.fails","it.runIf.concurrent.skip","it.runIf.concurrent.only","it.runIf.concurrent.sequential","it.runIf.concurrent.todo","it.runIf.concurrent.fails","it.runIf.sequential.skip","it.runIf.sequential.only","it.runIf.sequential.concurrent","it.runIf.sequential.todo","it.runIf.sequential.fails","it.runIf.todo.skip","it.runIf.todo.only","it.runIf.todo.concurrent","it.runIf.todo.sequential","it.runIf.todo.fails","it.runIf.fails.skip","it.runIf.fails.only","it.runIf.fails.concurrent","it.runIf.fails.sequential","it.runIf.fails.todo","it.skip.only.each","it.skip.concurrent.each","it.skip.sequential.each","it.skip.todo.each","it.skip.fails.each","it.only.skip.each","it.only.concurrent.each","it.only.sequential.each","it.only.todo.each","it.only.fails.each","it.concurrent.skip.each","it.concurrent.only.each","it.concurrent.sequential.each","it.concurrent.todo.each","it.concurrent.fails.each","it.sequential.skip.each","it.sequential.only.each","it.sequential.concurrent.each","it.sequential.todo.each","it.sequential.fails.each","it.todo.skip.each","it.todo.only.each","it.todo.concurrent.each","it.todo.sequential.each","it.todo.fails.each","it.fails.skip.each","it.fails.only.each","it.fails.concurrent.each","it.fails.sequential.each","it.fails.todo.each","it.extend.skipIf.skip","it.extend.skipIf.only","it.extend.skipIf.concurrent","it.extend.skipIf.sequential","it.extend.skipIf.todo","it.extend.skipIf.fails","it.extend.runIf.skip","it.extend.runIf.only","it.extend.runIf.concurrent","it.extend.runIf.sequential","it.extend.runIf.todo","it.extend.runIf.fails","it.extend.skip.each","it.extend.only.each","it.extend.concurrent.each","it.extend.sequential.each","it.extend.todo.each","it.extend.fails.each","it.skipIf.skip.each","it.skipIf.only.each","it.skipIf.concurrent.each","it.skipIf.sequential.each","it.skipIf.todo.each","it.skipIf.fails.each","it.runIf.skip.each","it.runIf.only.each","it.runIf.concurrent.each","it.runIf.sequential.each","it.runIf.todo.each","it.runIf.fails.each","it.extend.skipIf.each","it.extend.runIf.each","test","test.skip","test.only","test.concurrent","test.sequential","test.todo","test.fails","test.extend","test.skipIf","test.runIf","test.each","test.skip.only","test.skip.concurrent","test.skip.sequential","test.skip.todo","test.skip.fails","test.only.skip","test.only.concurrent","test.only.sequential","test.only.todo","test.only.fails","test.concurrent.skip","test.concurrent.only","test.concurrent.sequential","test.concurrent.todo","test.concurrent.fails","test.sequential.skip","test.sequential.only","test.sequential.concurrent","test.sequential.todo","test.sequential.fails","test.todo.skip","test.todo.only","test.todo.concurrent","test.todo.sequential","test.todo.fails","test.fails.skip","test.fails.only","test.fails.concurrent","test.fails.sequential","test.fails.todo","test.extend.skip","test.extend.only","test.extend.concurrent","test.extend.sequential","test.extend.todo","test.extend.fails","test.skipIf.skip","test.skipIf.only","test.skipIf.concurrent","test.skipIf.sequential","test.skipIf.todo","test.skipIf.fails","test.runIf.skip","test.runIf.only","test.runIf.concurrent","test.runIf.sequential","test.runIf.todo","test.runIf.fails","test.skip.each","test.only.each","test.concurrent.each","test.sequential.each","test.todo.each","test.fails.each","test.extend.skipIf","test.extend.runIf","test.extend.each","test.skipIf.each","test.runIf.each","test.skip.only.concurrent","test.skip.only.sequential","test.skip.only.todo","test.skip.only.fails","test.skip.concurrent.only","test.skip.concurrent.sequential","test.skip.concurrent.todo","test.skip.concurrent.fails","test.skip.sequential.only","test.skip.sequential.concurrent","test.skip.sequential.todo","test.skip.sequential.fails","test.skip.todo.only","test.skip.todo.concurrent","test.skip.todo.sequential","test.skip.todo.fails","test.skip.fails.only","test.skip.fails.concurrent","test.skip.fails.sequential","test.skip.fails.todo","test.only.skip.concurrent","test.only.skip.sequential","test.only.skip.todo","test.only.skip.fails","test.only.concurrent.skip","test.only.concurrent.sequential","test.only.concurrent.todo","test.only.concurrent.fails","test.only.sequential.skip","test.only.sequential.concurrent","test.only.sequential.todo","test.only.sequential.fails","test.only.todo.skip","test.only.todo.concurrent","test.only.todo.sequential","test.only.todo.fails","test.only.fails.skip","test.only.fails.concurrent","test.only.fails.sequential","test.only.fails.todo","test.concurrent.skip.only","test.concurrent.skip.sequential","test.concurrent.skip.todo","test.concurrent.skip.fails","test.concurrent.only.skip","test.concurrent.only.sequential","test.concurrent.only.todo","test.concurrent.only.fails","test.concurrent.sequential.skip","test.concurrent.sequential.only","test.concurrent.sequential.todo","test.concurrent.sequential.fails","test.concurrent.todo.skip","test.concurrent.todo.only","test.concurrent.todo.sequential","test.concurrent.todo.fails","test.concurrent.fails.skip","test.concurrent.fails.only","test.concurrent.fails.sequential","test.concurrent.fails.todo","test.sequential.skip.only","test.sequential.skip.concurrent","test.sequential.skip.todo","test.sequential.skip.fails","test.sequential.only.skip","test.sequential.only.concurrent","test.sequential.only.todo","test.sequential.only.fails","test.sequential.concurrent.skip","test.sequential.concurrent.only","test.sequential.concurrent.todo","test.sequential.concurrent.fails","test.sequential.todo.skip","test.sequential.todo.only","test.sequential.todo.concurrent","test.sequential.todo.fails","test.sequential.fails.skip","test.sequential.fails.only","test.sequential.fails.concurrent","test.sequential.fails.todo","test.todo.skip.only","test.todo.skip.concurrent","test.todo.skip.sequential","test.todo.skip.fails","test.todo.only.skip","test.todo.only.concurrent","test.todo.only.sequential","test.todo.only.fails","test.todo.concurrent.skip","test.todo.concurrent.only","test.todo.concurrent.sequential","test.todo.concurrent.fails","test.todo.sequential.skip","test.todo.sequential.only","test.todo.sequential.concurrent","test.todo.sequential.fails","test.todo.fails.skip","test.todo.fails.only","test.todo.fails.concurrent","test.todo.fails.sequential","test.fails.skip.only","test.fails.skip.concurrent","test.fails.skip.sequential","test.fails.skip.todo","test.fails.only.skip","test.fails.only.concurrent","test.fails.only.sequential","test.fails.only.todo","test.fails.concurrent.skip","test.fails.concurrent.only","test.fails.concurrent.sequential","test.fails.concurrent.todo","test.fails.sequential.skip","test.fails.sequential.only","test.fails.sequential.concurrent","test.fails.sequential.todo","test.fails.todo.skip","test.fails.todo.only","test.fails.todo.concurrent","test.fails.todo.sequential","test.extend.skip.only","test.extend.skip.concurrent","test.extend.skip.sequential","test.extend.skip.todo","test.extend.skip.fails","test.extend.only.skip","test.extend.only.concurrent","test.extend.only.sequential","test.extend.only.todo","test.extend.only.fails","test.extend.concurrent.skip","test.extend.concurrent.only","test.extend.concurrent.sequential","test.extend.concurrent.todo","test.extend.concurrent.fails","test.extend.sequential.skip","test.extend.sequential.only","test.extend.sequential.concurrent","test.extend.sequential.todo","test.extend.sequential.fails","test.extend.todo.skip","test.extend.todo.only","test.extend.todo.concurrent","test.extend.todo.sequential","test.extend.todo.fails","test.extend.fails.skip","test.extend.fails.only","test.extend.fails.concurrent","test.extend.fails.sequential","test.extend.fails.todo","test.skipIf.skip.only","test.skipIf.skip.concurrent","test.skipIf.skip.sequential","test.skipIf.skip.todo","test.skipIf.skip.fails","test.skipIf.only.skip","test.skipIf.only.concurrent","test.skipIf.only.sequential","test.skipIf.only.todo","test.skipIf.only.fails","test.skipIf.concurrent.skip","test.skipIf.concurrent.only","test.skipIf.concurrent.sequential","test.skipIf.concurrent.todo","test.skipIf.concurrent.fails","test.skipIf.sequential.skip","test.skipIf.sequential.only","test.skipIf.sequential.concurrent","test.skipIf.sequential.todo","test.skipIf.sequential.fails","test.skipIf.todo.skip","test.skipIf.todo.only","test.skipIf.todo.concurrent","test.skipIf.todo.sequential","test.skipIf.todo.fails","test.skipIf.fails.skip","test.skipIf.fails.only","test.skipIf.fails.concurrent","test.skipIf.fails.sequential","test.skipIf.fails.todo","test.runIf.skip.only","test.runIf.skip.concurrent","test.runIf.skip.sequential","test.runIf.skip.todo","test.runIf.skip.fails","test.runIf.only.skip","test.runIf.only.concurrent","test.runIf.only.sequential","test.runIf.only.todo","test.runIf.only.fails","test.runIf.concurrent.skip","test.runIf.concurrent.only","test.runIf.concurrent.sequential","test.runIf.concurrent.todo","test.runIf.concurrent.fails","test.runIf.sequential.skip","test.runIf.sequential.only","test.runIf.sequential.concurrent","test.runIf.sequential.todo","test.runIf.sequential.fails","test.runIf.todo.skip","test.runIf.todo.only","test.runIf.todo.concurrent","test.runIf.todo.sequential","test.runIf.todo.fails","test.runIf.fails.skip","test.runIf.fails.only","test.runIf.fails.concurrent","test.runIf.fails.sequential","test.runIf.fails.todo","test.skip.only.each","test.skip.concurrent.each","test.skip.sequential.each","test.skip.todo.each","test.skip.fails.each","test.only.skip.each","test.only.concurrent.each","test.only.sequential.each","test.only.todo.each","test.only.fails.each","test.concurrent.skip.each","test.concurrent.only.each","test.concurrent.sequential.each","test.concurrent.todo.each","test.concurrent.fails.each","test.sequential.skip.each","test.sequential.only.each","test.sequential.concurrent.each","test.sequential.todo.each","test.sequential.fails.each","test.todo.skip.each","test.todo.only.each","test.todo.concurrent.each","test.todo.sequential.each","test.todo.fails.each","test.fails.skip.each","test.fails.only.each","test.fails.concurrent.each","test.fails.sequential.each","test.fails.todo.each","test.extend.skipIf.skip","test.extend.skipIf.only","test.extend.skipIf.concurrent","test.extend.skipIf.sequential","test.extend.skipIf.todo","test.extend.skipIf.fails","test.extend.runIf.skip","test.extend.runIf.only","test.extend.runIf.concurrent","test.extend.runIf.sequential","test.extend.runIf.todo","test.extend.runIf.fails","test.extend.skip.each","test.extend.only.each","test.extend.concurrent.each","test.extend.sequential.each","test.extend.todo.each","test.extend.fails.each","test.skipIf.skip.each","test.skipIf.only.each","test.skipIf.concurrent.each","test.skipIf.sequential.each","test.skipIf.todo.each","test.skipIf.fails.each","test.runIf.skip.each","test.runIf.only.each","test.runIf.concurrent.each","test.runIf.sequential.each","test.runIf.todo.each","test.runIf.fails.each","test.extend.skipIf.each","test.extend.runIf.each","bench","bench.skip","bench.only","bench.todo","bench.skipIf","bench.runIf","bench.skip.only","bench.skip.todo","bench.only.skip","bench.only.todo","bench.todo.skip","bench.todo.only","bench.skipIf.skip","bench.skipIf.only","bench.skipIf.todo","bench.runIf.skip","bench.runIf.only","bench.runIf.todo","bench.skip.only.todo","bench.skip.todo.only","bench.only.skip.todo","bench.only.todo.skip","bench.todo.skip.only","bench.todo.only.skip","bench.skipIf.skip.only","bench.skipIf.skip.todo","bench.skipIf.only.skip","bench.skipIf.only.todo","bench.skipIf.todo.skip","bench.skipIf.todo.only","bench.runIf.skip.only","bench.runIf.skip.todo","bench.runIf.only.skip","bench.runIf.only.todo","bench.runIf.todo.skip","bench.runIf.todo.only","describe","describe.skip","describe.only","describe.concurrent","describe.sequential","describe.shuffle","describe.todo","describe.skipIf","describe.runIf","describe.each","describe.skip.only","describe.skip.concurrent","describe.skip.sequential","describe.skip.shuffle","describe.skip.todo","describe.only.skip","describe.only.concurrent","describe.only.sequential","describe.only.shuffle","describe.only.todo","describe.concurrent.skip","describe.concurrent.only","describe.concurrent.sequential","describe.concurrent.shuffle","describe.concurrent.todo","describe.sequential.skip","describe.sequential.only","describe.sequential.concurrent","describe.sequential.shuffle","describe.sequential.todo","describe.shuffle.skip","describe.shuffle.only","describe.shuffle.concurrent","describe.shuffle.sequential","describe.shuffle.todo","describe.todo.skip","describe.todo.only","describe.todo.concurrent","describe.todo.sequential","describe.todo.shuffle","describe.skipIf.skip","describe.skipIf.only","describe.skipIf.concurrent","describe.skipIf.sequential","describe.skipIf.shuffle","describe.skipIf.todo","describe.runIf.skip","describe.runIf.only","describe.runIf.concurrent","describe.runIf.sequential","describe.runIf.shuffle","describe.runIf.todo","describe.skip.each","describe.only.each","describe.concurrent.each","describe.sequential.each","describe.shuffle.each","describe.todo.each","describe.skipIf.each","describe.runIf.each","describe.skip.only.concurrent","describe.skip.only.sequential","describe.skip.only.shuffle","describe.skip.only.todo","describe.skip.concurrent.only","describe.skip.concurrent.sequential","describe.skip.concurrent.shuffle","describe.skip.concurrent.todo","describe.skip.sequential.only","describe.skip.sequential.concurrent","describe.skip.sequential.shuffle","describe.skip.sequential.todo","describe.skip.shuffle.only","describe.skip.shuffle.concurrent","describe.skip.shuffle.sequential","describe.skip.shuffle.todo","describe.skip.todo.only","describe.skip.todo.concurrent","describe.skip.todo.sequential","describe.skip.todo.shuffle","describe.only.skip.concurrent","describe.only.skip.sequential","describe.only.skip.shuffle","describe.only.skip.todo","describe.only.concurrent.skip","describe.only.concurrent.sequential","describe.only.concurrent.shuffle","describe.only.concurrent.todo","describe.only.sequential.skip","describe.only.sequential.concurrent","describe.only.sequential.shuffle","describe.only.sequential.todo","describe.only.shuffle.skip","describe.only.shuffle.concurrent","describe.only.shuffle.sequential","describe.only.shuffle.todo","describe.only.todo.skip","describe.only.todo.concurrent","describe.only.todo.sequential","describe.only.todo.shuffle","describe.concurrent.skip.only","describe.concurrent.skip.sequential","describe.concurrent.skip.shuffle","describe.concurrent.skip.todo","describe.concurrent.only.skip","describe.concurrent.only.sequential","describe.concurrent.only.shuffle","describe.concurrent.only.todo","describe.concurrent.sequential.skip","describe.concurrent.sequential.only","describe.concurrent.sequential.shuffle","describe.concurrent.sequential.todo","describe.concurrent.shuffle.skip","describe.concurrent.shuffle.only","describe.concurrent.shuffle.sequential","describe.concurrent.shuffle.todo","describe.concurrent.todo.skip","describe.concurrent.todo.only","describe.concurrent.todo.sequential","describe.concurrent.todo.shuffle","describe.sequential.skip.only","describe.sequential.skip.concurrent","describe.sequential.skip.shuffle","describe.sequential.skip.todo","describe.sequential.only.skip","describe.sequential.only.concurrent","describe.sequential.only.shuffle","describe.sequential.only.todo","describe.sequential.concurrent.skip","describe.sequential.concurrent.only","describe.sequential.concurrent.shuffle","describe.sequential.concurrent.todo","describe.sequential.shuffle.skip","describe.sequential.shuffle.only","describe.sequential.shuffle.concurrent","describe.sequential.shuffle.todo","describe.sequential.todo.skip","describe.sequential.todo.only","describe.sequential.todo.concurrent","describe.sequential.todo.shuffle","describe.shuffle.skip.only","describe.shuffle.skip.concurrent","describe.shuffle.skip.sequential","describe.shuffle.skip.todo","describe.shuffle.only.skip","describe.shuffle.only.concurrent","describe.shuffle.only.sequential","describe.shuffle.only.todo","describe.shuffle.concurrent.skip","describe.shuffle.concurrent.only","describe.shuffle.concurrent.sequential","describe.shuffle.concurrent.todo","describe.shuffle.sequential.skip","describe.shuffle.sequential.only","describe.shuffle.sequential.concurrent","describe.shuffle.sequential.todo","describe.shuffle.todo.skip","describe.shuffle.todo.only","describe.shuffle.todo.concurrent","describe.shuffle.todo.sequential","describe.todo.skip.only","describe.todo.skip.concurrent","describe.todo.skip.sequential","describe.todo.skip.shuffle","describe.todo.only.skip","describe.todo.only.concurrent","describe.todo.only.sequential","describe.todo.only.shuffle","describe.todo.concurrent.skip","describe.todo.concurrent.only","describe.todo.concurrent.sequential","describe.todo.concurrent.shuffle","describe.todo.sequential.skip","describe.todo.sequential.only","describe.todo.sequential.concurrent","describe.todo.sequential.shuffle","describe.todo.shuffle.skip","describe.todo.shuffle.only","describe.todo.shuffle.concurrent","describe.todo.shuffle.sequential","describe.skipIf.skip.only","describe.skipIf.skip.concurrent","describe.skipIf.skip.sequential","describe.skipIf.skip.shuffle","describe.skipIf.skip.todo","describe.skipIf.only.skip","describe.skipIf.only.concurrent","describe.skipIf.only.sequential","describe.skipIf.only.shuffle","describe.skipIf.only.todo","describe.skipIf.concurrent.skip","describe.skipIf.concurrent.only","describe.skipIf.concurrent.sequential","describe.skipIf.concurrent.shuffle","describe.skipIf.concurrent.todo","describe.skipIf.sequential.skip","describe.skipIf.sequential.only","describe.skipIf.sequential.concurrent","describe.skipIf.sequential.shuffle","describe.skipIf.sequential.todo","describe.skipIf.shuffle.skip","describe.skipIf.shuffle.only","describe.skipIf.shuffle.concurrent","describe.skipIf.shuffle.sequential","describe.skipIf.shuffle.todo","describe.skipIf.todo.skip","describe.skipIf.todo.only","describe.skipIf.todo.concurrent","describe.skipIf.todo.sequential","describe.skipIf.todo.shuffle","describe.runIf.skip.only","describe.runIf.skip.concurrent","describe.runIf.skip.sequential","describe.runIf.skip.shuffle","describe.runIf.skip.todo","describe.runIf.only.skip","describe.runIf.only.concurrent","describe.runIf.only.sequential","describe.runIf.only.shuffle","describe.runIf.only.todo","describe.runIf.concurrent.skip","describe.runIf.concurrent.only","describe.runIf.concurrent.sequential","describe.runIf.concurrent.shuffle","describe.runIf.concurrent.todo","describe.runIf.sequential.skip","describe.runIf.sequential.only","describe.runIf.sequential.concurrent","describe.runIf.sequential.shuffle","describe.runIf.sequential.todo","describe.runIf.shuffle.skip","describe.runIf.shuffle.only","describe.runIf.shuffle.concurrent","describe.runIf.shuffle.sequential","describe.runIf.shuffle.todo","describe.runIf.todo.skip","describe.runIf.todo.only","describe.runIf.todo.concurrent","describe.runIf.todo.sequential","describe.runIf.todo.shuffle","describe.skip.only.each","describe.skip.concurrent.each","describe.skip.sequential.each","describe.skip.shuffle.each","describe.skip.todo.each","describe.only.skip.each","describe.only.concurrent.each","describe.only.sequential.each","describe.only.shuffle.each","describe.only.todo.each","describe.concurrent.skip.each","describe.concurrent.only.each","describe.concurrent.sequential.each","describe.concurrent.shuffle.each","describe.concurrent.todo.each","describe.sequential.skip.each","describe.sequential.only.each","describe.sequential.concurrent.each","describe.sequential.shuffle.each","describe.sequential.todo.each","describe.shuffle.skip.each","describe.shuffle.only.each","describe.shuffle.concurrent.each","describe.shuffle.sequential.each","describe.shuffle.todo.each","describe.todo.skip.each","describe.todo.only.each","describe.todo.concurrent.each","describe.todo.sequential.each","describe.todo.shuffle.each","describe.skipIf.skip.each","describe.skipIf.only.each","describe.skipIf.concurrent.each","describe.skipIf.sequential.each","describe.skipIf.shuffle.each","describe.skipIf.todo.each","describe.runIf.skip.each","describe.runIf.only.each","describe.runIf.concurrent.each","describe.runIf.sequential.each","describe.runIf.shuffle.each","describe.runIf.todo.each","suite","suite.skip","suite.only","suite.concurrent","suite.sequential","suite.shuffle","suite.todo","suite.skipIf","suite.runIf","suite.each","suite.skip.only","suite.skip.concurrent","suite.skip.sequential","suite.skip.shuffle","suite.skip.todo","suite.only.skip","suite.only.concurrent","suite.only.sequential","suite.only.shuffle","suite.only.todo","suite.concurrent.skip","suite.concurrent.only","suite.concurrent.sequential","suite.concurrent.shuffle","suite.concurrent.todo","suite.sequential.skip","suite.sequential.only","suite.sequential.concurrent","suite.sequential.shuffle","suite.sequential.todo","suite.shuffle.skip","suite.shuffle.only","suite.shuffle.concurrent","suite.shuffle.sequential","suite.shuffle.todo","suite.todo.skip","suite.todo.only","suite.todo.concurrent","suite.todo.sequential","suite.todo.shuffle","suite.skipIf.skip","suite.skipIf.only","suite.skipIf.concurrent","suite.skipIf.sequential","suite.skipIf.shuffle","suite.skipIf.todo","suite.runIf.skip","suite.runIf.only","suite.runIf.concurrent","suite.runIf.sequential","suite.runIf.shuffle","suite.runIf.todo","suite.skip.each","suite.only.each","suite.concurrent.each","suite.sequential.each","suite.shuffle.each","suite.todo.each","suite.skipIf.each","suite.runIf.each","suite.skip.only.concurrent","suite.skip.only.sequential","suite.skip.only.shuffle","suite.skip.only.todo","suite.skip.concurrent.only","suite.skip.concurrent.sequential","suite.skip.concurrent.shuffle","suite.skip.concurrent.todo","suite.skip.sequential.only","suite.skip.sequential.concurrent","suite.skip.sequential.shuffle","suite.skip.sequential.todo","suite.skip.shuffle.only","suite.skip.shuffle.concurrent","suite.skip.shuffle.sequential","suite.skip.shuffle.todo","suite.skip.todo.only","suite.skip.todo.concurrent","suite.skip.todo.sequential","suite.skip.todo.shuffle","suite.only.skip.concurrent","suite.only.skip.sequential","suite.only.skip.shuffle","suite.only.skip.todo","suite.only.concurrent.skip","suite.only.concurrent.sequential","suite.only.concurrent.shuffle","suite.only.concurrent.todo","suite.only.sequential.skip","suite.only.sequential.concurrent","suite.only.sequential.shuffle","suite.only.sequential.todo","suite.only.shuffle.skip","suite.only.shuffle.concurrent","suite.only.shuffle.sequential","suite.only.shuffle.todo","suite.only.todo.skip","suite.only.todo.concurrent","suite.only.todo.sequential","suite.only.todo.shuffle","suite.concurrent.skip.only","suite.concurrent.skip.sequential","suite.concurrent.skip.shuffle","suite.concurrent.skip.todo","suite.concurrent.only.skip","suite.concurrent.only.sequential","suite.concurrent.only.shuffle","suite.concurrent.only.todo","suite.concurrent.sequential.skip","suite.concurrent.sequential.only","suite.concurrent.sequential.shuffle","suite.concurrent.sequential.todo","suite.concurrent.shuffle.skip","suite.concurrent.shuffle.only","suite.concurrent.shuffle.sequential","suite.concurrent.shuffle.todo","suite.concurrent.todo.skip","suite.concurrent.todo.only","suite.concurrent.todo.sequential","suite.concurrent.todo.shuffle","suite.sequential.skip.only","suite.sequential.skip.concurrent","suite.sequential.skip.shuffle","suite.sequential.skip.todo","suite.sequential.only.skip","suite.sequential.only.concurrent","suite.sequential.only.shuffle","suite.sequential.only.todo","suite.sequential.concurrent.skip","suite.sequential.concurrent.only","suite.sequential.concurrent.shuffle","suite.sequential.concurrent.todo","suite.sequential.shuffle.skip","suite.sequential.shuffle.only","suite.sequential.shuffle.concurrent","suite.sequential.shuffle.todo","suite.sequential.todo.skip","suite.sequential.todo.only","suite.sequential.todo.concurrent","suite.sequential.todo.shuffle","suite.shuffle.skip.only","suite.shuffle.skip.concurrent","suite.shuffle.skip.sequential","suite.shuffle.skip.todo","suite.shuffle.only.skip","suite.shuffle.only.concurrent","suite.shuffle.only.sequential","suite.shuffle.only.todo","suite.shuffle.concurrent.skip","suite.shuffle.concurrent.only","suite.shuffle.concurrent.sequential","suite.shuffle.concurrent.todo","suite.shuffle.sequential.skip","suite.shuffle.sequential.only","suite.shuffle.sequential.concurrent","suite.shuffle.sequential.todo","suite.shuffle.todo.skip","suite.shuffle.todo.only","suite.shuffle.todo.concurrent","suite.shuffle.todo.sequential","suite.todo.skip.only","suite.todo.skip.concurrent","suite.todo.skip.sequential","suite.todo.skip.shuffle","suite.todo.only.skip","suite.todo.only.concurrent","suite.todo.only.sequential","suite.todo.only.shuffle","suite.todo.concurrent.skip","suite.todo.concurrent.only","suite.todo.concurrent.sequential","suite.todo.concurrent.shuffle","suite.todo.sequential.skip","suite.todo.sequential.only","suite.todo.sequential.concurrent","suite.todo.sequential.shuffle","suite.todo.shuffle.skip","suite.todo.shuffle.only","suite.todo.shuffle.concurrent","suite.todo.shuffle.sequential","suite.skipIf.skip.only","suite.skipIf.skip.concurrent","suite.skipIf.skip.sequential","suite.skipIf.skip.shuffle","suite.skipIf.skip.todo","suite.skipIf.only.skip","suite.skipIf.only.concurrent","suite.skipIf.only.sequential","suite.skipIf.only.shuffle","suite.skipIf.only.todo","suite.skipIf.concurrent.skip","suite.skipIf.concurrent.only","suite.skipIf.concurrent.sequential","suite.skipIf.concurrent.shuffle","suite.skipIf.concurrent.todo","suite.skipIf.sequential.skip","suite.skipIf.sequential.only","suite.skipIf.sequential.concurrent","suite.skipIf.sequential.shuffle","suite.skipIf.sequential.todo","suite.skipIf.shuffle.skip","suite.skipIf.shuffle.only","suite.skipIf.shuffle.concurrent","suite.skipIf.shuffle.sequential","suite.skipIf.shuffle.todo","suite.skipIf.todo.skip","suite.skipIf.todo.only","suite.skipIf.todo.concurrent","suite.skipIf.todo.sequential","suite.skipIf.todo.shuffle","suite.runIf.skip.only","suite.runIf.skip.concurrent","suite.runIf.skip.sequential","suite.runIf.skip.shuffle","suite.runIf.skip.todo","suite.runIf.only.skip","suite.runIf.only.concurrent","suite.runIf.only.sequential","suite.runIf.only.shuffle","suite.runIf.only.todo","suite.runIf.concurrent.skip","suite.runIf.concurrent.only","suite.runIf.concurrent.sequential","suite.runIf.concurrent.shuffle","suite.runIf.concurrent.todo","suite.runIf.sequential.skip","suite.runIf.sequential.only","suite.runIf.sequential.concurrent","suite.runIf.sequential.shuffle","suite.runIf.sequential.todo","suite.runIf.shuffle.skip","suite.runIf.shuffle.only","suite.runIf.shuffle.concurrent","suite.runIf.shuffle.sequential","suite.runIf.shuffle.todo","suite.runIf.todo.skip","suite.runIf.todo.only","suite.runIf.todo.concurrent","suite.runIf.todo.sequential","suite.runIf.todo.shuffle","suite.skip.only.each","suite.skip.concurrent.each","suite.skip.sequential.each","suite.skip.shuffle.each","suite.skip.todo.each","suite.only.skip.each","suite.only.concurrent.each","suite.only.sequential.each","suite.only.shuffle.each","suite.only.todo.each","suite.concurrent.skip.each","suite.concurrent.only.each","suite.concurrent.sequential.each","suite.concurrent.shuffle.each","suite.concurrent.todo.each","suite.sequential.skip.each","suite.sequential.only.each","suite.sequential.concurrent.each","suite.sequential.shuffle.each","suite.sequential.todo.each","suite.shuffle.skip.each","suite.shuffle.only.each","suite.shuffle.concurrent.each","suite.shuffle.sequential.each","suite.shuffle.todo.each","suite.todo.skip.each","suite.todo.only.each","suite.todo.concurrent.each","suite.todo.sequential.each","suite.todo.shuffle.each","suite.skipIf.skip.each","suite.skipIf.only.each","suite.skipIf.concurrent.each","suite.skipIf.sequential.each","suite.skipIf.shuffle.each","suite.skipIf.todo.each","suite.runIf.skip.each","suite.runIf.only.each","suite.runIf.concurrent.each","suite.runIf.sequential.each","suite.runIf.shuffle.each","suite.runIf.todo.each","xtest","xtest.each","xit","xit.each","fit","xdescribe","xdescribe.each","fdescribe"]),isTypeOfVitestFnCall=(d,Y,q)=>{const B=parseVitestFnCall(d,Y);return B!==null&&q.includes(B.type)},parseVitestFnCall=(d,Y)=>{const q=parseVitestFnCallWithReason(d,Y);return typeof q=="string"?null:q},y$4=new WeakMap,parseVitestFnCallWithReason=(d,Y)=>{let q=y$4.get(d);return q||(q=P$2(d,Y),y$4.set(d,q),q)},F=d=>d==="expect"?"expect":d==="expectTypeOf"?"expectTypeOf":d==="vi"?"vi":DescribeAlias.hasOwnProperty(d)?"describe":TestCaseName.hasOwnProperty(d)?"test":HookName.hasOwnProperty(d)?"hook":"unknown",A$3=d=>{const Y=[];for(const q of d){if(q.parent?.type===utils.AST_NODE_TYPES.MemberExpression&&q.parent.parent?.type===utils.AST_NODE_TYPES.CallExpression)return{matcher:q,args:q.parent.parent.arguments,modifiers:Y};const B=getAccessorValue(q);if(Y.length===0){if(!ModifierName.hasOwnProperty(B))return"modifier-unknown"}else if(Y.length===1){if(B!==ModifierName.not&&B!=ModifierName.have)return"modifier-unknown";const H=getAccessorValue(Y[0]);if(H!==ModifierName.resolves&&H!==ModifierName.rejects&&H!==ModifierName.to)return"modifier-unknown"}else return"modifier-unknown";Y.push(q)}return"matcher-not-found"},w$2=(d,Y)=>{const q=A$3(d.members);return typeof q=="string"?q:{...d,type:Y,...q}},findTopMostCallExpression=d=>{let Y=d,{parent:q}=d;for(;q;){if(q.type===utils.AST_NODE_TYPES.CallExpression){Y=q,q=q.parent;continue}if(q.type!==utils.AST_NODE_TYPES.MemberExpression)break;q=q.parent}return Y},P$2=(d,Y)=>{const q=getNodeChain(d);if(!q?.length)return null;const[B,...H]=q,V=getAccessorValue(q[q.length-1]);if(V==="each"&&d.callee.type!==utils.AST_NODE_TYPES.CallExpression&&d.callee.type!==utils.AST_NODE_TYPES.TaggedTemplateExpression||d.callee.type===utils.AST_NODE_TYPES.TaggedTemplateExpression&&V!=="each")return null;const K=k$1(Y,d,getAccessorValue(B));if(!K)return null;const X=K.original??K.local,z=[X,...H.map(getAccessorValue)];if(K.type!=="testContext"&&X!=="vi"&&X!=="expect"&&X!=="expectTypeOf"&&!ValidVitestFnCallChains.has(z.join(".")))return null;const J={name:X,head:{...K,node:B},members:H},Q=F(X);if(Q==="expect"||Q==="expectTypeOf"){const G=w$2(J,Q);return typeof G=="string"&&findTopMostCallExpression(d)!==d?null:G==="matcher-not-found"&&d.parent?.type===utils.AST_NODE_TYPES.MemberExpression?"matcher-not-called":G}return q.slice(0,q.length-1).some(G=>G.parent?.type!==utils.AST_NODE_TYPES.MemberExpression)||d.parent?.type===utils.AST_NODE_TYPES.CallExpression||d.parent?.type===utils.AST_NODE_TYPES.MemberExpression?null:{...J,type:Q}},M$3=(d,Y)=>d&&Y?[...d,...Y]:null;function getNodeChain(d){if(isSupportedAccessor(d))return[d];switch(d.type){case utils.AST_NODE_TYPES.TaggedTemplateExpression:return getNodeChain(d.tag);case utils.AST_NODE_TYPES.MemberExpression:return M$3(getNodeChain(d.object),getNodeChain(d.property));case utils.AST_NODE_TYPES.CallExpression:return getNodeChain(d.callee)}return null}const k$1=(d,Y,q)=>{const B=d.sourceCode.getScope?d.sourceCode.getScope(Y):d.getScope(),H=resolveScope(B,q);return H==="local"?null:H==="testContext"?{local:q,original:null,type:"testContext"}:H?H.source==="vitest"?{original:H.imported,local:H.local,type:"import"}:null:{original:N$5(q,d),local:q,type:"global"}},N$5=(d,Y)=>{const q=Y.settings.vitest?.globalAliases??{},B=Object.entries(q).find(([H,V])=>V.includes(d));return B?B[0]:null},I$1=({parent:d})=>{if(d?.type===utils.AST_NODE_TYPES.CallExpression&&d.callee.type===utils.AST_NODE_TYPES.Identifier)return TestCaseName.hasOwnProperty(d.callee.name)},resolveScope=(d,Y)=>{let q=d;for(;q!==null;){const B=q.set.get(Y);if(B&&B.defs.length>0){const H=B.defs[B.defs.length-1],V=isFunction(H.node)?H.node.params.find(z=>z.type===utils.AST_NODE_TYPES.ObjectPattern):void 0;if(V){const z=V.properties.find(J=>J.type===utils.AST_NODE_TYPES.Property);if((z?.key.type===utils.AST_NODE_TYPES.Identifier?z.key:void 0)?.name===Y)return"testContext"}const K=isFunction(H.node)?H.node.params.find(z=>z.type===utils.AST_NODE_TYPES.Identifier):void 0;if(K&&I$1(K.parent))return"testContext";const X=O$2(H);return X?.local===Y?X:"local"}q=q.upper}return null},v=d=>d.type===utils.AST_NODE_TYPES.AwaitExpression?d.argument.type===utils.AST_NODE_TYPES.ImportExpression?d.argument.source:null:d.type===utils.AST_NODE_TYPES.CallExpression&&isIdentifier(d.callee,"require")?d.arguments[0]??null:null,R=d=>d.parent.type===utils.AST_NODE_TYPES.TSImportEqualsDeclaration||d.node.type!==utils.AST_NODE_TYPES.ImportSpecifier||d.node.imported.type!=utils.AST_NODE_TYPES.Identifier||d.parent.importKind==="type"?null:{source:d.parent.source.value,imported:d.node.imported.name,local:d.node.local.name},O$2=d=>d.type==="Variable"?D$1(d):d.type==="ImportBinding"?R(d):null,D$1=d=>{if(!d.node.init)return null;const Y=v(d.node.init);return!Y||!isStringNode(Y)||d.name.parent?.type!==utils.AST_NODE_TYPES.Property||!isSupportedAccessor(d.name.parent.key)?null:{source:getStringValue(Y),imported:getAccessorValue(d.name.parent.key),local:d.name.name}},getTestCallExpressionsFromDeclaredVariables=(d,Y)=>d.reduce((q,{references:B})=>q.concat(B.map(({identifier:H})=>H.parent).filter(H=>H?.type===utils.AST_NODE_TYPES.CallExpression&&isTypeOfVitestFnCall(H,Y,["test"]))),[]),getFirstMatcherArg=d=>{const[Y]=d.args;return Y.type===utils.AST_NODE_TYPES.SpreadElement?Y:followTypeAssertionChain$1(Y)},L$1=d=>d.type===utils.AST_NODE_TYPES.TSAsExpression||d.type===utils.AST_NODE_TYPES.TSTypeAssertion,followTypeAssertionChain$1=d=>L$1(d)?followTypeAssertionChain$1(d.expression):d,RULE_NAME$$="prefer-lowercase-title",E$4=d=>d.arguments[0]&&isStringNode(d.arguments[0]),x$4=d=>{const Y=[];return d.includes(DescribeAlias.describe)&&Y.push(...Object.keys(DescribeAlias)),d.includes(TestCaseName.test)&&Y.push(...Object.keys(TestCaseName).filter(q=>q.endsWith(TestCaseName.test))),d.includes(TestCaseName.it)&&Y.push(...Object.keys(TestCaseName).filter(q=>q.endsWith(TestCaseName.it))),Y},we=createEslintRule({name:RULE_NAME$$,meta:{type:"problem",docs:{description:"enforce lowercase titles",recommended:!1},fixable:"code",messages:{lowerCaseTitle:"`{{ method }}`s should begin with lowercase",fullyLowerCaseTitle:"`{{ method }}`s should be lowercase"},schema:[{type:"object",properties:{ignore:{type:"array",items:{type:"string",enum:[DescribeAlias.describe,TestCaseName.test,TestCaseName.it]}},allowedPrefixes:{type:"array",items:{type:"string"},additionalItems:!1},ignoreTopLevelDescribe:{type:"boolean",default:!1},lowercaseFirstCharacterOnly:{type:"boolean",default:!0}},additionalProperties:!1}]},defaultOptions:[{ignore:[],allowedPrefixes:[],ignoreTopLevelDescribe:!1,lowercaseFirstCharacterOnly:!0}],create:(d,[{ignore:Y=[],allowedPrefixes:q=[],ignoreTopLevelDescribe:B=!1,lowercaseFirstCharacterOnly:H=!1}])=>{const V=x$4(Y);let K=0;return{CallExpression(X){const z=parseVitestFnCall(X,d);if(!z||!E$4)return;if(z?.type==="describe"){if(K++,B&&K===1)return}else if(z?.type!=="test")return;const[J]=X.arguments,Q=getStringValue(J);if(typeof Q!="string"||q.some(ee=>Q.startsWith(ee)))return;const G=Q.charAt(0);V.includes(z.name)||H&&(!G||G===G.toLowerCase())||!H&&Q===Q.toLowerCase()||d.report({messageId:H?"lowerCaseTitle":"fullyLowerCaseTitle",node:X.arguments[0],data:{method:z.name},fix:ee=>{const Z=getStringValue(J),oe=[J.range[0]+1,J.range[1]-1],te=H?Z.substring(0,1).toLowerCase()+Z.substring(1):Z.toLowerCase();return[ee.replaceTextRange(oe,te)]}})},"CallExpression:exit"(X){isTypeOfVitestFnCall(X,d,["describe"])&&K--}}}}),RULE_NAME$_="max-nested-describe",Re=createEslintRule({name:RULE_NAME$_,meta:{type:"problem",docs:{description:"require describe block to be less than set max value or default value",recommended:!1},schema:[{type:"object",properties:{max:{type:"number"}},additionalProperties:!1}],messages:{maxNestedDescribe:"Nested describe block should be less than set max value"}},defaultOptions:[{max:5}],create(d,[{max:Y}]){const q=[];function B(V){V.parent?.type==="CallExpression"&&(V.parent.callee.type!=="Identifier"||V.parent.callee.name!=="describe"||(q.push(0),q.length>Y&&d.report({node:V.parent,messageId:"maxNestedDescribe"})))}function H(V){V.parent?.type==="CallExpression"&&(V.parent.callee.type!=="Identifier"||V.parent.callee.name!=="describe"||q.pop())}return{FunctionExpression:B,"FunctionExpression:exit":H,ArrowFunctionExpression:B,"ArrowFunctionExpression:exit":H}}}),RULE_NAME$Z="no-identical-title",c$4=()=>({describeTitles:[],testTitles:[]}),Le=createEslintRule({name:RULE_NAME$Z,meta:{type:"problem",docs:{description:"disallow identical titles",recommended:!1},fixable:"code",schema:[],messages:{multipleTestTitle:"Test is used multiple times in the same describe(suite) block",multipleDescribeTitle:"Describe is used multiple times in the same describe(suite) block"}},defaultOptions:[],create(d){const Y=[c$4()];return{CallExpression(q){const B=Y[Y.length-1],H=parseVitestFnCall(q,d);if(!H||((H.name==="describe"||H.name==="suite")&&Y.push(c$4()),H.members.find(X=>isSupportedAccessor(X,"each"))))return;const[V]=q.arguments;if(!V||!isStringNode(V))return;const K=getStringValue(V);H.type==="test"&&(B?.testTitles.includes(K)&&d.report({node:q,messageId:"multipleTestTitle"}),B?.testTitles.push(K)),H.type==="describe"&&(B?.describeTitles.includes(K)&&d.report({node:q,messageId:"multipleDescribeTitle"}),B?.describeTitles.push(K))},"CallExpression:exit"(q){isTypeOfVitestFnCall(q,d,["describe"])&&Y.pop()}}}}),RULE_NAME$Y="no-focused-tests",n$2=d=>d.type==="Identifier"&&["it","test","describe"].includes(d.name),a$6=d=>d.type==="Identifier"&&d.name==="only",Te=createEslintRule({name:RULE_NAME$Y,meta:{type:"problem",docs:{description:"disallow focused tests",recommended:!1},fixable:"code",schema:[{type:"object",properties:{fixable:{type:"boolean",default:!0}},additionalProperties:!1}],messages:{noFocusedTests:"Focused tests are not allowed"}},defaultOptions:[{fixable:!0}],create:d=>{const Y=d.options[0]?.fixable;return{ExpressionStatement(q){if(q.expression.type==="CallExpression"){const{callee:B}=q.expression;if(B.type==="MemberExpression"&&n$2(B.object)&&a$6(B.property)&&d.report({node:B.property,messageId:"noFocusedTests",fix:H=>Y?H.removeRange([B.property.range[0]-1,B.property.range[1]]):null}),B.type==="TaggedTemplateExpression"){const H=B.tag.type==="MemberExpression"?B.tag.object:null;if(!H)return;H.type==="MemberExpression"&&n$2(H.object)&&a$6(H.property)&&d.report({node:H.property,messageId:"noFocusedTests",fix:V=>Y?V.removeRange([H.property.range[0]-1,H.property.range[1]]):null})}}},CallExpression(q){if(q.callee.type==="CallExpression"){const{callee:B}=q.callee;if(B.type==="MemberExpression"&&B.object.type==="MemberExpression"&&n$2(B.object.object)&&a$6(B.object.property)&&B.property.type==="Identifier"&&B.property.name==="each"){const H=B.object.property;d.report({node:B.object.property,messageId:"noFocusedTests",fix:V=>Y?V.removeRange([H.range[0]-1,H.range[1]]):null})}}}}}}),RULE_NAME$X="no-conditional-tests",Ue=createEslintRule({name:RULE_NAME$X,meta:{type:"problem",docs:{description:"disallow conditional tests",recommended:!1},schema:[],messages:{noConditionalTests:"Avoid using if conditions in a test"}},defaultOptions:[],create(d){return{Identifier:function(Y){["test","it","describe"].includes(Y.name)&&Y.parent?.parent?.parent?.parent?.type==="IfStatement"&&d.report({node:Y,messageId:"noConditionalTests"})}}}}),i$2={typecheck:!1};function parsePluginSettings(d){const Y=typeof d.vitest!="object"||d.vitest===null?{}:d.vitest;return{...i$2,...Y}}const RULE_NAME$W="expect-expect",_e=createEslintRule({name:RULE_NAME$W,meta:{type:"suggestion",docs:{description:"enforce having expectation in test body",recommended:!1},schema:[{type:"object",properties:{assertFunctionNames:{type:"array",items:{type:"string"}},additionalTestBlockFunctions:{type:"array",items:{type:"string"}}},additionalProperties:!1}],messages:{noAssertions:"Test has no assertions"}},defaultOptions:[{assertFunctionNames:["expect","assert"],additionalTestBlockFunctions:[]}],create(d,[{assertFunctionNames:Y=["expect"],additionalTestBlockFunctions:q=[]}]){const B=[];parsePluginSettings(d.settings).typecheck&&Y.push("expectTypeOf","assertType");const H=Y.map(x$3);function V(K){for(const X of K){const z=X.type===utils.AST_NODE_TYPES.CallExpression?B.indexOf(X):-1;if(X.type===utils.AST_NODE_TYPES.FunctionDeclaration){const J=d.sourceCode.getDeclaredVariables(X),Q=getTestCallExpressionsFromDeclaredVariables(J,d);V(Q)}if(z!==-1){B.splice(z,1);break}}}return{CallExpression(K){if(K.callee.type===utils.AST_NODE_TYPES.Identifier&&K.callee.name==="bench"||K?.callee?.type===utils.AST_NODE_TYPES.MemberExpression&&K.callee.property.type===utils.AST_NODE_TYPES.Identifier&&K.callee.property.name==="extend"||K?.callee?.type===utils.AST_NODE_TYPES.MemberExpression&&K.callee.property.type===utils.AST_NODE_TYPES.Identifier&&K.callee.property.name==="skip")return;const X=getNodeName(K)??"";if(isTypeOfVitestFnCall(K,d,["test"])||q.includes(X)){if(K.callee.type===utils.AST_NODE_TYPES.MemberExpression&&isSupportedAccessor(K.callee.property,"todo"))return;B.push(K)}else H.some(z=>z.test(X))&&V(d.sourceCode.getAncestors(K))},"Program:exit"(){B.forEach(K=>{d.report({node:K.callee,messageId:"noAssertions"})})}}}});function x$3(d){const Y=d.split(".").map(q=>q==="**"?"[_a-z\\d\\.]*":q.replace(/\*/gu,"[a-z\\d]*"));return new RegExp(`^${Y.join("\\.")}(\\.|$)`,"ui")}const RULE_NAME$V="consistent-test-it",g$1=(d,Y,q)=>B=>[B.replaceText(d.type===utils.AST_NODE_TYPES.MemberExpression?d.object:d,E$3(Y,q))];function E$3(d,Y){return d===TestCaseName.fit?"test.only":d.startsWith("f")||d.startsWith("x")?d.charAt(0)+Y:Y}function u$4(d){return d===TestCaseName.test?TestCaseName.it:TestCaseName.test}const he=createEslintRule({name:RULE_NAME$V,meta:{type:"suggestion",fixable:"code",docs:{description:"enforce using test or it but not both",recommended:!1},messages:{consistentMethod:"Prefer using {{ testFnKeyWork }} instead of {{ oppositeTestKeyword }}",consistentMethodWithinDescribe:"Prefer using {{ testKeywordWithinDescribe }} instead of {{ oppositeTestKeyword }} within describe"},schema:[{type:"object",properties:{fn:{type:"string",enum:[TestCaseName.test,TestCaseName.it]},withinDescribe:{type:"string",enum:[TestCaseName.test,TestCaseName.it]}},additionalProperties:!1}]},defaultOptions:[{fn:TestCaseName.test,withinDescribe:TestCaseName.it}],create(d){const Y=d.options[0]??{},q=Y.fn||TestCaseName.test,B=Y?.withinDescribe||Y?.fn||TestCaseName?.it,H=q===B?q:void 0;let V=0;return{ImportDeclaration(K){if(H==null||K.source.type!=="Literal"||K.source.value!=="vitest")return;const X=u$4(H);for(const z of K.specifiers)z.type==="ImportSpecifier"&&z.imported.type==="Identifier"&&z.local.name===z.imported.name&&z.local.name===X&&d.report({node:z,data:{testFnKeyWork:q,oppositeTestKeyword:X},messageId:"consistentMethod",fix:J=>{const Q=K.specifiers.filter(G=>G.local.name!==X);if(Q.length>0){const G=Q.map(Z=>Z.local.name).join(", "),ee=K.specifiers.at(-1)?.range;return ee?J.replaceTextRange([K.specifiers[0].range[0],ee[1]],G):null}return J.replaceText(z.local,H)}})},CallExpression(K){if(K.callee.type===utils.AST_NODE_TYPES.Identifier&&K.callee.name==="bench")return;const X=parseVitestFnCall(K,d);if(!X)return;if(X.type==="describe"){V++;return}const z=K.callee.type===utils.AST_NODE_TYPES.TaggedTemplateExpression?K.callee.tag:K.callee.type===utils.AST_NODE_TYPES.CallExpression?K.callee.callee:K.callee;if(X.type==="test"&&V===0&&!X.name.endsWith(q)){const J=u$4(q);d.report({node:K.callee,data:{testFnKeyWork:q,oppositeTestKeyword:J},messageId:"consistentMethod",fix:g$1(z,X.name,q)})}else if(X.type==="test"&&V>0&&!X.name.endsWith(B)){const J=u$4(B);d.report({messageId:"consistentMethodWithinDescribe",node:K.callee,data:{testKeywordWithinDescribe:B,oppositeTestKeyword:J},fix:g$1(z,X.name,B)})}},"CallExpression:exit"(K){isTypeOfVitestFnCall(K,d,["describe"])&&V--}}}}),RULE_NAME$U="prefer-to-be",E$2=d=>d.type===utils.AST_NODE_TYPES.Literal&&d.value===null,N$4=d=>E$2(getFirstMatcherArg(d)),c$3=(d,Y)=>isIdentifier(getFirstMatcherArg(d),Y),h$2=d=>Math.floor(d)!==Math.ceil(d),y$3=d=>{let Y=getFirstMatcherArg(d);return Y.type===utils.AST_NODE_TYPES.Literal&&typeof Y.value=="number"&&h$2(Y.value)?!1:(Y.type===utils.AST_NODE_TYPES.UnaryExpression&&Y.operator==="-"&&(Y=Y.argument),Y.type===utils.AST_NODE_TYPES.Literal?!("regex"in Y):Y.type===utils.AST_NODE_TYPES.TemplateLiteral)},o$2=(d,Y,q,B,H)=>{d.report({messageId:`useToBe${Y}`,fix(V){const K=[replaceAccessorFixer(V,q.matcher,`toBe${Y}`)];return q.args?.length&&Y!==""&&K.push(removeExtraArgumentsFixer(V,d,B,0)),H&&K.push(V.removeRange([H.range[0]-1,H.range[1]])),K},node:q.matcher})},ge=createEslintRule({name:RULE_NAME$U,meta:{type:"suggestion",docs:{description:"enforce using toBe()",recommended:!1},schema:[],fixable:"code",messages:{useToBe:"Use `toBe` instead",useToBeUndefined:"Use `toBeUndefined()` instead",useToBeDefined:"Use `toBeDefined()` instead",useToBeNull:"Use `toBeNull()` instead",useToBeNaN:"Use `toBeNaN()` instead"}},defaultOptions:[],create(d){return{CallExpression(Y){const q=parseVitestFnCall(Y,d);if(q?.type!=="expect")return;const B=getAccessorValue(q.matcher),H=q.modifiers.find(V=>getAccessorValue(V)==="not");if(H&&["toBeUndefined","toBeDefined"].includes(B)){o$2(d,B==="toBeDefined"?"Undefined":"Defined",q,Y,H);return}if(!(!EqualityMatcher.hasOwnProperty(B)||q.args.length===0)){if(N$4(q)){o$2(d,"Null",q,Y);return}if(c$3(q,"undefined")){o$2(d,H?"Defined":"Undefined",q,Y);return}if(c$3(q,"NaN")){o$2(d,"NaN",q,Y);return}y$3(q)&&B!==EqualityMatcher.toBe&&o$2(d,"",q,Y)}}}}}),RULE_NAME$T="no-hooks",be=createEslintRule({name:RULE_NAME$T,meta:{type:"suggestion",docs:{description:"disallow setup and teardown hooks",recommended:!1},schema:[{type:"object",properties:{allow:{type:"array",contains:["beforeAll","beforeEach","afterAll","afterEach"]}},additionalProperties:!1}],messages:{unexpectedHook:"Unexpected '{{ hookName }}' hook"}},defaultOptions:[{allow:[]}],create(d,[{allow:Y=[]}]){return{CallExpression(q){const B=parseVitestFnCall(q,d);B?.type==="hook"&&!Y.includes(B.name)&&d.report({node:q,messageId:"unexpectedHook",data:{hookName:B.name}})}}}}),RULE_NAME$S="no-restricted-vi-methods",ke=createEslintRule({name:RULE_NAME$S,meta:{type:"suggestion",docs:{description:"disallow specific `vi.` methods",recommended:!1},schema:[{type:"object",additionalProperties:{type:["string","null"]}}],messages:{restrictedViMethod:"Use of `{{ restriction }}` is disallowed",restrictedViMethodWithMessage:"{{ message }}"}},defaultOptions:[{}],create(d,[Y]){return{CallExpression(q){const B=parseVitestFnCall(q,d);if(B?.type!=="vi"||B.members.length===0)return;const H=getAccessorValue(B.members[0]);if(H in Y){const V=Y[H];d.report({messageId:V?"restrictedViMethodWithMessage":"restrictedViMethod",data:{message:V,restriction:H},loc:{start:B.members[0].loc.start,end:B.members[B.members.length-1].loc.end}})}}}}}),RULE_NAME$R="consistent-test-filename",o$1=/.*\.test\.[tj]sx?$/,e=/.*\.(test|spec)\.[tj]sx?$/,xe=createEslintRule({name:RULE_NAME$R,meta:{type:"problem",docs:{recommended:!1,requiresTypeChecking:!1,description:"require .spec test file pattern"},messages:{consistentTestFilename:"Use test file name pattern {{ pattern }}"},schema:[{type:"object",additionalProperties:!1,properties:{pattern:{format:"regex",default:o$1.source},allTestPattern:{format:"regex",default:e.source}}}]},defaultOptions:[{pattern:e.source,allTestPattern:e.source}],create:d=>{const Y=d.options[0]??{},{pattern:q=o$1,allTestPattern:B=e}=Y,H=typeof q=="string"?new RegExp(q):q,V=typeof B=="string"?new RegExp(B):B,{filename:K}=d;return V.test(K)?{Program:X=>{H.test(K)||d.report({node:X,messageId:"consistentTestFilename",data:{pattern:H.source}})}}:{}}}),RULE_NAME$Q="max-expects",ve=createEslintRule({name:RULE_NAME$Q,meta:{docs:{requiresTypeChecking:!1,recommended:!1,description:"enforce a maximum number of expect per test"},messages:{maxExpect:"Too many assertion calls ({{ count }}) - maximum allowed is {{ max }}"},type:"suggestion",schema:[{type:"object",properties:{max:{type:"number"}},additionalProperties:!1}]},defaultOptions:[{max:5}],create(d,[{max:Y}]){let q=0;const B=H=>{(H.parent?.type!==utils.AST_NODE_TYPES.CallExpression||isTypeOfVitestFnCall(H.parent,d,["test"]))&&(q=0)};return{FunctionExpression:B,"FunctionExpression:exit":B,ArrowFunctionExpression:B,"ArrowFunctionExpression:exit":B,CallExpression(H){const V=parseVitestFnCall(H,d);V?.type!=="expect"||V.head.node.parent?.type===utils.AST_NODE_TYPES.MemberExpression||(q+=1,q>Y&&d.report({node:H,messageId:"maxExpect",data:{count:q,max:Y}}))}}}}),RULE_NAME$P="no-alias-methods",Ce=createEslintRule({name:RULE_NAME$P,meta:{docs:{description:"disallow alias methods",requiresTypeChecking:!1,recommended:!1},messages:{noAliasMethods:"Replace {{ alias }}() with its canonical name {{ canonical }}()"},type:"suggestion",fixable:"code",schema:[]},defaultOptions:[],create(d){const Y={toBeCalled:"toHaveBeenCalled",toBeCalledTimes:"toHaveBeenCalledTimes",toBeCalledWith:"toHaveBeenCalledWith",lastCalledWith:"toHaveBeenLastCalledWith",nthCalledWith:"toHaveBeenNthCalledWith",toReturn:"toHaveReturned",toReturnTimes:"toHaveReturnedTimes",toReturnWith:"toHaveReturnedWith",lastReturnedWith:"toHaveLastReturnedWith",nthReturnedWith:"toHaveNthReturnedWith",toThrowError:"toThrow"};return{CallExpression(q){const B=parseVitestFnCall(q,d);if(B?.type!=="expect")return;const{matcher:H}=B,V=getAccessorValue(H);if(V in Y){const K=Y[V];d.report({messageId:"noAliasMethods",data:{alias:V,canonical:K},node:H,fix:X=>[replaceAccessorFixer(X,H,K)]})}}}}}),RULE_NAME$O="no-commented-out-tests";function n$1(d){return/^\s*[xf]?(test|it|describe)(\.\w+|\[['"]\w+['"]\])?\s*\(/mu.test(d.value)}const Be=createEslintRule({name:RULE_NAME$O,meta:{docs:{description:"disallow commented out tests",requiresTypeChecking:!1,recommended:!1},messages:{noCommentedOutTests:"Remove commented out tests - you may want to use `skip` or `only` instead"},schema:[],type:"suggestion"},defaultOptions:[],create(d){const{sourceCode:Y}=d;function q(B){n$1(B)&&d.report({messageId:"noCommentedOutTests",node:B})}return{Program(){Y.getAllComments().forEach(q)}}}}),RULE_NAME$N="no-conditional-expect",r=d=>d.callee.type===utils.AST_NODE_TYPES.MemberExpression&&isSupportedAccessor(d.callee.property,"catch"),Se=createEslintRule({name:RULE_NAME$N,meta:{type:"problem",docs:{description:"disallow conditional expects",requiresTypeChecking:!1,recommended:!1},messages:{noConditionalExpect:"Avoid calling `expect` inside conditional statements"},schema:[]},defaultOptions:[],create(d){let Y=0,q=!1,B=!1;const H=()=>q&&Y++,V=()=>q&&Y--;return{FunctionDeclaration(K){const X=d.sourceCode.getDeclaredVariables(K);getTestCallExpressionsFromDeclaredVariables(X,d).length>0&&(q=!0)},CallExpression(K){const{type:X}=parseVitestFnCall(K,d)??{};X==="test"&&(q=!0),r(K)&&(B=!0),q&&X==="expect"&&Y>0&&d.report({messageId:"noConditionalExpect",node:K}),B&&X==="expect"&&d.report({messageId:"noConditionalExpect",node:K})},"CallExpression:exit"(K){isTypeOfVitestFnCall(K,d,["test"])&&(q=!1),r(K)&&(B=!1)},CatchClause:H,"CatchClause:exit":V,IfStatement:H,"IfStatement:exit":V,SwitchStatement:H,"SwitchStatement:exit":V,ConditionalExpression:H,"ConditionalExpression:exit":V,LogicalExpression:H,"LogicalExpression:exit":V}}}),RULE_NAME$M="no-import-node-test",ye=createEslintRule({name:RULE_NAME$M,meta:{docs:{description:"disallow importing `node:test`",recommended:!1},type:"suggestion",messages:{noImportNodeTest:"Import from `vitest` instead of `node:test`"},fixable:"code",schema:[]},defaultOptions:[],create(d){return{ImportDeclaration(Y){Y.source.value==="node:test"&&d.report({messageId:"noImportNodeTest",node:Y,fix:q=>q.replaceText(Y.source,Y.source.raw.replace("node:test","vitest"))})}}}}),RULE_NAME$L="no-conditional-in-test",Ie=createEslintRule({name:RULE_NAME$L,meta:{docs:{description:"disallow conditional tests",requiresTypeChecking:!1,recommended:!1},messages:{noConditionalInTest:"Remove conditional tests"},schema:[],type:"problem"},defaultOptions:[],create(d){return{IfStatement(Y){Y.parent?.parent?.parent?.type==="CallExpression"&&isTypeOfVitestFnCall(Y.parent?.parent?.parent,d,["test","it"])&&d.report({messageId:"noConditionalInTest",node:Y})}}}}),RULE_NAME$K="no-disabled-tests",He=createEslintRule({name:RULE_NAME$K,meta:{type:"suggestion",docs:{description:"disallow disabled tests",recommended:!1},messages:{missingFunction:"Test is missing function argument",pending:"Call to pending()",pendingSuite:"Call to pending() within test suite",pendingTest:"Call to pending() within test",disabledSuite:"Disabled test suite - if you want to skip a test suite temporarily, use .todo() instead",disabledTest:"Disabled test - if you want to skip a test temporarily, use .todo() instead"},schema:[]},defaultOptions:[],create(d){let Y=0,q=0;return{CallExpression(B){const H=parseVitestFnCall(B,d);if(!H)return;H.type==="describe"&&Y++,H.type==="test"&&(q++,B.arguments.length<2&&H.members.every(K=>getAccessorValue(K)==="skip")&&d.report({messageId:"missingFunction",node:B}));const V=H.members.find(K=>getAccessorValue(K)==="skip");(H.name.startsWith("x")||V!==void 0)&&d.report({messageId:H.type==="describe"?"disabledSuite":"disabledTest",node:V??H.head.node})},"CallExpression:exit"(B){const H=parseVitestFnCall(B,d);H&&(H.type==="describe"&&Y--,H.type==="test"&&q--)},'CallExpression[callee.name="pending"]'(B){const H=d.sourceCode.getScope?d.sourceCode.getScope(B):d.getScope();resolveScope(H,"pending")||(q>0?d.report({messageId:"pendingTest",node:B}):Y>0?d.report({messageId:"pendingSuite",node:B}):d.report({messageId:"pending",node:B}))}}}}),RULE_NAME$J="no-done-callback",P$1=(d,Y,q)=>{if(Y)return d.arguments[1];const B=parseVitestFnCall(d,q);return B?.type==="hook"&&d.arguments.length>=1?d.arguments[0]:B?.type==="test"&&d.arguments.length>=2?d.arguments[1]:null},Oe=createEslintRule({name:RULE_NAME$J,meta:{type:"suggestion",docs:{description:"disallow using a callback in asynchronous tests and hooks",recommended:!1},deprecated:!0,schema:[],messages:{noDoneCallback:"Return a promise instead of relying on callback parameter",suggestWrappingInPromise:"Wrap in `new Promise({{ callback }} => ...`",useAwaitInsteadOfCallback:"Use `await` instead of callback in async function"},hasSuggestions:!0},defaultOptions:[],create(d){return{CallExpression(Y){const q=/\.each$|\.concurrent$/.test(getNodeName(Y.callee)??"");if(q&&Y.callee.type!==utils.AST_NODE_TYPES.TaggedTemplateExpression||d.sourceCode.getAncestors(Y).some(K=>K.type!==utils.AST_NODE_TYPES.CallExpression||!isTypeOfVitestFnCall(K,d,["describe","test"])?!1:K.callee.type===utils.AST_NODE_TYPES.MemberExpression&&isSupportedAccessor(K.callee.property,"concurrent")))return;const B=P$1(Y,q,d),H=Number(q);if(!B||!isFunction(B)||B.params.length!==1+H)return;const V=B.params[H];if(V.type!==utils.AST_NODE_TYPES.Identifier){d.report({node:V,messageId:"noDoneCallback"});return}if(B.async){d.report({node:V,messageId:"useAwaitInsteadOfCallback"});return}d.report({node:Y,messageId:"noDoneCallback",suggest:[{messageId:"suggestWrappingInPromise",data:{callback:V.name},fix(K){const{body:X,params:z}=B,{sourceCode:J}=d,Q=J.getFirstToken(X),G=J.getLastToken(X),[ee]=z,Z=z[z.length-1],oe=J.getTokenBefore(ee);let te=J.getTokenAfter(Z);if(te?.value===","&&(te=J.getTokenAfter(te)),!Q||!G||!oe||!te)throw new Error(`Unexpected null when attempting to fix ${d.filename} - please file an issue at https://github/veritem/eslint-plugin-vitest`);let se=K.replaceText(ee,"()");oe.value==="("&&te.value===")"&&(se=K.removeRange([oe.range[1],te.range[0]]));let ie=`new Promise(${V.name} => `,re=")",ne=!0;return X.type===utils.AST_NODE_TYPES.BlockStatement&&(ie=`return ${ie}{`,re+="}",ne=!1),[se,ne?K.insertTextBefore(Q,ie):K.insertTextAfter(Q,ie),K.insertTextAfter(G,re)]}}]})}}}}),RULE_NAME$I="no-duplicate-hooks",qe=createEslintRule({name:RULE_NAME$I,meta:{docs:{recommended:!1,description:"disallow duplicate hooks and teardown hooks",requiresTypeChecking:!1},messages:{noDuplicateHooks:"Duplicate {{ hook }} in describe block"},schema:[],type:"suggestion"},defaultOptions:[],create(d){const Y=[{}];return{CallExpression(q){const B=parseVitestFnCall(q,d);if(B?.type==="describe"&&Y.push({}),B?.type!=="hook")return;const H=Y[Y.length-1];H[B.name]||=0,H[B.name]+=1,H[B.name]>1&&d.report({messageId:"noDuplicateHooks",data:{hook:B.name},node:q})},"CallExpression:exit"(q){isTypeOfVitestFnCall(q,d,["describe"])&&Y.pop()}}}}),RULE_NAME$H="no-large-snapshots",m$5=(d,Y,{maxSize:q=50,allowedSnapshots:B={}})=>{const H=Y.loc.start.line,V=Y.loc.end.line-H;if(!Object.keys(B).every(node_path.isAbsolute))throw new Error("All paths for allowedSnapshots must be absolute. You can use JS config and `path.resolve`");let K=!1;if(Y.type===utils.AST_NODE_TYPES.ExpressionStatement&&"left"in Y.expression&&Y.expression.left.type===utils.AST_NODE_TYPES.MemberExpression&&isSupportedAccessor(Y.expression.left.property)){const X=d.filename,z=B[X];if(z){const J=getAccessorValue(Y.expression.left.property);K=z.some(Q=>Q instanceof RegExp?Q.test(J):J===Q)}}!K&&V>q&&d.report({node:Y,messageId:q===0?"noSnapShot":"tooLongSnapShot",data:{lineCount:V,lineLimit:q}})},De=createEslintRule({name:RULE_NAME$H,meta:{docs:{description:"disallow large snapshots",recommended:!1},messages:{noSnapShot:"`{{ lineCount }}`s should begin with lowercase",tooLongSnapShot:"Expected vitest snapshot to be smaller than {{ lineLimit }} lines but was {{ lineCount }} lines long"},type:"suggestion",schema:[{type:"object",properties:{maxSize:{type:"number"},inlineMaxSize:{type:"number"},allowedSnapshots:{type:"object",additionalProperties:{type:"array"}}},additionalProperties:!1}]},defaultOptions:[{}],create(d,[Y]){return d.filename.endsWith(".snap")?{ExpressionStatement(q){m$5(d,q,Y)}}:{CallExpression(q){const B=parseVitestFnCall(q,d);B?.type==="expect"&&["toMatchInlineSnapshot","toThrowErrorMatchingInlineSnapshot"].includes(getAccessorValue(B.matcher))&&B.args.length&&m$5(d,B.args[0],{...Y,maxSize:Y.inlineMaxSize??Y.maxSize})}}}}),RULE_NAME$G="no-interpolation-in-snapshots",Fe=createEslintRule({name:RULE_NAME$G,meta:{type:"problem",docs:{description:"disallow string interpolation in snapshots",recommended:!1},fixable:"code",schema:[],messages:{noInterpolationInSnapshots:"Do not use string interpolation in snapshots"}},defaultOptions:[],create(d){return{CallExpression(Y){const q=parseVitestFnCall(Y,d);q?.type==="expect"&&["toMatchInlineSnapshot","toThrowErrorMatchingInlineSnapshot"].includes(getAccessorValue(q.matcher))&&q.args.forEach(B=>{B.type===utils.AST_NODE_TYPES.TemplateLiteral&&B.expressions.length>0&&d.report({messageId:"noInterpolationInSnapshots",node:B})})}}}}),t="__mocks__",p$1=d=>d.split(node_path.posix.sep).includes(t),s=d=>isStringNode(d)&&p$1(getStringValue(d)),RULE_NAME$F="no-mocks-import",Pe=createEslintRule({name:RULE_NAME$F,meta:{type:"problem",docs:{description:"disallow importing from __mocks__ directory",recommended:!1},messages:{noMocksImport:`Mocks should not be manually imported from a ${t} directory. Instead use \`vi.mock\` and import from the original module path`},schema:[]},defaultOptions:[],create(d){return{ImportDeclaration(Y){s(Y.source)&&d.report({node:Y,messageId:"noMocksImport"})},'CallExpression[callee.name="require"]'(Y){const[q]=Y.arguments;q&&s(q)&&d.report({node:q,messageId:"noMocksImport"})}}}}),RULE_NAME$E="no-restricted-matchers",l$3=(d,Y)=>ModifierName.hasOwnProperty(Y)||Y.endsWith(".not")?d.startsWith(Y):d===Y,je=createEslintRule({name:RULE_NAME$E,meta:{docs:{description:"disallow the use of certain matchers",recommended:!1},type:"suggestion",schema:[{type:"object",additionalProperties:{type:["string","null"]}}],messages:{restrictedChain:"use of {{ restriction }} is disallowed",restrictedChainWithMessage:"{{ message }}"}},defaultOptions:[{}],create(d,[Y]){return{CallExpression(q){const B=parseVitestFnCall(q,d);if(B?.type!=="expect")return;const H=B.members.map(V=>getAccessorValue(V)).join(".");for(const[V,K]of Object.entries(Y))if(l$3(H,V)){d.report({messageId:K?"restrictedChainWithMessage":"restrictedChain",data:{message:K,restriction:V},loc:{start:B.members[0].loc.start,end:B.members[B.members.length-1].loc.end}});break}}}}}),RULE_NAME$D="no-standalone-expect",a$5=(d,Y)=>{const q=d.parent;if(!q)throw new Error("Unexpected block statement. If you feel like this is a bug report https://github.com/veritem/eslint-plugin-vitest/issues/new");if(q.type===utils.AST_NODE_TYPES.FunctionDeclaration)return"function";if(isFunction(q)&&q.parent){const B=q.parent;if(B.type===utils.AST_NODE_TYPES.VariableDeclarator)return"function";if(B.type===utils.AST_NODE_TYPES.CallExpression&&isTypeOfVitestFnCall(B,Y,["describe"]))return"describe"}return null},Ve=createEslintRule({name:RULE_NAME$D,meta:{docs:{description:"disallow using `expect` outside of `it` or `test` blocks",recommended:!1},type:"suggestion",messages:{noStandaloneExpect:"Expect must be called inside a test block"},schema:[{type:"object",properties:{additionalTestBlockFunctions:{type:"array",items:{type:"string"}}},additionalProperties:!1}]},defaultOptions:[{additionalTestBlockFunctions:[]}],create(d,[{additionalTestBlockFunctions:Y=[]}]){const q=[],B=H=>Y.includes(getNodeName(H)||"");return{CallExpression(H){const V=parseVitestFnCall(H,d);if(V?.type==="expect"){if(V.head.node.parent?.type===utils.AST_NODE_TYPES.MemberExpression&&V.members.length===1&&!["assertions","hasAssertions"].includes(getAccessorValue(V.members[0])))return;const K=q[q.length-1];(!K||K===DescribeAlias.describe)&&d.report({node:H,messageId:"noStandaloneExpect"});return}(V?.type==="test"||B(H))&&q.push("test"),H.callee.type===utils.AST_NODE_TYPES.TaggedTemplateExpression&&q.push("template")},"CallExpression:exit"(H){const V=q[q.length-1];(V==="test"&&(isTypeOfVitestFnCall(H,d,["test"])||B(H))&&H.callee.type!==utils.AST_NODE_TYPES.MemberExpression||V==="template"&&H.callee.type===utils.AST_NODE_TYPES.TaggedTemplateExpression)&&q.pop()},BlockStatement(H){const V=a$5(H,d);V&&q.push(V)},"BlockStatement:exit"(H){a$5(H,d)&&q.pop()},ArrowFunctionExpression(H){H.parent?.type!==utils.AST_NODE_TYPES.CallExpression&&q.push("arrow")},"ArrowFunctionExpression:exit"(){q[q.length-1]==="arrow"&&q.pop()}}}}),RULE_NAME$C="no-test-prefixes",Ke=createEslintRule({name:RULE_NAME$C,meta:{docs:{description:"disallow using `test` as a prefix",recommended:!1},type:"suggestion",messages:{usePreferredName:'Use "{{ preferredNodeName }}" instead'},fixable:"code",schema:[]},defaultOptions:[],create(d){return{CallExpression(Y){const q=parseVitestFnCall(Y,d);if(q?.type!=="describe"&&q?.type!=="test"||q.name[0]!=="f"&&q.name[0]!=="x")return;const B=[q.name.slice(1),q.name[0]==="f"?"only":"skip",...q.members.map(V=>getAccessorValue(V))].join("."),H=Y.callee.type===utils.AST_NODE_TYPES.TaggedTemplateExpression?Y.callee.tag:Y.callee.type===utils.AST_NODE_TYPES.CallExpression?Y.callee.callee:Y.callee;d.report({messageId:"usePreferredName",node:Y.callee,data:{preferredNodeName:B},fix:V=>[V.replaceText(H,B)]})}}}}),RULE_NAME$B="no-test-return-statement",u$3=d=>{const[,Y]=d;return Y&&isFunction(Y)&&Y.body.type===utils.AST_NODE_TYPES.BlockStatement?Y.body.body:[]},$e=createEslintRule({name:RULE_NAME$B,meta:{type:"problem",docs:{description:"disallow return statements in tests",recommended:!1},schema:[],messages:{noTestReturnStatement:"Return statements are not allowed in tests"}},defaultOptions:[],create(d){return{CallExpression(Y){if(!isTypeOfVitestFnCall(Y,d,["test"]))return;const q=u$3(Y.arguments).find(B=>B.type===utils.AST_NODE_TYPES.ReturnStatement);q&&d.report({messageId:"noTestReturnStatement",node:q})},FunctionDeclaration(Y){const q=d.sourceCode.getDeclaredVariables(Y);if(getTestCallExpressionsFromDeclaredVariables(q,d).length===0)return;const B=Y.body.body.find(H=>H.type===utils.AST_NODE_TYPES.ReturnStatement);B&&d.report({messageId:"noTestReturnStatement",node:B})}}}}),RULE_NAME$A="prefer-called-with",Ge=createEslintRule({name:RULE_NAME$A,meta:{docs:{description:"enforce using `toBeCalledWith()` or `toHaveBeenCalledWith()`",recommended:!1},messages:{preferCalledWith:"Prefer {{ matcherName }}With(/* expected args */)"},type:"suggestion",fixable:"code",schema:[]},defaultOptions:[],create(d){return{CallExpression(Y){const q=parseVitestFnCall(Y,d);if(q?.type!=="expect"||q.modifiers.some(V=>getAccessorValue(V)==="not"))return;const{matcher:B}=q,H=getAccessorValue(B);["toBeCalled","toHaveBeenCalled"].includes(H)&&d.report({data:{matcherName:H},messageId:"preferCalledWith",node:B,fix:V=>[V.replaceText(B,`${H}With`)]})}}}}),RULE_NAME$z="valid-title",$=d=>["f","x"].includes(d.charAt(0))?d.substring(1):d,N$3=d=>d.type===utils.AST_NODE_TYPES.TemplateLiteral?`\`${d.quasis[0].value.raw}\``:d.raw,b={type:"array",items:{type:"string"},minItems:1,maxItems:2,additionalItems:!1},m$4=d=>{const[Y,q]=Array.isArray(d)?d:[d];return[new RegExp(Y,"u"),q]};function W(d){const Y=d.getSymbol();return Y?Y.getDeclarations()?.some(q=>o__default.isFunctionDeclaration(q)||o__default.isMethodDeclaration(q)||o__default.isFunctionExpression(q)||o__default.isArrowFunction(q))??!1:!1}function _(d){const Y=d.getSymbol();return Y?Y.getDeclarations()?.some(q=>o__default.isClassDeclaration(q)||o__default.isClassExpression(q))??!1:!1}function j(d){return!!(d.flags&o__default.TypeFlags.StringLike)}const A$2=d=>{if(typeof d=="string"||Array.isArray(d)){const Y=m$4(d);return{describe:Y,test:Y,it:Y}}return{describe:d.describe?m$4(d.describe):null,test:d.test?m$4(d.test):null,it:d.it?m$4(d.it):null}},T$2=d=>isStringNode(d.right)?!0:d.left.type===utils.AST_NODE_TYPES.BinaryExpression?T$2(d.left):isStringNode(d.left),We=createEslintRule({name:RULE_NAME$z,meta:{docs:{description:"enforce valid titles",recommended:!1},messages:{titleMustBeString:"Test title must be a string, a function or class name",emptyTitle:"{{ functionName }} should not have an empty title",duplicatePrefix:"should not have duplicate prefix",accidentalSpace:"should not have leading or trailing spaces",disallowedWord:'"{{ word }}" is not allowed in test title',mustNotMatch:"{{ functionName }} should not match {{ pattern }}",mustMatch:"{{ functionName }} should match {{ pattern }}",mustNotMatchCustom:"{{ message }}",mustMatchCustom:"{{ message }}"},type:"suggestion",schema:[{type:"object",properties:{ignoreTypeOfDescribeName:{type:"boolean",default:!1},allowArguments:{type:"boolean",default:!1},disallowedWords:{type:"array",items:{type:"string"}}},patternProperties:{[/^must(?:Not)?Match$/u.source]:{oneOf:[{type:"string"},b,{type:"object",propertyNames:{type:"string",enum:["describe","test","it"]},additionalProperties:{oneOf:[{type:"string"},b]}}]}},additionalProperties:!1}],fixable:"code"},defaultOptions:[{ignoreTypeOfDescribeName:!1,allowArguments:!1,disallowedWords:[]}],create(d,[{ignoreTypeOfDescribeName:Y,allowArguments:q,disallowedWords:B=[],mustNotMatch:H,mustMatch:V}]){const K=new RegExp(`\\b(${B.join("|")})\\b`,"iu"),X=A$2(H??{}),z=A$2(V??{}),J=parsePluginSettings(d.settings);return{CallExpression(Q){const G=parseVitestFnCall(Q,d);if(G?.type!=="describe"&&G?.type!=="test"&&G?.type!=="it"||G.members&&G.members[0]&&G.members[0].type===utils.AST_NODE_TYPES.Identifier&&G.members[0].name==="extend")return;const[ee]=Q.arguments;if(J.typecheck){const ce=utils.ESLintUtils.getParserServices(d).getTypeAtLocation(ee);if(W(ce)||_(ce)||j(ce))return}if(!ee||q&&ee.type===utils.AST_NODE_TYPES.Identifier)return;if(!isStringNode(ee)){if(ee.type===utils.AST_NODE_TYPES.BinaryExpression&&T$2(ee))return;ee.type!==utils.AST_NODE_TYPES.TemplateLiteral&&!(Y&&G.type==="describe")&&d.report({messageId:"titleMustBeString",loc:ee.loc});return}const Z=getStringValue(ee);if(!Z){d.report({messageId:"emptyTitle",data:{functionName:G.type==="describe"?DescribeAlias.describe:TestCaseName.test},node:Q});return}if(B.length>0){const ce=K.exec(Z);if(ce){d.report({messageId:"disallowedWord",data:{word:ce[1]},node:ee});return}}Z.trim().length!==Z.length&&d.report({messageId:"accidentalSpace",node:ee,fix:ce=>[ce.replaceTextRange(ee.range,N$3(ee).replace(/^([`'"]) +?/u,"$1").replace(/ +?([`'"])$/u,"$1"))]});const oe=$(G.name),[te]=Z.split(" ");te.toLowerCase()===oe&&d.report({messageId:"duplicatePrefix",node:ee,fix:ce=>[ce.replaceTextRange(ee.range,N$3(ee).replace(/^([`'"]).+? /u,"$1"))]});const se=oe,[ie,re]=X[se]??[];if(ie&&ie.test(Z)){d.report({messageId:re?"mustNotMatchCustom":"mustNotMatch",node:ee,data:{functionName:se,pattern:ie,message:re}});return}const[ne,ae]=z[se]??[];ne&&(ne.test(Z)||d.report({messageId:ae?"mustMatchCustom":"mustMatch",node:ee,data:{functionName:se,pattern:ne,message:ae}}))}}}}),RULE_NAME$y="valid-expect",h$1=["toReject","toResolve"],D=d=>(d.type===utils.AST_NODE_TYPES.ArrayExpression&&d.parent&&d.parent.type===utils.AST_NODE_TYPES.CallExpression&&(d=d.parent),d.type===utils.AST_NODE_TYPES.CallExpression&&d.callee.type===utils.AST_NODE_TYPES.MemberExpression&&isSupportedAccessor(d.callee.object,"Promise")&&d.parent?d:null),A$1=({start:d,end:Y})=>`${d.line}:${d.column}-${Y.line}:${Y.column}`,O$1=d=>d.parent.type===utils.AST_NODE_TYPES.Property&&d.type===utils.AST_NODE_TYPES.FunctionExpression?d.parent:d;function M$2(d){const Y=d.parent?.parent;return Y&&Y.type===utils.AST_NODE_TYPES.CallExpression&&Y.callee.type===utils.AST_NODE_TYPES.MemberExpression&&isSupportedAccessor(Y.callee.property)&&["then","catch"].includes(getAccessorValue(Y.callee.property))&&Y.parent?M$2(Y):d}const U=d=>d.parent?.parent&&[utils.AST_NODE_TYPES.CallExpression,utils.AST_NODE_TYPES.ArrayExpression].includes(d.parent.type)?D(d.parent):null,N$2=({parent:d})=>d?isFunction(d)?d:N$2(d):null,w$1=(d,Y)=>Y&&d.type===utils.AST_NODE_TYPES.ReturnStatement?!0:d.type===utils.AST_NODE_TYPES.ConditionalExpression&&d.parent?w$1(d.parent,Y):[utils.AST_NODE_TYPES.ArrowFunctionExpression,utils.AST_NODE_TYPES.AwaitExpression].includes(d.type),ze=createEslintRule({name:RULE_NAME$y,meta:{docs:{description:"enforce valid `expect()` usage",recommended:!1},messages:{tooManyArgs:"Expect takes at most {{ amount}} argument{{ s }}",notEnoughArgs:"Expect requires at least {{ amount }} argument{{ s }}",modifierUnknown:"Expect has an unknown modifier",matcherNotFound:"Expect must have a corresponding matcher call",matcherNotCalled:"Matchers must be called to assert",asyncMustBeAwaited:"Async assertions must be awaited{{ orReturned }}",promisesWithAsyncAssertionsMustBeAwaited:"Promises which return async assertions must be awaited{{ orReturned }}"},type:"suggestion",fixable:"code",schema:[{type:"object",properties:{alwaysAwait:{type:"boolean",default:!1},asyncMatchers:{type:"array",items:{type:"string"}},minArgs:{type:"number",minimum:1},maxArgs:{type:"number",minimum:1}},additionalProperties:!1}]},defaultOptions:[{alwaysAwait:!1,asyncMatchers:h$1,minArgs:1,maxArgs:1}],create:(d,[{alwaysAwait:Y,asyncMatchers:q=h$1,minArgs:B=1,maxArgs:H=1}])=>{const V=new Set,K=[],X=Q=>V.add(A$1(Q)),z=Q=>V.has(A$1(Q)),J=Q=>{let G=Q,{parent:ee}=Q;for(;ee&&ee.type===utils.AST_NODE_TYPES.MemberExpression;)G=ee,ee=ee.parent;return G};return{CallExpression(Q){const G=parseVitestFnCallWithReason(Q,d),ee=parsePluginSettings(d.settings);if(typeof G=="string"){const ae=Q.parent?.type===utils.AST_NODE_TYPES.MemberExpression?J(Q.parent).property:Q;if(G==="matcher-not-found"){d.report({messageId:"matcherNotFound",node:ae});return}if(G==="matcher-not-called"&&d.report({messageId:isSupportedAccessor(ae)&&ModifierName.hasOwnProperty(getAccessorValue(ae))?"matcherNotFound":"matcherNotCalled",node:ae}),G==="modifier-unknown"){d.report({messageId:"modifierUnknown",node:ae});return}return}else if(G?.type==="expectTypeOf"&&ee.typecheck||G?.type!=="expect"||G.modifiers.some(ae=>ae.type===utils.AST_NODE_TYPES.Identifier&&ae.name=="to"))return;const{parent:Z}=G.head.node;if(Z?.type!==utils.AST_NODE_TYPES.CallExpression)return;if(Z.arguments.length<B){const ae=getAccessorValue(G.head.node).length,ce={start:{column:Z.loc.start.column+ae,line:Z.loc.start.line},end:{column:Z.loc.start.column+ae+1,line:Z.loc.start.line}};d.report({messageId:"notEnoughArgs",data:{amount:B,s:B===1?"":"s"},node:Z,loc:ce})}if(Z.arguments.length>H){if(Z.arguments.length===2){const ue=Z.arguments[1].type===utils.AST_NODE_TYPES.Literal&&typeof Z.arguments[1].value=="string",pe=Z.arguments[1].type===utils.AST_NODE_TYPES.TemplateLiteral;if(ue||pe)return}const{start:ae}=Z.arguments[H].loc,{end:ce}=Z.arguments[Z.arguments.length-1].loc,le={start:ae,end:{column:ce.column+1,line:ce.line}};d.report({messageId:"tooManyArgs",data:{amount:H,s:H===1?"":"s"},node:Z,loc:le})}const{matcher:oe}=G,te=oe.parent.parent,se=G.modifiers.some(ae=>getAccessorValue(ae)!=="not")||q.includes(getAccessorValue(oe));if(!te?.parent||!se)return;const ie=te.parent.type===utils.AST_NODE_TYPES.ArrayExpression,re=M$2(te),ne=U(re)||re;ne.parent&&!w$1(ne.parent,!Y)&&!z(ne.loc)&&(K.push({messageId:ne===re?"asyncMustBeAwaited":"promisesWithAsyncAssertionsMustBeAwaited",node:ne}),ie&&X(ne.loc))},"Program:exit"(){const Q=[];K.forEach(({node:G,messageId:ee},Z)=>{const oe=Y?"":" or returned";d.report({loc:G.loc,data:{orReturned:oe},messageId:ee,node:G,fix(te){const se=N$2(G);if(!se)return null;const ie=Q.some(ne=>ne.text==="async ");if(!se.async&&!ie){const ne=O$1(se);Q.push(te.insertTextBefore(ne,"async "))}const re=G.parent?.type===utils.AST_NODE_TYPES.ReturnStatement?G.parent:null;if(Y&&re){const ne=d.sourceCode.getText(re).replace("return","await");Q.push(te.replaceText(re,ne))}else Q.push(te.insertTextBefore(G,"await "));return Z===K.length-1?Q:null}})})}}}}),isBooleanLiteral=d=>d.type===utils.AST_NODE_TYPES.Literal&&typeof d.value=="boolean",isBooleanEqualityMatcher=d=>{const Y=getAccessorValue(d.matcher);if(["toBeTruthy","toBeFalsy"].includes(Y))return!0;if(d.args.length!==1)return!1;const q=getFirstMatcherArg(d);return EqualityMatcher.hasOwnProperty(Y)&&isBooleanLiteral(q)},isInstanceOfBinaryExpression=(d,Y)=>d.type===utils.AST_NODE_TYPES.BinaryExpression&&d.operator==="instanceof"&&isSupportedAccessor(d.right,Y),hasOnlyOneArgument=d=>d.arguments.length===1,RULE_NAME$x="prefer-to-be-object",Je=createEslintRule({name:RULE_NAME$x,meta:{type:"suggestion",docs:{description:"enforce using toBeObject()",recommended:!1},fixable:"code",messages:{preferToBeObject:"Prefer toBeObject() to test if a value is an object"},schema:[]},defaultOptions:[],create(d){return{CallExpression(Y){const q=parseVitestFnCall(Y,d);if(q?.type!=="expectTypeOf")return;if(isParsedInstanceOfMatcherCall(q,"Object")){d.report({node:q.matcher,messageId:"preferToBeObject",fix:V=>[V.replaceTextRange([q.matcher.range[0],q.matcher.range[1]+8],"toBeObject()")]});return}const{parent:B}=q.head.node;if(B?.type!==utils.AST_NODE_TYPES.CallExpression)return;const[H]=B.arguments;!H||!isBooleanEqualityMatcher(q)||!isInstanceOfBinaryExpression(H,"Object")||d.report({node:q.matcher,messageId:"preferToBeObject",fix(V){const K=[V.replaceText(q.matcher,"toBeObject"),V.removeRange([H.left.range[1],H.range[1]])];let X=getAccessorValue(q.matcher)==="toBeFalsy";if(q.args.length){const[z]=q.args;K.push(V.remove(z)),X=z.type===utils.AST_NODE_TYPES.Literal&&followTypeAssertionChain$1(z).value===!1}if(X){const z=q.modifiers.find(J=>getAccessorValue(J)==="not");K.push(z?V.removeRange([z.range[0]-1,z.range[1]]):V.insertTextBefore(q.matcher,"not."))}return K}})}}}}),RULE_NAME$w="prefer-to-be-truthy",n=d=>d.type===utils.AST_NODE_TYPES.Literal&&d.value===!0,Qe=createEslintRule({name:RULE_NAME$w,meta:{type:"suggestion",docs:{description:"enforce using `toBeTruthy`",recommended:!1},messages:{preferToBeTruthy:"Prefer using `toBeTruthy` to test value is `true`"},fixable:"code",schema:[]},defaultOptions:[],create(d){return{CallExpression(Y){const q=parseVitestFnCall(Y,d);(q?.type==="expect"||q?.type==="expectTypeOf")&&q.args.length===1&&n(getFirstMatcherArg(q))&&EqualityMatcher.hasOwnProperty(getAccessorValue(q.matcher))&&d.report({node:q.matcher,messageId:"preferToBeTruthy",fix:B=>[B.replaceText(q.matcher,"toBeTruthy"),B.remove(q.args[0])]})}}}}),RULE_NAME$v="prefer-to-be-falsy",c$2=d=>d.type===utils.AST_NODE_TYPES.Literal&&d.value===!1,Xe=createEslintRule({name:RULE_NAME$v,meta:{type:"suggestion",docs:{description:"enforce using toBeFalsy()",recommended:!1},fixable:"code",schema:[],messages:{preferToBeFalsy:"Prefer using toBeFalsy()"}},defaultOptions:[],create(d){return{CallExpression(Y){const q=parseVitestFnCall(Y,d);(q?.type==="expect"||q?.type==="expectTypeOf")&&q.args.length===1&&c$2(getFirstMatcherArg(q))&&EqualityMatcher.hasOwnProperty(getAccessorValue(q.matcher))&&d.report({node:q.matcher,messageId:"preferToBeFalsy",fix:B=>[B.replaceText(q.matcher,"toBeFalsy"),B.remove(q.args[0])]})}}}}),RULE_NAME$u="prefer-to-have-length",Ye=createEslintRule({name:RULE_NAME$u,meta:{type:"suggestion",docs:{description:"enforce using toHaveLength()",recommended:!1},fixable:"code",messages:{preferToHaveLength:"Prefer toHaveLength()"},schema:[]},defaultOptions:[],create(d){return{CallExpression(Y){const q=parseVitestFnCall(Y,d);if(q?.type!=="expect")return;const{parent:B}=q.head.node;if(B?.type!==utils.AST_NODE_TYPES.CallExpression)return;const[H]=B.arguments,{matcher:V}=q;!EqualityMatcher.hasOwnProperty(getAccessorValue(V))||H?.type!==utils.AST_NODE_TYPES.MemberExpression||!isSupportedAccessor(H.property,"length")||d.report({node:V,messageId:"preferToHaveLength",fix(K){return[K.removeRange([H.property.range[0]-1,H.range[1]]),K.replaceTextRange([V.parent.object.range[1],V.parent.range[1]],".toHaveLength")]}})}}}}),RULE_NAME$t="prefer-equality-matcher",Ze=createEslintRule({name:RULE_NAME$t,meta:{type:"suggestion",docs:{description:"enforce using the built-in quality matchers",recommended:!1},messages:{useEqualityMatcher:"Prefer using one of the equality matchers instead",suggestEqualityMatcher:"Use `{{ equalityMatcher }}`"},hasSuggestions:!0,schema:[]},defaultOptions:[],create(d){return{CallExpression(Y){const q=parseVitestFnCall(Y,d);if(q?.type!=="expect"||q.args.length===0)return;const{parent:B}=q.head.node;if(B?.type!==utils.AST_NODE_TYPES.CallExpression)return;const{arguments:[H],range:[,V]}=B,{matcher:K}=q,X=getFirstMatcherArg(q);if(H?.type!==utils.AST_NODE_TYPES.BinaryExpression||H.operator!=="==="&&H.operator!=="!=="||!EqualityMatcher.hasOwnProperty(getAccessorValue(K))||!isBooleanLiteral(X))return;const z=X.value,[J]=q.modifiers,Q=q.modifiers.some(Z=>getAccessorValue(Z)==="not"),G=(H.operator==="!=="?!z:z)===Q,ee=Z=>oe=>{const{sourceCode:te}=d;let se=J&&getAccessorValue(J)!=="not"?`.${getAccessorValue(J)}`:"";return G&&(se+=`.${ModifierName.not}`),[oe.replaceText(H,te.getText(H.left)),oe.replaceTextRange([V,K.parent.range[1]],`${se}.${Z}`),oe.replaceText(X,te.getText(H.right))]};d.report({messageId:"useEqualityMatcher",suggest:["toBe","toEqual","toStrictEqual"].map(Z=>({messageId:"suggestEqualityMatcher",data:{equalityMatcher:Z},fix:ee(Z)})),node:K})}}}}),RULE_NAME$s="prefer-strict-equal",er=createEslintRule({name:RULE_NAME$s,meta:{type:"suggestion",docs:{description:"enforce strict equal over equal",recommended:!1},messages:{useToStrictEqual:"Use `toStrictEqual()` instead",suggestReplaceWithStrictEqual:"Replace with `toStrictEqual()`"},schema:[],hasSuggestions:!0},defaultOptions:[],create(d){return{CallExpression(Y){const q=parseVitestFnCall(Y,d);if(q?.type!=="expect")return;const{matcher:B}=q;isSupportedAccessor(B,"toEqual")&&d.report({messageId:"useToStrictEqual",node:B,suggest:[{messageId:"suggestReplaceWithStrictEqual",fix:H=>[replaceAccessorFixer(H,B,EqualityMatcher.toStrictEqual)]}]})}}}}),RULE_NAME$r="prefer-expect-resolves",rr=createEslintRule({name:RULE_NAME$r,meta:{type:"suggestion",docs:{description:"enforce using `expect().resolves` over `expect(await ...)` syntax",recommended:!1},fixable:"code",messages:{expectResolves:"Use `expect().resolves` instead"},schema:[]},defaultOptions:[],create:d=>({CallExpression(Y){const q=parseVitestFnCall(Y,d);if(q?.type!=="expect")return;const{parent:B}=q.head.node;if(B?.type!==utils.AST_NODE_TYPES.CallExpression)return;const[H]=B.arguments;H?.type===utils.AST_NODE_TYPES.AwaitExpression&&d.report({node:H,messageId:"expectResolves",fix(V){return[V.insertTextBefore(B,"await "),V.removeRange([H.range[0],H.argument.range[0]]),V.insertTextAfter(B,".resolves")]}})}})}),RULE_NAME$q="prefer-each",or=createEslintRule({name:RULE_NAME$q,meta:{type:"suggestion",docs:{description:"enforce using `each` rather than manual loops",recommended:!1},schema:[],messages:{preferEach:"Prefer using `{{ fn }}.each` rather than a manual loop"}},defaultOptions:[],create(d){const Y=[];let q=!1;const B=()=>Y.length===1&&Y[0]==="test"?"it":"describe",H=()=>{Y.length===0||q||(Y.length=0)},V=K=>{Y.length===0||q||(d.report({node:K,messageId:"preferEach",data:{fn:B()}}),Y.length=0)};return{ForStatement:H,"ForStatement:exit":V,ForInStatement:H,"ForInStatement:exit":V,ForOfStatement:H,"ForOfStatement:exit":V,CallExpression(K){const{type:X}=parseVitestFnCall(K,d)??{};(X==="hook"||X==="describe"||X==="test")&&Y.push(X),X==="test"&&(q=!0)},"CallExpression:exit"(K){const{type:X}=parseVitestFnCall(K,d)??{};X==="test"&&(q=!1)}}}}),RULE_NAME$p="prefer-hooks-on-top",ar=createEslintRule({name:RULE_NAME$p,meta:{type:"suggestion",docs:{description:"enforce having hooks before any test cases",recommended:!1},messages:{noHookOnTop:"Hooks should come before test cases"},schema:[]},defaultOptions:[],create(d){const Y=[!1];return{CallExpression(q){isTypeOfVitestFnCall(q,d,["test"])&&(Y[Y.length-1]=!0),Y[Y.length-1]&&isTypeOfVitestFnCall(q,d,["hook"])&&d.report({messageId:"noHookOnTop",node:q}),Y.push(!1)},"CallExpression:exit"(){Y.pop()}}}}),RULE_NAME$o="prefer-hooks-in-order",a$4=["beforeAll","beforeEach","afterEach","afterAll"],tr=createEslintRule({name:RULE_NAME$o,meta:{type:"suggestion",docs:{description:"enforce having hooks in consistent order",recommended:!1},messages:{reorderHooks:"`{{ currentHook }}` hooks should be before any `{{ previousHook }}` hooks"},schema:[]},defaultOptions:[],create(d){let Y=-1,q=!1;return{CallExpression(B){if(q)return;const H=parseVitestFnCall(B,d);if(H?.type!=="hook"){Y=-1;return}q=!0;const V=H.name,K=a$4.indexOf(V);if(K<Y){d.report({messageId:"reorderHooks",data:{previousHook:a$4[Y],currentHook:V},node:B}),q=!1;return}Y=K},"CallExpression:exit"(B){if(isTypeOfVitestFnCall(B,d,["hook"])){q=!1;return}q||(Y=-1)}}}}),RULE_NAME$n="prefer-mock-promise-shorthand",l$2=(d,Y)=>`${d}${Y?"Once":""}`,f=d=>d.body.type!==utils.AST_NODE_TYPES.BlockStatement?d.body:d.body.body[0]?.type===utils.AST_NODE_TYPES.ReturnStatement?d.body.body[0].argument:null,nr=createEslintRule({name:RULE_NAME$n,meta:{type:"suggestion",docs:{description:"enforce mock resolved/rejected shorthands for promises",recommended:!1},messages:{useMockShorthand:"Prefer {{ replacement }}"},schema:[],fixable:"code"},defaultOptions:[],create(d){const Y=(q,B,H,V=H)=>{if(V?.type!==utils.AST_NODE_TYPES.CallExpression)return;const K=getNodeName(V);if(K!=="Promise.resolve"&&K!=="Promise.reject")return;const X=l$2(K.endsWith("reject")?"mockRejectedValue":"mockResolvedValue",B);d.report({node:q,messageId:"useMockShorthand",data:{replacement:X},fix(z){const{sourceCode:J}=d;return V.arguments.length>1?null:[z.replaceText(q,X),z.replaceText(H,V.arguments.length===1?J.getText(V.arguments[0]):"undefined")]}})};return{CallExpression(q){if(q.callee.type!==utils.AST_NODE_TYPES.MemberExpression||!isSupportedAccessor(q.callee.property)||q.arguments.length===0)return;const B=getAccessorValue(q.callee.property),H=B.endsWith("Once");if(B===l$2("mockReturnValue",H))Y(q.callee.property,H,q.arguments[0]);else if(B===l$2("mockImplementation",H)){const[V]=q.arguments;if(!isFunction(V)||V.params.length!==0)return;Y(q.callee.property,H,V,f(V))}}}}}),a$3=node_module.createRequire(typeof document>"u"?require("url").pathToFileURL(__filename).href:_documentCurrentScript&&_documentCurrentScript.tagName.toUpperCase()==="SCRIPT"&&_documentCurrentScript.src||new URL("index.cjs",document.baseURI).href),c$1=node_module.createRequire(a$3.resolve("eslint"));c$1.resolve("espree");const p=new Set([utils.AST_NODE_TYPES.Program,utils.AST_NODE_TYPES.BlockStatement,utils.AST_NODE_TYPES.SwitchCase,utils.AST_NODE_TYPES.SwitchStatement]),isValidParent=d=>p.has(d),isTokenASemicolon=d=>d.value===";"&&d.type===utils.AST_TOKEN_TYPES.Punctuator,getActualLastToken=(d,Y)=>{const q=d.getLastToken(Y),B=d.getTokenBefore(q),H=d.getTokenAfter(q);return B&&H&&B.range[0]>=Y.range[0]&&isTokenASemicolon(q)&&q.loc.start.line!==B.loc.end.line&&q.loc.end.line===H.loc.start.line?B:q},getPaddingLineSequences=(d,Y,q)=>{const B=[];let H=getActualLastToken(q,d);if(Y.loc.start.line-d.loc.end.line>=2)do{const V=q.getTokenAfter(H,{includeComments:!0});V.loc.start.line-H.loc.end.line>=2&&B.push([H,V]),H=V}while(H.range[0]<Y.range[0]);return B},areTokensOnSameLine=(d,Y)=>d.loc.end.line===Y.loc.start.line,E$1=d=>d.type===utils.AST_NODE_TYPES.TSAsExpression||d.type===utils.AST_NODE_TYPES.TSTypeAssertion,followTypeAssertionChain=d=>E$1(d)?followTypeAssertionChain(d.expression):d,RULE_NAME$m="prefer-vi-mocked",m$3=["Mock","MockedFunction","MockedClass","MockedObject"],sr=createEslintRule({name:RULE_NAME$m,meta:{type:"suggestion",docs:{description:"require `vi.mocked()` over `fn as Mock`",requiresTypeChecking:!0,recommended:!1},fixable:"code",messages:{useViMocked:"Prefer `vi.mocked()`"},schema:[]},defaultOptions:[],create(d){function Y(q){const{typeAnnotation:B}=q;if(B.type!==utils.AST_NODE_TYPES.TSTypeReference)return;const{typeName:H}=B;if(H.type!==utils.AST_NODE_TYPES.Identifier||!m$3.includes(H.name))return;const V=d.sourceCode.text.slice(...followTypeAssertionChain(q.expression).range);d.report({node:q,messageId:"useViMocked",fix(K){return K.replaceText(q,`vi.mocked(${V})`)}})}return{TSAsExpression(q){q.parent.type!==utils.AST_NODE_TYPES.TSAsExpression&&Y(q)},TSTypeAssertion(q){Y(q)}}}}),RULE_NAME$l="prefer-snapshot-hint",E=["toMatchSnapshot","toThrowErrorMatchingSnapshot"],x$2=E,S$3=d=>{if(d.args.length===0)return!0;if(!isSupportedAccessor(d.matcher,"toMatchSnapshot"))return d.args.length!==1;if(d.args.length===2)return!1;const[Y]=d.args;return!isStringNode(Y)},ir=createEslintRule({name:RULE_NAME$l,meta:{type:"suggestion",docs:{description:"enforce including a hint with external snapshots",recommended:!1},messages:{missingHint:"You should provide a hint for this snapshot"},schema:[{type:"string",enum:["always","multi"]}]},defaultOptions:["multi"],create(d,[Y]){const q=[];let B=0;const H=[],V=()=>{for(const z of q)S$3(z)&&d.report({messageId:"missingHint",node:z.matcher})},K=()=>{B++},X=()=>{B--,Y==="always"&&(V(),q.length=0),Y==="multi"&&B===0&&(q.length>1&&V(),q.length=0)};return{"Program:exit"(){K(),X()},FunctionExpression:K,"FunctionExpression:exit":X,ArrowFunctionExpression:K,"ArrowFunctionExpression:exit":X,"CallExpression:exit"(z){isTypeOfVitestFnCall(z,d,["describe","test"])&&(B=H.pop()??0)},CallExpression(z){const J=parseVitestFnCall(z,d);if(J?.type!=="expect"){(J?.type==="describe"||J?.type==="test")&&(H.push(B),B=0);return}const Q=getAccessorValue(J.matcher);x$2.includes(Q)&&q.push(J)}}}}),RULE_NAME$k="valid-describe-callback",o=d=>{const[Y]=d,q=d[d.length-1];return{start:Y.loc.start,end:q.loc.end}},i$1=(d,Y)=>d.members.every(q=>getAccessorValue(q)!=="each")&&Y.params.length,u$2=(d,Y)=>{d.body.forEach(q=>{q.type===utils.AST_NODE_TYPES.ReturnStatement&&Y.report({messageId:"unexpectedReturnInDescribe",node:q})})},mr=createEslintRule({name:RULE_NAME$k,meta:{type:"problem",docs:{description:"enforce valid describe callback",recommended:!1},messages:{nameAndCallback:"Describe requires a name and callback arguments",secondArgumentMustBeFunction:"Second argument must be a function",unexpectedDescribeArgument:"Unexpected argument in describe callback",unexpectedReturnInDescribe:"Unexpected return statement in describe callback"},schema:[]},defaultOptions:[],create(d){return{CallExpression(Y){const q=parseVitestFnCall(Y,d);if(q?.type!=="describe"||q?.members[0]?.type===utils.AST_NODE_TYPES.Identifier&&q.members[0].name==="todo")return;if(Y.arguments.length<1)return d.report({messageId:"nameAndCallback",loc:Y.loc});const[,B,H]=Y.arguments;if(!B){d.report({messageId:"nameAndCallback",loc:o(Y.arguments)});return}if(!isFunction(B)){if(H&&isFunction(H)){i$1(q,H)&&d.report({messageId:"unexpectedDescribeArgument",node:H}),H.body.type===utils.AST_NODE_TYPES.CallExpression&&d.report({messageId:"unexpectedReturnInDescribe",node:H}),H.body.type===utils.AST_NODE_TYPES.BlockStatement&&u$2(H.body,d);return}d.report({messageId:"secondArgumentMustBeFunction",loc:o(Y.arguments)});return}i$1(q,B)&&d.report({messageId:"unexpectedDescribeArgument",node:B}),B.body.type===utils.AST_NODE_TYPES.CallExpression&&d.report({messageId:"unexpectedReturnInDescribe",node:B}),B.body.type===utils.AST_NODE_TYPES.BlockStatement&&u$2(B.body,d)}}}}),RULE_NAME$j="require-top-level-describe",pr=createEslintRule({name:RULE_NAME$j,meta:{docs:{description:"enforce that all tests are in a top-level describe",recommended:!1},messages:{tooManyDescribes:"There should not be more than {{ max }} describe{{ s }} at the top level",unexpectedTestCase:"All test cases must be wrapped in a describe block",unexpectedHook:"All hooks must be wrapped in a describe block"},type:"suggestion",schema:[{type:"object",properties:{maxNumberOfTopLevelDescribes:{type:"number",minimum:1}},additionalProperties:!1}]},defaultOptions:[{}],create(d){const{maxNumberOfTopLevelDescribes:Y=1/0}=d.options[0]??{};let q=0,B=0;return{CallExpression(H){const V=parseVitestFnCall(H,d);if(V){if(V.type==="describe"){B++,B===1&&(q++,q>Y&&d.report({node:H,messageId:"tooManyDescribes",data:{max:Y,s:Y===1?"":"s"}}));return}if(B===0){if(V.type==="test"){d.report({node:H,messageId:"unexpectedTestCase"});return}V.type==="hook"&&d.report({node:H,messageId:"unexpectedHook"})}}},"CallExpression:exit"(H){isTypeOfVitestFnCall(H,d,["describe"])&&B--}}}}),RULE_NAME$i="require-to-throw-message",Er=createEslintRule({name:RULE_NAME$i,meta:{type:"suggestion",docs:{description:"require toThrow() to be called with an error message",recommended:!1},schema:[],messages:{addErrorMessage:"Add an error message to {{ matcherName }}()"}},defaultOptions:[],create(d){return{CallExpression(Y){const q=parseVitestFnCall(Y,d);if(q?.type!=="expect")return;const{matcher:B}=q,H=getAccessorValue(B);q.args.length===0&&["toThrow","toThrowError"].includes(H)&&!q.modifiers.some(V=>getAccessorValue(V)==="not")&&d.report({messageId:"addErrorMessage",data:{matcherName:H},node:B})}}}}),RULE_NAME$h="require-hook",S$2=(d,Y)=>parseVitestFnCall(d,Y)?!0:!!getNodeName(d)?.startsWith("vi"),m$2=d=>d.type===utils.AST_NODE_TYPES.Literal&&d.value===null||isIdentifier(d,"undefined"),a$2=(d,Y,q=[])=>{switch(d.type){case utils.AST_NODE_TYPES.ExpressionStatement:return a$2(d.expression,Y,q);case utils.AST_NODE_TYPES.CallExpression:return!(S$2(d,Y)||q.includes(getNodeName(d)));case utils.AST_NODE_TYPES.VariableDeclaration:return d.kind==="const"?!1:d.declarations.some(({init:B})=>B!==null&&!m$2(B));default:return!1}},lr=createEslintRule({name:RULE_NAME$h,meta:{docs:{description:"require setup and teardown to be within a hook",recommended:!1},messages:{useHook:"This should be done within a hook"},type:"suggestion",schema:[{type:"object",properties:{allowedFunctionCalls:{type:"array",items:{type:"string"}}},additionalProperties:!1}]},defaultOptions:[{allowedFunctionCalls:[]}],create(d){const{allowedFunctionCalls:Y}=d.options[0]??{},q=B=>{for(const H of B)a$2(H,d,Y)&&d.report({node:H,messageId:"useHook"})};return{Program(B){q(B.body)},CallExpression(B){if(!isTypeOfVitestFnCall(B,d,["describe"])||B.arguments.length<2)return;const[,H]=B.arguments;!isFunction(H)||H.body.type!==utils.AST_NODE_TYPES.BlockStatement||q(H.body.body)}}}}),RULE_NAME$g="require-local-test-context-for-concurrent-snapshots",fr=createEslintRule({name:RULE_NAME$g,meta:{docs:{description:"require local Test Context for concurrent snapshot tests",recommended:!1},messages:{requireLocalTestContext:"Use local Test Context instead"},type:"problem",schema:[]},defaultOptions:[],create(d){return{CallExpression(Y){const q=parseVitestFnCall(Y,d);q===null||q.type!=="expect"||q.type==="expect"&&q.head.type==="testContext"||!["toMatchSnapshot","toMatchInlineSnapshot","toMatchFileSnapshot","toThrowErrorMatchingSnapshot","toThrowErrorMatchingInlineSnapshot"].includes(Y.callee?.property.name)||!d.sourceCode.getAncestors(Y).some(B=>B.type!==utils.AST_NODE_TYPES.CallExpression||!isTypeOfVitestFnCall(B,d,["describe","test"])?!1:B.callee.type===utils.AST_NODE_TYPES.MemberExpression&&isSupportedAccessor(B.callee.property,"concurrent"))||d.report({node:Y,messageId:"requireLocalTestContext"})}}}}),RULE_NAME$f="prefer-todo",S$1=d=>d.members.some(Y=>getAccessorValue(Y)!=="skip")||d.name.startsWith("x")?!1:!d.name.startsWith("f");function T$1(d){return isFunction(d)?d.body.type===utils.AST_NODE_TYPES.BlockStatement&&!d.body.body.length:!1}function a$1(d,Y){return d.members.length?replaceAccessorFixer(Y,d.members[0],"todo"):Y.replaceText(d.head.node,`${d.head.local}.todo`)}const cr=createEslintRule({name:RULE_NAME$f,meta:{type:"layout",docs:{description:"enforce using `test.todo`",recommended:!1},messages:{emptyTest:"Prefer todo test case over empty test case",unimplementedTest:"Prefer todo test case over unimplemented test case"},fixable:"code",schema:[]},defaultOptions:[],create(d){return{CallExpression(Y){const[q,B]=Y.arguments,H=parseVitestFnCall(Y,d);!q||H?.type!=="test"||!S$1(H)||!isStringNode(q)||(B&&T$1(B)&&d.report({messageId:"emptyTest",node:Y,fix:V=>[V.removeRange([q.range[1],B.range[1]]),a$1(H,V)]}),hasOnlyOneArgument(Y)&&d.report({messageId:"unimplementedTest",node:Y,fix:V=>a$1(H,V)}))}}}}),RULE_NAME$e="prefer-spy-on",u$1=d=>"object"in d?d.object:d.callee.type===utils.AST_NODE_TYPES.MemberExpression?d.callee.object:null,a=d=>{if(d.type!==utils.AST_NODE_TYPES.CallExpression&&d.type!==utils.AST_NODE_TYPES.MemberExpression)return null;const Y=u$1(d);return Y?Y.type===utils.AST_NODE_TYPES.Identifier?d.type===utils.AST_NODE_TYPES.CallExpression&&getNodeName(d.callee)==="vi.fn"?d:null:a(Y):null},S=(d,Y)=>{if(d.parent?.type===utils.AST_NODE_TYPES.MemberExpression&&d.parent.property.type===utils.AST_NODE_TYPES.Identifier&&d.parent.property.name==="mockImplementation")return"";const[q]=d.arguments,B=q&&Y.sourceCode.getText(q);return B?`.mockImplementation(${B})`:".mockImplementation()"},Nr=createEslintRule({name:RULE_NAME$e,meta:{type:"suggestion",docs:{description:"enforce using `vi.spyOn`",recommended:!1},messages:{useViSpayOn:"Use `vi.spyOn` instead"},fixable:"code",schema:[]},defaultOptions:[],create(d){return{AssignmentExpression(Y){const{left:q,right:B}=Y;if(q.type!==utils.AST_NODE_TYPES.MemberExpression)return;const H=a(B);H&&d.report({node:Y,messageId:"useViSpayOn",fix(V){const K=q.property.type===utils.AST_NODE_TYPES.Identifier&&!q.computed?"'":"",X=S(H,d);return[V.insertTextBefore(q,"vi.spyOn("),V.replaceTextRange([q.object.range[1],q.property.range[0]],`, ${K}`),V.replaceTextRange([q.property.range[1],H.range[1]],`${K})${X}`)]}})}}}}),RULE_NAME$d="prefer-comparison-matcher",g=d=>isStringNode(d)||d?.type===utils.AST_NODE_TYPES.TemplateLiteral,C=d=>g(d.left)||g(d.right),M$1=d=>{switch(d){case">":return"<=";case"<":return">=";case">=":return"<";case"<=":return">"}return null},O=(d,Y)=>{switch(Y?M$1(d):d){case">":return"toBeGreaterThan";case"<":return"toBeLessThan";case">=":return"toBeGreaterThanOrEqual";case"<=":return"toBeLessThanOrEqual"}return null},dr=createEslintRule({name:RULE_NAME$d,meta:{type:"suggestion",docs:{description:"enforce using the built-in comparison matchers",recommended:!1},schema:[],fixable:"code",messages:{useToBeComparison:"Prefer using `{{ preferredMatcher }}` instead"}},defaultOptions:[],create(d){return{CallExpression(Y){const q=parseVitestFnCall(Y,d);if(q?.type!=="expect"||q.args.length===0)return;const{parent:B}=q.head.node;if(B?.type!==utils.AST_NODE_TYPES.CallExpression)return;const{arguments:[H],range:[,V]}=B,{matcher:K}=q,X=getFirstMatcherArg(q);if(H?.type!==utils.AST_NODE_TYPES.BinaryExpression||C(H)||!EqualityMatcher.hasOwnProperty(getAccessorValue(K))||!isBooleanLiteral(X))return;const[z]=q.modifiers,J=q.modifiers.some(G=>getAccessorValue(G)==="not"),Q=O(H.operator,X.value===J);Q&&d.report({fix(G){const{sourceCode:ee}=d,Z=z&&getAccessorValue(z)!=="not"?`.${getAccessorValue(z)}`:"";return[G.replaceText(H,ee.getText(H.left)),G.replaceTextRange([V,K.parent.range[1]],`${Z}.${Q}`),G.replaceText(X,ee.getText(H.right))]},messageId:"useToBeComparison",data:{preferredMatcher:Q},node:K})}}}}),RULE_NAME$c="prefer-to-contain",T=d=>d.type===utils.AST_NODE_TYPES.CallExpression&&d.callee.type===utils.AST_NODE_TYPES.MemberExpression&&isSupportedAccessor(d.callee.property,"includes")&&hasOnlyOneArgument(d)&&d.arguments[0].type!==utils.AST_NODE_TYPES.SpreadElement,Ar=createEslintRule({name:RULE_NAME$c,meta:{docs:{description:"enforce using toContain()",recommended:!1},messages:{useToContain:"Use toContain() instead"},fixable:"code",type:"suggestion",schema:[]},defaultOptions:[],create(d){return{CallExpression(Y){const q=parseVitestFnCall(Y,d);if(q?.type!=="expect"||q.args.length===0)return;const{parent:B}=q.head.node;if(B?.type!==utils.AST_NODE_TYPES.CallExpression)return;const{arguments:[H],range:[,V]}=B,{matcher:K}=q,X=getFirstMatcherArg(q);if(!H||X.type===utils.AST_NODE_TYPES.SpreadElement||!EqualityMatcher.hasOwnProperty(getAccessorValue(K))||!isBooleanLiteral(X)||!T(H))return;const z=q.modifiers.some(J=>getAccessorValue(J)==="not");d.report({fix(J){const{sourceCode:Q}=d,G=X.value===z;return[J.removeRange([H.callee.property.range[0]-1,H.range[1]]),J.replaceTextRange([V,K.parent.range[1]],G?`.${ModifierName.not}.toContain`:".toContain"),J.replaceText(q.args[0],Q.getText(H.arguments[0]))]},messageId:"useToContain",node:K})}}}}),RULE_NAME$b="prefer-expect-assertions",L=d=>{let Y=d;for(;Y;){if(Y.parent?.type===utils.AST_NODE_TYPES.BlockStatement)return Y.parent.body[0]===Y;if(Y.parent?.type===utils.AST_NODE_TYPES.ArrowFunctionExpression)return!0;Y=Y.parent}throw new Error("Could not find parent block statement")},y$2=(d,Y,q)=>({messageId:"suggestRemovingExtraArguments",fix:B=>removeExtraArgumentsFixer(B,d,Y,q)}),Mr=createEslintRule({name:"prefer-expect-assertions",meta:{docs:{description:"enforce using expect assertions instead of callbacks",recommended:!1},messages:{hasAssertionsTakesNoArguments:"`expect.hasAssertions` expects no arguments",assertionsRequiresOneArgument:"`expect.assertions` excepts a single argument of type number",assertionsRequiresNumberArgument:"This argument should be a number",haveExpectAssertions:"Every test should have either `expect.assertions(<number of assertions>)` or `expect.hasAssertions()` as its first expression",suggestAddingHasAssertions:"Add `expect.hasAssertions()`",suggestAddingAssertions:"Add `expect.assertions(<number of assertions>)`",suggestRemovingExtraArguments:"Remove extra arguments"},type:"suggestion",hasSuggestions:!0,schema:[{type:"object",properties:{onlyFunctionsWithAsyncKeyword:{type:"boolean"},onlyFunctionsWithExpectInLoop:{type:"boolean"},onlyFunctionsWithExpectInCallback:{type:"boolean"}},additionalProperties:!1}]},defaultOptions:[{onlyFunctionsWithAsyncKeyword:!1,onlyFunctionsWithExpectInCallback:!1,onlyFunctionsWithExpectInLoop:!1}],create(d,[Y]){let q=0,B=!1,H=!1,V=!1,K=null,X=!1,z=!1;const J=te=>!!(!Y.onlyFunctionsWithAsyncKeyword&&!Y.onlyFunctionsWithExpectInCallback&&!Y.onlyFunctionsWithExpectInLoop||Y.onlyFunctionsWithAsyncKeyword&&te.async||Y.onlyFunctionsWithExpectInCallback&&B||Y.onlyFunctionsWithExpectInLoop&&H);function Q(te,se){if(getAccessorValue(te.members[0])==="hasAssertions"){te.args.length&&d.report({messageId:"hasAssertionsTakesNoArguments",node:te.matcher,suggest:[y$2(d,se,0)]});return}if(te.args.length!==1){let{loc:re}=te.matcher;const ne=[];te.args.length&&(re=te.args[1].loc,ne.push(y$2(d,se,1))),d.report({messageId:"assertionsRequiresOneArgument",suggest:ne,loc:re});return}const[ie]=te.args;ie.type===utils.AST_NODE_TYPES.Literal&&typeof ie.value=="number"&&Number.isInteger(ie.value)||d.report({messageId:"assertionsRequiresNumberArgument",node:ie})}const G=()=>X&&q++,ee=()=>X&&q--,Z=()=>z=!0,oe=()=>z=!1;return{FunctionExpression:G,"FunctionExpression:exit":ee,ArrowFunctionExpression:G,"ArrowFunctionExpression:exit":ee,ForStatement:Z,"ForStatement:exit":oe,ForInStatement:Z,"ForInStatement:exit":oe,ForOfStatement:Z,"ForOfStatement:exit":oe,CallExpression(te){const se=parseVitestFnCall(te,d);if(se?.type==="test"){X=!0;return}se?.head.type==="testContext"&&se.members[0].type===utils.AST_NODE_TYPES.Identifier&&se.members[0].name==="expect"&&(K=`${se.head.local}`),se?.type==="expect"&&X&&(q===1&&L(te)&&se.head.node.parent?.type===utils.AST_NODE_TYPES.MemberExpression&&se.members.length===1&&["assertions","hasAssertions"].includes(getAccessorValue(se.members[0]))&&(Q(se,te),V=!0),z&&(H=!0),q>1&&(B=!0))},"CallExpression:exit"(te){if(!isTypeOfVitestFnCall(te,d,["test"])||(X=!1,te.arguments.length<2))return;const[,se]=te.arguments;if(!isFunction(se)||!J(se))return;if(H=!1,B=!1,V){V=!1;return}const ie=[];if(se.body.type===utils.AST_NODE_TYPES.BlockStatement){const re=K?`${K}.`:"";ie.push(["suggestAddingHasAssertions",`${re}expect.hasAssertions();`],["suggestAddingAssertions",`${re}expect.assertions();`])}d.report({messageId:"haveExpectAssertions",node:te,suggest:ie.map(([re,ne])=>({messageId:re,fix:ae=>ae.insertTextBeforeRange([se.body.range[0]+1,se.body.range[1]],ne)}))})}}}});var PaddingType=(d=>(d[d.Any=0]="Any",d[d.Always=1]="Always",d))(PaddingType||{}),StatementType=(d=>(d[d.Any=0]="Any",d[d.AfterAllToken=1]="AfterAllToken",d[d.AfterEachToken=2]="AfterEachToken",d[d.BeforeAllToken=3]="BeforeAllToken",d[d.BeforeEachToken=4]="BeforeEachToken",d[d.DescribeToken=5]="DescribeToken",d[d.ExpectToken=6]="ExpectToken",d[d.ExpectTypeOfToken=7]="ExpectTypeOfToken",d[d.FdescribeToken=8]="FdescribeToken",d[d.FitToken=9]="FitToken",d[d.ItToken=10]="ItToken",d[d.TestToken=11]="TestToken",d[d.XdescribeToken=12]="XdescribeToken",d[d.XitToken=13]="XitToken",d[d.XtestToken=14]="XtestToken",d))(StatementType||{});const x$1=(d,Y,q)=>{const{sourceCode:B,ruleContext:H}=q;getPaddingLineSequences(d,Y,B).length>0||H.report({node:Y,messageId:"missingPadding",fix(V){let K=getActualLastToken(B,d);const X=B.getFirstTokenBetween(K,Y,{includeComments:!0,filter(J){return areTokensOnSameLine(K,J)?(K=J,!1):!0}})||Y,z=areTokensOnSameLine(K,X)?`

`:`
`;return V.insertTextAfter(K,z)}})},m$1={0:()=>!0,1:x$1},y$1=()=>{let d=null;return{get prevNode(){return d.prevNode},set prevNode(Y){d.prevNode=Y},enter(){d={upper:d,prevNode:null}},exit(){d=d.upper}}},i=d=>(Y,q)=>{let B=Y;if(B.type===utils.AST_NODE_TYPES.ExpressionStatement){B.expression.type===utils.AST_NODE_TYPES.AwaitExpression&&(B=B.expression.argument);const H=q.getFirstToken(B);return H?.type===utils.AST_TOKEN_TYPES.Identifier&&H.value===d}return!1},A={0:()=>!0,1:i("afterAll"),2:i("afterEach"),3:i("beforeAll"),4:i("beforeEach"),5:i("describe"),6:i("expect"),7:i("expectTypeOf"),8:i("fdescribe"),9:i("fit"),10:i("it"),11:i("test"),12:i("xdescribe"),13:i("xit"),14:i("xtest")},l$1=(d,Y,q)=>{let B=d;const{sourceCode:H}=q;for(;B.type===utils.AST_NODE_TYPES.LabeledStatement;)B=B.body;return Array.isArray(Y)?Y.some(V=>l$1(B,V,q)):A[Y](B,H)},N$1=(d,Y,q)=>{const{configs:B}=q,H=V=>m$1[V](d,Y,q);for(let V=B.length-1;V>=0;--V){const{prevStatementType:K,nextStatementType:X,paddingType:z}=B[V];if(l$1(d,K,q)&&l$1(Y,X,q))return H(z)}return H(0)},u=(d,Y)=>{const{scopeInfo:q}=Y;isValidParent(d?.parent.type)&&(q.prevNode&&N$1(q.prevNode,d,Y),q.prevNode=d)},createPaddingRule=(d,Y,q,B=!1)=>createEslintRule({name:d,meta:{docs:{description:Y},fixable:"whitespace",deprecated:B,messages:{missingPadding:"expect blank line before this statement"},schema:[],type:"suggestion"},defaultOptions:[],create(H){const V={ruleContext:H,sourceCode:H.sourceCode??H.getSourceCode(),scopeInfo:y$1(),configs:q},{scopeInfo:K}=V;return{Program:K.enter,"Program:exit":K.exit,BlockStatement:K.enter,"BlockStatement:exit":K.exit,SwitchStatement:K.enter,"SwitchStatement:exit":K.exit,":statement":X=>u(X,V),SwitchCase(X){u(X,V),K.enter()},"SwitchCase:exit":K.exit}}}),RULE_NAME$a="padding-around-after-all-blocks",config$6=[{paddingType:PaddingType.Always,prevStatementType:StatementType.Any,nextStatementType:StatementType.AfterAllToken},{paddingType:PaddingType.Always,prevStatementType:StatementType.AfterAllToken,nextStatementType:StatementType.Any}],ur=createPaddingRule(RULE_NAME$a,"Enforce padding around `afterAll` blocks",config$6),RULE_NAME$9="padding-around-after-each-blocks",config$5=[{paddingType:PaddingType.Always,prevStatementType:StatementType.Any,nextStatementType:StatementType.AfterEachToken},{paddingType:PaddingType.Always,prevStatementType:StatementType.AfterEachToken,nextStatementType:StatementType.Any}],wr=createPaddingRule(RULE_NAME$9,"Enforce padding around `afterEach` blocks",config$5),RULE_NAME$8="padding-around-before-all-blocks",config$4=[{paddingType:PaddingType.Always,prevStatementType:StatementType.Any,nextStatementType:StatementType.BeforeAllToken},{paddingType:PaddingType.Always,prevStatementType:StatementType.BeforeAllToken,nextStatementType:StatementType.Any}],Lr=createPaddingRule(RULE_NAME$8,"Enforce padding around `beforeAll` blocks",config$4),RULE_NAME$7="padding-around-before-each-blocks",config$3=[{paddingType:PaddingType.Always,prevStatementType:StatementType.Any,nextStatementType:StatementType.BeforeEachToken},{paddingType:PaddingType.Always,prevStatementType:StatementType.BeforeEachToken,nextStatementType:StatementType.Any}],Tr=createPaddingRule(RULE_NAME$7,"Enforce padding around `beforeEach` blocks",config$3),RULE_NAME$6="padding-around-describe-blocks",config$2=[{paddingType:PaddingType.Always,prevStatementType:StatementType.Any,nextStatementType:[StatementType.DescribeToken,StatementType.FdescribeToken,StatementType.XdescribeToken]},{paddingType:PaddingType.Always,prevStatementType:[StatementType.DescribeToken,StatementType.FdescribeToken,StatementType.XdescribeToken],nextStatementType:StatementType.Any}],Ur=createPaddingRule(RULE_NAME$6,"Enforce padding around `describe` blocks",config$2),RULE_NAME$5="padding-around-expect-groups",config$1=[{paddingType:PaddingType.Always,prevStatementType:StatementType.Any,nextStatementType:StatementType.ExpectToken},{paddingType:PaddingType.Always,prevStatementType:StatementType.ExpectToken,nextStatementType:StatementType.Any},{paddingType:PaddingType.Any,prevStatementType:StatementType.ExpectToken,nextStatementType:StatementType.ExpectToken},{paddingType:PaddingType.Always,prevStatementType:StatementType.Any,nextStatementType:StatementType.ExpectTypeOfToken},{paddingType:PaddingType.Always,prevStatementType:StatementType.ExpectTypeOfToken,nextStatementType:StatementType.Any},{paddingType:PaddingType.Any,prevStatementType:StatementType.ExpectTypeOfToken,nextStatementType:StatementType.ExpectTypeOfToken}],_r=createPaddingRule(RULE_NAME$5,"Enforce padding around `expect` groups",config$1),RULE_NAME$4="padding-around-test-blocks",config=[{paddingType:PaddingType.Always,prevStatementType:StatementType.Any,nextStatementType:[StatementType.TestToken,StatementType.ItToken,StatementType.FitToken,StatementType.XitToken,StatementType.XtestToken]},{paddingType:PaddingType.Always,prevStatementType:[StatementType.TestToken,StatementType.ItToken,StatementType.FitToken,StatementType.XitToken,StatementType.XtestToken],nextStatementType:StatementType.Any}],hr=createPaddingRule(RULE_NAME$4,"Enforce padding around `test` blocks",config),RULE_NAME$3="padding-around-all",Rr=createPaddingRule(RULE_NAME$3,"Enforce padding around vitest functions",[...config$6,...config$5,...config$4,...config$3,...config$2,...config$1,...config]),RULE_NAME$2="valid-expect-in-promise",w=["toRejectWith","toResolveWith"],c=d=>{if(d.type===utils.AST_NODE_TYPES.CallExpression&&d.callee.type===utils.AST_NODE_TYPES.MemberExpression&&isSupportedAccessor(d.callee.property)){if(d.arguments.length===0)return!1;switch(getAccessorValue(d.callee.property)){case"then":return d.arguments.length<3;case"catch":case"finally":return d.arguments.length<2}}return!1},k=(d,Y)=>{const q=parseVitestFnCall(d,Y);if(q?.type!=="test")return!1;const B=q.members.some(K=>getAccessorValue(K)==="each");if(B&&d.callee.type!==utils.AST_NODE_TYPES.TaggedTemplateExpression)return!0;const[,H]=d.arguments,V=Number(B);return H&&isFunction(H)&&H.params.length===1+V},x=(d,Y)=>{const{name:q}=Y;if(d.argument===null)return!1;if(d.argument.type===utils.AST_NODE_TYPES.CallExpression&&d.argument.arguments.length>0){const B=getNodeName(d.argument);if(["Promise.all","Promise.allSettled"].includes(B)){const[H]=d.argument.arguments;if(H.type===utils.AST_NODE_TYPES.ArrayExpression&&H.elements.some(V=>V&&isIdentifier(V,q)))return!0}if(["Promise.resolve","Promise.reject"].includes(B)&&d.argument.arguments.length===1)return isIdentifier(d.argument.arguments[0],q)}return isIdentifier(d.argument,q)},h=(d,Y)=>{for(const q of Y)if(q?.type===utils.AST_NODE_TYPES.AwaitExpression&&isIdentifier(q.argument,d)||q?.type===utils.AST_NODE_TYPES.ArrayExpression&&h(d,q.elements))return!0;return!1},M=(d,Y)=>{let q=Y;for(;q;){if(q.type===utils.AST_NODE_TYPES.CallExpression){if(h(d,q.arguments))return!0;q=q.callee}if(q.type!==utils.AST_NODE_TYPES.MemberExpression)break;q=q.object}return!1},N=d=>{let Y=d,q=d;for(;q&&(q.type===utils.AST_NODE_TYPES.CallExpression&&(Y=q,q=q.callee),q.type===utils.AST_NODE_TYPES.MemberExpression);)q=q.object;return Y},m=(d,Y,q)=>{const{name:B}=d;for(const H of Y)if(!(H.range[0]<=d.range[0])){if(H.type===utils.AST_NODE_TYPES.ReturnStatement)return x(H,d);if(H.type===utils.AST_NODE_TYPES.ExpressionStatement){if(H.expression.type===utils.AST_NODE_TYPES.CallExpression){if(M(B,H.expression))return!0;const V=N(H.expression),K=parseVitestFnCall(H.expression,q);if(K?.type==="expect"&&V.arguments.length>0&&isIdentifier(V.arguments[0],B)&&K.members.some(X=>{const z=getAccessorValue(X);return z===ModifierName.resolves||z===ModifierName.rejects}))return!0}if(H.expression.type===utils.AST_NODE_TYPES.AwaitExpression&&x(H.expression,d))return!0;if(H.expression.type===utils.AST_NODE_TYPES.AssignmentExpression){if(isIdentifier(H.expression.left,B)&&getNodeName(H.expression.right)?.startsWith(`${B}.`)&&c(H.expression.right))continue;break}}if(H.type===utils.AST_NODE_TYPES.BlockStatement&&m(d,H.body,q))return!0}return!1},y=d=>{let Y=d;for(;Y;){if(Y.type===utils.AST_NODE_TYPES.BlockStatement)return Y.body;Y=Y.parent}throw new Error("Could not find BlockStatement - please file a github issue at https://github.com/vitest-dev/eslint-plugin-vitest")},I=(d,Y)=>{let q=d;for(;q;){if(isFunction(q))return q=q.parent,q?.type===utils.AST_NODE_TYPES.CallExpression&&isTypeOfVitestFnCall(q,Y,["test"]);q=q.parent}return!1},P=(d,Y)=>{const q=y(d);return isIdentifier(d.id)?m(d.id,q,Y):!0},gr=createEslintRule({name:RULE_NAME$2,meta:{docs:{description:"require promises that have expectations in their chain to be valid"},messages:{expectInFloatingPromise:"This promise should either be returned or awaited to ensure the expects in its chain are called"},type:"suggestion",schema:[]},defaultOptions:[{alwaysAwait:!1,asyncMatchers:w,minArgs:1,maxArgs:1}],create(d){let Y=!1;const q=[];return{CallExpression(B){if(k(B,d)){Y=!0;return}if(c(B)){q.unshift(!1);return}q.length>0&&isTypeOfVitestFnCall(B,d,["expect"])&&(q[0]=!0)},"CallExpression:exit"(B){if(Y){isTypeOfVitestFnCall(B,d,["test"])&&(Y=!1);return}if(!c(B)||!q.shift())return;const{parent:H}=findTopMostCallExpression(B);if(!(!H||!I(H,d))){switch(H.type){case utils.AST_NODE_TYPES.VariableDeclarator:{if(P(H,d))return;break}case utils.AST_NODE_TYPES.AssignmentExpression:{if(H.left.type===utils.AST_NODE_TYPES.Identifier&&m(H.left,y(H),d))return;break}case utils.AST_NODE_TYPES.ExpressionStatement:break;case utils.AST_NODE_TYPES.ReturnStatement:case utils.AST_NODE_TYPES.AwaitExpression:default:return}d.report({messageId:"expectInFloatingPromise",node:H})}}}}}),RULE_NAME$1="prefer-strict-boolean-matchers",br=createEslintRule({name:RULE_NAME$1,meta:{type:"suggestion",docs:{description:"enforce using `toBe(true)` and `toBe(false)` over matchers that coerce types to boolean",recommended:!1},messages:{preferToBeTrue:"Prefer using `toBe(true)` to test value is `true`",preferToBeFalse:"Prefer using `toBe(false)` to test value is `false`"},fixable:"code",schema:[]},defaultOptions:[],create(d){return{CallExpression(Y){const q=parseVitestFnCall(Y,d);if(!(q?.type==="expect"||q?.type==="expectTypeOf"))return;const B=getAccessorValue(q.matcher);B==="toBeFalsy"&&d.report({node:q.matcher,messageId:"preferToBeFalse",fix:H=>[H.replaceText(q.matcher,"toBe"),H.insertTextAfterRange([q.matcher.range[0],q.matcher.range[1]+1],"false")]}),B==="toBeTruthy"&&d.report({node:q.matcher,messageId:"preferToBeTrue",fix:H=>[H.replaceText(q.matcher,"toBe"),H.insertTextAfterRange([q.matcher.range[0],q.matcher.range[1]+1],"true")]})}}}}),RULE_NAME="require-mock-type-parameters",kr=createEslintRule({name:RULE_NAME,meta:{type:"suggestion",docs:{description:"enforce using type parameters with vitest mock functions",recommended:!1},messages:{noTypeParameter:"Missing type parameters"},fixable:"code",schema:[{type:"object",properties:{checkImportFunctions:{type:"boolean"}},additionalProperties:!1}]},defaultOptions:[{checkImportFunctions:!1}],create(d,[Y]){return{CallExpression(q){const B=parseVitestFnCall(q,d);if(B?.type==="vi")for(const H of B?.members)!("name"in H)||H.parent.parent.typeArguments!==void 0||(H.name==="fn"&&d.report({node:H,messageId:"noTypeParameter"}),Y.checkImportFunctions&&["importActual","importMock"].includes(H.name)&&d.report({node:H,messageId:"noTypeParameter"}))}}}}),Ne=d=>Object.keys(d).reduce((Y,q)=>({...Y,[`vitest/${q}`]:d[q]}),{}),de=d=>({plugins:["@vitest"],rules:Object.keys(d).reduce((Y,q)=>({...Y,[`@vitest/${q}`]:d[q]}),{})}),Ae={[RULE_NAME$$]:"warn",[RULE_NAME$_]:"warn",[RULE_NAME$Y]:"warn",[RULE_NAME$X]:"warn",[RULE_NAME$V]:"warn",[RULE_NAME$T]:"warn",[RULE_NAME$S]:"warn",[RULE_NAME$R]:"warn",[RULE_NAME$Q]:"warn",[RULE_NAME$P]:"warn",[RULE_NAME$N]:"warn",[RULE_NAME$L]:"warn",[RULE_NAME$K]:"warn",[RULE_NAME$J]:"warn",[RULE_NAME$I]:"warn",[RULE_NAME$H]:"warn",[RULE_NAME$G]:"warn",[RULE_NAME$F]:"warn",[RULE_NAME$E]:"warn",[RULE_NAME$D]:"warn",[RULE_NAME$C]:"warn",[RULE_NAME$B]:"warn",[RULE_NAME$A]:"warn",[RULE_NAME$v]:"off",[RULE_NAME$x]:"warn",[RULE_NAME$w]:"off",[RULE_NAME$u]:"warn",[RULE_NAME$t]:"warn",[RULE_NAME$s]:"warn",[RULE_NAME$r]:"warn",[RULE_NAME$q]:"warn",[RULE_NAME$p]:"warn",[RULE_NAME$o]:"warn",[RULE_NAME$n]:"warn",[RULE_NAME$m]:"warn",[RULE_NAME$l]:"warn",[RULE_NAME$j]:"warn",[RULE_NAME$i]:"warn",[RULE_NAME$h]:"warn",[RULE_NAME$f]:"warn",[RULE_NAME$e]:"warn",[RULE_NAME$d]:"warn",[RULE_NAME$c]:"warn",[RULE_NAME$b]:"warn",[RULE_NAME$U]:"warn",[RULE_NAME$a]:"warn",[RULE_NAME$9]:"warn",[RULE_NAME$3]:"warn",[RULE_NAME$8]:"warn",[RULE_NAME$7]:"warn",[RULE_NAME$6]:"warn",[RULE_NAME$5]:"warn",[RULE_NAME$4]:"warn",[RULE_NAME$2]:"warn",[RULE_NAME$W]:"warn",[RULE_NAME$Z]:"warn",[RULE_NAME$O]:"warn",[RULE_NAME$z]:"warn",[RULE_NAME$y]:"warn",[RULE_NAME$k]:"warn",[RULE_NAME$g]:"warn",[RULE_NAME$M]:"warn",[RULE_NAME$1]:"warn",[RULE_NAME]:"warn"},Me={[RULE_NAME$W]:"error",[RULE_NAME$Z]:"error",[RULE_NAME$O]:"error",[RULE_NAME$z]:"error",[RULE_NAME$y]:"error",[RULE_NAME$k]:"error",[RULE_NAME$g]:"error",[RULE_NAME$M]:"error"},l={meta:{name:"vitest",version},rules:{[RULE_NAME$$]:we,[RULE_NAME$_]:Re,[RULE_NAME$Z]:Le,[RULE_NAME$Y]:Te,[RULE_NAME$X]:Ue,[RULE_NAME$W]:_e,[RULE_NAME$V]:he,[RULE_NAME$U]:ge,[RULE_NAME$T]:be,[RULE_NAME$S]:ke,[RULE_NAME$R]:xe,[RULE_NAME$Q]:ve,[RULE_NAME$P]:Ce,[RULE_NAME$O]:Be,[RULE_NAME$N]:Se,[RULE_NAME$L]:Ie,[RULE_NAME$K]:He,[RULE_NAME$J]:Oe,[RULE_NAME$I]:qe,[RULE_NAME$H]:De,[RULE_NAME$G]:Fe,[RULE_NAME$F]:Pe,[RULE_NAME$E]:je,[RULE_NAME$D]:Ve,[RULE_NAME$C]:Ke,[RULE_NAME$B]:$e,[RULE_NAME$M]:ye,[RULE_NAME$A]:Ge,[RULE_NAME$z]:We,[RULE_NAME$y]:ze,[RULE_NAME$v]:Xe,[RULE_NAME$x]:Je,[RULE_NAME$w]:Qe,[RULE_NAME$u]:Ye,[RULE_NAME$t]:Ze,[RULE_NAME$s]:er,[RULE_NAME$r]:rr,[RULE_NAME$q]:or,[RULE_NAME$p]:ar,[RULE_NAME$o]:tr,[RULE_NAME$g]:fr,[RULE_NAME$n]:nr,[RULE_NAME$m]:sr,[RULE_NAME$l]:ir,[RULE_NAME$k]:mr,[RULE_NAME$j]:pr,[RULE_NAME$i]:Er,[RULE_NAME$h]:lr,[RULE_NAME$f]:cr,[RULE_NAME$e]:Nr,[RULE_NAME$d]:dr,[RULE_NAME$c]:Ar,[RULE_NAME$b]:Mr,[RULE_NAME$a]:ur,[RULE_NAME$9]:wr,[RULE_NAME$3]:Rr,[RULE_NAME$8]:Lr,[RULE_NAME$7]:Tr,[RULE_NAME$6]:Ur,[RULE_NAME$5]:_r,[RULE_NAME$4]:hr,[RULE_NAME$2]:gr,[RULE_NAME$1]:br,[RULE_NAME]:kr},environments:{env:{globals:{suite:!0,test:!0,describe:!0,it:!0,expectTypeOf:!0,assertType:!0,expect:!0,assert:!0,chai:!0,vitest:!0,vi:!0,beforeAll:!0,afterAll:!0,beforeEach:!0,afterEach:!0,onTestFailed:!0,onTestFinished:!0}}},configs:{"legacy-recommended":de(Me),"legacy-all":de(Ae),recommended:{name:"@vitest/recommended",plugins:{get vitest(){return l}},rules:Ne(Me)},all:{name:"@vitest/all",plugins:{get vitest(){return l}},rules:Ne(Ae)},env:{name:"@vitest/env",languageOptions:{globals:{suite:"writable",test:"writable",describe:"writable",it:"writable",expectTypeOf:"writable",assertType:"writable",expect:"writable",assert:"writable",chai:"writable",vitest:"writable",vi:"writable",beforeAll:"writable",afterAll:"writable",beforeEach:"writable",afterEach:"writable",onTestFailed:"writable",onTestFinished:"writable"}}}}};module.exports=l;
