# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.computeschedule import ComputeScheduleMgmtClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestComputeScheduleMgmtScheduledActionsOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(ComputeScheduleMgmtClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_scheduled_actions_virtual_machines_submit_deallocate(self, resource_group):
        response = self.client.scheduled_actions.virtual_machines_submit_deallocate(
            locationparameter="str",
            request_body={
                "correlationid": "str",
                "executionParameters": {
                    "optimizationPreference": "str",
                    "retryPolicy": {"retryCount": 0, "retryWindowInMinutes": 0},
                },
                "resources": {"ids": ["str"]},
                "schedule": {
                    "deadlineType": "str",
                    "deadLine": "2020-02-20 00:00:00",
                    "deadline": "2020-02-20 00:00:00",
                    "timeZone": "str",
                    "timezone": "str",
                },
            },
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_scheduled_actions_virtual_machines_submit_hibernate(self, resource_group):
        response = self.client.scheduled_actions.virtual_machines_submit_hibernate(
            locationparameter="str",
            request_body={
                "correlationid": "str",
                "executionParameters": {
                    "optimizationPreference": "str",
                    "retryPolicy": {"retryCount": 0, "retryWindowInMinutes": 0},
                },
                "resources": {"ids": ["str"]},
                "schedule": {
                    "deadlineType": "str",
                    "deadLine": "2020-02-20 00:00:00",
                    "deadline": "2020-02-20 00:00:00",
                    "timeZone": "str",
                    "timezone": "str",
                },
            },
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_scheduled_actions_virtual_machines_submit_start(self, resource_group):
        response = self.client.scheduled_actions.virtual_machines_submit_start(
            locationparameter="str",
            request_body={
                "correlationid": "str",
                "executionParameters": {
                    "optimizationPreference": "str",
                    "retryPolicy": {"retryCount": 0, "retryWindowInMinutes": 0},
                },
                "resources": {"ids": ["str"]},
                "schedule": {
                    "deadlineType": "str",
                    "deadLine": "2020-02-20 00:00:00",
                    "deadline": "2020-02-20 00:00:00",
                    "timeZone": "str",
                    "timezone": "str",
                },
            },
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_scheduled_actions_virtual_machines_execute_deallocate(self, resource_group):
        response = self.client.scheduled_actions.virtual_machines_execute_deallocate(
            locationparameter="str",
            request_body={
                "correlationid": "str",
                "executionParameters": {
                    "optimizationPreference": "str",
                    "retryPolicy": {"retryCount": 0, "retryWindowInMinutes": 0},
                },
                "resources": {"ids": ["str"]},
            },
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_scheduled_actions_virtual_machines_execute_hibernate(self, resource_group):
        response = self.client.scheduled_actions.virtual_machines_execute_hibernate(
            locationparameter="str",
            request_body={
                "correlationid": "str",
                "executionParameters": {
                    "optimizationPreference": "str",
                    "retryPolicy": {"retryCount": 0, "retryWindowInMinutes": 0},
                },
                "resources": {"ids": ["str"]},
            },
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_scheduled_actions_virtual_machines_execute_start(self, resource_group):
        response = self.client.scheduled_actions.virtual_machines_execute_start(
            locationparameter="str",
            request_body={
                "correlationid": "str",
                "executionParameters": {
                    "optimizationPreference": "str",
                    "retryPolicy": {"retryCount": 0, "retryWindowInMinutes": 0},
                },
                "resources": {"ids": ["str"]},
            },
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_scheduled_actions_virtual_machines_execute_create(self, resource_group):
        response = self.client.scheduled_actions.virtual_machines_execute_create(
            locationparameter="str",
            request_body={
                "executionParameters": {
                    "optimizationPreference": "str",
                    "retryPolicy": {"retryCount": 0, "retryWindowInMinutes": 0},
                },
                "resourceConfigParameters": {
                    "resourceCount": 0,
                    "baseProfile": {"str": {}},
                    "resourceOverrides": [{"str": {}}],
                    "resourcePrefix": "str",
                },
                "correlationid": "str",
            },
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_scheduled_actions_virtual_machines_execute_delete(self, resource_group):
        response = self.client.scheduled_actions.virtual_machines_execute_delete(
            locationparameter="str",
            request_body={
                "executionParameters": {
                    "optimizationPreference": "str",
                    "retryPolicy": {"retryCount": 0, "retryWindowInMinutes": 0},
                },
                "resources": {"ids": ["str"]},
                "correlationid": "str",
                "forceDeletion": bool,
            },
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_scheduled_actions_virtual_machines_get_operation_status(self, resource_group):
        response = self.client.scheduled_actions.virtual_machines_get_operation_status(
            locationparameter="str",
            request_body={"correlationid": "str", "operationIds": ["str"]},
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_scheduled_actions_virtual_machines_cancel_operations(self, resource_group):
        response = self.client.scheduled_actions.virtual_machines_cancel_operations(
            locationparameter="str",
            request_body={"correlationid": "str", "operationIds": ["str"]},
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_scheduled_actions_virtual_machines_get_operation_errors(self, resource_group):
        response = self.client.scheduled_actions.virtual_machines_get_operation_errors(
            locationparameter="str",
            request_body={"operationIds": ["str"]},
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_scheduled_actions_get(self, resource_group):
        response = self.client.scheduled_actions.get(
            resource_group_name=resource_group.name,
            scheduled_action_name="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_scheduled_actions_begin_create_or_update(self, resource_group):
        response = self.client.scheduled_actions.begin_create_or_update(
            resource_group_name=resource_group.name,
            scheduled_action_name="str",
            resource={
                "location": "str",
                "id": "str",
                "name": "str",
                "properties": {
                    "actionType": "str",
                    "notificationSettings": [
                        {"destination": "str", "language": "str", "type": "str", "disabled": bool}
                    ],
                    "resourceType": "str",
                    "schedule": {
                        "requestedDaysOfTheMonth": [0],
                        "requestedMonths": ["str"],
                        "requestedWeekDays": ["str"],
                        "scheduledTime": "12:30:00",
                        "timeZone": "str",
                        "deadlineType": "str",
                        "executionParameters": {
                            "optimizationPreference": "str",
                            "retryPolicy": {"retryCount": 0, "retryWindowInMinutes": 0},
                        },
                    },
                    "startTime": "2020-02-20 00:00:00",
                    "disabled": bool,
                    "endTime": "2020-02-20 00:00:00",
                    "provisioningState": "str",
                },
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "tags": {"str": "str"},
                "type": "str",
            },
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_scheduled_actions_update(self, resource_group):
        response = self.client.scheduled_actions.update(
            resource_group_name=resource_group.name,
            scheduled_action_name="str",
            properties={
                "properties": {
                    "actionType": "str",
                    "disabled": bool,
                    "endTime": "2020-02-20 00:00:00",
                    "notificationSettings": [
                        {"destination": "str", "language": "str", "type": "str", "disabled": bool}
                    ],
                    "resourceType": "str",
                    "schedule": {
                        "requestedDaysOfTheMonth": [0],
                        "requestedMonths": ["str"],
                        "requestedWeekDays": ["str"],
                        "scheduledTime": "12:30:00",
                        "timeZone": "str",
                        "deadlineType": "str",
                        "executionParameters": {
                            "optimizationPreference": "str",
                            "retryPolicy": {"retryCount": 0, "retryWindowInMinutes": 0},
                        },
                    },
                    "startTime": "2020-02-20 00:00:00",
                },
                "tags": {"str": "str"},
            },
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_scheduled_actions_begin_delete(self, resource_group):
        response = self.client.scheduled_actions.begin_delete(
            resource_group_name=resource_group.name,
            scheduled_action_name="str",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_scheduled_actions_list_by_resource_group(self, resource_group):
        response = self.client.scheduled_actions.list_by_resource_group(
            resource_group_name=resource_group.name,
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_scheduled_actions_list_by_subscription(self, resource_group):
        response = self.client.scheduled_actions.list_by_subscription()
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_scheduled_actions_list_resources(self, resource_group):
        response = self.client.scheduled_actions.list_resources(
            resource_group_name=resource_group.name,
            scheduled_action_name="str",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_scheduled_actions_attach_resources(self, resource_group):
        response = self.client.scheduled_actions.attach_resources(
            resource_group_name=resource_group.name,
            scheduled_action_name="str",
            body={
                "resources": [
                    {
                        "id": "str",
                        "name": "str",
                        "resourceId": "str",
                        "notificationSettings": [
                            {"destination": "str", "language": "str", "type": "str", "disabled": bool}
                        ],
                        "type": "str",
                    }
                ]
            },
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_scheduled_actions_detach_resources(self, resource_group):
        response = self.client.scheduled_actions.detach_resources(
            resource_group_name=resource_group.name,
            scheduled_action_name="str",
            body={"resources": ["str"]},
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_scheduled_actions_patch_resources(self, resource_group):
        response = self.client.scheduled_actions.patch_resources(
            resource_group_name=resource_group.name,
            scheduled_action_name="str",
            body={
                "resources": [
                    {
                        "id": "str",
                        "name": "str",
                        "resourceId": "str",
                        "notificationSettings": [
                            {"destination": "str", "language": "str", "type": "str", "disabled": bool}
                        ],
                        "type": "str",
                    }
                ]
            },
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_scheduled_actions_disable(self, resource_group):
        response = self.client.scheduled_actions.disable(
            resource_group_name=resource_group.name,
            scheduled_action_name="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_scheduled_actions_enable(self, resource_group):
        response = self.client.scheduled_actions.enable(
            resource_group_name=resource_group.name,
            scheduled_action_name="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_scheduled_actions_cancel_next_occurrence(self, resource_group):
        response = self.client.scheduled_actions.cancel_next_occurrence(
            resource_group_name=resource_group.name,
            scheduled_action_name="str",
            body={"resourceIds": ["str"]},
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_scheduled_actions_trigger_manual_occurrence(self, resource_group):
        response = self.client.scheduled_actions.trigger_manual_occurrence(
            resource_group_name=resource_group.name,
            scheduled_action_name="str",
        )

        # please add some check logic here by yourself
        # ...
