"""severities histogram constraint

Revision ID: 443a136bb5f2
Revises: 33094e577642
Create Date: 2023-12-01 17:39:24.284436+00:00

"""
from alembic import op

# revision identifiers, used by Alembic.
revision = '443a136bb5f2'
down_revision = '33094e577642'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    # Fix duplicated histograms
    conn = op.get_bind()
    rows = conn.execute('SELECT '  # nosec
               'SUM(medium) as medium, '
               'SUM(high) as high,'
               'SUM(critical) as critical, '
               'SUM(confirmed) as confirmed, '
               'workspace_id, '
               'date, '
               'COUNT(*) '
               'FROM severities_histogram '
               'group by '
               'workspace_id, '
               'date '
               'having COUNT(*) > 1')
    for row in rows:
        conn.execute(f"DELETE FROM severities_histogram WHERE workspace_id={row[4]} AND date='{row[5]}'")  # nosec
        conn.execute(f"insert into severities_histogram (workspace_id, date, medium, high, critical, confirmed)"
                     f" values('{row[4]}','{row[5]}','{row[0]}','{row[1]}','{row[2]}','{row[3]}')")
    op.create_unique_constraint('uix_severities_histogram_table_date_workspace_id', 'severities_histogram',
                                ['date', 'workspace_id'])
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_constraint('uix_severities_histogram_table_date_workspace_id', 'severities_histogram', type_='unique')
    # ### end Alembic commands ###
