title: Release Notes for v3.2

# Python-Markdown 3.2 Release Notes

Python-Markdown version 3.2 supports Python versions 3.5, 3.6, 3.7, 3.8, and
PyPy3.

## Backwards-incompatible changes

### Drop support for Python 2.7

Python 2.7 reaches end-of-life on 2020-01-01 and Python-Markdown 3.2 has dropped
support for it. Please upgrade to Python 3, or use Python-Markdown 3.1.

### `em` and `strong` inline processor changes

In order to fix issue #792, `em`/`strong` inline processors were refactored. This
translated into removing many of the existing inline processors that handled this
logic:

* `em_strong`
* `strong`
* `emphasis`
* `strong2`
* `emphasis`

These processors were replaced with two new ones:

* `em_strong`
* `em_strong2`

The [`legacy_em`](../extensions/legacy_em.md) extension was also modified with new,
refactored logic and simply overrides the `em_strong2` inline processor.

### CodeHilite now always wraps with `<code>` tags

Before, the HTML generated by CodeHilite looked like:
- `<pre><code>foo = 'bar'</code></pre>` if you **were not** using Pygments.
- `<pre>foo = 'bar'</pre>`  if you **were** using Pygments.

To make the cases more consistent (and adhere to many Markdown specifications and
HTML code block markup suggestions), CodeHilite will now always additionally wrap
code with `<code>` tags. See #862 for more details.

This change does not alter the Python-Markdown API, but users relying on the old
markup will find their output now changed.

Internally, this change relies on the Pygments 2.4, so you must be using at least
that version to see this effect. Users with earlier Pygments versions will
continue to see the old behavior.

### `markdown.util.etree` deprecated

Previously, Python-Markdown was using either the `xml.etree.cElementTree` module
or the `xml.etree.ElementTree` module, based on their availability. In modern
Python versions, the former is a deprecated alias for the latter. Thus, the
compatibility layer is deprecated and extensions are advised to use
`xml.etree.ElementTree` directly. Importing `markdown.util.etree` will raise
a `DeprecationWarning` beginning in version 3.2 and may be removed in a future
release.

Therefore, extension developers are encouraged to replace
`from markdown.util import etree` with
`import xml.etree.ElementTree as etree` in their code.

## New features

The following new features have been included in the release:

* Some new configuration options have been added to the [toc](../extensions/toc.md)
  extension:

    * The `anchorlink_class` and `permalink_class` options allow class(es) to be
      assigned to the `anchorlink` and `permalink` respectively. This allows using
      icon fonts from CSS for the links. Therefore, an empty string passed to
      `permalink` now generates an empty `permalink`. Previously no `permalink`
      would have been generated. (#776)

    * The `permalink_title` option allows the title attribute of a `permalink` to be
      set to something other than the default English string `Permanent link`. (#877)

* Document thread safety (#812).

* Markdown parsing in HTML has been exposed via a separate extension called
  [`md_in_html`](../extensions/md_in_html.md).

* Add support for Python 3.8.

## Bug fixes

The following bug fixes are included in the 3.2 release:

* HTML tag placeholders are no longer included in  `.toc_tokens` (#899).
* Unescape backslash-escaped characters in TOC ids (#864).
* Refactor bold and italic logic in order to solve complex nesting issues (#792).
* Always wrap CodeHilite code in `code` tags (#862).
