// This file was generated by gir (https://github.com/gtk-rs/gir)
// from
// from gir-files (https://github.com/gtk-rs/gir-files.git)
// DO NOT EDIT

use crate::{ffi, Language};
use glib::{
    prelude::*,
    signal::{connect_raw, SignalHandlerId},
    translate::*,
};
use std::boxed::Box as Box_;

glib::wrapper! {
    #[doc(alias = "GtkSourceLanguageManager")]
    pub struct LanguageManager(Object<ffi::GtkSourceLanguageManager, ffi::GtkSourceLanguageManagerClass>);

    match fn {
        type_ => || ffi::gtk_source_language_manager_get_type(),
    }
}

impl LanguageManager {
    #[doc(alias = "gtk_source_language_manager_new")]
    pub fn new() -> LanguageManager {
        assert_initialized_main_thread!();
        unsafe { from_glib_full(ffi::gtk_source_language_manager_new()) }
    }

    // rustdoc-stripper-ignore-next
    /// Creates a new builder-pattern struct instance to construct [`LanguageManager`] objects.
    ///
    /// This method returns an instance of [`LanguageManagerBuilder`](crate::builders::LanguageManagerBuilder) which can be used to create [`LanguageManager`] objects.
    pub fn builder() -> LanguageManagerBuilder {
        LanguageManagerBuilder::new()
    }

    #[cfg(feature = "v5_4")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v5_4")))]
    #[doc(alias = "gtk_source_language_manager_append_search_path")]
    pub fn append_search_path(&self, path: &str) {
        unsafe {
            ffi::gtk_source_language_manager_append_search_path(
                self.to_glib_none().0,
                path.to_glib_none().0,
            );
        }
    }

    #[doc(alias = "gtk_source_language_manager_get_language")]
    #[doc(alias = "get_language")]
    pub fn language(&self, id: &str) -> Option<Language> {
        unsafe {
            from_glib_none(ffi::gtk_source_language_manager_get_language(
                self.to_glib_none().0,
                id.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_source_language_manager_get_language_ids")]
    #[doc(alias = "get_language_ids")]
    #[doc(alias = "language-ids")]
    pub fn language_ids(&self) -> Vec<glib::GString> {
        unsafe {
            FromGlibPtrContainer::from_glib_none(ffi::gtk_source_language_manager_get_language_ids(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_source_language_manager_get_search_path")]
    #[doc(alias = "get_search_path")]
    #[doc(alias = "search-path")]
    pub fn search_path(&self) -> Vec<glib::GString> {
        unsafe {
            FromGlibPtrContainer::from_glib_none(ffi::gtk_source_language_manager_get_search_path(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_source_language_manager_guess_language")]
    pub fn guess_language(
        &self,
        filename: Option<impl AsRef<std::path::Path>>,
        content_type: Option<&str>,
    ) -> Option<Language> {
        unsafe {
            from_glib_none(ffi::gtk_source_language_manager_guess_language(
                self.to_glib_none().0,
                filename.as_ref().map(|p| p.as_ref()).to_glib_none().0,
                content_type.to_glib_none().0,
            ))
        }
    }

    #[cfg(feature = "v5_4")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v5_4")))]
    #[doc(alias = "gtk_source_language_manager_prepend_search_path")]
    pub fn prepend_search_path(&self, path: &str) {
        unsafe {
            ffi::gtk_source_language_manager_prepend_search_path(
                self.to_glib_none().0,
                path.to_glib_none().0,
            );
        }
    }

    #[doc(alias = "gtk_source_language_manager_set_search_path")]
    #[doc(alias = "search-path")]
    pub fn set_search_path(&self, dirs: &[&str]) {
        unsafe {
            ffi::gtk_source_language_manager_set_search_path(
                self.to_glib_none().0,
                dirs.to_glib_none().0,
            );
        }
    }

    #[doc(alias = "gtk_source_language_manager_get_default")]
    #[doc(alias = "get_default")]
    #[allow(clippy::should_implement_trait)]
    pub fn default() -> LanguageManager {
        assert_initialized_main_thread!();
        unsafe { from_glib_none(ffi::gtk_source_language_manager_get_default()) }
    }

    #[doc(alias = "language-ids")]
    pub fn connect_language_ids_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_language_ids_trampoline<F: Fn(&LanguageManager) + 'static>(
            this: *mut ffi::GtkSourceLanguageManager,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::language-ids\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_language_ids_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "search-path")]
    pub fn connect_search_path_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_search_path_trampoline<F: Fn(&LanguageManager) + 'static>(
            this: *mut ffi::GtkSourceLanguageManager,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::search-path\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_search_path_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

impl Default for LanguageManager {
    fn default() -> Self {
        Self::new()
    }
}

// rustdoc-stripper-ignore-next
/// A [builder-pattern] type to construct [`LanguageManager`] objects.
///
/// [builder-pattern]: https://doc.rust-lang.org/1.0.0/style/ownership/builders.html
#[must_use = "The builder must be built to be used"]
pub struct LanguageManagerBuilder {
    builder: glib::object::ObjectBuilder<'static, LanguageManager>,
}

impl LanguageManagerBuilder {
    fn new() -> Self {
        Self {
            builder: glib::object::Object::builder(),
        }
    }

    pub fn search_path(self, search_path: impl Into<glib::StrV>) -> Self {
        Self {
            builder: self.builder.property("search-path", search_path.into()),
        }
    }

    // rustdoc-stripper-ignore-next
    /// Build the [`LanguageManager`].
    #[must_use = "Building the object from the builder is usually expensive and is not expected to have side effects"]
    pub fn build(self) -> LanguageManager {
        self.builder.build()
    }
}
