/*****************************************************************

Copyright (c) 2000 Matthias Elter

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************/

#ifndef __extensionmanager_h__
#define __extensionmanager_h__

#include <qptrlist.h>
#include <qobject.h>

#include "container_extension.h"

class ExtensionManager : public QObject
{
    Q_OBJECT

public:
    static ExtensionManager* the();

    void initialize();

    void addExtension( const QString &desktopFile );

    void addContainer( ExtensionContainer* );
    void removeAllContainers();
    QPtrList<ExtensionContainer> containers() const { return _containers; }

public slots:
    void removeContainer( ExtensionContainer* );

protected:
    ExtensionManager();

    void setUniqueId(ExtensionContainer*);

    void saveContainerConfig(bool layoutOnly = false);
    void loadContainerConfig();
    void defaultContainerConfig();

protected slots:
    void embeddedWindowDestroyed();

private:
    QPtrList<ExtensionContainer> _containers;
};

#endif

