/*****************************************************************

Copyright (c) 1996-2000 the kicker authors. See file AUTHORS.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************/

#include <qlayout.h>
#include <qtooltip.h>

#include <karrowbutton.h>
#include <klocale.h>
#include <kdebug.h>

#include "panner.h"
#include "panner.moc"

Panner::Panner( QWidget* parent, const char* name )
    : QScrollView( parent, name )
{
    setBackgroundOrigin( AncestorOrigin );
    viewport()->setBackgroundOrigin( AncestorOrigin );

    setResizePolicy(Manual);
    setVScrollBarMode( QScrollView::AlwaysOff );
    setHScrollBarMode( QScrollView::AlwaysOff );

    viewport()->setBackgroundMode( PaletteBackground );

    // layout
    _layout = new QBoxLayout( this, QBoxLayout::LeftToRight );

    _layout->addWidget( viewport(), 1 );

    // left/up scroll button
    _luSB = new KArrowButton(this);
    _luSB->installEventFilter( this );
    _luSB->setAutoRepeat(true);
    _luSB->setMinimumSize( 12, 12 );
    connect(_luSB, SIGNAL(clicked()), SLOT(scrollLeftUp()));

    // right/ down scroll button
    _rdSB = new KArrowButton(this);
    _rdSB->installEventFilter( this );
    _rdSB->setAutoRepeat(true);
    _luSB->setMinimumSize( 12, 12 );
    connect(_rdSB, SIGNAL(clicked()), SLOT(scrollRightDown()));

    // scroll buttons
    _layout->addWidget(_luSB);
    _layout->addWidget(_rdSB);

    setOrientation( Horizontal );
}

Panner::~Panner() {}

void Panner::setOrientation(Orientation o)
{
    _orient = o;

    if( orientation() == Horizontal ) {
        _luSB->setArrowType(Qt::LeftArrow);
        _rdSB->setArrowType(Qt::RightArrow);
        _luSB->setSizePolicy( QSizePolicy( QSizePolicy::Minimum, QSizePolicy::Expanding ) );
        _rdSB->setSizePolicy( QSizePolicy( QSizePolicy::Minimum, QSizePolicy::Expanding ) );
        QToolTip::add(_luSB, i18n("Scroll left"));
        QToolTip::add(_rdSB, i18n("Scroll right"));
        _layout->setDirection( QBoxLayout::LeftToRight );
    } else {
        _luSB->setArrowType(Qt::UpArrow);
        _rdSB->setArrowType(Qt::DownArrow);
        _luSB->setSizePolicy( QSizePolicy( QSizePolicy::Expanding, QSizePolicy::Minimum ) );
        _rdSB->setSizePolicy( QSizePolicy( QSizePolicy::Expanding, QSizePolicy::Minimum ) );
        QToolTip::add(_luSB, i18n("Scroll up"));
        QToolTip::add(_rdSB, i18n("Scroll down"));
        _layout->setDirection( QBoxLayout::TopToBottom );
    }

    _layout->activate();
}

void Panner::resizeEvent( QResizeEvent* e )
{
    QScrollView::resizeEvent( e );
    updateScrollButtons();
}

void Panner::scrollRightDown()
{
    if(orientation() == Horizontal) // scroll right
        scrollBy( 40, 0 );
    else // scroll down
        scrollBy( 0, 40 );
}

void Panner::scrollLeftUp()
{
    if(orientation() == Horizontal) // scroll left
        scrollBy( -40, 0 );
    else // scroll up
        scrollBy( 0, -40 );
}

void Panner::updateScrollButtons()
{
    if ((contentsWidth() - 1 > width() && orientation() == Horizontal)
        || (contentsHeight() -1 > height() && orientation() == Vertical)) {
        _luSB->show();
        _rdSB->show();
    } else {
        _luSB->hide();
        _rdSB->hide();
    }
}

void Panner::resizeContents( int w, int h )
{
    QScrollView::resizeContents( w, h );
    updateScrollButtons();
}
