/* -*- C++ -*-

   This file declares the KVaio class.

   $ Author: Mirko Boehm $
   $ Copyright: (C) 1996-2003, Mirko Boehm $
   $ Contact: mirko@kde.org
         http://www.kde.org
         http://www.hackerbuero.org $
   $ License: LGPL with the following explicit clarification:
         This code may be linked against any version of the Qt toolkit
         from Troll Tech, Norway. $

   $Id: kvaio.h,v 1.7 2004/01/08 01:48:18 mirko Exp $

   * Portions of this code are
   * (C) 2001-2002 Stelian Pop <stelian@popies.net> and
   * (C) 2001-2002 Alcove <www.alcove.com>.
   * Thanks to Stelian for the implementation of the sonypi driver.
*/

#ifndef _KVAIO_H
#define _KVAIO_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <qtimer.h>

#include <dcopclient.h>
#include <kmainwindow.h>
#include "kvaiodriverinterface.h"

extern "C" {
#include <X11/Xlib.h>
#include <X11/extensions/XTest.h>
}

class KVaio;

/**
 * @short KVaio class
 * This class provides an interface between the Vaio driver and the
 * respective application (either the kmilod module or a single
 * application).
 * This class provides the application of the events created by the
 * KVaioDriverInterface class.
 * @author Mirko Boehm <mirko@hackerbuero.org>
 * @version 0.2
 */
class KVaio : public QObject
{
    Q_OBJECT
public:
    KVaio(QObject *parent = 0, const char *name =0);
    virtual ~KVaio();
    int brightness();
    const KVaioDriverInterface *driver();
    void loadConfiguration(KConfig *);
protected:
    KVaioDriverInterface *mDriver;
    bool mSimulateMouseWheelEvents;
    Display *mDisp;
    DCOPClient mClient;
    void simulateButton(Display *disp, int button, int mask);
    bool isKMiloDAvailable();
    bool showTextMsg(const QString& msg);
    bool showProgressMsg(const QString& msg, int progress);
    bool showBatteryStatus ( bool force = false);
    bool modifyBrightness(int step);
    bool modifyVolume(int step);
protected slots:
    void slotVaioEvent(int);
    void slotTimeout(); 
private:
    bool mCTRL_JogDial_Brightness;
    bool mALT_JogDial_Volume;
    bool mJogDialPress_MMBClick;
    bool mReportUnknownEvents;
    bool mReportPowerStatus;
    bool mShowPowerStatusOnBackButton;
    QTimer *mTimer;
};

#endif // _KVAIO_H
