/***************************************************************************
                          main.cpp  -  description
                             -------------------
    begin                : Thu Jul 19 00:06:05 CEST 2001
    copyright            : (C) 2001 by Primoz Anzur 
    email                : zerokode@gmx.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <kcmdlineargs.h>
#include <kaboutdata.h>

#include "mainwindow.h"

static const char description[] =
	I18N_NOOP("Letter Order Game");

static KCmdLineOptions options[] =
{
    KCmdLineLastOption
};

int main(int argc, char *argv[])
{

  KAboutData aboutData( "kmessedwords", I18N_NOOP("KMessedWords"),
    LOCAL_VERSION, description, KAboutData::License_GPL,
    "(c) 2001 - 2002, Primoz Anzur", 0, "http://edu.kde.org/kmessedwords", "submit@bugs.kde.org");
  aboutData.addAuthor("Primoz Anzur","Creator, maintainer, graphic design", "zerokode@gmx.net");
  aboutData.addCredit("Waldo Bastian","Created the core KMW engine / improved syllables engine", "bastian@kde.org");
  aboutData.addCredit("Chris Howells","Added \"Help\" menu", "howells@kde.org");
  aboutData.addCredit("David Vignoni", I18N_NOOP("svg icon"), "david80v@tin.it");
  KCmdLineArgs::init( argc, argv, &aboutData );
  KCmdLineArgs::addCmdLineOptions( options ); // Add our own options.

  KApplication a;
  MainWindow *mw = new MainWindow();
  a.setMainWidget(mw);
  mw->show();

  return a.exec();
}
