//
// C++ Implementation: ksayitbookmarkhandler
//
// Description:
//
//
// Author: Robert Vogl <voglrobe@web.de>, (C) 2005
//
// Copyright: See COPYING file that comes with this distribution
//
//

// Qt include
#include <qregexp.h>

// KDE includes
#include <kdebug.h>
#include <klocale.h>
#include <kmessagebox.h>
#include <kurl.h>

// App specific includes
#include "ksayitbookmarkhandler.h"
#include "ksayit.h"

KSayItBookmarkHandler::KSayItBookmarkHandler(KBookmarkManager *bkManager, KSayItApp* parent)
 : KBookmarkOwner(), m_bkManager(bkManager), m_parent(parent)
{
    m_ID       = QString::null;
    m_title    = QString::null;
    m_filename = QString::null;
}

KSayItBookmarkHandler::~KSayItBookmarkHandler()
{
}


void KSayItBookmarkHandler::notifyBookmarkHandler(const QString &ID, const QString &title)
{
    kdDebug(100200) << "KSayItBookmarkHandler::notifyBookmarkManager()" << endl;
    
    m_ID = ID;
    m_title = title;
}


void KSayItBookmarkHandler::setFilename(const QString &filename)
{
    kdDebug(100200) << "KSayItBookmarkHandler::setFilename(" << filename << ")" << endl;
    
    m_filename = filename;
}


void KSayItBookmarkHandler::openBookmarkURL(const QString &url)
{
    kdDebug(100200) << "KSayItBookmarkHandler::openBookmarkURL(" << url << ")" << endl;
    // e.g.: ksayit://testdocbook.docbook/00000105
    
    QString l_url = url;
    QString type = l_url.section( "://", 0, 0 );
    QString file = l_url.section( QRegExp("/+"), 1, 1 );
    QString ID   = l_url.section( QRegExp("/+"), 2, 2 );
    QString err  = QString::null;
    
    // Some checks
    if ( type != "ksayit" ){
        err += i18n("This is not a KSayIt bookmark.\n"); 
    }
    if ( file != m_filename.lower() ){
        err += i18n("The bookmark belongs not to the current file.\n");
    }               
    int ID2Int = ID.toInt(0, 10);
    QString ID2Int2String = QString::number(ID2Int, 10);
    if ( ID2Int2String.rightJustify(8,'0') != ID ){
        err += i18n("The format of the bookmark is malformed.");
    }
    if ( err != QString::null ){
        KMessageBox::sorry( 0, err, i18n("Bookmark not found") );
        return;
    }
    
    bool result;
    result = m_parent->setItemByBookmark( ID );
    if ( !result ){
        err = i18n("Bookmark not found. Maybe the file content or the bookmark URL has been changed.");
        KMessageBox::sorry( 0, err, i18n("Bookmark not found") );           
    }    
}


QString KSayItBookmarkHandler::currentTitle() const
{
    kdDebug(100200) << "KSayItBookmarkHandler::currentTitle()" << endl;
    
    QString result;
    if ( m_title == ""){
        result = i18n("untitled");
    } else {
        result = m_title;
    }   
    
    return result;
}


QString KSayItBookmarkHandler::currentURL() const
{
    kdDebug(100200) << "KSayItBookmarkHandler::currentURL()" << endl;
    
    QString url;

    if ( m_filename == QString::null ){
        url = "ksayit://???";
        return url;
    }     
    
    url = "ksayit://" + m_filename + "/" + m_ID;
    return url;
}


void KSayItBookmarkHandler::traverseBookmarks(KBookmarkGroup bkGroup)
{
    kdDebug(100200) << "### KSayItBookmarkHandler::traverseBookmarks()" << endl;
    
    if( bkGroup.isNull() )
        return;
        
    KURL url;
    QString title;
    KBookmark bkNext, bkPrev, bkNew;
    
    KBookmark bk = bkGroup.first();           
    while ( !bk.isNull() && !bk.isSeparator() ){
        if ( bk.isGroup() ){
            traverseBookmarks( bk.toGroup() ); // recursive call
            bkNext = bkGroup.next( bk );
        } else {
            url = bk.url();
            title = bk.text();
            bkNext = bkGroup.next( bk );
            bkPrev = bkGroup.previous( bk );
            if ( bkPrev.isNull() )  // no predecessor
                bkPrev = bk;
            
            // Modifications on URL/Title BEGIN
            //
            // Modifications on URL/Title END           
                          
            bkNew = bkGroup.addBookmark( m_bkManager, title, url, QString::null, false );
            bkGroup.moveItem( bkNew, bkPrev );
            bkGroup.deleteBookmark( bk );            
        }
        bk = bkNext;    
    }
    m_bkManager->save(); // make persistent
}
