/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sail.rdbms.schema;

import org.openrdf.sail.rdbms.schema.ValueType;

public class ValueTypes
implements Cloneable {
    public static ValueTypes UNKNOWN = new ValueTypes();
    public static ValueTypes RESOURCE;
    public static ValueTypes URI;
    private boolean bnodes;
    private boolean uris;
    private boolean literals;
    private boolean typed;
    private boolean numeric;
    private boolean calendar;
    private boolean languages;
    private boolean longValues;

    public boolean isBNodes() {
        return this.bnodes;
    }

    public boolean isURIs() {
        return this.uris;
    }

    public boolean isLiterals() {
        return this.literals;
    }

    public boolean isTyped() {
        return this.typed;
    }

    public boolean isNumeric() {
        return this.numeric;
    }

    public boolean isCalendar() {
        return this.calendar;
    }

    public boolean isLanguages() {
        return this.languages;
    }

    public boolean isLong() {
        return this.longValues;
    }

    public void reset() {
        this.bnodes = false;
        this.uris = false;
        this.literals = false;
        this.typed = false;
        this.numeric = false;
        this.calendar = false;
        this.languages = false;
        this.longValues = false;
    }

    public void add(ValueType code) {
        this.bnodes |= code.isBNode();
        this.uris |= code.isURI();
        this.literals |= code.isLiteral();
        this.typed |= code.isTypedLiteral();
        this.numeric |= code.isNumericLiteral();
        this.calendar |= code.isCalendarLiteral();
        this.languages |= code.isLanguageLiteral();
        this.longValues |= code.isLong();
    }

    public ValueTypes merge(ValueTypes valueTypes) {
        this.bnodes |= valueTypes.bnodes;
        this.uris |= valueTypes.uris;
        this.literals |= valueTypes.literals;
        this.typed |= valueTypes.typed;
        this.numeric |= valueTypes.numeric;
        this.calendar |= valueTypes.calendar;
        this.languages |= valueTypes.languages;
        this.longValues |= valueTypes.longValues;
        return this;
    }

    public ValueTypes clone() {
        try {
            return (ValueTypes)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError();
        }
    }

    static {
        ValueTypes.UNKNOWN.bnodes = true;
        ValueTypes.UNKNOWN.uris = true;
        ValueTypes.UNKNOWN.literals = true;
        ValueTypes.UNKNOWN.typed = true;
        ValueTypes.UNKNOWN.numeric = true;
        ValueTypes.UNKNOWN.calendar = true;
        ValueTypes.UNKNOWN.languages = true;
        ValueTypes.UNKNOWN.longValues = true;
        RESOURCE = new ValueTypes();
        ValueTypes.RESOURCE.bnodes = true;
        ValueTypes.RESOURCE.uris = true;
        ValueTypes.RESOURCE.longValues = true;
        URI = new ValueTypes();
        ValueTypes.URI.uris = true;
        ValueTypes.URI.longValues = true;
    }
}

