#if	!defined(lint) && !defined(DOS)
static char rcsid[] = "$Id: msspell.c,v 4.8 1996/03/15 07:41:11 hubert Exp $";
#endif
/*
 * Program:	msspell.c
 *
 *
 * Thomas Unger
 * Networks and Distributed Computing
 * Computing and Communications
 * University of Washington
 * Administration Builiding, AG-44
 * Seattle, Washington, 98195, USA
 * Internet: unger@cac.washington.edu
 *
 * Please address all bugs and comments to "pine-bugs@cac.washington.edu"
 *
 *
 * Pine and Pico are registered trademarks of the University of Washington.
 * No commercial use of these trademarks may be made without prior written
 * permission of the University of Washington.
 * 
 * Pine, Pico, and Pilot software and its included text are Copyright
 * 1989-1996 by the University of Washington.
 * 
 * The full text of our legal notices is contained in the file called
 * CPYRIGHT, included with this distribution.
 */

#include <windows.h>
#include <stdio.h>
#include "osdep.h"
#include "pico.h"
#include "estruct.h"
#ifdef	SPELLER
#include "edef.h"

#pragma pack(1)
#include "msspell.h"
#pragma pack()



extern FILE		*gfDebugFile = NULL;



#ifdef	ANSI
    void chword(char *, char *);
    int  movetoword(char *);
#else
    void chword();
    int  movetoword();
#endif


#define  NSHLINES  12

static char *spellhelp[] = {
  "Spell Check Help",
  " ",
  "\tThe spell checker examines all words in the text.  It then",
  "\toffers each misspelled word for correction while simultaneously",
  "\thighlighting it in the text.  To leave a word unchanged simply",
  "~\thit ~R~e~t~u~r~n at the edit prompt.  If a word has been corrected,",
  "\teach occurrence of the incorrect word is offered for replacement.",
  " ",
  "~\tSpell checking can be cancelled at any time by typing ~^~C (~F~3)",
  "\tafter exiting help.",
  " ",
  "End of Spell Check Help",
  " ",
  NULL
};


static char *pinespellhelp[] = {
  "Spell Check Help",
  " ",
  "\tThe spell checker examines all words in the text.  It then",
  "\toffers each misspelled word for correction while simultaneously",
  "\thighlighting it in the text.  To leave a word unchanged simply",
  "\thit Return at the edit prompt.  If a word has been corrected,",
  "\teach occurrence of the incorrect word is offered for replacement.",
  " ",
  "\tSpell checking can be cancelled at any time by typing ^C (F3)",
  "\tafter exiting help.",
  " ",
  "End of Spell Check Help",
  " ",
  NULL
};




typedef struct {
     HINSTANCE	hSpell;
     WORD	version;
     FARPROC	Version;
     FARPROC	CheckWord;
     FARPROC	GetValidLettersBlock;
     BYTE	validChars[256];
} Spell300;

#define SPELL_DLL_NAME		"SPELLCH3.DLL"


extern HWND		ghTTYWnd;
extern HINSTANCE	ghInstance;


LRESULT FAR PASCAL __export CWHook (HWND hWnd, UINT uMsg, 
				WPARAM wParam, LPARAM lParam);
void	showsize (void);


/*
 * spell() - check for potentially missspelled words and offer them for
 *           correction
 */
spell(f, n)
{
    int		status;
    char	errbuf[128];
    Spell300	speller;
    UINT	errFlag;
    char	wb[NLINE], cb[NLINE];
    CHECKWORD	checkword;
    int		i;
    
        
    if (curwp->w_markp)				/* Clear existing mark. */
	setmark (0, 1);
    setimark(0, 1);
    emlwrite("Checking spelling..."); 		/* greetings */

    
    /*
     * Load speller DLL.
     */
    errFlag = SetErrorMode (SEM_NOOPENFILEERRORBOX);
    speller.hSpell = LoadLibrary (SPELL_DLL_NAME);
    SetErrorMode (errFlag);
    if ((UINT)speller.hSpell < (UINT)HINSTANCE_ERROR) {
	mswin_exec_err_msg ("speller", (int)speller.hSpell, errbuf, 128);
	emlwrite (errbuf);
	return(-1);
    }
    
    speller.Version = GetProcAddress (speller.hSpell, "SPCHK_Version");
    speller.CheckWord = GetProcAddress (speller.hSpell, "SPCHK_CheckWord");
    speller.GetValidLettersBlock = GetProcAddress (speller.hSpell, 
					    "SPCHK_GetValidLettersBlock");
    if (    speller.Version == NULL || 
	    speller.CheckWord == NULL || 
	    speller.GetValidLettersBlock == NULL) {
	emlwrite ("Speller DLL does not support the correct functions", NULL);
	return (-1);
    }
    speller.version = speller.Version ();
    
    
    /*
     * Get list of valid letters.
     */
    speller.GetValidLettersBlock (&speller.validChars);
    
    
    /*
     * Initialize the checkword structure.
     */
    memset (&checkword, 0, sizeof (CHECKWORD));
    checkword.wSizeOfBlock = sizeof (CHECKWORD);
    checkword.hWndParent = ghTTYWnd;
    checkword.CheckWordOptions = CWO_ALLOWCHANGE | CWO_AUTOSUGGEST | 
	    CWO_NOHELP | CWO_USEMAINHOOK | CWO_SENDMSGTOMAINHOOK |
	    CWO_CHECKMULTIPLE;
    checkword.fpMainHook = MakeProcInstance ((FARPROC) CWHook, ghInstance);
    checkword.dwCustData = (DWORD) &speller;
    
    gotobob(0, 1);
    checkword.wSizeOfBlock = sizeof (CHECKWORD);
    status = speller.CheckWord (&checkword);
    
    
    FreeProcInstance (checkword.fpMainHook);
    FreeLibrary (speller.hSpell);
    speller.hSpell = NULL;
    speller.Version = NULL;
    speller.CheckWord = NULL;
    emlwrite("Done checking spelling");
    if (curwp->w_markp) {
	markregion (0);
	setmark (0, 1);		/* Clears mark. */
    }
    swapimark (0, 1);
    return (TRUE);
}


#if  0
void
showsize ()
{
    CHECKWORD	cw;
    int		size;
    char	b[256];
    
    size = 0;
    size += sizeof(cw.wSizeOfBlock);
    wsprintf (b, "wSizeOfBlock %d, size %d\r\n", sizeof(cw.wSizeOfBlock), size);
    OutputDebugString (b);
    size += sizeof(cw.hWndParent);
    wsprintf (b, "hWndParent %d, size %d\r\n", sizeof(cw.hWndParent), size);
    OutputDebugString (b);
    size += sizeof(cw.hWndDlg);
    wsprintf (b, "hWndDlg %d, size %d\r\n", sizeof(cw.hWndDlg), size);
    OutputDebugString (b);
    size += sizeof(cw.CheckWordOptions);
    wsprintf (b, "CheckWordOptions %d, size %d\r\n", sizeof(cw.CheckWordOptions), size);
    OutputDebugString (b);
    size += sizeof(cw.szLanguage);
    wsprintf (b, "szLanguage %d, size %d\r\n", sizeof(cw.szLanguage), size);
    OutputDebugString (b);
    size += sizeof(cw.hCustomDics);
    wsprintf (b, "hCustomDics %d, size %d\r\n", sizeof(cw.hCustomDics), size);
    OutputDebugString (b);
    size += sizeof(cw.NumCustom);
    wsprintf (b, "NumCustom %d, size %d\r\n", sizeof(cw.NumCustom), size);
    OutputDebugString (b);
    size += sizeof(cw.CurCustom);
    wsprintf (b, "CurCustom %d, size %d\r\n", sizeof(cw.CurCustom), size);
    OutputDebugString (b);
    size += sizeof(cw.hDebugLog);
    wsprintf (b, "hDebugLog %d, size %d\r\n", sizeof(cw.hDebugLog), size);
    OutputDebugString (b);
    size += sizeof(cw.hInstance);
    wsprintf (b, "hInstance %d, size %d\r\n", sizeof(cw.hInstance), size);
    OutputDebugString (b);
    size += sizeof(cw.fpMainHook);
    wsprintf (b, "fpMainHook %d, size %d\r\n", sizeof(cw.fpMainHook), size);
    OutputDebugString (b);
    size += sizeof(cw.fpOptionsHook);
    wsprintf (b, "fpOptionsHook %d, size %d\r\n", sizeof(cw.fpOptionsHook), size);
    OutputDebugString (b);
    size += sizeof(cw.lpMainDlg);
    wsprintf (b, "lpMainDlg %d, size %d\r\n", sizeof(cw.lpMainDlg), size);
    OutputDebugString (b);
    size += sizeof(cw.lpOptionsDlg);
    wsprintf (b, "lpOptionsDlg %d, size %d\r\n", sizeof(cw.lpOptionsDlg), size);
    OutputDebugString (b);
    size += sizeof(cw.dwCustData);
    wsprintf (b, "dwCustData %d, size %d\r\n", sizeof(cw.dwCustData), size);
    OutputDebugString (b);
    size += sizeof(cw.dwCustData2);
    wsprintf (b, "dwCustData2 %d, size %d\r\n", sizeof(cw.dwCustData2), size);
    OutputDebugString (b);
    size += sizeof(cw.ToCheck);
    wsprintf (b, "ToCheck %d, size %d\r\n", sizeof(cw.ToCheck), size);
    OutputDebugString (b);
    size += sizeof(cw.Changed);
    wsprintf (b, "Changed %d, size %d\r\n", sizeof(cw.Changed), size);
    OutputDebugString (b);
    size += sizeof(cw.bCurWordChanged);
    wsprintf (b, "bCurWordChanged %d, size %d\r\n", sizeof(cw.bCurWordChanged), size);
    OutputDebugString (b);
    size += sizeof(cw.PrevWord);
    wsprintf (b, "PrevWord %d, size %d\r\n", sizeof(cw.PrevWord), size);
    OutputDebugString (b);
    size += sizeof(cw.wFunctionType);
    wsprintf (b, "wFunctionType %d, size %d\r\n", sizeof(cw.wFunctionType), size);
    OutputDebugString (b);
    size += sizeof(cw.CurPosCheck);
    wsprintf (b, "CurPosCheck %d, size %d\r\n", sizeof(cw.CurPosCheck), size);
    OutputDebugString (b);
    size += sizeof(cw.CurPosChanged);
    wsprintf (b, "CurPosChanged %d, size %d\r\n", sizeof(cw.CurPosChanged), size);
    OutputDebugString (b);
    size += sizeof(cw.CurWord);
    wsprintf (b, "CurWord %d, size %d\r\n", sizeof(cw.CurWord), size);
    OutputDebugString (b);
    size += sizeof(cw.hDic);
    wsprintf (b, "hDic %d, size %d\r\n", sizeof(cw.hDic), size);
    OutputDebugString (b);
    size += sizeof(cw.hIndexBlock);
    wsprintf (b, "hIndexBlock %d, size %d\r\n", sizeof(cw.hIndexBlock), size);
    OutputDebugString (b);
    size += sizeof(cw.lpLoadedBlock);
    wsprintf (b, "lpLoadedBlock %d, size %d\r\n", sizeof(cw.lpLoadedBlock), size);
    OutputDebugString (b);
    size += sizeof(cw.lpIndexBlock);
    wsprintf (b, "lpIndexBlock %d, size %d\r\n", sizeof(cw.lpIndexBlock), size);
    OutputDebugString (b);
    size += sizeof(cw.hWordsBlock);
    wsprintf (b, "hWordsBlock %d, size %d\r\n", sizeof(cw.hWordsBlock), size);
    OutputDebugString (b);
    size += sizeof(cw.dwWordsSize);
    wsprintf (b, "dwWordsSize %d, size %d\r\n", sizeof(cw.dwWordsSize), size);
    OutputDebugString (b);
    size += sizeof(cw.bExpandWordsBlock);
    wsprintf (b, "bExpandWordsBlock %d, size %d\r\n", sizeof(cw.bExpandWordsBlock), size);
    OutputDebugString (b);
    size += sizeof(cw.hIgnoreAll);
    wsprintf (b, "hIgnoreAll %d, size %d\r\n", sizeof(cw.hIgnoreAll), size);
    OutputDebugString (b);
    size += sizeof(cw.lpIgnoreAll);
    wsprintf (b, "lpIgnoreAll %d, size %d\r\n", sizeof(cw.lpIgnoreAll), size);
    OutputDebugString (b);
    size += sizeof(cw.lpCustomDics);
    wsprintf (b, "lpCustomDics %d, size %d\r\n", sizeof(cw.lpCustomDics), size);
    OutputDebugString (b);
    wsprintf (b, "total size %d, %d\n", size, sizeof (CHECKWORD));
    OutputDebugString (b);
}
#endif



LRESULT FAR PASCAL __export 

CWHook (HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
    LPCHECKWORD		pCW;
    BOOL		more;
    Spell300		*psp;
    

    switch (uMsg) {
    case SPELL_GETNEXT:
	pCW = (LPCHECKWORD) lParam;
	psp = (Spell300 *)pCW->dwCustData;
	more = nextword (pCW->ToCheck, &psp->validChars);
	// update ();
	return (more);
	
    case SPELL_WORDNOTFOUND:
	update ();
	return (0);
	
    case SPELL_WORDCHANGED:
	pCW = (LPCHECKWORD) lParam;
	chword (pCW->ToCheck, pCW->Changed);
	update ();
	return (0);
	
    default:
	return (0);
    }
    return (0);
}





/* 
 * chword() - change the given word, wp, pointed to by the curwp->w_dot 
 *            pointers to the word in cb
 */
void
chword(wb, cb)
  char *wb;					/* word buffer */
  char *cb;					/* changed buffer */
{
    /* Clear region. */
    markregion (0);				/* Clear highlighting. */
    curwp->w_markp = NULL;
    
    ldelete((long) strlen(wb), 0);		/* not saved in kill buffer */
    while(*cb != '\0')
      linsert(1, *cb++);



    curwp->w_flag |= WFEDIT;
}




/* 
 * nextword() - Move to next word.
 *
 *	returns:
 *		TRUE upon success
 *		FALSE otherwise
 */
nextword (w, validChar)
  char *w;
  BYTE *validChar;
{
    int      i;
    int      ret  = FALSE;
    int	     ll;
    int	     olddoto;
    LINE     *olddotp;
    register int   off;				/* curwp offset */
    register LINE *lp;				/* curwp line   */
    char     c;
    

    markregion (0);				/* Clear highlighting. */

    olddoto = curwp->w_doto;			/* save where we are */
    olddotp = curwp->w_dotp;
    
    /*
     * Advance dot to mark then scan for alphabetical character.
     */
    if (curwp->w_markp) {
	curwp->w_dotp = curwp->w_markp;
	curwp->w_doto = curwp->w_marko;
    }

    /*
     * Get line length and check if already at end of line.
     */
    ll =  llength(curwp->w_dotp);
    
    /*
     * Scan throug text for start of a word.
     */
    for (;;) {
	if (curwp->w_doto < ll) {
	    c = lgetc(curwp->w_dotp, curwp->w_doto).c;
	    if (validChar[c])
		break;
        }
	if (++curwp->w_doto >= ll) {
	    /* Move to the next line until we find a line that does not
	     * start with the message quote character. */
	    do {
		curwp->w_dotp = lforw(curwp->w_dotp);
		if (curwp->w_dotp == curbp->b_linep) 
		    goto NoWord;
		ll =  llength(curwp->w_dotp);
		curwp->w_doto = 0;
		c = lgetc(curwp->w_dotp, curwp->w_doto).c;
            } while (Pmaster && Pmaster->quote_str && c == *Pmaster->quote_str);
        }
    }
    
    
    
    /*
     * Scan to next blank.
     */
    curwp->w_markp = curwp->w_dotp;
    curwp->w_marko = curwp->w_doto + 1;
    
    ll =  llength(curwp->w_markp);
    for (;;) {
	c = lgetc(curwp->w_markp, curwp->w_marko).c;
	if (!validChar[c])
	    break;
	if (++curwp->w_marko >= ll)
	    break;
    }
    
    /*
     * Copy characters between dot and mark into word buffer.
     */
    for (i = curwp->w_doto; i < curwp->w_marko; ++i) 
	*w++ = lgetc(curwp->w_dotp, i).c;
    *w = '\0';
    curwp->w_flag |= WFHARD;
    return (TRUE);

    
    /*
     * No word found.  Leave DOT at last word and return FALSE;
     */
NoWord:
    curwp->w_flag |= WFHARD;
    setmark (0, 1);				/* Clears mark. */
    curwp->w_doto = olddoto;
    curwp->w_dotp = olddotp;
    *w = '\0';
    return (FALSE);
}
#endif	/* SPELLER */
